/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.thin;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import javax.cache.configuration.Factory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.jdbc.thin.ConnectionProperties;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.ssl.SslContextFactory;

public class JdbcThinSSLUtil {
    private static final X509TrustManager TRUST_ALL_MANAGER = new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
        }
    };
    public static final char[] EMPTY_CHARS = new char[0];

    private JdbcThinSSLUtil() {
    }

    public static SSLSocket createSSLSocket(InetSocketAddress addr, ConnectionProperties connProps) throws SQLException {
        try {
            SSLSocketFactory sslSocketFactory = JdbcThinSSLUtil.getSSLSocketFactory(connProps);
            SSLSocket sock = (SSLSocket)sslSocketFactory.createSocket(addr.getAddress(), addr.getPort());
            sock.setUseClientMode(true);
            sock.startHandshake();
            return sock;
        }
        catch (IOException e) {
            throw new SQLException("Failed to SSL connect to server [url=" + connProps.getUrl() + " address=" + addr + ']', "08001", e);
        }
    }

    private static SSLSocketFactory getSSLSocketFactory(ConnectionProperties connProps) throws SQLException {
        String sslFactory = connProps.getSslFactory();
        String cipherSuites = connProps.getSslCipherSuites();
        String cliCertKeyStoreUrl = connProps.getSslClientCertificateKeyStoreUrl();
        String cliCertKeyStorePwd = connProps.getSslClientCertificateKeyStorePassword();
        String cliCertKeyStoreType = connProps.getSslClientCertificateKeyStoreType();
        String trustCertKeyStoreUrl = connProps.getSslTrustCertificateKeyStoreUrl();
        String trustCertKeyStorePwd = connProps.getSslTrustCertificateKeyStorePassword();
        String trustCertKeyStoreType = connProps.getSslTrustCertificateKeyStoreType();
        String sslProtocol = connProps.getSslProtocol();
        String keyAlgorithm = connProps.getSslKeyAlgorithm();
        if (!F.isEmpty(sslFactory)) {
            try {
                Class<?> cls = JdbcThinSSLUtil.class.getClassLoader().loadClass(sslFactory);
                Factory f = (Factory)cls.newInstance();
                return (SSLSocketFactory)f.create();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new SQLException("Could not fount SSL factory class: " + sslFactory, "08001", e);
            }
        }
        if (cliCertKeyStoreUrl == null && cliCertKeyStorePwd == null && cliCertKeyStoreType == null && trustCertKeyStoreUrl == null && trustCertKeyStorePwd == null && trustCertKeyStoreType == null && sslProtocol == null && cipherSuites == null) {
            try {
                return SSLContext.getDefault().getSocketFactory();
            }
            catch (NoSuchAlgorithmException e) {
                throw new SQLException("Could not create default SSL context", "08001", e);
            }
        }
        if (cliCertKeyStoreUrl == null) {
            cliCertKeyStoreUrl = System.getProperty("javax.net.ssl.keyStore");
        }
        if (cliCertKeyStorePwd == null) {
            cliCertKeyStorePwd = System.getProperty("javax.net.ssl.keyStorePassword");
        }
        if (cliCertKeyStoreType == null) {
            cliCertKeyStoreType = System.getProperty("javax.net.ssl.keyStoreType", "JKS");
        }
        if (trustCertKeyStoreUrl == null) {
            trustCertKeyStoreUrl = System.getProperty("javax.net.ssl.trustStore");
        }
        if (trustCertKeyStorePwd == null) {
            trustCertKeyStorePwd = System.getProperty("javax.net.ssl.trustStorePassword");
        }
        if (trustCertKeyStoreType == null) {
            trustCertKeyStoreType = System.getProperty("javax.net.ssl.trustStoreType", "JKS");
        }
        if (sslProtocol == null) {
            sslProtocol = "TLS";
        }
        SslContextFactory f = new SslContextFactory();
        f.setProtocol(sslProtocol);
        f.setKeyAlgorithm(keyAlgorithm);
        f.setKeyStoreFilePath(cliCertKeyStoreUrl);
        f.setKeyStoreType(cliCertKeyStoreType);
        f.setKeyStorePassword(cliCertKeyStorePwd == null ? EMPTY_CHARS : cliCertKeyStorePwd.toCharArray());
        if (connProps.isSslTrustAll()) {
            f.setTrustManagers(TRUST_ALL_MANAGER);
        } else {
            f.setTrustStoreFilePath(trustCertKeyStoreUrl);
            f.setTrustStoreType(trustCertKeyStoreType);
            f.setTrustStorePassword(trustCertKeyStorePwd == null ? EMPTY_CHARS : trustCertKeyStorePwd.toCharArray());
        }
        if (!F.isEmpty(cipherSuites)) {
            f.setCipherSuites(cipherSuites.split(","));
        }
        try {
            SSLContext sslContext = f.create();
            return sslContext.getSocketFactory();
        }
        catch (IgniteException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SSLException) {
                throw new SQLException(cause.getMessage(), "08001", e);
            }
            throw new SQLException("Unknown error.", "08001", e);
        }
    }
}

