/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.util.LinkedHashMap;
import java.util.logging.Logger;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;

public class ClusterStateChangeCommand
implements Command<ClusterState> {
    static final String FORCE_COMMAND = "--force";
    private ClusterState state;
    private String clusterName;
    private boolean forceDeactivation;

    @Override
    public void printUsage(Logger log) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put(ClusterState.ACTIVE.toString(), "Activate cluster. Cache updates are allowed.");
        params.put(ClusterState.INACTIVE.toString(), "Deactivate cluster.");
        params.put(ClusterState.ACTIVE_READ_ONLY.toString(), "Activate cluster. Cache updates are denied.");
        Command.usage(log, "Change cluster state:", CommandList.SET_STATE, params, CommandLogger.or((Object[])ClusterState.values()), CommandLogger.optional(FORCE_COMMAND), CommandLogger.optional("--yes"));
    }

    @Override
    public void prepareConfirmation(GridClientConfiguration clientCfg) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            this.clusterName = client.state().clusterName();
        }
    }

    @Override
    public String confirmationPrompt() {
        return "Warning: the command will change state of cluster with name \"" + this.clusterName + "\" to " + (Object)((Object)this.state) + ".";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger log) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            client.state().state(this.state, this.forceDeactivation);
            log.info("Cluster state changed to " + (Object)((Object)this.state));
            Object var5_6 = null;
            return var5_6;
        }
        catch (Throwable e) {
            log.info("Failed to change cluster state to " + (Object)((Object)this.state));
            throw e;
        }
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        String arg;
        String s = argIter.nextArg("New cluster state not found.");
        try {
            this.state = ClusterState.valueOf(s.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Can't parse new cluster state. State: " + s, e);
        }
        this.forceDeactivation = false;
        if (argIter.hasNextArg() && FORCE_COMMAND.equalsIgnoreCase(arg = argIter.peekNextArg())) {
            this.forceDeactivation = true;
            argIter.nextArg("");
        }
    }

    @Override
    public ClusterState arg() {
        return this.state;
    }

    @Override
    public String name() {
        return CommandList.SET_STATE.toCommandName();
    }
}

