/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.cache.Cache;
import javax.cache.expiry.ExpiryPolicy;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.client.ClientCache;
import org.apache.ignite.client.ClientCacheConfiguration;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.internal.binary.streams.BinaryInputStream;
import org.apache.ignite.internal.binary.streams.BinaryOutputStream;
import org.apache.ignite.internal.client.thin.ClientBinaryMarshaller;
import org.apache.ignite.internal.client.thin.ClientFieldsQueryCursor;
import org.apache.ignite.internal.client.thin.ClientFieldsQueryPager;
import org.apache.ignite.internal.client.thin.ClientOperation;
import org.apache.ignite.internal.client.thin.ClientProtocolError;
import org.apache.ignite.internal.client.thin.ClientQueryCursor;
import org.apache.ignite.internal.client.thin.ClientQueryPager;
import org.apache.ignite.internal.client.thin.ClientUtils;
import org.apache.ignite.internal.client.thin.PayloadInputChannel;
import org.apache.ignite.internal.client.thin.PayloadOutputChannel;
import org.apache.ignite.internal.client.thin.ProtocolContext;
import org.apache.ignite.internal.client.thin.ProtocolVersionFeature;
import org.apache.ignite.internal.client.thin.ReliableChannel;
import org.apache.ignite.internal.client.thin.TcpClientTransactions;
import org.apache.ignite.internal.processors.platform.cache.expiry.PlatformExpiryPolicy;

class TcpClientCache<K, V>
implements ClientCache<K, V> {
    private static final byte KEEP_BINARY_FLAG_MASK = 1;
    private static final byte TRANSACTIONAL_FLAG_MASK = 2;
    private static final byte WITH_EXPIRY_POLICY_FLAG_MASK = 4;
    private final int cacheId;
    private final ReliableChannel ch;
    private final String name;
    private final ClientBinaryMarshaller marsh;
    private final TcpClientTransactions transactions;
    private final ClientUtils serDes;
    private final boolean keepBinary;
    private final ExpiryPolicy expiryPlc;

    TcpClientCache(String name, ReliableChannel ch, ClientBinaryMarshaller marsh, TcpClientTransactions transactions) {
        this(name, ch, marsh, transactions, false, null);
    }

    TcpClientCache(String name, ReliableChannel ch, ClientBinaryMarshaller marsh, TcpClientTransactions transactions, boolean keepBinary, ExpiryPolicy expiryPlc) {
        this.name = name;
        this.cacheId = ClientUtils.cacheId(name);
        this.ch = ch;
        this.marsh = marsh;
        this.transactions = transactions;
        this.serDes = new ClientUtils(marsh);
        this.keepBinary = keepBinary;
        this.expiryPlc = expiryPlc;
    }

    @Override
    public V get(K key) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return (V)this.cacheSingleKeyOperation(key, ClientOperation.CACHE_GET, null, this::readObject);
    }

    @Override
    public void put(K key, V val) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (val == null) {
            throw new NullPointerException("val");
        }
        this.cacheSingleKeyOperation(key, ClientOperation.CACHE_PUT, req -> this.writeObject((PayloadOutputChannel)req, val), null);
    }

    @Override
    public boolean containsKey(K key) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.cacheSingleKeyOperation(key, ClientOperation.CACHE_CONTAINS_KEY, null, res -> res.in().readBoolean());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ClientCacheConfiguration getConfiguration() throws ClientException {
        return this.ch.service(ClientOperation.CACHE_GET_CONFIGURATION, this::writeCacheInfo, res -> {
            try {
                return this.serDes.cacheConfiguration(res.in(), res.clientChannel().protocolCtx());
            }
            catch (IOException e) {
                return null;
            }
        });
    }

    @Override
    public int size(CachePeekMode ... peekModes) throws ClientException {
        return this.ch.service(ClientOperation.CACHE_GET_SIZE, req -> {
            this.writeCacheInfo((PayloadOutputChannel)req);
            ClientUtils.collection(peekModes, req.out(), (out, m) -> out.writeByte((byte)m.ordinal()));
        }, res -> (int)res.in().readLong());
    }

    @Override
    public Map<K, V> getAll(Set<? extends K> keys) throws ClientException {
        if (keys == null) {
            throw new NullPointerException("keys");
        }
        if (keys.isEmpty()) {
            return new HashMap();
        }
        return this.ch.service(ClientOperation.CACHE_GET_ALL, req -> {
            this.writeCacheInfo((PayloadOutputChannel)req);
            ClientUtils.collection(keys, req.out(), this.serDes::writeObject);
        }, res -> ClientUtils.collection(res.in(), in -> new AbstractMap.SimpleEntry(this.readObject((BinaryInputStream)in), this.readObject((BinaryInputStream)in)))).stream().collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) throws ClientException {
        if (map == null) {
            throw new NullPointerException("map");
        }
        if (map.isEmpty()) {
            return;
        }
        this.ch.request(ClientOperation.CACHE_PUT_ALL, req -> {
            this.writeCacheInfo((PayloadOutputChannel)req);
            ClientUtils.collection(map.entrySet(), req.out(), (out, e) -> {
                this.serDes.writeObject((BinaryOutputStream)out, e.getKey());
                this.serDes.writeObject((BinaryOutputStream)out, e.getValue());
            });
        });
    }

    @Override
    public boolean replace(K key, V oldVal, V newVal) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (oldVal == null) {
            throw new NullPointerException("oldVal");
        }
        if (newVal == null) {
            throw new NullPointerException("newVal");
        }
        return this.cacheSingleKeyOperation(key, ClientOperation.CACHE_REPLACE_IF_EQUALS, req -> {
            this.writeObject((PayloadOutputChannel)req, oldVal);
            this.writeObject((PayloadOutputChannel)req, newVal);
        }, res -> res.in().readBoolean());
    }

    @Override
    public boolean replace(K key, V val) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (val == null) {
            throw new NullPointerException("val");
        }
        return this.cacheSingleKeyOperation(key, ClientOperation.CACHE_REPLACE, req -> this.writeObject((PayloadOutputChannel)req, val), res -> res.in().readBoolean());
    }

    @Override
    public boolean remove(K key) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.cacheSingleKeyOperation(key, ClientOperation.CACHE_REMOVE_KEY, null, res -> res.in().readBoolean());
    }

    @Override
    public boolean remove(K key, V oldVal) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (oldVal == null) {
            throw new NullPointerException("oldVal");
        }
        return this.cacheSingleKeyOperation(key, ClientOperation.CACHE_REMOVE_IF_EQUALS, req -> this.writeObject((PayloadOutputChannel)req, oldVal), res -> res.in().readBoolean());
    }

    @Override
    public void removeAll(Set<? extends K> keys) throws ClientException {
        if (keys == null) {
            throw new NullPointerException("keys");
        }
        if (keys.isEmpty()) {
            return;
        }
        this.ch.request(ClientOperation.CACHE_REMOVE_KEYS, req -> {
            this.writeCacheInfo((PayloadOutputChannel)req);
            ClientUtils.collection(keys, req.out(), this.serDes::writeObject);
        });
    }

    @Override
    public void removeAll() throws ClientException {
        this.ch.request(ClientOperation.CACHE_REMOVE_ALL, this::writeCacheInfo);
    }

    @Override
    public V getAndPut(K key, V val) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (val == null) {
            throw new NullPointerException("val");
        }
        return (V)this.cacheSingleKeyOperation(key, ClientOperation.CACHE_GET_AND_PUT, req -> this.writeObject((PayloadOutputChannel)req, val), this::readObject);
    }

    @Override
    public V getAndRemove(K key) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return (V)this.cacheSingleKeyOperation(key, ClientOperation.CACHE_GET_AND_REMOVE, null, this::readObject);
    }

    @Override
    public V getAndReplace(K key, V val) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (val == null) {
            throw new NullPointerException("val");
        }
        return (V)this.cacheSingleKeyOperation(key, ClientOperation.CACHE_GET_AND_REPLACE, req -> this.writeObject((PayloadOutputChannel)req, val), this::readObject);
    }

    @Override
    public boolean putIfAbsent(K key, V val) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (val == null) {
            throw new NullPointerException("val");
        }
        return this.cacheSingleKeyOperation(key, ClientOperation.CACHE_PUT_IF_ABSENT, req -> this.writeObject((PayloadOutputChannel)req, val), res -> res.in().readBoolean());
    }

    @Override
    public void clear() throws ClientException {
        this.ch.request(ClientOperation.CACHE_CLEAR, this::writeCacheInfo);
    }

    @Override
    public <K1, V1> ClientCache<K1, V1> withKeepBinary() {
        return this.keepBinary ? this : new TcpClientCache<K, V>(this.name, this.ch, this.marsh, this.transactions, true, this.expiryPlc);
    }

    @Override
    public <K1, V1> ClientCache<K1, V1> withExpirePolicy(ExpiryPolicy expirePlc) {
        return new TcpClientCache<K, V>(this.name, this.ch, this.marsh, this.transactions, this.keepBinary, expirePlc);
    }

    @Override
    public <R> QueryCursor<R> query(Query<R> qry) {
        QueryCursor<Cache.Entry<K, V>> res;
        if (qry == null) {
            throw new NullPointerException("qry");
        }
        if (qry instanceof ScanQuery) {
            res = this.scanQuery((ScanQuery)qry);
        } else if (qry instanceof SqlQuery) {
            res = this.sqlQuery((SqlQuery)qry);
        } else if (qry instanceof SqlFieldsQuery) {
            res = this.query((SqlFieldsQuery)qry);
        } else {
            throw new IllegalArgumentException(String.format("Query of type [%s] is not supported", qry.getClass().getSimpleName()));
        }
        return res;
    }

    @Override
    public FieldsQueryCursor<List<?>> query(SqlFieldsQuery qry) {
        if (qry == null) {
            throw new NullPointerException("qry");
        }
        Consumer<PayloadOutputChannel> qryWriter = payloadCh -> {
            this.writeCacheInfo((PayloadOutputChannel)payloadCh);
            this.serDes.write(qry, payloadCh.out());
        };
        return new ClientFieldsQueryCursor(new ClientFieldsQueryPager(this.ch, ClientOperation.QUERY_SQL_FIELDS, ClientOperation.QUERY_SQL_FIELDS_CURSOR_GET_PAGE, qryWriter, this.keepBinary, this.marsh));
    }

    private QueryCursor<Cache.Entry<K, V>> scanQuery(ScanQuery<K, V> qry) {
        Consumer<PayloadOutputChannel> qryWriter = payloadCh -> {
            this.writeCacheInfo((PayloadOutputChannel)payloadCh);
            BinaryOutputStream out = payloadCh.out();
            if (qry.getFilter() == null) {
                out.writeByte((byte)101);
            } else {
                this.serDes.writeObject(out, qry.getFilter());
                out.writeByte((byte)1);
            }
            out.writeInt(qry.getPageSize());
            out.writeInt(qry.getPartition() == null ? -1 : qry.getPartition());
            out.writeBoolean(qry.isLocal());
        };
        return new ClientQueryCursor<Cache.Entry<K, V>>(new ClientQueryPager(this.ch, ClientOperation.QUERY_SCAN, ClientOperation.QUERY_SCAN_CURSOR_GET_PAGE, qryWriter, this.keepBinary, this.marsh));
    }

    private QueryCursor<Cache.Entry<K, V>> sqlQuery(SqlQuery qry) {
        Consumer<PayloadOutputChannel> qryWriter = payloadCh -> {
            this.writeCacheInfo((PayloadOutputChannel)payloadCh);
            BinaryOutputStream out = payloadCh.out();
            this.serDes.writeObject(out, qry.getType());
            this.serDes.writeObject(out, qry.getSql());
            ClientUtils.collection(qry.getArgs(), out, this.serDes::writeObject);
            out.writeBoolean(qry.isDistributedJoins());
            out.writeBoolean(qry.isLocal());
            out.writeBoolean(qry.isReplicatedOnly());
            out.writeInt(qry.getPageSize());
            out.writeLong(qry.getTimeout());
        };
        return new ClientQueryCursor<Cache.Entry<K, V>>(new ClientQueryPager(this.ch, ClientOperation.QUERY_SQL, ClientOperation.QUERY_SQL_CURSOR_GET_PAGE, qryWriter, this.keepBinary, this.marsh));
    }

    private <T> T cacheSingleKeyOperation(K key, ClientOperation op, Consumer<PayloadOutputChannel> additionalPayloadWriter, Function<PayloadInputChannel, T> payloadReader) throws ClientException {
        Consumer<PayloadOutputChannel> payloadWriter = req -> {
            this.writeCacheInfo((PayloadOutputChannel)req);
            this.writeObject((PayloadOutputChannel)req, key);
            if (additionalPayloadWriter != null) {
                additionalPayloadWriter.accept((PayloadOutputChannel)req);
            }
        };
        return this.transactions.tx() == null ? this.ch.affinityService(this.cacheId, key, op, payloadWriter, payloadReader) : this.ch.service(op, payloadWriter, payloadReader);
    }

    private void writeCacheInfo(PayloadOutputChannel payloadCh) {
        BinaryOutputStream out = payloadCh.out();
        out.writeInt(this.cacheId);
        byte flags = this.keepBinary ? (byte)1 : 0;
        TcpClientTransactions.TcpClientTransaction tx = this.transactions.tx();
        if (this.expiryPlc != null) {
            ProtocolContext protocolCtx = payloadCh.clientChannel().protocolCtx();
            if (!protocolCtx.isFeatureSupported(ProtocolVersionFeature.EXPIRY_POLICY)) {
                throw new ClientProtocolError(String.format("Expire policies are not supported by the server version %s, required version %s", protocolCtx.version(), ProtocolVersionFeature.EXPIRY_POLICY.verIntroduced()));
            }
            flags = (byte)(flags | 4);
        }
        if (tx != null) {
            if (tx.clientChannel() != payloadCh.clientChannel()) {
                throw new ClientException("Transaction context has been lost due to connection errors. Cache operations are prohibited until current transaction closed.");
            }
            flags = (byte)(flags | 2);
        }
        out.writeByte(flags);
        if ((flags & 4) != 0) {
            out.writeLong(PlatformExpiryPolicy.convertDuration(this.expiryPlc.getExpiryForCreation()));
            out.writeLong(PlatformExpiryPolicy.convertDuration(this.expiryPlc.getExpiryForUpdate()));
            out.writeLong(PlatformExpiryPolicy.convertDuration(this.expiryPlc.getExpiryForAccess()));
        }
        if ((flags & 2) != 0) {
            out.writeInt(tx.txId());
        }
    }

    private <T> T readObject(BinaryInputStream in) {
        return this.serDes.readObject(in, this.keepBinary);
    }

    private <T> T readObject(PayloadInputChannel payloadCh) {
        return this.readObject(payloadCh.in());
    }

    private void writeObject(PayloadOutputChannel payloadCh, Object obj) {
        this.serDes.writeObject(payloadCh.out(), obj);
    }
}

