/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.messages;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryAbstractMessage;

public class TcpDiscoveryAuthFailedMessage
extends TcpDiscoveryAbstractMessage {
    private static final long serialVersionUID = 0L;
    private transient InetAddress addr;
    private UUID targetNodeId;

    public TcpDiscoveryAuthFailedMessage(UUID creatorNodeId, InetAddress addr, UUID targetNodeId) {
        super(creatorNodeId);
        this.addr = addr;
        this.targetNodeId = targetNodeId;
    }

    public UUID getTargetNodeId() {
        return this.targetNodeId;
    }

    public InetAddress address() {
        return this.addr;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        U.writeByteArray(out, this.addr.getAddress());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.addr = InetAddress.getByAddress(U.readByteArray(in));
    }

    @Override
    public String toString() {
        return S.toString(TcpDiscoveryAuthFailedMessage.class, this, "super", super.toString());
    }
}

