/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.protocols.tcp;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.client.marshaller.GridClientMarshaller;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestProtocolHandler;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.client.message.GridClientAuthenticationRequest;
import org.apache.ignite.internal.processors.rest.client.message.GridClientCacheRequest;
import org.apache.ignite.internal.processors.rest.client.message.GridClientClusterNameRequest;
import org.apache.ignite.internal.processors.rest.client.message.GridClientClusterStateRequest;
import org.apache.ignite.internal.processors.rest.client.message.GridClientClusterStateRequestV2;
import org.apache.ignite.internal.processors.rest.client.message.GridClientHandshakeRequest;
import org.apache.ignite.internal.processors.rest.client.message.GridClientHandshakeResponse;
import org.apache.ignite.internal.processors.rest.client.message.GridClientMessage;
import org.apache.ignite.internal.processors.rest.client.message.GridClientPingPacket;
import org.apache.ignite.internal.processors.rest.client.message.GridClientResponse;
import org.apache.ignite.internal.processors.rest.client.message.GridClientStateRequest;
import org.apache.ignite.internal.processors.rest.client.message.GridClientTaskRequest;
import org.apache.ignite.internal.processors.rest.client.message.GridClientTopologyRequest;
import org.apache.ignite.internal.processors.rest.handlers.cache.GridCacheRestMetrics;
import org.apache.ignite.internal.processors.rest.protocols.tcp.GridMemcachedMessage;
import org.apache.ignite.internal.processors.rest.protocols.tcp.GridTcpMemcachedNioListener;
import org.apache.ignite.internal.processors.rest.protocols.tcp.GridTcpRestProtocol;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisMessage;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisNioListener;
import org.apache.ignite.internal.processors.rest.request.GridRestCacheRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestChangeStateRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestClusterNameRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestClusterStateRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestTaskRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestTopologyRequest;
import org.apache.ignite.internal.util.nio.GridNioFuture;
import org.apache.ignite.internal.util.nio.GridNioServerListenerAdapter;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.nio.GridNioSessionMetaKey;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.jetbrains.annotations.Nullable;

public class GridTcpRestNioListener
extends GridNioServerListenerAdapter<GridClientMessage> {
    private static final Map<GridClientCacheRequest.GridCacheOperation, GridRestCommand> cacheCmdMap = new EnumMap<GridClientCacheRequest.GridCacheOperation, GridRestCommand>(GridClientCacheRequest.GridCacheOperation.class);
    private static final int USER_ATTR_KEY = GridNioSessionMetaKey.nextUniqueKey();
    private static final int CREDS_KEY = GridNioSessionMetaKey.nextUniqueKey();
    private static final Collection<Short> SUPP_VERS = new HashSet<Short>();
    private final CountDownLatch marshMapLatch = new CountDownLatch(1);
    private Map<Byte, GridClientMarshaller> marshMap;
    private IgniteLogger log;
    private GridTcpRestProtocol proto;
    private GridRestProtocolHandler hnd;
    private GridTcpMemcachedNioListener memcachedLsnr;
    private GridRedisNioListener redisLsnr;

    public GridTcpRestNioListener(IgniteLogger log, GridTcpRestProtocol proto, GridRestProtocolHandler hnd, GridKernalContext ctx) {
        this.memcachedLsnr = new GridTcpMemcachedNioListener(log, hnd);
        this.redisLsnr = new GridRedisNioListener(log, hnd, ctx);
        this.log = log;
        this.proto = proto;
        this.hnd = hnd;
    }

    void marshallers(Map<Byte, GridClientMarshaller> marshMap) {
        assert (marshMap != null);
        this.marshMap = marshMap;
        this.marshMapLatch.countDown();
    }

    @Override
    public void onConnected(GridNioSession ses) {
    }

    @Override
    public void onDisconnected(GridNioSession ses, @Nullable Exception e) {
        if (e != null) {
            if (e instanceof RuntimeException) {
                U.error(this.log, "Failed to process request from remote client: " + ses, e);
            } else {
                U.warn(this.log, "Closed client session due to exception [ses=" + ses + ", msg=" + e.getMessage() + ']');
            }
        }
    }

    @Override
    public void onMessage(final GridNioSession ses, final GridClientMessage msg) {
        if (msg instanceof GridMemcachedMessage) {
            this.memcachedLsnr.onMessage(ses, (GridMemcachedMessage)msg);
        } else if (msg instanceof GridRedisMessage) {
            this.redisLsnr.onMessage(ses, (GridRedisMessage)msg);
        } else if (msg instanceof GridClientPingPacket) {
            ses.send(msg);
        } else if (msg instanceof GridClientHandshakeRequest) {
            GridClientHandshakeRequest hs = (GridClientHandshakeRequest)msg;
            short ver = hs.version();
            if (!SUPP_VERS.contains(ver)) {
                U.error(this.log, "Client protocol version is not supported [ses=" + ses + ", ver=" + ver + ", supported=" + SUPP_VERS + ']');
                ses.close();
            } else {
                GridClientMarshaller marsh;
                byte marshId = hs.marshallerId();
                if (this.marshMapLatch.getCount() > 0L) {
                    try {
                        U.await(this.marshMapLatch);
                    }
                    catch (IgniteInterruptedCheckedException e) {
                        U.error(this.log, "Marshaller is not initialized.", e);
                        ses.close();
                        return;
                    }
                }
                if ((marsh = this.marshMap.get(marshId)) == null) {
                    U.error(this.log, "Client marshaller ID is invalid. Note that .NET and C++ clients are supported only in enterprise edition [ses=" + ses + ", marshId=" + marshId + ']');
                    ses.close();
                } else {
                    ses.addMeta(GridNioSessionMetaKey.MARSHALLER.ordinal(), marsh);
                    ses.send(GridClientHandshakeResponse.OK);
                }
            }
        } else {
            GridRestRequest req = this.createRestRequest(ses, msg);
            if (req != null) {
                this.hnd.handleAsync(req).listen((IgniteInClosure<IgniteInternalFuture<GridRestResponse>>)new CI1<IgniteInternalFuture<GridRestResponse>>(){

                    @Override
                    public void apply(IgniteInternalFuture<GridRestResponse> fut) {
                        GridClientResponse res = new GridClientResponse();
                        res.requestId(msg.requestId());
                        res.clientId(msg.clientId());
                        try {
                            GridRestResponse restRes = fut.get();
                            res.sessionToken(restRes.sessionTokenBytes());
                            res.successStatus(restRes.getSuccessStatus());
                            res.errorMessage(restRes.getError());
                            Map<String, Long> o = restRes.getResponse();
                            if (o instanceof GridCacheRestMetrics) {
                                o = ((GridCacheRestMetrics)((Object)o)).map();
                            }
                            res.result(o);
                        }
                        catch (IgniteCheckedException e) {
                            U.error(GridTcpRestNioListener.this.log, "Failed to process client request: " + msg, e);
                            res.successStatus(1);
                            res.errorMessage("Failed to process client request: " + e.getMessage());
                        }
                        GridNioFuture<?> sf = ses.send(res);
                        sf.listen(new CI1<IgniteInternalFuture<?>>(){

                            @Override
                            public void apply(IgniteInternalFuture<?> fut) {
                                try {
                                    fut.get();
                                }
                                catch (IgniteCheckedException e) {
                                    U.error(GridTcpRestNioListener.this.log, "Failed to process client request [ses=" + ses + ", msg=" + msg + ']', e);
                                }
                            }
                        });
                    }
                });
            } else {
                U.error(this.log, "Failed to process client request (unknown packet type) [ses=" + ses + ", msg=" + msg + ']');
            }
        }
    }

    @Nullable
    private GridRestRequest createRestRequest(GridNioSession ses, GridClientMessage msg) {
        GridRestRequest restReq = null;
        if (msg instanceof GridClientAuthenticationRequest) {
            GridClientAuthenticationRequest req = (GridClientAuthenticationRequest)msg;
            restReq = new GridRestTaskRequest();
            restReq.command(GridRestCommand.NOOP);
            ses.addMeta(CREDS_KEY, req.credentials());
            ses.addMeta(USER_ATTR_KEY, req.userAttributes());
        } else if (msg instanceof GridClientCacheRequest) {
            GridClientCacheRequest req = (GridClientCacheRequest)msg;
            GridRestCacheRequest restCacheReq = new GridRestCacheRequest();
            restCacheReq.cacheName(req.cacheName());
            restCacheReq.cacheFlags(req.cacheFlagsOn());
            restCacheReq.key(req.key());
            restCacheReq.value(req.value());
            restCacheReq.value2(req.value2());
            Map<Object, Object> vals = req.values();
            if (vals != null) {
                restCacheReq.values(new HashMap<Object, Object>(vals));
            }
            restCacheReq.command(cacheCmdMap.get((Object)req.operation()));
            restReq = restCacheReq;
        } else if (msg instanceof GridClientTaskRequest) {
            GridClientTaskRequest req = (GridClientTaskRequest)msg;
            GridRestTaskRequest restTaskReq = new GridRestTaskRequest();
            restTaskReq.command(GridRestCommand.EXE);
            restTaskReq.taskName(req.taskName());
            restTaskReq.params(Arrays.asList(req.argument()));
            restReq = restTaskReq;
        } else if (msg instanceof GridClientTopologyRequest) {
            GridClientTopologyRequest req = (GridClientTopologyRequest)msg;
            GridRestTopologyRequest restTopReq = new GridRestTopologyRequest();
            restTopReq.includeMetrics(req.includeMetrics());
            restTopReq.includeAttributes(req.includeAttributes());
            if (req.nodeId() != null) {
                restTopReq.command(GridRestCommand.NODE);
                restTopReq.nodeId(req.nodeId());
            } else if (req.nodeIp() != null) {
                restTopReq.command(GridRestCommand.NODE);
                restTopReq.nodeIp(req.nodeIp());
            } else {
                restTopReq.command(GridRestCommand.TOPOLOGY);
            }
            restReq = restTopReq;
        } else if (msg instanceof GridClientStateRequest) {
            GridClientStateRequest req = (GridClientStateRequest)msg;
            GridRestChangeStateRequest restChangeReq = new GridRestChangeStateRequest();
            if (req.isReqCurrentState()) {
                restChangeReq.reqCurrentState();
                restChangeReq.command(GridRestCommand.CLUSTER_CURRENT_STATE);
            } else {
                restChangeReq.active(req.active());
                restChangeReq.command(req.active() ? GridRestCommand.CLUSTER_ACTIVATE : GridRestCommand.CLUSTER_DEACTIVATE);
            }
            restReq = restChangeReq;
        } else if (msg instanceof GridClientClusterStateRequest) {
            GridClientClusterStateRequest req = (GridClientClusterStateRequest)msg;
            boolean forceDeactivation = !(msg instanceof GridClientClusterStateRequestV2) || ((GridClientClusterStateRequestV2)msg).forceDeactivation();
            GridRestClusterStateRequest restChangeReq = new GridRestClusterStateRequest();
            if (req.isReqCurrentState()) {
                restChangeReq.reqCurrentMode();
                restChangeReq.command(GridRestCommand.CLUSTER_STATE);
            } else {
                restChangeReq.state(req.state());
                restChangeReq.command(GridRestCommand.CLUSTER_SET_STATE);
                restChangeReq.forceDeactivation(forceDeactivation);
            }
            restReq = restChangeReq;
        } else if (msg instanceof GridClientClusterNameRequest) {
            restReq = new GridRestClusterNameRequest();
        }
        if (restReq != null) {
            restReq.destinationId(msg.destinationId());
            restReq.clientId(msg.clientId());
            restReq.sessionToken(msg.sessionToken());
            restReq.address(ses.remoteAddress());
            restReq.certificates(ses.certificates());
            restReq.credentials(ses.meta(CREDS_KEY));
            restReq.userAttributes((Map)ses.meta(USER_ATTR_KEY));
        }
        return restReq;
    }

    @Override
    public void onSessionIdleTimeout(GridNioSession ses) {
        ses.close();
    }

    static {
        cacheCmdMap.put(GridClientCacheRequest.GridCacheOperation.PUT, GridRestCommand.CACHE_PUT);
        cacheCmdMap.put(GridClientCacheRequest.GridCacheOperation.PUT_ALL, GridRestCommand.CACHE_PUT_ALL);
        cacheCmdMap.put(GridClientCacheRequest.GridCacheOperation.GET, GridRestCommand.CACHE_GET);
        cacheCmdMap.put(GridClientCacheRequest.GridCacheOperation.GET_ALL, GridRestCommand.CACHE_GET_ALL);
        cacheCmdMap.put(GridClientCacheRequest.GridCacheOperation.RMV, GridRestCommand.CACHE_REMOVE);
        cacheCmdMap.put(GridClientCacheRequest.GridCacheOperation.RMV_ALL, GridRestCommand.CACHE_REMOVE_ALL);
        cacheCmdMap.put(GridClientCacheRequest.GridCacheOperation.REPLACE, GridRestCommand.CACHE_REPLACE);
        cacheCmdMap.put(GridClientCacheRequest.GridCacheOperation.CAS, GridRestCommand.CACHE_CAS);
        cacheCmdMap.put(GridClientCacheRequest.GridCacheOperation.METRICS, GridRestCommand.CACHE_METRICS);
        cacheCmdMap.put(GridClientCacheRequest.GridCacheOperation.APPEND, GridRestCommand.CACHE_APPEND);
        cacheCmdMap.put(GridClientCacheRequest.GridCacheOperation.PREPEND, GridRestCommand.CACHE_PREPEND);
        SUPP_VERS.add((short)1);
    }
}

