/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.schema;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.QueryTypeDescriptorImpl;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexOperationCancellationToken;
import org.apache.ignite.internal.processors.query.schema.SchemaOperationException;
import org.apache.ignite.internal.processors.query.schema.operation.SchemaAbstractOperation;
import org.apache.ignite.internal.processors.query.schema.operation.SchemaAddQueryEntityOperation;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.Nullable;

public class SchemaOperationWorker
extends GridWorker {
    private final GridQueryProcessor qryProc;
    private final IgniteUuid depId;
    private final SchemaAbstractOperation op;
    private final boolean nop;
    private final boolean cacheRegistered;
    private final QueryTypeDescriptorImpl type;
    private final GridFutureAdapter fut;
    private final GridFutureAdapter pubFut;
    private final AtomicBoolean startGuard = new AtomicBoolean();
    private final SchemaIndexOperationCancellationToken cancelToken = new SchemaIndexOperationCancellationToken();

    public SchemaOperationWorker(GridKernalContext ctx, GridQueryProcessor qryProc, IgniteUuid depId, SchemaAbstractOperation op, boolean nop, @Nullable SchemaOperationException err, boolean cacheRegistered, @Nullable QueryTypeDescriptorImpl type) {
        super(ctx.igniteInstanceName(), SchemaOperationWorker.workerName(op), ctx.log(SchemaOperationWorker.class));
        this.qryProc = qryProc;
        this.depId = depId;
        this.op = op;
        this.nop = nop;
        this.cacheRegistered = cacheRegistered;
        this.type = type;
        this.fut = new GridFutureAdapter();
        if (err != null) {
            this.fut.onDone(err);
        } else if (nop || !cacheRegistered && !(op instanceof SchemaAddQueryEntityOperation)) {
            this.fut.onDone();
        }
        this.pubFut = this.publicFuture(this.fut);
    }

    @Override
    protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
        try {
            this.qryProc.processSchemaOperationLocal(this.op, this.type, this.depId, this.cancelToken);
            this.fut.onDone();
        }
        catch (Throwable e) {
            this.fut.onDone(QueryUtils.wrapIfNeeded(e));
        }
    }

    public SchemaOperationWorker start() {
        if (this.startGuard.compareAndSet(false, true) && !this.fut.isDone()) {
            new IgniteThread(this).start();
        }
        return this;
    }

    private GridFutureAdapter<?> publicFuture(GridFutureAdapter fut) {
        final GridFutureAdapter chainedFut = new GridFutureAdapter();
        fut.listen(new IgniteInClosure<IgniteInternalFuture>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void apply(IgniteInternalFuture fut) {
                Exception err = null;
                try {
                    fut.get();
                    if (SchemaOperationWorker.this.cacheRegistered && !SchemaOperationWorker.this.nop) {
                        SchemaOperationWorker.this.qryProc.onLocalOperationFinished(SchemaOperationWorker.this.op, SchemaOperationWorker.this.type);
                    }
                }
                catch (Exception e) {
                    err = e;
                }
                finally {
                    chainedFut.onDone(null, err);
                }
            }
        });
        return chainedFut;
    }

    public boolean nop() {
        return this.nop;
    }

    public boolean cacheRegistered() {
        return this.cacheRegistered;
    }

    @Override
    public void cancel() {
        if (this.cancelToken.cancel()) {
            super.cancel();
        }
    }

    public SchemaAbstractOperation operation() {
        return this.op;
    }

    public IgniteInternalFuture future() {
        return this.pubFut;
    }

    private static String workerName(SchemaAbstractOperation op) {
        return "schema-op-worker-" + op.id();
    }
}

