/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.events;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.PlatformEventFilterListener;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;

public class PlatformEventFilterListenerImpl
implements PlatformEventFilterListener,
Externalizable {
    private static final long serialVersionUID = 0L;
    private Object pred;
    private int[] types;
    private transient long hnd;
    private transient PlatformContext ctx;

    public PlatformEventFilterListenerImpl() {
    }

    public PlatformEventFilterListenerImpl(long hnd, PlatformContext ctx) {
        assert (ctx != null);
        assert (hnd != 0L);
        this.hnd = hnd;
        this.ctx = ctx;
        this.pred = null;
        this.types = null;
    }

    public PlatformEventFilterListenerImpl(Object pred, int ... types) {
        assert (pred != null);
        this.pred = pred;
        this.types = types;
    }

    @Override
    public boolean apply(Event evt) {
        return this.apply0(null, evt);
    }

    @Override
    public boolean apply(UUID uuid, Event evt) {
        return this.apply0(uuid, evt);
    }

    private boolean apply0(UUID uuid, Event evt) {
        if (!this.ctx.isEventTypeSupported(evt.type())) {
            return false;
        }
        if (this.types != null) {
            boolean match = false;
            for (int type : this.types) {
                if (type != evt.type()) continue;
                match = true;
                break;
            }
            if (!match) {
                return false;
            }
        }
        PlatformMemory mem = this.ctx.memory().allocate();
        Object object = null;
        try {
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx writer = this.ctx.writer(out);
            this.ctx.writeEvent(writer, evt);
            writer.writeUuid(uuid);
            out.synchronize();
            int res = this.ctx.gateway().eventFilterApply(this.hnd, mem.pointer());
            boolean bl = res != 0;
            return bl;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (mem != null) {
                if (object != null) {
                    try {
                        mem.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    mem.close();
                }
            }
        }
    }

    @Override
    public void onClose() {
        this.ctx.gateway().eventFilterDestroy(this.hnd);
    }

    @Override
    public void initialize(GridKernalContext gridCtx) {
        this.ctx = PlatformUtils.platformContext(gridCtx.grid());
        try (PlatformMemory mem = this.ctx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx writer = this.ctx.writer(out);
            writer.writeObjectDetached(this.pred);
            out.synchronize();
            this.hnd = this.ctx.gateway().eventFilterCreate(mem.pointer());
        }
    }

    public boolean equals(Object o) {
        return this == o || o != null && o instanceof PlatformEventFilterListenerImpl && this.hnd == ((PlatformEventFilterListenerImpl)o).hnd;
    }

    public int hashCode() {
        return (int)(this.hnd ^ this.hnd >>> 32);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.pred);
        out.writeObject(this.types);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.pred = in.readObject();
        this.types = (int[])in.readObject();
    }
}

