/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.scanner;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.FilteredWalIterator;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.IgniteWalIteratorFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.WalFilters;
import org.apache.ignite.internal.processors.cache.persistence.wal.scanner.ScannerHandler;
import org.apache.ignite.internal.util.lang.IgniteThrowableSupplier;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.NotNull;

public class WalScanner {
    private final IgniteThrowableSupplier<WALIterator> walIteratorSupplier;

    WalScanner(WALIterator preconfiguredIter, IgniteWalIteratorFactory.IteratorParametersBuilder parametersBuilder, IgniteWalIteratorFactory factory) {
        this.walIteratorSupplier = preconfiguredIter != null ? () -> preconfiguredIter : () -> WalScanner.standaloneWalIterator(factory == null ? new IgniteWalIteratorFactory() : factory, parametersBuilder);
    }

    private static WALIterator standaloneWalIterator(IgniteWalIteratorFactory iteratorFactory, IgniteWalIteratorFactory.IteratorParametersBuilder parametersBuilder) throws IgniteCheckedException {
        return iteratorFactory.iterator(parametersBuilder.copy().addFilter((type, pointer) -> type.purpose() == WALRecord.RecordPurpose.PHYSICAL || type.purpose() == WALRecord.RecordPurpose.MIXED));
    }

    @NotNull
    public ScanTerminateStep findAllRecordsFor(@NotNull Collection<T2<Integer, Long>> groupAndPageIds) {
        Objects.requireNonNull(groupAndPageIds);
        HashSet<T2<Integer, Long>> groupAndPageIds0 = new HashSet<T2<Integer, Long>>(groupAndPageIds);
        Set<T2<Integer, Integer>> groupAndParts = groupAndPageIds0.stream().map(tup -> new T2(tup.get1(), PageIdUtils.partId((Long)tup.get2()))).collect(Collectors.toSet());
        Predicate<IgniteBiTuple<WALPointer, WALRecord>> filter = WalFilters.checkpoint().or(WalFilters.pageOwner(groupAndPageIds0)).or(WalFilters.partitionMetaStateUpdate(groupAndParts));
        return new ScanTerminateStep(() -> new FilteredWalIterator(this.walIteratorSupplier.get(), filter));
    }

    public static WalScanner buildWalScanner(WALIterator walIterator) {
        return new WalScanner(walIterator, null, null);
    }

    public static WalScanner buildWalScanner(IgniteWalIteratorFactory.IteratorParametersBuilder parametersBuilder) {
        return WalScanner.buildWalScanner(parametersBuilder, null);
    }

    public static WalScanner buildWalScanner(IgniteWalIteratorFactory.IteratorParametersBuilder parametersBuilder, IgniteWalIteratorFactory factory) {
        return new WalScanner(null, parametersBuilder, factory);
    }

    public static class ScanTerminateStep {
        final IgniteThrowableSupplier<WALIterator> iterSupplier;

        private ScanTerminateStep(IgniteThrowableSupplier<WALIterator> iterSupplier) {
            this.iterSupplier = iterSupplier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forEach(@NotNull ScannerHandler handler) throws IgniteCheckedException {
            try (WALIterator it = this.iterSupplier.get();){
                while (it.hasNext()) {
                    handler.handle((IgniteBiTuple)it.next());
                }
            }
            finally {
                handler.finish();
            }
        }
    }
}

