/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryInfoCollection;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheMetricsImpl;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMvccEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCachePartitionExchangeManager;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionPartialCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionDemandMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionExchangeId;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionSupplyMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPreloader;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPreloaderAssignments;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteDhtDemandedPartitionsMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.dr.GridDrType;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.IgniteInClosureX;
import org.apache.ignite.internal.util.lang.IgnitePredicateX;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.spi.IgniteSpiException;
import org.jetbrains.annotations.Nullable;

public class GridDhtPartitionDemander {
    private final GridCacheSharedContext<?, ?> ctx;
    private final CacheGroupContext grp;
    private final IgniteLogger log;
    @GridToStringInclude
    private final GridFutureAdapter syncFut = new GridFutureAdapter();
    @GridToStringInclude
    private volatile RebalanceFuture rebalanceFut;
    private AtomicReference<GridTimeoutObject> lastTimeoutObj = new AtomicReference();
    private volatile GridDhtPartitionsExchangeFuture lastExchangeFut;
    private final AtomicLong lastCancelledTime = new AtomicLong(-1L);

    public GridDhtPartitionDemander(CacheGroupContext grp) {
        assert (grp != null);
        this.grp = grp;
        this.ctx = grp.shared();
        this.log = this.ctx.logger(this.getClass());
        boolean enabled = grp.rebalanceEnabled() && !this.ctx.kernalContext().clientNode();
        this.rebalanceFut = new RebalanceFuture();
        if (!enabled) {
            this.rebalanceFut.onDone(true);
            this.syncFut.onDone();
        }
        HashMap tops = new HashMap();
        String metricGroupName = MetricUtils.metricName("cacheGroups", grp.cacheOrGroupName());
        MetricRegistry mreg = grp.shared().kernalContext().metric().registry(metricGroupName);
        mreg.register("RebalancingPartitionsLeft", () -> this.rebalanceFut.partitionsLeft.get(), "The number of cache group partitions left to be rebalanced.");
        mreg.register("RebalancingReceivedKeys", () -> this.rebalanceFut.receivedKeys.get(), "The number of currently rebalanced keys for the whole cache group.");
        mreg.register("RebalancingReceivedBytes", () -> this.rebalanceFut.receivedBytes.get(), "The number of currently rebalanced bytes of this cache group.");
        mreg.register("RebalancingStartTime", () -> this.rebalanceFut.startTime, "The time the first partition demand message was sent. If there are no messages to send, the rebalancing time will be undefined.");
        mreg.register("RebalancingEndTime", () -> this.rebalanceFut.endTime, "The time the rebalancing was completed. If the rebalancing completed with an error, was cancelled, or the start time was undefined, the rebalancing end time will be undefined.");
        mreg.register("RebalancingLastCancelledTime", () -> this.lastCancelledTime.get(), "The time the rebalancing was completed with an error or was cancelled. If there were several such cases, the metric stores the last time. The metric displays the value even if there is no rebalancing process.");
    }

    void start() {
    }

    void stop() {
        try {
            this.rebalanceFut.cancel();
        }
        catch (Exception ignored) {
            this.rebalanceFut.onDone(false);
        }
        this.lastExchangeFut = null;
        this.lastTimeoutObj.set(null);
        this.syncFut.onDone();
    }

    IgniteInternalFuture<?> syncFuture() {
        return this.syncFut;
    }

    IgniteInternalFuture<Boolean> rebalanceFuture() {
        return this.rebalanceFut;
    }

    IgniteInternalFuture<Boolean> forceRebalance() {
        GridDhtPartitionsExchangeFuture exchFut;
        GridTimeoutObject obj = this.lastTimeoutObj.getAndSet(null);
        if (obj != null) {
            this.ctx.time().removeTimeoutObject(obj);
        }
        if ((exchFut = this.lastExchangeFut) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Forcing rebalance event for future: " + exchFut);
            }
            final GridFutureAdapter<Boolean> fut = new GridFutureAdapter<Boolean>();
            exchFut.listen(new CI1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                @Override
                public void apply(IgniteInternalFuture<AffinityTopologyVersion> t) {
                    IgniteInternalFuture<Boolean> fut0 = GridDhtPartitionDemander.this.ctx.exchange().forceRebalance(exchFut.exchangeId());
                    fut0.listen(new IgniteInClosure<IgniteInternalFuture<Boolean>>(){

                        @Override
                        public void apply(IgniteInternalFuture<Boolean> future) {
                            try {
                                fut.onDone(future.get());
                            }
                            catch (Exception e) {
                                fut.onDone(e);
                            }
                        }
                    });
                }
            });
            return fut;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Ignoring force rebalance request (no topology event happened yet).");
        }
        return new GridFinishedFuture<Boolean>(true);
    }

    void onTopologyChanged(GridDhtPartitionsExchangeFuture lastFut) {
        this.lastExchangeFut = lastFut;
    }

    Collection<UUID> remainingNodes() {
        return this.rebalanceFut.remainingNodes();
    }

    @Nullable
    RebalanceFuture addAssignments(GridDhtPreloaderAssignments assignments, boolean force, long rebalanceId, RebalanceFuture next, @Nullable GridCompoundFuture<Boolean, Boolean> forcedRebFut, GridCompoundFuture<Boolean, Boolean> compatibleRebFut) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Adding partition assignments: " + assignments);
        }
        assert (force == (forcedRebFut != null));
        long delay = this.grp.config().getRebalanceDelay();
        if ((delay == 0L || force) && assignments != null) {
            RebalanceFuture oldFut = this.rebalanceFut;
            if (assignments.cancelled()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Rebalancing skipped due to cancelled assignments.");
                }
                return null;
            }
            if (assignments.isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Rebalancing skipped due to empty assignments.");
                }
                if (oldFut.isInitial()) {
                    oldFut.onDone(true);
                }
                ((GridFutureAdapter)this.grp.preloader().syncFuture()).onDone();
                return null;
            }
            if (!force && (!oldFut.isDone() || ((Boolean)oldFut.result()).booleanValue()) && oldFut.compatibleWith(assignments)) {
                if (!oldFut.isDone()) {
                    compatibleRebFut.add(oldFut);
                }
                return null;
            }
            RebalanceFuture fut = new RebalanceFuture(this.grp, assignments, this.log, rebalanceId, next, this.lastCancelledTime);
            if (!this.grp.localWalEnabled()) {
                fut.listen(new IgniteInClosureX<IgniteInternalFuture<Boolean>>(){

                    @Override
                    public void applyx(IgniteInternalFuture<Boolean> future) throws IgniteCheckedException {
                        if (future.get().booleanValue()) {
                            GridDhtPartitionDemander.this.ctx.walState().onGroupRebalanceFinished(GridDhtPartitionDemander.this.grp.groupId());
                        }
                    }
                });
            }
            if (!oldFut.isInitial()) {
                oldFut.tryCancel();
            } else {
                fut.listen(f -> oldFut.onDone(f.result()));
            }
            if (this.grp.persistenceEnabled()) {
                for (Map.Entry e : assignments.entrySet()) {
                    for (Integer partId : ((GridDhtPartitionDemandMessage)e.getValue()).partitions().fullSet()) {
                        GridDhtLocalPartition part = this.grp.topology().localPartition(partId);
                        if (part == null || part.state() != GridDhtPartitionState.MOVING) continue;
                        part.clearAsync();
                    }
                }
            }
            if (forcedRebFut != null) {
                forcedRebFut.add(fut);
            }
            this.rebalanceFut = fut;
            for (GridCacheContext cctx : this.grp.caches()) {
                if (!cctx.statisticsEnabled()) continue;
                CacheMetricsImpl metrics = cctx.cache().metrics0();
                metrics.clearRebalanceCounters();
                for (GridDhtPartitionDemandMessage msg : assignments.values()) {
                    for (Integer partId : msg.partitions().fullSet()) {
                        metrics.onRebalancingKeysCountEstimateReceived(this.grp.topology().globalPartSizes().get(partId));
                    }
                    CachePartitionPartialCountersMap histMap = msg.partitions().historicalMap();
                    for (int i = 0; i < histMap.size(); ++i) {
                        long from = histMap.initialUpdateCounterAt(i);
                        long to = histMap.updateCounterAt(i);
                        metrics.onRebalancingKeysCountEstimateReceived(to - from);
                    }
                }
                metrics.startRebalance(0L);
            }
            fut.sendRebalanceStartedEvent();
            return fut;
        }
        if (delay > 0L) {
            for (GridCacheContext cctx : this.grp.caches()) {
                if (!cctx.statisticsEnabled()) continue;
                CacheMetricsImpl metrics = cctx.cache().metrics0();
                metrics.startRebalance(delay);
            }
            GridTimeoutObject obj = this.lastTimeoutObj.get();
            if (obj != null) {
                this.ctx.time().removeTimeoutObject(obj);
            }
            final GridDhtPartitionsExchangeFuture exchFut = this.lastExchangeFut;
            assert (exchFut != null) : "Delaying rebalance process without topology event.";
            obj = new GridTimeoutObjectAdapter(delay){

                @Override
                public void onTimeout() {
                    exchFut.listen(new CI1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                        @Override
                        public void apply(IgniteInternalFuture<AffinityTopologyVersion> f) {
                            GridDhtPartitionDemander.this.ctx.exchange().forceRebalance(exchFut.exchangeId());
                        }
                    });
                }
            };
            this.lastTimeoutObj.set(obj);
            this.ctx.time().addTimeoutObject(obj);
        }
        return null;
    }

    public void registerSupplyMessage(UUID nodeId, GridDhtPartitionSupplyMessage supplyMsg, Runnable r) {
        RebalanceFuture fut = this.rebalanceFut;
        if (fut.isActual(supplyMsg.rebalanceId())) {
            boolean historical = false;
            for (Integer p : supplyMsg.infos().keySet()) {
                ((LongAdder)fut.queued.get(p)).increment();
                if (!fut.historical.contains(p)) continue;
                historical = true;
            }
            if (historical) {
                this.ctx.kernalContext().getStripedRebalanceExecutorService().execute(r, Math.abs(nodeId.hashCode()));
            } else {
                this.ctx.kernalContext().getRebalanceExecutorService().execute(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSupplyMessage(UUID nodeId, GridDhtPartitionSupplyMessage supplyMsg) {
        block50: {
            AffinityTopologyVersion topVer = supplyMsg.topologyVersion();
            RebalanceFuture fut = this.rebalanceFut;
            fut.cancelLock.readLock().lock();
            try {
                if (fut.isDone()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Supply message ignored (rebalance completed) [" + this.demandRoutineInfo(nodeId, supplyMsg) + "]");
                    }
                    return;
                }
                ClusterNode node = this.ctx.node(nodeId);
                if (node == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Supply message ignored (supplier has left cluster) [" + this.demandRoutineInfo(nodeId, supplyMsg) + "]");
                    }
                    return;
                }
                if (!fut.isActual(supplyMsg.rebalanceId())) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Supply message ignored (topology changed) [" + this.demandRoutineInfo(nodeId, supplyMsg) + "]");
                    }
                    return;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received supply message [" + this.demandRoutineInfo(nodeId, supplyMsg) + "]");
                }
                if (supplyMsg.classError() != null) {
                    U.warn(this.log, "Rebalancing from node cancelled [" + this.demandRoutineInfo(nodeId, supplyMsg) + "]. Supply message couldn't be unmarshalled: " + supplyMsg.classError());
                    fut.cancel(nodeId);
                    return;
                }
                if (supplyMsg.error() != null) {
                    U.warn(this.log, "Rebalancing from node cancelled [" + this.demandRoutineInfo(nodeId, supplyMsg) + "]]. Supplier has failed with error: " + supplyMsg.error());
                    fut.cancel(nodeId);
                    return;
                }
                GridDhtPartitionTopology top = this.grp.topology();
                this.rebalanceFut.receivedBytes.addAndGet(supplyMsg.messageSize());
                if (this.grp.sharedGroup()) {
                    for (GridCacheContext gridCacheContext : this.grp.caches()) {
                        if (!gridCacheContext.statisticsEnabled()) continue;
                        long l = supplyMsg.keysForCache(gridCacheContext.cacheId());
                        if (l != -1L) {
                            gridCacheContext.cache().metrics0().onRebalancingKeysCountEstimateReceived(l);
                        }
                        gridCacheContext.cache().metrics0().onRebalanceBatchReceived(supplyMsg.messageSize());
                    }
                } else {
                    GridCacheContext cctx = this.grp.singleCacheContext();
                    if (cctx.statisticsEnabled()) {
                        if (supplyMsg.estimatedKeysCount() != -1L) {
                            cctx.cache().metrics0().onRebalancingKeysCountEstimateReceived(supplyMsg.estimatedKeysCount());
                        }
                        cctx.cache().metrics0().onRebalanceBatchReceived(supplyMsg.messageSize());
                    }
                }
                try {
                    AffinityAssignment aff = this.grp.affinity().cachedAffinity(topVer);
                    for (Map.Entry<Integer, CacheEntryInfoCollection> entry : supplyMsg.infos().entrySet()) {
                        int p = entry.getKey();
                        if (aff.get(p).contains(this.ctx.localNode())) {
                            GridDhtLocalPartition part;
                            try {
                                part = top.localPartition(p, topVer, true);
                            }
                            catch (GridDhtInvalidPartitionException err) {
                                assert (!topVer.equals(top.lastTopologyChangeVersion()));
                                if (!this.log.isDebugEnabled()) continue;
                                this.log.debug("Failed to get partition for rebalancing [grp=" + this.grp.cacheOrGroupName() + ", err=" + err + ", p=" + p + ", topVer=" + topVer + ", lastTopVer=" + top.lastTopologyChangeVersion() + ']');
                                continue;
                            }
                            assert (part != null);
                            boolean last = supplyMsg.last().containsKey(p);
                            if (part.state() == GridDhtPartitionState.MOVING) {
                                boolean reserved = part.reserve();
                                assert (reserved) : "Failed to reserve partition [igniteInstanceName=" + this.ctx.igniteInstanceName() + ", grp=" + this.grp.cacheOrGroupName() + ", part=" + part + ']';
                                part.beforeApplyBatch(last);
                                try {
                                    block49: {
                                        Iterator<GridCacheEntryInfo> infos = entry.getValue().infos().iterator();
                                        try {
                                            if (this.grp.mvccEnabled()) {
                                                this.mvccPreloadEntries(topVer, node, p, infos);
                                            } else {
                                                this.preloadEntries(topVer, p, infos);
                                            }
                                        }
                                        catch (GridDhtInvalidPartitionException ignored) {
                                            if (!this.log.isDebugEnabled()) break block49;
                                            this.log.debug("Partition became invalid during rebalancing (will ignore): " + p);
                                        }
                                    }
                                    ((LongAdder)fut.processed.get(p)).increment();
                                    if (!last) continue;
                                    this.ownPartition(fut, p, nodeId, supplyMsg);
                                    continue;
                                }
                                finally {
                                    part.release();
                                    continue;
                                }
                            }
                            if (last) {
                                fut.partitionDone(nodeId, p, false);
                            }
                            if (!this.log.isDebugEnabled()) continue;
                            this.log.debug("Skipping rebalancing partition (state is not MOVING): [" + this.demandRoutineInfo(nodeId, supplyMsg) + ", p=" + p + "]");
                            continue;
                        }
                        fut.partitionDone(nodeId, p, false);
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Skipping rebalancing partition (affinity changed): [" + this.demandRoutineInfo(nodeId, supplyMsg) + ", p=" + p + "]");
                    }
                    for (Integer n : supplyMsg.missed()) {
                        if (!aff.get(n).contains(this.ctx.localNode())) continue;
                        fut.partitionMissed(nodeId, n);
                    }
                    for (Integer n : supplyMsg.missed()) {
                        fut.partitionDone(nodeId, n, false);
                    }
                    GridDhtPartitionDemandMessage gridDhtPartitionDemandMessage = new GridDhtPartitionDemandMessage(supplyMsg.rebalanceId(), supplyMsg.topologyVersion(), this.grp.groupId());
                    gridDhtPartitionDemandMessage.timeout(this.grp.preloader().timeout());
                    if (!fut.isDone()) {
                        try {
                            this.ctx.io().sendOrderedMessage(node, gridDhtPartitionDemandMessage.topic(), gridDhtPartitionDemandMessage.convertIfNeeded(node.version()), this.grp.ioPolicy(), this.grp.preloader().timeout());
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Send next demand message [" + this.demandRoutineInfo(nodeId, supplyMsg) + "]");
                            }
                            break block50;
                        }
                        catch (ClusterTopologyCheckedException clusterTopologyCheckedException) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Supplier has left [" + this.demandRoutineInfo(nodeId, supplyMsg) + ", errMsg=" + clusterTopologyCheckedException.getMessage() + ']');
                            }
                            break block50;
                        }
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Will not request next demand message [" + this.demandRoutineInfo(nodeId, supplyMsg) + ", rebalanceFuture=" + fut + "]");
                    }
                }
                catch (IgniteCheckedException | IgniteSpiException e) {
                    fut.cancel(nodeId);
                    LT.error(this.log, e, "Error during rebalancing [" + this.demandRoutineInfo(nodeId, supplyMsg) + ", err=" + e + ']');
                }
            }
            finally {
                fut.cancelLock.readLock().unlock();
            }
        }
    }

    protected void ownPartition(RebalanceFuture fut, int p, UUID nodeId, GridDhtPartitionSupplyMessage supplyMsg) {
        if (fut.isDone() || !fut.isActual(supplyMsg.rebalanceId())) {
            return;
        }
        long queued = ((LongAdder)fut.queued.get(p)).sum();
        long processed = ((LongAdder)fut.processed.get(p)).sum();
        if (processed == queued) {
            fut.partitionDone(nodeId, p, true);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Finished rebalancing partition: [" + this.demandRoutineInfo(nodeId, supplyMsg) + ", p=" + p + "]");
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Retrying partition owning: [" + this.demandRoutineInfo(nodeId, supplyMsg) + ", p=" + p + ", processed=" + processed + ", queued=" + queued + "]");
            }
            this.ctx.kernalContext().getRebalanceExecutorService().execute(() -> this.ownPartition(fut, p, nodeId, supplyMsg));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mvccPreloadEntries(AffinityTopologyVersion topVer, ClusterNode node, int p, Iterator<GridCacheEntryInfo> infos) throws IgniteCheckedException {
        GridCacheContext cctx;
        if (!infos.hasNext()) {
            return;
        }
        ArrayList<GridCacheMvccEntryInfo> entryHist = new ArrayList<GridCacheMvccEntryInfo>();
        GridCacheContext gridCacheContext = cctx = this.grp.sharedGroup() ? null : this.grp.singleCacheContext();
        while (infos.hasNext() || !entryHist.isEmpty()) {
            this.ctx.database().checkpointReadLock();
            try {
                for (int i = 0; i < 100; ++i) {
                    boolean flushHistory;
                    boolean hasMore = infos.hasNext();
                    assert (hasMore || !entryHist.isEmpty());
                    GridCacheMvccEntryInfo entry = null;
                    if (hasMore) {
                        entry = (GridCacheMvccEntryInfo)infos.next();
                        GridCacheMvccEntryInfo prev = entryHist.isEmpty() ? null : (GridCacheMvccEntryInfo)entryHist.get(0);
                        flushHistory = prev != null && (this.grp.sharedGroup() && prev.cacheId() != entry.cacheId() || !prev.key().equals(entry.key()));
                    } else {
                        flushHistory = true;
                    }
                    if (flushHistory) {
                        assert (!entryHist.isEmpty());
                        int cacheId = ((GridCacheMvccEntryInfo)entryHist.get(0)).cacheId();
                        if (this.grp.sharedGroup() && (cctx == null || cacheId != cctx.cacheId())) {
                            assert (cacheId != 0);
                            cctx = this.grp.shared().cacheContext(cacheId);
                        }
                        if (cctx != null) {
                            this.mvccPreloadEntry(cctx, node, entryHist, topVer, p);
                            this.rebalanceFut.receivedKeys.incrementAndGet();
                            this.updateGroupMetrics();
                        }
                        if (!hasMore) {
                            return;
                        }
                        entryHist.clear();
                    }
                    entryHist.add(entry);
                }
            }
            finally {
                this.ctx.database().checkpointReadUnlock();
            }
        }
    }

    private void preloadEntries(final AffinityTopologyVersion topVer, int p, Iterator<GridCacheEntryInfo> infos) throws IgniteCheckedException {
        this.grp.offheap().storeEntries(p, infos, new IgnitePredicateX<CacheDataRow>(){

            @Override
            public boolean applyx(CacheDataRow row) throws IgniteCheckedException {
                return GridDhtPartitionDemander.this.preloadEntry(row, topVer);
            }
        });
    }

    private boolean preloadEntry(CacheDataRow row, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        GridCacheContext<?, ?> cctx;
        assert (!this.grp.mvccEnabled());
        assert (this.ctx.database().checkpointLockIsHeldByThread());
        this.rebalanceFut.receivedKeys.incrementAndGet();
        this.updateGroupMetrics();
        GridCacheContext<?, ?> gridCacheContext = cctx = this.grp.sharedGroup() ? this.ctx.cacheContext(row.cacheId()) : this.grp.singleCacheContext();
        if (cctx == null) {
            return false;
        }
        cctx = cctx.isNear() ? cctx.dhtCache().context() : cctx;
        GridCacheEntryEx cached = cctx.cache().entryEx(row.key(), topVer);
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Rebalancing key [key=" + cached.key() + ", part=" + cached.partition() + ", grpId=" + this.grp.groupId() + ']');
            }
            assert (row.expireTime() >= 0L) : row.expireTime();
            if (cached.initialValue(row.value(), row.version(), null, null, (byte)0, (byte)0, 0L, row.expireTime(), true, topVer, cctx.isDrEnabled() ? GridDrType.DR_PRELOAD : GridDrType.DR_NONE, false, row)) {
                cached.touch();
                if (cctx.events().isRecordable(84) && !cached.isInternal()) {
                    cctx.events().addEvent(cached.partition(), cached.key(), cctx.localNodeId(), null, null, null, 84, row.value(), true, null, false, null, null, null, true);
                }
                return true;
            }
            cached.touch();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Rebalancing entry is already in cache (will ignore) [key=" + cached.key() + ", part=" + cached.partition() + ']');
            }
        }
        catch (GridCacheEntryRemovedException ignored) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Entry has been concurrently removed while rebalancing (will ignore) [key=" + cached.key() + ", part=" + cached.partition() + ']');
            }
        }
        catch (IgniteInterruptedCheckedException e) {
            throw e;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteCheckedException("Failed to cache rebalanced entry (will stop rebalancing) [key=" + row.key() + ", part=" + row.partition() + ']', e);
        }
        return false;
    }

    private boolean mvccPreloadEntry(GridCacheContext cctx, ClusterNode from, List<GridCacheMvccEntryInfo> history, AffinityTopologyVersion topVer, int p) throws IgniteCheckedException {
        assert (this.ctx.database().checkpointLockIsHeldByThread());
        assert (!history.isEmpty());
        GridCacheMvccEntryInfo info = history.get(0);
        assert (info.key() != null);
        try {
            GridCacheEntryEx cached = null;
            try {
                cached = cctx.cache().entryEx(info.key(), topVer);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Rebalancing key [key=" + info.key() + ", part=" + p + ", node=" + from.id() + ']');
                }
                if (cached.mvccPreloadEntry(history)) {
                    cached.touch();
                    if (cctx.events().isRecordable(84) && !cached.isInternal()) {
                        cctx.events().addEvent(cached.partition(), cached.key(), cctx.localNodeId(), null, null, null, 84, null, true, null, false, null, null, null, true);
                    }
                    return true;
                }
                cached.touch();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Rebalancing entry is already in cache (will ignore) [key=" + cached.key() + ", part=" + p + ']');
                }
            }
            catch (GridCacheEntryRemovedException ignored) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Entry has been concurrently removed while rebalancing (will ignore) [key=" + cached.key() + ", part=" + p + ']');
                }
            }
        }
        catch (IgniteInterruptedCheckedException | ClusterTopologyCheckedException e) {
            throw e;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteCheckedException("Failed to cache rebalanced entry (will stop rebalancing) [local=" + this.ctx.localNode() + ", node=" + from.id() + ", key=" + info.key() + ", part=" + p + ']', e);
        }
        return false;
    }

    private String demandRoutineInfo(UUID supplier, GridDhtPartitionSupplyMessage supplyMsg) {
        return "grp=" + this.grp.cacheOrGroupName() + ", topVer=" + supplyMsg.topologyVersion() + ", supplier=" + supplier;
    }

    private void updateGroupMetrics() {
        for (GridCacheContext cctx0 : this.grp.caches()) {
            if (!cctx0.statisticsEnabled()) continue;
            cctx0.cache().metrics0().onRebalanceKeyReceived();
        }
    }

    public String toString() {
        return S.toString(GridDhtPartitionDemander.class, this);
    }

    public static class RebalanceFuture
    extends GridFutureAdapter<Boolean> {
        private static final AtomicReferenceFieldUpdater<RebalanceFuture, RebalanceFutureState> STATE_UPD = AtomicReferenceFieldUpdater.newUpdater(RebalanceFuture.class, RebalanceFutureState.class, "state");
        private final GridCacheSharedContext<?, ?> ctx;
        private volatile RebalanceFutureState state = RebalanceFutureState.INIT;
        private final CacheGroupContext grp;
        private final IgniteLogger log;
        private final Map<UUID, IgniteDhtDemandedPartitionsMap> remaining = new HashMap<UUID, IgniteDhtDemandedPartitionsMap>();
        private final Map<UUID, Collection<Integer>> missed = new HashMap<UUID, Collection<Integer>>();
        @GridToStringExclude
        private final GridDhtPartitionExchangeId exchId;
        private final AffinityTopologyVersion topVer;
        private final long rebalanceId;
        private final long routines;
        private final ReentrantReadWriteLock cancelLock;
        private final Map<Integer, LongAdder> queued = new HashMap<Integer, LongAdder>();
        private final Map<Integer, LongAdder> processed = new HashMap<Integer, LongAdder>();
        private final Set<Integer> historical = new HashSet<Integer>();
        private final AtomicLong receivedBytes = new AtomicLong(0L);
        private final AtomicLong receivedKeys = new AtomicLong(0L);
        private final AtomicLong partitionsLeft = new AtomicLong(0L);
        private volatile long startTime = -1L;
        private volatile long endTime = -1L;
        private final AtomicLong lastCancelledTime;
        private final RebalanceFuture next;
        private final GridDhtPreloaderAssignments assignments;
        private final Map<ClusterNode, Set<Integer>> rebalancingParts;

        RebalanceFuture(CacheGroupContext grp, GridDhtPreloaderAssignments assignments, IgniteLogger log, long rebalanceId, RebalanceFuture next, AtomicLong lastCancelledTime) {
            assert (assignments != null);
            this.rebalancingParts = U.newHashMap(assignments.size());
            this.assignments = assignments;
            this.exchId = assignments.exchangeId();
            this.topVer = assignments.topologyVersion();
            this.next = next;
            this.lastCancelledTime = lastCancelledTime;
            assignments.forEach((k, v) -> {
                assert (v.partitions() != null) : "Partitions are null [grp=" + grp.cacheOrGroupName() + ", fromNode=" + k.id() + "]";
                this.remaining.put(k.id(), v.partitions());
                this.partitionsLeft.addAndGet(v.partitions().size());
                this.rebalancingParts.put((ClusterNode)k, (Set<Integer>)new HashSet<Integer>(v.partitions().size()){
                    {
                        super(x0);
                        this.addAll(v.partitions().historicalSet());
                        this.addAll(v.partitions().fullSet());
                    }
                });
                this.historical.addAll(v.partitions().historicalSet());
                Stream.concat(v.partitions().historicalSet().stream(), v.partitions().fullSet().stream()).forEach(p -> {
                    this.queued.put((Integer)p, new LongAdder());
                    this.processed.put((Integer)p, new LongAdder());
                });
            });
            this.routines = this.remaining.size();
            this.grp = grp;
            this.log = log;
            this.rebalanceId = rebalanceId;
            this.ctx = grp.shared();
            this.cancelLock = new ReentrantReadWriteLock();
        }

        RebalanceFuture() {
            this.rebalancingParts = null;
            this.assignments = null;
            this.exchId = null;
            this.topVer = null;
            this.ctx = null;
            this.grp = null;
            this.log = null;
            this.rebalanceId = -1L;
            this.routines = 0L;
            this.cancelLock = new ReentrantReadWriteLock();
            this.next = null;
            this.lastCancelledTime = new AtomicLong();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestPartitions() {
            if (!STATE_UPD.compareAndSet(this, RebalanceFutureState.INIT, RebalanceFutureState.STARTED)) {
                this.cancel();
                return;
            }
            if (!this.ctx.kernalContext().grid().isRebalanceEnabled()) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Cancel partition demand because rebalance disabled on current node.");
                }
                this.cancel();
                return;
            }
            if (this.isDone()) {
                assert (!((Boolean)this.result()).booleanValue()) : "Rebalance future was done, but partitions never requested [grp=" + this.grp.cacheOrGroupName() + ", topVer=" + this.topologyVersion() + "]";
                return;
            }
            CacheConfiguration cfg = this.grp.config();
            for (Map.Entry e : this.assignments.entrySet()) {
                IgniteDhtDemandedPartitionsMap parts;
                ClusterNode node = (ClusterNode)e.getKey();
                GridDhtPartitionDemandMessage d = (GridDhtPartitionDemandMessage)e.getValue();
                RebalanceFuture rebalanceFuture = this;
                synchronized (rebalanceFuture) {
                    if (this.isDone()) {
                        return;
                    }
                    if (this.startTime == -1L) {
                        this.startTime = System.currentTimeMillis();
                    }
                    parts = this.remaining.get(node.id());
                    U.log(this.log, "Prepared rebalancing [grp=" + this.grp.cacheOrGroupName() + ", mode=" + (Object)((Object)cfg.getRebalanceMode()) + ", supplier=" + node.id() + ", partitionsCount=" + parts.size() + ", topVer=" + this.topologyVersion() + "]");
                }
                if (parts.isEmpty()) continue;
                d.rebalanceId(this.rebalanceId);
                d.timeout(this.grp.preloader().timeout());
                IgniteInternalFuture<?> clearAllFuture = this.clearFullPartitions(this, d.partitions().fullSet());
                clearAllFuture.listen(f -> this.ctx.kernalContext().closure().runLocalSafe(() -> {
                    if (this.isDone()) {
                        return;
                    }
                    try {
                        if (this.log.isInfoEnabled()) {
                            this.log.info("Starting rebalance routine [" + this.grp.cacheOrGroupName() + ", topVer=" + this.topologyVersion() + ", supplier=" + node.id() + ", fullPartitions=" + S.compact(parts.fullSet()) + ", histPartitions=" + S.compact(parts.historicalSet()) + "]");
                        }
                        this.ctx.io().sendOrderedMessage(node, d.topic(), d.convertIfNeeded(node.version()), this.grp.ioPolicy(), d.timeout());
                        RebalanceFuture rebalanceFuture = this;
                        synchronized (rebalanceFuture) {
                            if (this.isDone()) {
                                this.cleanupRemoteContexts(node.id());
                            }
                        }
                    }
                    catch (IgniteCheckedException e1) {
                        ClusterTopologyCheckedException cause = e1.getCause(ClusterTopologyCheckedException.class);
                        if (cause != null) {
                            this.log.warning("Failed to send initial demand request to node. " + e1.getMessage());
                        } else {
                            this.log.error("Failed to send initial demand request to node.", e1);
                        }
                        this.cancel();
                    }
                    catch (Throwable th) {
                        this.log.error("Runtime error caught during initial demand request sending.", th);
                        this.cancel();
                    }
                }, true));
            }
        }

        private IgniteInternalFuture<?> clearFullPartitions(RebalanceFuture fut, Set<Integer> fullPartitions) {
            GridFutureAdapter clearAllFuture = new GridFutureAdapter();
            if (fullPartitions.isEmpty()) {
                clearAllFuture.onDone();
                return clearAllFuture;
            }
            for (GridCacheContext cctx : this.grp.caches()) {
                if (!cctx.statisticsEnabled()) continue;
                CacheMetricsImpl metrics = cctx.cache().metrics0();
                metrics.rebalanceClearingPartitions(fullPartitions.size());
            }
            AtomicInteger clearingPartitions = new AtomicInteger(fullPartitions.size());
            for (int partId : fullPartitions) {
                if (fut.isDone()) {
                    clearAllFuture.onDone();
                    return clearAllFuture;
                }
                GridDhtLocalPartition part = this.grp.topology().localPartition(partId);
                if (part != null && part.state() == GridDhtPartitionState.MOVING) {
                    part.onClearFinished(f -> {
                        if (!fut.isDone()) {
                            if (f.error() != null) {
                                for (GridCacheContext cctx : this.grp.caches()) {
                                    if (!cctx.statisticsEnabled()) continue;
                                    CacheMetricsImpl metrics = cctx.cache().metrics0();
                                    metrics.rebalanceClearingPartitions(0);
                                }
                                this.log.error("Unable to await partition clearing " + part, f.error());
                                fut.cancel();
                                clearAllFuture.onDone(f.error());
                            } else {
                                int remaining = clearingPartitions.decrementAndGet();
                                for (GridCacheContext cctx : this.grp.caches()) {
                                    if (!cctx.statisticsEnabled()) continue;
                                    CacheMetricsImpl metrics = cctx.cache().metrics0();
                                    metrics.rebalanceClearingPartitions(remaining);
                                }
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug("Partition is ready for rebalance [grp=" + this.grp.cacheOrGroupName() + ", p=" + part.id() + ", remaining=" + remaining + "]");
                                }
                                if (remaining == 0) {
                                    clearAllFuture.onDone();
                                }
                            }
                        } else {
                            clearAllFuture.onDone();
                        }
                    });
                    continue;
                }
                int remaining = clearingPartitions.decrementAndGet();
                for (GridCacheContext cctx : this.grp.caches()) {
                    if (!cctx.statisticsEnabled()) continue;
                    CacheMetricsImpl metrics = cctx.cache().metrics0();
                    metrics.rebalanceClearingPartitions(remaining);
                }
                if (remaining != 0) continue;
                clearAllFuture.onDone();
            }
            return clearAllFuture;
        }

        @Override
        public boolean onDone(@Nullable Boolean res, @Nullable Throwable err) {
            if (super.onDone(res, err)) {
                if (this.next != null) {
                    this.next.requestPartitions();
                }
                return true;
            }
            return false;
        }

        public AffinityTopologyVersion topologyVersion() {
            return this.topVer;
        }

        private boolean isActual(long rebalanceId) {
            return this.rebalanceId == rebalanceId;
        }

        public boolean isInitial() {
            return this.topVer == null;
        }

        private void tryCancel() {
            if (STATE_UPD.compareAndSet(this, RebalanceFutureState.INIT, RebalanceFutureState.MARK_CANCELLED)) {
                return;
            }
            this.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            this.cancelLock.writeLock().lock();
            try {
                RebalanceFuture rebalanceFuture = this;
                synchronized (rebalanceFuture) {
                    block10: {
                        if (!this.isDone()) break block10;
                        boolean bl = true;
                        return bl;
                    }
                    U.log(this.log, "Cancelled rebalancing from all nodes [grp=" + this.grp.cacheOrGroupName() + ", topVer=" + this.topologyVersion() + "]");
                    if (!this.ctx.kernalContext().isStopping()) {
                        for (UUID nodeId : this.remaining.keySet()) {
                            this.cleanupRemoteContexts(nodeId);
                        }
                    }
                    this.remaining.clear();
                    this.checkIsDone(true);
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.cancelLock.writeLock().unlock();
            }
        }

        @Override
        public boolean onDone(@Nullable Boolean res, @Nullable Throwable err, boolean cancel) {
            boolean isCancelled;
            assert (!cancel) : "RebalanceFuture cancel is not supported. Use res = false.";
            boolean byThisCall = super.onDone(res, err, cancel);
            boolean bl = isCancelled = res == Boolean.FALSE || this.isFailed();
            if (byThisCall) {
                if (isCancelled) {
                    this.lastCancelledTime.accumulateAndGet(System.currentTimeMillis(), Math::max);
                } else if (this.startTime != -1L) {
                    this.endTime = System.currentTimeMillis();
                }
            }
            return byThisCall;
        }

        private synchronized void cancel(UUID nodeId) {
            if (this.isDone()) {
                return;
            }
            U.log(this.log, "Cancelled rebalancing [grp=" + this.grp.cacheOrGroupName() + ", supplier=" + nodeId + ", topVer=" + this.topologyVersion() + ']');
            this.cleanupRemoteContexts(nodeId);
            this.remaining.remove(nodeId);
            this.onDone(false);
            this.checkIsDone();
        }

        private synchronized void partitionMissed(UUID nodeId, int p) {
            if (this.isDone()) {
                return;
            }
            this.missed.computeIfAbsent(nodeId, k -> new HashSet());
            this.missed.get(nodeId).add(p);
        }

        private void cleanupRemoteContexts(UUID nodeId) {
            block3: {
                ClusterNode node = this.ctx.discovery().node(nodeId);
                if (node == null) {
                    return;
                }
                GridDhtPartitionDemandMessage d = new GridDhtPartitionDemandMessage(-this.rebalanceId, this.topologyVersion(), this.grp.groupId());
                d.timeout(this.grp.preloader().timeout());
                try {
                    Object rebalanceTopic = GridCachePartitionExchangeManager.rebalanceTopic(0);
                    this.ctx.io().sendOrderedMessage(node, rebalanceTopic, d.convertIfNeeded(node.version()), this.grp.ioPolicy(), this.grp.preloader().timeout());
                }
                catch (IgniteCheckedException ignored) {
                    if (!this.log.isDebugEnabled()) break block3;
                    this.log.debug("Failed to send failover context cleanup request to node " + nodeId);
                }
            }
        }

        private synchronized void partitionDone(UUID nodeId, int p, boolean updateState) {
            if (updateState && this.grp.localWalEnabled()) {
                this.grp.topology().own(this.grp.topology().localPartition(p));
            }
            if (this.isDone()) {
                return;
            }
            if (this.grp.eventRecordable(82)) {
                this.rebalanceEvent(p, 82, this.exchId.discoveryEvent());
            }
            IgniteDhtDemandedPartitionsMap parts = this.remaining.get(nodeId);
            assert (parts != null) : "Remaining not found [grp=" + this.grp.cacheOrGroupName() + ", fromNode=" + nodeId + ", part=" + p + "]";
            boolean rmvd = parts.remove(p);
            assert (rmvd) : "Partition already done [grp=" + this.grp.cacheOrGroupName() + ", fromNode=" + nodeId + ", part=" + p + ", left=" + parts + "]";
            if (rmvd) {
                this.partitionsLeft.decrementAndGet();
            }
            if (parts.isEmpty()) {
                int remainingRoutines = this.remaining.size() - 1;
                U.log(this.log, "Completed " + (remainingRoutines == 0 ? "(final) " : "") + "rebalancing [grp=" + this.grp.cacheOrGroupName() + ", supplier=" + nodeId + ", topVer=" + this.topologyVersion() + ", progress=" + (this.routines - (long)remainingRoutines) + "/" + this.routines + "]");
                this.remaining.remove(nodeId);
            }
            this.checkIsDone();
        }

        private void rebalanceEvent(int part, int type, DiscoveryEvent discoEvt) {
            assert (discoEvt != null);
            this.grp.addRebalanceEvent(part, type, discoEvt.eventNode(), discoEvt.type(), discoEvt.timestamp());
        }

        private void rebalanceEvent(int type, DiscoveryEvent discoEvt) {
            this.rebalanceEvent(-1, type, discoEvt);
        }

        private void checkIsDone() {
            this.checkIsDone(false);
        }

        private void checkIsDone(boolean cancelled) {
            if (this.remaining.isEmpty()) {
                this.sendRebalanceFinishedEvent();
                if (this.log.isInfoEnabled()) {
                    this.log.info("Completed rebalance future: " + this);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Partitions have been scheduled to resend [reason=Rebalance is done, grp=" + this.grp.cacheOrGroupName() + "]");
                }
                if (!cancelled) {
                    this.ctx.exchange().scheduleResendPartitions();
                }
                HashSet<Integer> m = new HashSet<Integer>();
                for (Map.Entry<UUID, Collection<Integer>> e : this.missed.entrySet()) {
                    if (e.getValue() == null || e.getValue().isEmpty()) continue;
                    m.addAll(e.getValue());
                }
                if (!m.isEmpty()) {
                    U.log(this.log, "Reassigning partitions that were missed [parts=" + m + ", grpId=" + this.grp.groupId() + ", grpName=" + this.grp.cacheOrGroupName() + ", topVer=" + this.topVer + ']');
                    this.onDone(false);
                    this.ctx.exchange().forceReassign(this.exchId);
                    return;
                }
                if (!cancelled && !this.grp.preloader().syncFuture().isDone()) {
                    ((GridFutureAdapter)this.grp.preloader().syncFuture()).onDone();
                }
                this.onDone(!cancelled);
            }
        }

        private synchronized Collection<UUID> remainingNodes() {
            return this.remaining.keySet();
        }

        private void sendRebalanceStartedEvent() {
            if (this.grp.eventRecordable(80)) {
                this.rebalanceEvent(80, this.exchId.discoveryEvent());
            }
        }

        private void sendRebalanceFinishedEvent() {
            if (this.grp.eventRecordable(81)) {
                this.rebalanceEvent(81, this.exchId.discoveryEvent());
            }
        }

        public boolean compatibleWith(GridDhtPreloaderAssignments otherAssignments) {
            if (this.isInitial() || ((GridDhtPreloader)this.grp.preloader()).disableRebalancingCancellationOptimization()) {
                return false;
            }
            if (this.ctx.exchange().lastAffinityChangedTopologyVersion(this.topVer).equals(this.ctx.exchange().lastAffinityChangedTopologyVersion(otherAssignments.topologyVersion()))) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Rebalancing is forced on the same topology [grp=" + this.grp.cacheOrGroupName() + ", top=" + this.topVer + ']');
                }
                return false;
            }
            if (otherAssignments.affinityReassign()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Some of owned partitions were reassigned through coordinator [grp=" + this.grp.cacheOrGroupName() + ", init=" + this.topVer + " ,other=" + otherAssignments.topologyVersion() + ']');
                }
                return false;
            }
            Set<Object> p0 = new HashSet();
            Set<Integer> p1 = new HashSet<Integer>();
            for (ClusterNode clusterNode : this.rebalancingParts.keySet()) {
                if (this.grp.cacheObjectContext().kernalContext().discovery().alive(clusterNode)) continue;
                return false;
            }
            for (Set set : this.rebalancingParts.values()) {
                p0.addAll(set);
            }
            for (GridDhtPartitionDemandMessage gridDhtPartitionDemandMessage : otherAssignments.values()) {
                p1.addAll(gridDhtPartitionDemandMessage.partitions().fullSet());
                p1.addAll(gridDhtPartitionDemandMessage.partitions().historicalSet());
            }
            if (!p0.containsAll(p1)) {
                return false;
            }
            p1 = Stream.concat(this.grp.affinity().cachedAffinity(otherAssignments.topologyVersion()).primaryPartitions(this.ctx.localNodeId()).stream(), this.grp.affinity().cachedAffinity(otherAssignments.topologyVersion()).backupPartitions(this.ctx.localNodeId()).stream()).collect(Collectors.toSet());
            NavigableSet<AffinityTopologyVersion> toCheck = this.grp.affinity().cachedVersions().headSet(otherAssignments.topologyVersion(), false);
            if (!toCheck.contains(this.topVer)) {
                this.log.warning("History is not enough for checking compatible last rebalance, new rebalance started [grp=" + this.grp.cacheOrGroupName() + ", lastTop=" + this.topVer + ']');
                return false;
            }
            for (AffinityTopologyVersion previousTopVer : toCheck.descendingSet()) {
                if (previousTopVer.before(this.topVer)) break;
                if (!this.ctx.exchange().lastAffinityChangedTopologyVersion(previousTopVer).equals(previousTopVer) || (p0 = Stream.concat(this.grp.affinity().cachedAffinity(previousTopVer).primaryPartitions(this.ctx.localNodeId()).stream(), this.grp.affinity().cachedAffinity(previousTopVer).backupPartitions(this.ctx.localNodeId()).stream()).collect(Collectors.toSet())).equals(p1)) continue;
                return false;
            }
            return true;
        }

        @Override
        public String toString() {
            return S.toString(RebalanceFuture.class, this);
        }
    }

    private static enum RebalanceFutureState {
        INIT,
        STARTED,
        MARK_CANCELLED;

    }
}

