/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.ignite.cache.PartitionLossPolicy;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.TopologyValidator;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheInvalidStateException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.IgniteClusterReadOnlyException;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.jetbrains.annotations.Nullable;

public abstract class GridDhtTopologyFutureAdapter
extends GridFutureAdapter<AffinityTopologyVersion>
implements GridDhtTopologyFuture {
    protected volatile Map<Integer, CacheGroupValidation> grpValidRes = Collections.emptyMap();
    protected volatile boolean clusterIsActive = true;

    protected final CacheGroupValidation validateCacheGroup(CacheGroupContext grp, Collection<ClusterNode> topNodes) {
        TopologyValidator validator;
        List lostParts = grp.isLocal() ? Collections.emptyList() : grp.topology().lostPartitions();
        boolean valid = true;
        if (!grp.systemCache() && (validator = grp.topologyValidator()) != null) {
            valid = validator.validate(topNodes);
        }
        return new CacheGroupValidation(valid, lostParts);
    }

    @Override
    @Nullable
    public final CacheInvalidStateException validateCache(GridCacheContext cctx, boolean recovery, boolean read, @Nullable Object key, @Nullable Collection<?> keys) {
        assert (this.isDone()) : this;
        Throwable err = this.error();
        if (err != null) {
            return new CacheInvalidStateException(err);
        }
        if (!this.clusterIsActive) {
            return new CacheInvalidStateException("Failed to perform cache operation (cluster is not activated): " + cctx.name());
        }
        if (cctx.cache() == null) {
            return new CacheInvalidStateException("Failed to perform cache operation (cache is stopped): " + cctx.name());
        }
        CacheGroupContext grp = cctx.group();
        if (cctx.shared().readOnlyMode() && !read && !GridCacheUtils.isSystemCache(cctx.name())) {
            return new CacheInvalidStateException(new IgniteClusterReadOnlyException(String.format("Failed to perform %s operation (cluster is in read-only mode) [cacheGrp=%s, cache=%s]", "cache", cctx.group().name(), cctx.name())));
        }
        CacheGroupValidation validation = this.grpValidRes.get(grp.groupId());
        if (validation == null) {
            return null;
        }
        if (!read && !validation.isValid()) {
            return new CacheInvalidStateException("Failed to perform cache operation (cache topology is not valid): " + cctx.name());
        }
        if (!validation.hasLostPartitions()) {
            return null;
        }
        PartitionLossPolicy lossPlc = grp.config().getPartitionLossPolicy();
        if (!(read || lossPlc != PartitionLossPolicy.READ_ONLY_SAFE && lossPlc != PartitionLossPolicy.READ_ONLY_ALL)) {
            return new CacheInvalidStateException("Failed to write to cache (cache is moved to a read-only state): " + cctx.name());
        }
        if (read && recovery) {
            return null;
        }
        if (key != null) {
            return this.validateKey(cctx, key, validation.lostPartitions());
        }
        if (keys != null) {
            for (Object key0 : keys) {
                CacheInvalidStateException res = this.validateKey(cctx, key0, validation.lostPartitions());
                if (res == null) continue;
                return res;
            }
            return null;
        }
        return new CacheInvalidStateException("Failed to perform a cache operation (the cache has lost partitions [cacheGrp=" + cctx.group().name() + ", cache=" + cctx.name() + ']');
    }

    public boolean hasLostPartitions() {
        return this.grpValidRes.values().stream().anyMatch(CacheGroupValidation::hasLostPartitions);
    }

    private CacheInvalidStateException validateKey(GridCacheContext cctx, Object key, Collection<Integer> lostParts) {
        int part = cctx.affinity().partition(key);
        return lostParts.contains(part) ? new CacheInvalidStateException("Failed to execute the cache operation (all partition owners have left the grid, partition data has been lost) [cacheName=" + cctx.name() + ", partition=" + part + ", key=" + key + ']') : null;
    }

    protected static class CacheGroupValidation {
        private final boolean valid;
        private final Collection<Integer> lostParts;

        private CacheGroupValidation(boolean valid, Collection<Integer> lostParts) {
            this.valid = valid;
            this.lostParts = lostParts;
        }

        public boolean isValid() {
            return this.valid;
        }

        public boolean hasLostPartitions() {
            return !this.lostParts.isEmpty();
        }

        public Collection<Integer> lostPartitions() {
            return this.lostParts;
        }
    }
}

