/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheConcurrentMap;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class GridCachePartitionedConcurrentMap
implements GridCacheConcurrentMap {
    private final CacheGroupContext grp;

    GridCachePartitionedConcurrentMap(CacheGroupContext grp) {
        this.grp = grp;
    }

    @Nullable
    private GridDhtLocalPartition localPartition(GridCacheContext cctx, KeyCacheObject key, AffinityTopologyVersion topVer, boolean create) {
        int p = key.partition();
        if (p == -1) {
            p = cctx.affinity().partition(key);
        }
        return this.grp.topology().localPartition(p, topVer, create);
    }

    @Override
    @Nullable
    public GridCacheMapEntry getEntry(GridCacheContext ctx, KeyCacheObject key) {
        GridDhtLocalPartition part = this.localPartition(ctx, key, AffinityTopologyVersion.NONE, false);
        if (part == null) {
            return null;
        }
        return part.getEntry(ctx, key);
    }

    @Override
    public GridCacheMapEntry putEntryIfObsoleteOrAbsent(GridCacheContext ctx, AffinityTopologyVersion topVer, KeyCacheObject key, boolean create, boolean touch) {
        GridDhtLocalPartition part;
        GridCacheMapEntry res;
        do {
            if ((part = this.localPartition(ctx, key, topVer, create)) != null) continue;
            return null;
        } while ((res = part.putEntryIfObsoleteOrAbsent(ctx, topVer, key, create, touch)) == null && create);
        return res;
    }

    @Override
    public int internalSize() {
        int size = 0;
        for (GridDhtLocalPartition part : this.grp.topology().currentLocalPartitions()) {
            size += part.internalSize();
        }
        return size;
    }

    @Override
    public int publicSize(int cacheId) {
        int size = 0;
        for (GridDhtLocalPartition part : this.grp.topology().currentLocalPartitions()) {
            size += part.publicSize(cacheId);
        }
        return size;
    }

    @Override
    public void incrementPublicSize(GridCacheConcurrentMap.CacheMapHolder hld, GridCacheEntryEx e) {
        this.localPartition(e.context(), e.key(), AffinityTopologyVersion.NONE, true).incrementPublicSize(hld, e);
    }

    @Override
    public void decrementPublicSize(GridCacheConcurrentMap.CacheMapHolder hld, GridCacheEntryEx e) {
        this.localPartition(e.context(), e.key(), AffinityTopologyVersion.NONE, true).decrementPublicSize(hld, e);
    }

    @Override
    public boolean removeEntry(GridCacheEntryEx entry) {
        GridDhtLocalPartition part = this.localPartition(entry.context(), entry.key(), AffinityTopologyVersion.NONE, false);
        if (part == null) {
            return false;
        }
        return part.removeEntry(entry);
    }

    @Override
    public Iterable<GridCacheMapEntry> entries(final int cacheId, final CacheEntryPredicate ... filter) {
        return new Iterable<GridCacheMapEntry>(){

            @Override
            public Iterator<GridCacheMapEntry> iterator() {
                return new PartitionedIterator<GridCacheMapEntry>(){

                    @Override
                    protected Iterator<GridCacheMapEntry> iterator(GridDhtLocalPartition part) {
                        return part.entries(cacheId, filter).iterator();
                    }
                };
            }
        };
    }

    @Override
    public Set<GridCacheMapEntry> entrySet(final int cacheId, final CacheEntryPredicate ... filter) {
        return new PartitionedSet<GridCacheMapEntry>(){

            @Override
            protected Set<GridCacheMapEntry> set(GridDhtLocalPartition part) {
                return part.entrySet(cacheId, filter);
            }
        };
    }

    public String toString() {
        return S.toString(GridCachePartitionedConcurrentMap.class, this);
    }

    private abstract class PartitionedSet<T>
    extends AbstractSet<T> {
        private PartitionedSet() {
        }

        protected abstract Set<T> set(GridDhtLocalPartition var1);

        @Override
        public Iterator<T> iterator() {
            return new PartitionedIterator<T>(){

                @Override
                protected Iterator<T> iterator(GridDhtLocalPartition part) {
                    return PartitionedSet.this.set(part).iterator();
                }
            };
        }

        @Override
        public int size() {
            int size = 0;
            for (GridDhtLocalPartition part : GridCachePartitionedConcurrentMap.this.grp.topology().currentLocalPartitions()) {
                size += this.set(part).size();
            }
            return size;
        }

        @Override
        public boolean contains(Object o) {
            for (GridDhtLocalPartition part : GridCachePartitionedConcurrentMap.this.grp.topology().currentLocalPartitions()) {
                if (!this.set(part).contains(o)) continue;
                return true;
            }
            return false;
        }
    }

    private abstract class PartitionedIterator<T>
    implements Iterator<T> {
        private Iterator<GridDhtLocalPartition> partsIter;
        private Iterator<T> currIter;

        private PartitionedIterator() {
            this.partsIter = GridCachePartitionedConcurrentMap.this.grp.topology().currentLocalPartitions().iterator();
            this.currIter = this.partsIter.hasNext() ? this.iterator(this.partsIter.next()) : Collections.emptyIterator();
        }

        protected abstract Iterator<T> iterator(GridDhtLocalPartition var1);

        @Override
        public boolean hasNext() {
            if (this.currIter.hasNext()) {
                return true;
            }
            while (this.partsIter.hasNext()) {
                this.currIter = this.iterator(this.partsIter.next());
                if (!this.currIter.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                return this.currIter.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

