/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.lang.reflect.Field;
import javax.cache.configuration.CompleteConfiguration;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.SerializeSeparately;
import org.apache.ignite.internal.processors.cache.CacheConfigurationEnrichment;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.jetbrains.annotations.Nullable;

public class CacheConfigurationEnricher {
    private final Marshaller marshaller;
    private final ClassLoader clsLdr;

    public CacheConfigurationEnricher(Marshaller marshaller, ClassLoader clsLdr) {
        this.marshaller = marshaller;
        this.clsLdr = clsLdr;
    }

    public DynamicCacheDescriptor enrich(DynamicCacheDescriptor desc, boolean affinityNode) {
        if (CU.isUtilityCache(desc.cacheName())) {
            return desc;
        }
        if (desc.isConfigurationEnriched()) {
            return desc;
        }
        CacheConfiguration<?, ?> enrichedCfg = this.enrich(desc.cacheConfiguration(), desc.cacheConfigurationEnrichment(), affinityNode);
        desc.cacheConfiguration(enrichedCfg);
        desc.configurationEnriched(true);
        return desc;
    }

    public CacheGroupDescriptor enrich(CacheGroupDescriptor desc, boolean affinityNode) {
        if (CU.isUtilityCache(desc.cacheOrGroupName())) {
            return desc;
        }
        if (desc.isConfigurationEnriched()) {
            return desc;
        }
        CacheConfiguration<?, ?> enrichedCfg = this.enrich(desc.config(), desc.cacheConfigurationEnrichment(), affinityNode);
        desc.config(enrichedCfg);
        desc.configurationEnriched(true);
        return desc;
    }

    public CacheConfiguration<?, ?> enrich(CacheConfiguration<?, ?> ccfg, @Nullable CacheConfigurationEnrichment enrichment, boolean affinityNode) {
        if (enrichment == null) {
            return ccfg;
        }
        CacheConfiguration enrichedCp = new CacheConfiguration((CompleteConfiguration<?, ?>)ccfg);
        try {
            for (Field field : CacheConfiguration.class.getDeclaredFields()) {
                if (field.getDeclaredAnnotation(SerializeSeparately.class) == null || !affinityNode && CacheConfigurationEnricher.skipDeserialization(ccfg, field)) continue;
                field.setAccessible(true);
                Object enrichedVal = this.deserialize(field.getName(), enrichment.getFieldSerializedValue(field.getName()));
                field.set((Object)enrichedCp, enrichedVal);
            }
        }
        catch (Exception e) {
            throw new IgniteException("Failed to enrich cache configuration [cacheName=" + ccfg.getName() + "]", e);
        }
        return enrichedCp;
    }

    public CacheConfiguration<?, ?> enrichFully(CacheConfiguration<?, ?> ccfg, CacheConfigurationEnrichment enrichment) {
        return this.enrich(ccfg, enrichment, true);
    }

    private Object deserialize(String fieldName, byte[] serializedVal) {
        try {
            return U.unmarshal(this.marshaller, serializedVal, this.clsLdr);
        }
        catch (Exception e) {
            throw new IgniteException("Failed to deserialize field " + fieldName, e);
        }
    }

    private static boolean skipDeserialization(CacheConfiguration<?, ?> ccfg, Field field) {
        return "storeFactory".equals(field.getName()) && ccfg.getAtomicityMode() == CacheAtomicityMode.ATOMIC;
    }
}

