/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.meta.tasks;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.util.typedef.internal.U;

public class MetadataTypeArgs
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    public static final String TYPE_NAME = "--typeName";
    public static final String TYPE_ID = "--typeId";
    private String typeName;
    private Integer typeId;

    public MetadataTypeArgs() {
    }

    public MetadataTypeArgs(String typeName, Integer typeId) {
        assert (typeName != null ^ typeId != null);
        this.typeName = typeName;
        this.typeId = typeId;
    }

    public String typeName() {
        return this.typeName;
    }

    public int typeId(GridKernalContext ctx) {
        if (this.typeId != null) {
            return this.typeId;
        }
        return ctx.cacheObjects().typeId(this.typeName);
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeBoolean(this.typeName != null);
        if (this.typeName != null) {
            U.writeString(out, this.typeName);
        } else {
            out.writeInt(this.typeId);
        }
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        boolean useName = in.readBoolean();
        if (useName) {
            this.typeName = U.readString(in);
        } else {
            this.typeId = in.readInt();
        }
    }

    public static MetadataTypeArgs parseArguments(CommandArgIterator argIter) {
        String typeName = null;
        Integer typeId = null;
        while (argIter.hasNextSubArg() && typeName == null && typeId == null) {
            String optName;
            switch (optName = argIter.nextArg("Expecting --typeName or --typeId")) {
                case "--typeName": {
                    typeName = argIter.nextArg("type name");
                    break;
                }
                case "--typeId": {
                    typeId = argIter.nextIntArg("typeId");
                }
            }
        }
        if (typeName == null && typeId == null) {
            throw new IllegalArgumentException("Type to remove is not specified. Please add one of the options: --typeName <type_name> or --typeId <type_id>");
        }
        return new MetadataTypeArgs(typeName, typeId);
    }

    public String toString() {
        return this.typeId != null ? "0x" + Integer.toHexString(this.typeId).toUpperCase() : this.typeName;
    }
}

