/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import org.apache.ignite.internal.commandline.ActivateCommand;
import org.apache.ignite.internal.commandline.BaselineCommand;
import org.apache.ignite.internal.commandline.ClusterChangeTagCommand;
import org.apache.ignite.internal.commandline.ClusterStateChangeCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.DeactivateCommand;
import org.apache.ignite.internal.commandline.StateCommand;
import org.apache.ignite.internal.commandline.TracingConfigurationCommand;
import org.apache.ignite.internal.commandline.TxCommands;
import org.apache.ignite.internal.commandline.WalCommands;
import org.apache.ignite.internal.commandline.cache.CacheCommands;
import org.apache.ignite.internal.commandline.diagnostic.DiagnosticCommand;
import org.apache.ignite.internal.commandline.encryption.EncryptionCommand;
import org.apache.ignite.internal.commandline.meta.MetadataCommand;
import org.apache.ignite.internal.commandline.query.KillCommand;
import org.apache.ignite.internal.commandline.snapshot.SnapshotCommand;

public enum CommandList {
    ACTIVATE("--activate", new ActivateCommand()),
    DEACTIVATE("--deactivate", new DeactivateCommand()),
    STATE("--state", new StateCommand()),
    SET_STATE("--set-state", new ClusterStateChangeCommand()),
    BASELINE("--baseline", new BaselineCommand()),
    TX("--tx", new TxCommands()),
    CACHE("--cache", new CacheCommands()),
    WAL("--wal", new WalCommands()),
    DIAGNOSTIC("--diagnostic", new DiagnosticCommand()),
    ENCRYPTION("--encryption", new EncryptionCommand()),
    KILL("--kill", new KillCommand()),
    SNAPSHOT("--snapshot", new SnapshotCommand()),
    CLUSTER_CHANGE_TAG("--change-tag", new ClusterChangeTagCommand()),
    METADATA("--meta", new MetadataCommand()),
    TRACING_CONFIGURATION("--tracing-configuration", new TracingConfigurationCommand());

    private static final CommandList[] VALUES;
    private final String text;
    private final Command command;

    private CommandList(String text, Command command) {
        this.text = text;
        this.command = command;
    }

    public static CommandList of(String text) {
        for (CommandList cmd : VALUES) {
            if (!cmd.text().equalsIgnoreCase(text)) continue;
            return cmd;
        }
        return null;
    }

    public String text() {
        return this.text;
    }

    public Command command() {
        return this.command;
    }

    public String toString() {
        return this.text;
    }

    public String toCommandName() {
        return this.text.substring(2).toUpperCase();
    }

    static {
        VALUES = CommandList.values();
    }
}

