/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.client.ClientAuthenticationException;
import org.apache.ignite.client.ClientConnectionException;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.internal.client.thin.ClientCacheAffinityContext;
import org.apache.ignite.internal.client.thin.ClientChannel;
import org.apache.ignite.internal.client.thin.ClientChannelConfiguration;
import org.apache.ignite.internal.client.thin.ClientError;
import org.apache.ignite.internal.client.thin.ClientOperation;
import org.apache.ignite.internal.client.thin.ClientProtocolError;
import org.apache.ignite.internal.client.thin.NotificationListener;
import org.apache.ignite.internal.client.thin.PayloadInputChannel;
import org.apache.ignite.internal.client.thin.PayloadOutputChannel;
import org.apache.ignite.internal.util.HostAndPortRange;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;

final class ReliableChannel
implements AutoCloseable,
NotificationListener {
    private static final long EXECUTOR_SHUTDOWN_TIMEOUT = 10000L;
    static final String ASYNC_RUNNER_THREAD_NAME = "thin-client-channel-async-init";
    private final Function<ClientChannelConfiguration, ClientChannel> chFactory;
    private final ClientChannelHolder[] channels;
    private int curChIdx;
    private final boolean partitionAwarenessEnabled;
    private final ClientCacheAffinityContext affinityCtx;
    private final Map<UUID, ClientChannelHolder> nodeChannels = new ConcurrentHashMap<UUID, ClientChannelHolder>();
    private final Collection<NotificationListener> notificationLsnrs = new CopyOnWriteArrayList<NotificationListener>();
    private final Collection<Consumer<ClientChannel>> channelCloseLsnrs = new CopyOnWriteArrayList<Consumer<ClientChannel>>();
    private final ExecutorService asyncRunner = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(@NotNull Runnable r) {
            Thread thread = new Thread(r, ReliableChannel.ASYNC_RUNNER_THREAD_NAME);
            thread.setDaemon(true);
            return thread;
        }
    });
    private final AtomicBoolean scheduledChannelsReinit = new AtomicBoolean();
    private final AtomicBoolean affinityUpdateInProgress = new AtomicBoolean();
    private volatile boolean closed;
    private ArrayList<Runnable> chFailLsnrs = new ArrayList();

    ReliableChannel(Function<ClientChannelConfiguration, ClientChannel> chFactory, ClientConfiguration clientCfg, IgniteBinary binary) throws ClientException {
        if (chFactory == null) {
            throw new NullPointerException("chFactory");
        }
        if (clientCfg == null) {
            throw new NullPointerException("clientCfg");
        }
        this.chFactory = chFactory;
        List<InetSocketAddress> addrs = ReliableChannel.parseAddresses(clientCfg.getAddresses());
        this.channels = new ClientChannelHolder[addrs.size()];
        for (int i = 0; i < this.channels.length; ++i) {
            this.channels[i] = new ClientChannelHolder(new ClientChannelConfiguration(clientCfg, addrs.get(i)));
        }
        this.curChIdx = new Random().nextInt(this.channels.length);
        this.partitionAwarenessEnabled = clientCfg.isPartitionAwarenessEnabled() && this.channels.length > 1;
        this.affinityCtx = new ClientCacheAffinityContext(binary);
        ClientConnectionException lastEx = null;
        for (int i = 0; i < this.channels.length; ++i) {
            try {
                this.channels[this.curChIdx].getOrCreateChannel();
                if (this.partitionAwarenessEnabled) {
                    this.initAllChannelsAsync();
                }
                return;
            }
            catch (ClientConnectionException e) {
                lastEx = e;
                this.rollCurrentChannel();
                continue;
            }
        }
        throw lastEx;
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        this.asyncRunner.shutdown();
        try {
            this.asyncRunner.awaitTermination(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        for (ClientChannelHolder hld : this.channels) {
            hld.closeChannel();
        }
    }

    public <T> T service(ClientOperation op, Consumer<PayloadOutputChannel> payloadWriter, Function<PayloadInputChannel, T> payloadReader) throws ClientException, ClientError {
        ClientConnectionException failure = null;
        for (int i = 0; i < this.channels.length; ++i) {
            ClientChannel ch = null;
            try {
                ch = this.channel();
                return ch.service(op, payloadWriter, payloadReader);
            }
            catch (ClientConnectionException e) {
                if (failure == null) {
                    failure = e;
                } else {
                    failure.addSuppressed(e);
                }
                this.onChannelFailure(ch);
                continue;
            }
        }
        throw failure;
    }

    public <T> T service(ClientOperation op, Function<PayloadInputChannel, T> payloadReader) throws ClientException, ClientError {
        return this.service(op, null, payloadReader);
    }

    public void request(ClientOperation op, Consumer<PayloadOutputChannel> payloadWriter) throws ClientException, ClientError {
        this.service(op, payloadWriter, null);
    }

    public <T> T affinityService(int cacheId, Object key, ClientOperation op, Consumer<PayloadOutputChannel> payloadWriter, Function<PayloadInputChannel, T> payloadReader) throws ClientException, ClientError {
        ClientChannelHolder hld;
        UUID affinityNodeId;
        if (this.partitionAwarenessEnabled && !this.nodeChannels.isEmpty() && this.affinityInfoIsUpToDate(cacheId) && (affinityNodeId = this.affinityCtx.affinityNode(cacheId, key)) != null && (hld = this.nodeChannels.get(affinityNodeId)) != null) {
            ClientChannel ch = null;
            try {
                ch = hld.getOrCreateChannel();
                return ch.service(op, payloadWriter, payloadReader);
            }
            catch (ClientConnectionException ignore) {
                this.onChannelFailure(hld, ch);
            }
        }
        return this.service(op, payloadWriter, payloadReader);
    }

    public void addNotificationListener(NotificationListener lsnr) {
        this.notificationLsnrs.add(lsnr);
    }

    public void addChannelCloseListener(Consumer<ClientChannel> lsnr) {
        this.channelCloseLsnrs.add(lsnr);
    }

    @Override
    public void acceptNotification(ClientChannel ch, ClientOperation op, long rsrcId, byte[] payload, Exception err) {
        for (NotificationListener lsnr : this.notificationLsnrs) {
            try {
                lsnr.acceptNotification(ch, op, rsrcId, payload, err);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean affinityInfoIsUpToDate(int cacheId) {
        if (this.affinityCtx.affinityUpdateRequired(cacheId)) {
            if (this.affinityUpdateInProgress.compareAndSet(false, true)) {
                try {
                    ClientCacheAffinityContext.TopologyNodes lastTop = this.affinityCtx.lastTopology();
                    if (lastTop == null) {
                        boolean bl = false;
                        return bl;
                    }
                    for (UUID nodeId : lastTop.nodes()) {
                        if (lastTop != this.affinityCtx.lastTopology()) {
                            boolean bl = false;
                            return bl;
                        }
                        ClientChannelHolder hld = this.nodeChannels.get(nodeId);
                        if (hld == null) continue;
                        ClientChannel ch = null;
                        try {
                            ch = hld.getOrCreateChannel();
                            boolean bl = ch.service(ClientOperation.CACHE_PARTITIONS, this.affinityCtx::writePartitionsUpdateRequest, this.affinityCtx::readPartitionsUpdateResponse);
                            return bl;
                        }
                        catch (ClientConnectionException ignore) {
                            this.onChannelFailure(hld, ch);
                        }
                    }
                    this.affinityCtx.reset(lastTop);
                }
                finally {
                    this.affinityUpdateInProgress.set(false);
                }
            }
            return false;
        }
        return true;
    }

    private static List<InetSocketAddress> parseAddresses(String[] addrs) throws ClientException {
        if (F.isEmpty(addrs)) {
            throw new ClientException("Empty addresses");
        }
        ArrayList<HostAndPortRange> ranges = new ArrayList<HostAndPortRange>(addrs.length);
        for (String a : addrs) {
            try {
                ranges.add(HostAndPortRange.parse(a, 10800, 10900, "Failed to parse Ignite server address"));
            }
            catch (IgniteCheckedException e) {
                throw new ClientException(e);
            }
        }
        return ranges.stream().flatMap(r -> IntStream.rangeClosed(r.portFrom(), r.portTo()).boxed().map(p -> new InetSocketAddress(r.host(), (int)p))).collect(Collectors.toList());
    }

    private synchronized ClientChannel channel() {
        if (this.closed) {
            throw new ClientException("Channel is closed");
        }
        try {
            return this.channels[this.curChIdx].getOrCreateChannel();
        }
        catch (ClientConnectionException e) {
            this.rollCurrentChannel();
            throw e;
        }
    }

    private synchronized void rollCurrentChannel() {
        if (++this.curChIdx >= this.channels.length) {
            this.curChIdx = 0;
        }
    }

    private synchronized void onChannelFailure(ClientChannel ch) {
        this.onChannelFailure(this.channels[this.curChIdx], ch);
        this.chFailLsnrs.forEach(Runnable::run);
    }

    private synchronized void onChannelFailure(ClientChannelHolder hld, ClientChannel ch) {
        if (ch == hld.ch && ch != null) {
            hld.closeChannel();
            if (hld == this.channels[this.curChIdx]) {
                this.rollCurrentChannel();
            }
        }
    }

    private void initAllChannelsAsync() {
        if (this.scheduledChannelsReinit.compareAndSet(false, true)) {
            this.asyncRunner.submit(() -> {
                this.scheduledChannelsReinit.set(false);
                for (ClientChannelHolder hld : this.channels) {
                    if (this.scheduledChannelsReinit.get() || this.closed) {
                        return;
                    }
                    try {
                        hld.getOrCreateChannel(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private void onTopologyChanged(ClientChannel ch) {
        if (this.partitionAwarenessEnabled && this.affinityCtx.updateLastTopologyVersion(ch.serverTopologyVersion(), ch.serverNodeId())) {
            this.initAllChannelsAsync();
        }
    }

    public void addChannelFailListener(Runnable chFailLsnr) {
        this.chFailLsnrs.add(chFailLsnr);
    }

    private class ClientChannelHolder {
        private final ClientChannelConfiguration chCfg;
        private volatile ClientChannel ch;
        private final long[] reconnectRetries;

        private ClientChannelHolder(ClientChannelConfiguration chCfg) {
            this.chCfg = chCfg;
            this.reconnectRetries = chCfg.getReconnectThrottlingRetries() > 0 && chCfg.getReconnectThrottlingPeriod() > 0L ? new long[chCfg.getReconnectThrottlingRetries()] : null;
        }

        private boolean applyReconnectionThrottling() {
            if (this.reconnectRetries == null) {
                return false;
            }
            long ts = System.currentTimeMillis();
            for (int i = 0; i < this.reconnectRetries.length; ++i) {
                if (ts - this.reconnectRetries[i] < this.chCfg.getReconnectThrottlingPeriod()) continue;
                this.reconnectRetries[i] = ts;
                return false;
            }
            return true;
        }

        private synchronized ClientChannel getOrCreateChannel() throws ClientConnectionException, ClientAuthenticationException, ClientProtocolError {
            return this.getOrCreateChannel(false);
        }

        private synchronized ClientChannel getOrCreateChannel(boolean ignoreThrottling) throws ClientConnectionException, ClientAuthenticationException, ClientProtocolError {
            if (this.ch == null) {
                if (!ignoreThrottling && this.applyReconnectionThrottling()) {
                    throw new ClientConnectionException("Reconnect is not allowed due to applied throttling");
                }
                this.ch = (ClientChannel)ReliableChannel.this.chFactory.apply(this.chCfg);
                if (this.ch.serverNodeId() != null) {
                    this.ch.addTopologyChangeListener(x$0 -> ReliableChannel.this.onTopologyChanged(x$0));
                    this.ch.addNotificationListener(ReliableChannel.this);
                    ReliableChannel.this.nodeChannels.values().remove(this);
                    ReliableChannel.this.nodeChannels.putIfAbsent(this.ch.serverNodeId(), this);
                }
            }
            return this.ch;
        }

        private synchronized void closeChannel() {
            if (this.ch != null) {
                U.closeQuiet(this.ch);
                for (Consumer lsnr : ReliableChannel.this.channelCloseLsnrs) {
                    lsnr.accept(this.ch);
                }
                this.ch = null;
            }
        }
    }
}

