/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.cache.expiry.ExpiryPolicy;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheKeyConfiguration;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.PartitionLossPolicy;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.client.ClientCacheConfiguration;
import org.apache.ignite.internal.binary.BinaryFieldMetadata;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryReaderHandles;
import org.apache.ignite.internal.binary.BinarySchema;
import org.apache.ignite.internal.binary.BinaryThreadLocalContext;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.streams.BinaryHeapInputStream;
import org.apache.ignite.internal.binary.streams.BinaryInputStream;
import org.apache.ignite.internal.binary.streams.BinaryOutputStream;
import org.apache.ignite.internal.client.thin.ClientBinaryMarshaller;
import org.apache.ignite.internal.client.thin.ClientProtocolError;
import org.apache.ignite.internal.client.thin.ProtocolContext;
import org.apache.ignite.internal.client.thin.ProtocolVersionFeature;
import org.apache.ignite.internal.processors.platform.cache.expiry.PlatformExpiryPolicy;
import org.apache.ignite.internal.util.MutableSingletonList;
import org.apache.ignite.internal.util.typedef.internal.U;

final class ClientUtils {
    private final ClientBinaryMarshaller marsh;

    ClientUtils(ClientBinaryMarshaller marsh) {
        this.marsh = marsh;
    }

    static int cacheId(String name) {
        Objects.requireNonNull(name, "name");
        return name.hashCode();
    }

    static <E> void collection(Collection<E> col, BinaryOutputStream out, BiConsumer<BinaryOutputStream, E> elemWriter) {
        if (col == null || col.isEmpty()) {
            out.writeInt(0);
        } else {
            out.writeInt(col.size());
            for (E e : col) {
                elemWriter.accept(out, e);
            }
        }
    }

    static <E> void collection(E[] col, BinaryOutputStream out, BiConsumer<BinaryOutputStream, E> elemWriter) {
        if (col == null || col.length == 0) {
            out.writeInt(0);
        } else {
            out.writeInt(col.length);
            for (E e : col) {
                elemWriter.accept(out, e);
            }
        }
    }

    static <E> Collection<E> collection(BinaryInputStream in, Function<BinaryInputStream, E> elemReader) {
        LinkedList<E> col = new LinkedList<E>();
        int cnt = in.readInt();
        for (int i = 0; i < cnt; ++i) {
            col.add(elemReader.apply(in));
        }
        return col;
    }

    private static <K, V> Map<K, V> map(BinaryInputStream in, Function<BinaryInputStream, K> keyReader, Function<BinaryInputStream, V> valReader) {
        int cnt = in.readInt();
        HashMap<K, V> map = new HashMap<K, V>(cnt);
        for (int i = 0; i < cnt; ++i) {
            map.put(keyReader.apply(in), valReader.apply(in));
        }
        return map;
    }

    BinaryMetadata binaryMetadata(BinaryInputStream in) throws IOException {
        try (BinaryReaderExImpl reader = new BinaryReaderExImpl(this.marsh.context(), in, null, true);){
            int typeId = reader.readInt();
            String typeName = reader.readString();
            String affKeyFieldName = reader.readString();
            Map<String, BinaryFieldMetadata> fields = ClientUtils.map(in, unused -> reader.readString(), unused2 -> new BinaryFieldMetadata(reader.readInt(), reader.readInt()));
            boolean isEnum = reader.readBoolean();
            Map<String, Integer> enumValues = isEnum ? ClientUtils.map(in, unsed -> reader.readString(), unsed2 -> reader.readInt()) : null;
            Collection<BinarySchema> schemas = ClientUtils.collection(in, unused -> new BinarySchema(reader.readInt(), new ArrayList<Integer>(ClientUtils.collection(in, unused2 -> reader.readInt()))));
            BinaryMetadata binaryMetadata = new BinaryMetadata(typeId, typeName, fields, affKeyFieldName, schemas, isEnum, enumValues);
            return binaryMetadata;
        }
    }

    void binaryMetadata(BinaryMetadata meta, BinaryOutputStream out) {
        try (BinaryWriterExImpl w = new BinaryWriterExImpl(this.marsh.context(), out, null, null);){
            w.writeInt(meta.typeId());
            w.writeString(meta.typeName());
            w.writeString(meta.affinityKeyFieldName());
            ClientUtils.collection(meta.fieldsMap().entrySet(), out, (BinaryOutputStream unused, E e) -> {
                w.writeString((String)e.getKey());
                w.writeInt(((BinaryFieldMetadata)e.getValue()).typeId());
                w.writeInt(((BinaryFieldMetadata)e.getValue()).fieldId());
            });
            w.writeBoolean(meta.isEnum());
            if (meta.isEnum()) {
                ClientUtils.collection(meta.enumMap().entrySet(), out, (BinaryOutputStream unused, E e) -> {
                    w.writeString((String)e.getKey());
                    w.writeInt((Integer)e.getValue());
                });
            }
            ClientUtils.collection(meta.schemas(), out, (BinaryOutputStream unused, E s) -> {
                w.writeInt(s.schemaId());
                ClientUtils.collection(Arrays.stream(s.fieldIds()).boxed().collect(Collectors.toList()), out, (BinaryOutputStream unused2, E i) -> w.writeInt((int)i));
            });
        }
    }

    void cacheConfiguration(ClientCacheConfiguration cfg, BinaryOutputStream out, ProtocolContext protocolCtx) {
        try (BinaryWriterExImpl writer = new BinaryWriterExImpl(this.marsh.context(), out, null, null);){
            int origPos = out.position();
            writer.writeInt(0);
            writer.writeShort((short)0);
            AtomicInteger propCnt = new AtomicInteger(0);
            BiConsumer<CfgItem, Consumer> itemWriter = (cfgItem, cfgWriter) -> {
                writer.writeShort(cfgItem.code());
                cfgWriter.accept(writer);
                propCnt.incrementAndGet();
            };
            itemWriter.accept(CfgItem.NAME, w -> w.writeString(cfg.getName()));
            itemWriter.accept(CfgItem.CACHE_MODE, w -> w.writeInt(cfg.getCacheMode().ordinal()));
            itemWriter.accept(CfgItem.ATOMICITY_MODE, w -> w.writeInt(cfg.getAtomicityMode().ordinal()));
            itemWriter.accept(CfgItem.BACKUPS, w -> w.writeInt(cfg.getBackups()));
            itemWriter.accept(CfgItem.WRITE_SYNC_MODE, w -> w.writeInt(cfg.getWriteSynchronizationMode().ordinal()));
            itemWriter.accept(CfgItem.READ_FROM_BACKUP, w -> w.writeBoolean(cfg.isReadFromBackup()));
            itemWriter.accept(CfgItem.EAGER_TTL, w -> w.writeBoolean(cfg.isEagerTtl()));
            itemWriter.accept(CfgItem.GROUP_NAME, w -> w.writeString(cfg.getGroupName()));
            itemWriter.accept(CfgItem.DEFAULT_LOCK_TIMEOUT, w -> w.writeLong(cfg.getDefaultLockTimeout()));
            itemWriter.accept(CfgItem.PART_LOSS_POLICY, w -> w.writeInt(cfg.getPartitionLossPolicy().ordinal()));
            itemWriter.accept(CfgItem.REBALANCE_BATCH_SIZE, w -> w.writeInt(cfg.getRebalanceBatchSize()));
            itemWriter.accept(CfgItem.REBALANCE_BATCHES_PREFETCH_COUNT, w -> w.writeLong(cfg.getRebalanceBatchesPrefetchCount()));
            itemWriter.accept(CfgItem.REBALANCE_DELAY, w -> w.writeLong(cfg.getRebalanceDelay()));
            itemWriter.accept(CfgItem.REBALANCE_MODE, w -> w.writeInt(cfg.getRebalanceMode().ordinal()));
            itemWriter.accept(CfgItem.REBALANCE_ORDER, w -> w.writeInt(cfg.getRebalanceOrder()));
            itemWriter.accept(CfgItem.REBALANCE_THROTTLE, w -> w.writeLong(cfg.getRebalanceThrottle()));
            itemWriter.accept(CfgItem.REBALANCE_TIMEOUT, w -> w.writeLong(cfg.getRebalanceTimeout()));
            itemWriter.accept(CfgItem.COPY_ON_READ, w -> w.writeBoolean(cfg.isCopyOnRead()));
            itemWriter.accept(CfgItem.DATA_REGION_NAME, w -> w.writeString(cfg.getDataRegionName()));
            itemWriter.accept(CfgItem.STATS_ENABLED, w -> w.writeBoolean(cfg.isStatisticsEnabled()));
            itemWriter.accept(CfgItem.MAX_ASYNC_OPS, w -> w.writeInt(cfg.getMaxConcurrentAsyncOperations()));
            itemWriter.accept(CfgItem.MAX_QUERY_ITERATORS, w -> w.writeInt(cfg.getMaxQueryIteratorsCount()));
            itemWriter.accept(CfgItem.ONHEAP_CACHE_ENABLED, w -> w.writeBoolean(cfg.isOnheapCacheEnabled()));
            itemWriter.accept(CfgItem.QUERY_METRIC_SIZE, w -> w.writeInt(cfg.getQueryDetailMetricsSize()));
            itemWriter.accept(CfgItem.QUERY_PARALLELISM, w -> w.writeInt(cfg.getQueryParallelism()));
            itemWriter.accept(CfgItem.SQL_ESCAPE_ALL, w -> w.writeBoolean(cfg.isSqlEscapeAll()));
            itemWriter.accept(CfgItem.SQL_IDX_MAX_INLINE_SIZE, w -> w.writeInt(cfg.getSqlIndexMaxInlineSize()));
            itemWriter.accept(CfgItem.SQL_SCHEMA, w -> w.writeString(cfg.getSqlSchema()));
            itemWriter.accept(CfgItem.KEY_CONFIGS, w -> ClientUtils.collection(cfg.getKeyConfiguration(), out, (BinaryOutputStream unused, E i) -> {
                w.writeString(i.getTypeName());
                w.writeString(i.getAffinityKeyFieldName());
            }));
            itemWriter.accept(CfgItem.QUERY_ENTITIES, w -> ClientUtils.collection(cfg.getQueryEntities(), out, (BinaryOutputStream unused, E e) -> {
                w.writeString(e.getKeyType());
                w.writeString(e.getValueType());
                w.writeString(e.getTableName());
                w.writeString(e.getKeyFieldName());
                w.writeString(e.getValueFieldName());
                ClientUtils.collection(e.getFields().entrySet(), out, (BinaryOutputStream unused2, E f) -> {
                    QueryField qf = new QueryField((QueryEntity)e, (Map.Entry<String, String>)f);
                    w.writeString(qf.getName());
                    w.writeString(qf.getTypeName());
                    w.writeBoolean(qf.isKey());
                    w.writeBoolean(qf.isNotNull());
                    w.writeObject(qf.getDefaultValue());
                    if (protocolCtx.isFeatureSupported(ProtocolVersionFeature.QUERY_ENTITY_PRECISION_AND_SCALE)) {
                        w.writeInt(qf.getPrecision());
                        w.writeInt(qf.getScale());
                    }
                });
                ClientUtils.collection(e.getAliases().entrySet(), out, (BinaryOutputStream unused3, E a) -> {
                    w.writeString((String)a.getKey());
                    w.writeString((String)a.getValue());
                });
                ClientUtils.collection(e.getIndexes(), out, (BinaryOutputStream unused4, E i) -> {
                    w.writeString(i.getName());
                    w.writeByte((byte)i.getIndexType().ordinal());
                    w.writeInt(i.getInlineSize());
                    ClientUtils.collection(i.getFields().entrySet(), out, (BinaryOutputStream unused5, E f) -> {
                        w.writeString((String)f.getKey());
                        w.writeBoolean((Boolean)f.getValue());
                    });
                });
            }));
            if (protocolCtx.isFeatureSupported(ProtocolVersionFeature.EXPIRY_POLICY)) {
                itemWriter.accept(CfgItem.EXPIRE_POLICY, w -> {
                    ExpiryPolicy expiryPlc = cfg.getExpiryPolicy();
                    if (expiryPlc == null) {
                        w.writeBoolean(false);
                    } else {
                        w.writeBoolean(true);
                        w.writeLong(PlatformExpiryPolicy.convertDuration(expiryPlc.getExpiryForCreation()));
                        w.writeLong(PlatformExpiryPolicy.convertDuration(expiryPlc.getExpiryForUpdate()));
                        w.writeLong(PlatformExpiryPolicy.convertDuration(expiryPlc.getExpiryForAccess()));
                    }
                });
            } else if (cfg.getExpiryPolicy() != null) {
                throw new ClientProtocolError(String.format("Expire policies are not supported by the server version %s, required version %s", protocolCtx.version(), ProtocolVersionFeature.EXPIRY_POLICY.verIntroduced()));
            }
            writer.writeInt(origPos, out.position() - origPos - 4);
            writer.writeInt(origPos + 4, propCnt.get());
        }
    }

    ClientCacheConfiguration cacheConfiguration(BinaryInputStream in, ProtocolContext protocolCtx) throws IOException {
        try (BinaryReaderExImpl reader = new BinaryReaderExImpl(this.marsh.context(), in, null, true);){
            reader.readInt();
            ClientCacheConfiguration clientCacheConfiguration = new ClientCacheConfiguration().setName("TBD").setAtomicityMode(CacheAtomicityMode.fromOrdinal(reader.readInt())).setBackups(reader.readInt()).setCacheMode(CacheMode.fromOrdinal(reader.readInt())).setCopyOnRead(reader.readBoolean()).setDataRegionName(reader.readString()).setEagerTtl(reader.readBoolean()).setStatisticsEnabled(reader.readBoolean()).setGroupName(reader.readString()).setDefaultLockTimeout(reader.readLong()).setMaxConcurrentAsyncOperations(reader.readInt()).setMaxQueryIteratorsCount(reader.readInt()).setName(reader.readString()).setOnheapCacheEnabled(reader.readBoolean()).setPartitionLossPolicy(PartitionLossPolicy.fromOrdinal((byte)reader.readInt())).setQueryDetailMetricsSize(reader.readInt()).setQueryParallelism(reader.readInt()).setReadFromBackup(reader.readBoolean()).setRebalanceBatchSize(reader.readInt()).setRebalanceBatchesPrefetchCount(reader.readLong()).setRebalanceDelay(reader.readLong()).setRebalanceMode(CacheRebalanceMode.fromOrdinal(reader.readInt())).setRebalanceOrder(reader.readInt()).setRebalanceThrottle(reader.readLong()).setRebalanceTimeout(reader.readLong()).setSqlEscapeAll(reader.readBoolean()).setSqlIndexMaxInlineSize(reader.readInt()).setSqlSchema(reader.readString()).setWriteSynchronizationMode(CacheWriteSynchronizationMode.fromOrdinal(reader.readInt())).setKeyConfiguration(ClientUtils.collection(in, unused -> new CacheKeyConfiguration(reader.readString(), reader.readString())).toArray(new CacheKeyConfiguration[0])).setQueryEntities(ClientUtils.collection(in, unused -> {
                QueryEntity qryEntity = new QueryEntity(reader.readString(), reader.readString()).setTableName(reader.readString()).setKeyFieldName(reader.readString()).setValueFieldName(reader.readString());
                boolean isPrecisionAndScaleSupported = protocolCtx.isFeatureSupported(ProtocolVersionFeature.QUERY_ENTITY_PRECISION_AND_SCALE);
                Collection<QueryField> qryFields = ClientUtils.collection(in, unused2 -> {
                    String name = reader.readString();
                    String typeName = reader.readString();
                    boolean isKey = reader.readBoolean();
                    boolean isNotNull = reader.readBoolean();
                    Object dfltVal = reader.readObject();
                    int precision = isPrecisionAndScaleSupported ? reader.readInt() : -1;
                    int scale = isPrecisionAndScaleSupported ? reader.readInt() : -1;
                    return new QueryField(name, typeName, isKey, isNotNull, dfltVal, precision, scale);
                });
                return qryEntity.setFields(qryFields.stream().collect(Collectors.toMap(QueryField::getName, QueryField::getTypeName, (a, b) -> a, LinkedHashMap::new))).setKeyFields(qryFields.stream().filter(QueryField::isKey).map(QueryField::getName).collect(Collectors.toCollection(LinkedHashSet::new))).setNotNullFields(qryFields.stream().filter(QueryField::isNotNull).map(QueryField::getName).collect(Collectors.toSet())).setDefaultFieldValues(qryFields.stream().filter(f -> f.getDefaultValue() != null).collect(Collectors.toMap(QueryField::getName, QueryField::getDefaultValue))).setFieldsPrecision(qryFields.stream().filter(f -> f.getPrecision() != -1).collect(Collectors.toMap(QueryField::getName, QueryField::getPrecision))).setFieldsScale(qryFields.stream().filter(f -> f.getScale() != -1).collect(Collectors.toMap(QueryField::getName, QueryField::getScale))).setAliases(ClientUtils.collection(in, unused3 -> new AbstractMap.SimpleEntry<String, String>(reader.readString(), reader.readString())).stream().collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue))).setIndexes(ClientUtils.collection(in, unused4 -> {
                    String name = reader.readString();
                    QueryIndexType type = QueryIndexType.fromOrdinal(reader.readByte());
                    int inlineSize = reader.readInt();
                    LinkedHashMap fields = ClientUtils.collection(in, unused5 -> new AbstractMap.SimpleEntry<String, Boolean>(reader.readString(), reader.readBoolean())).stream().collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue, (a, b) -> a, LinkedHashMap::new));
                    return new QueryIndex(fields, type).setName(name).setInlineSize(inlineSize);
                }));
            }).toArray(new QueryEntity[0])).setExpiryPolicy(!protocolCtx.isFeatureSupported(ProtocolVersionFeature.EXPIRY_POLICY) ? null : (reader.readBoolean() ? new PlatformExpiryPolicy(reader.readLong(), reader.readLong(), reader.readLong()) : null));
            return clientCacheConfiguration;
        }
    }

    void write(SqlFieldsQuery qry, BinaryOutputStream out) {
        this.writeObject(out, qry.getSchema());
        out.writeInt(qry.getPageSize());
        out.writeInt(-1);
        this.writeObject(out, qry.getSql());
        ClientUtils.collection(qry.getArgs() == null ? null : Arrays.asList(qry.getArgs()), out, this::writeObject);
        out.writeByte((byte)0);
        out.writeBoolean(qry.isDistributedJoins());
        out.writeBoolean(qry.isLocal());
        out.writeBoolean(qry.isReplicatedOnly());
        out.writeBoolean(qry.isEnforceJoinOrder());
        out.writeBoolean(qry.isCollocated());
        out.writeBoolean(qry.isLazy());
        out.writeLong(qry.getTimeout());
        out.writeBoolean(true);
    }

    void writeObject(BinaryOutputStream out, Object obj) {
        out.writeByteArray(this.marsh.marshal(obj));
    }

    BinaryRawWriterEx createBinaryWriter(BinaryOutputStream out) {
        return new BinaryWriterExImpl(this.marsh.context(), out, BinaryThreadLocalContext.get().schemaHolder(), null);
    }

    <T> T readObject(BinaryInputStream in, boolean keepBinary) {
        if (keepBinary) {
            return this.marsh.unmarshal(in);
        }
        BinaryReaderHandles hnds = new BinaryReaderHandles();
        return (T)this.unwrapBinary(this.marsh.deserialize(in, hnds), hnds);
    }

    private Object unwrapBinary(Object obj, BinaryReaderHandles hnds) {
        if (obj instanceof BinaryObjectImpl) {
            BinaryObjectImpl obj0 = (BinaryObjectImpl)obj;
            return this.marsh.deserialize(BinaryHeapInputStream.create(obj0.array(), obj0.start()), hnds);
        }
        if (obj instanceof BinaryObject) {
            return ((BinaryObject)obj).deserialize();
        }
        if (BinaryUtils.knownCollection(obj)) {
            return this.unwrapCollection((Collection)obj, hnds);
        }
        if (BinaryUtils.knownMap(obj)) {
            return this.unwrapMap((Map)obj, hnds);
        }
        if (obj instanceof Object[]) {
            return this.unwrapArray((Object[])obj, hnds);
        }
        return obj;
    }

    private Collection<Object> unwrapCollection(Collection<Object> col, BinaryReaderHandles hnds) {
        Collection<Object> col0 = BinaryUtils.newKnownCollection(col);
        for (Object obj0 : col) {
            col0.add(this.unwrapBinary(obj0, hnds));
        }
        return col0 instanceof MutableSingletonList ? U.convertToSingletonList(col0) : col0;
    }

    private Map<Object, Object> unwrapMap(Map<Object, Object> map, BinaryReaderHandles hnds) {
        Map<Object, Object> map0 = BinaryUtils.newMap(map);
        for (Map.Entry<Object, Object> e : map.entrySet()) {
            map0.put(this.unwrapBinary(e.getKey(), hnds), this.unwrapBinary(e.getValue(), hnds));
        }
        return map0;
    }

    private Object[] unwrapArray(Object[] arr, BinaryReaderHandles hnds) {
        if (BinaryUtils.knownArray(arr)) {
            return arr;
        }
        Object[] res = (Object[])Array.newInstance(arr.getClass().getComponentType(), arr.length);
        for (int i = 0; i < arr.length; ++i) {
            res[i] = this.unwrapBinary(arr[i], hnds);
        }
        return res;
    }

    private static enum CfgItem {
        NAME(0),
        CACHE_MODE(1),
        ATOMICITY_MODE(2),
        BACKUPS(3),
        WRITE_SYNC_MODE(4),
        READ_FROM_BACKUP(6),
        EAGER_TTL(405),
        GROUP_NAME(400),
        DEFAULT_LOCK_TIMEOUT(402),
        PART_LOSS_POLICY(404),
        REBALANCE_BATCH_SIZE(303),
        REBALANCE_BATCHES_PREFETCH_COUNT(304),
        REBALANCE_DELAY(301),
        REBALANCE_MODE(300),
        REBALANCE_ORDER(305),
        REBALANCE_THROTTLE(306),
        REBALANCE_TIMEOUT(302),
        COPY_ON_READ(5),
        DATA_REGION_NAME(100),
        STATS_ENABLED(406),
        MAX_ASYNC_OPS(403),
        MAX_QUERY_ITERATORS(206),
        ONHEAP_CACHE_ENABLED(101),
        QUERY_METRIC_SIZE(202),
        QUERY_PARALLELISM(201),
        SQL_ESCAPE_ALL(205),
        SQL_IDX_MAX_INLINE_SIZE(204),
        SQL_SCHEMA(203),
        KEY_CONFIGS(401),
        QUERY_ENTITIES(200),
        EXPIRE_POLICY(407);

        private final short code;

        private CfgItem(int code) {
            this.code = (short)code;
        }

        short code() {
            return this.code;
        }
    }

    private static final class QueryField {
        private final String name;
        private final String typeName;
        private final boolean isKey;
        private final boolean isNotNull;
        private final Object dfltVal;
        private final int precision;
        private final int scale;

        QueryField(QueryEntity e, Map.Entry<String, String> nameAndTypeName) {
            this.name = nameAndTypeName.getKey();
            this.typeName = nameAndTypeName.getValue();
            Set<String> keys = e.getKeyFields();
            Set<String> notNulls = e.getNotNullFields();
            Map<String, Object> dflts = e.getDefaultFieldValues();
            Map<String, Integer> fldsPrecision = e.getFieldsPrecision();
            Map<String, Integer> fldsScale = e.getFieldsScale();
            this.isKey = keys != null && keys.contains(this.name);
            this.isNotNull = notNulls != null && notNulls.contains(this.name);
            this.dfltVal = dflts == null ? null : dflts.get(this.name);
            this.precision = fldsPrecision == null ? -1 : fldsPrecision.getOrDefault(this.name, -1);
            this.scale = fldsScale == null ? -1 : fldsScale.getOrDefault(this.name, -1);
        }

        public QueryField(String name, String typeName, boolean isKey, boolean isNotNull, Object dfltVal, int precision, int scale) {
            this.name = name;
            this.typeName = typeName;
            this.isKey = isKey;
            this.isNotNull = isNotNull;
            this.dfltVal = dfltVal;
            this.precision = precision;
            this.scale = scale;
        }

        String getName() {
            return this.name;
        }

        String getTypeName() {
            return this.typeName;
        }

        boolean isKey() {
            return this.isKey;
        }

        boolean isNotNull() {
            return this.isNotNull;
        }

        Object getDefaultValue() {
            return this.dfltVal;
        }

        public int getPrecision() {
            return this.precision;
        }

        public int getScale() {
            return this.scale;
        }
    }
}

