/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.UUID;
import org.apache.ignite.client.ClientClusterGroup;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.client.ClientServices;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.client.thin.ClientBinaryMarshaller;
import org.apache.ignite.internal.client.thin.ClientClusterGroupImpl;
import org.apache.ignite.internal.client.thin.ClientError;
import org.apache.ignite.internal.client.thin.ClientOperation;
import org.apache.ignite.internal.client.thin.ClientUtils;
import org.apache.ignite.internal.client.thin.PayloadOutputChannel;
import org.apache.ignite.internal.client.thin.ProtocolBitmaskFeature;
import org.apache.ignite.internal.client.thin.ReliableChannel;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.platform.PlatformServiceMethod;

class ClientServicesImpl
implements ClientServices {
    private final ReliableChannel ch;
    private final ClientBinaryMarshaller marsh;
    private final ClientUtils utils;
    private final ClientClusterGroupImpl grp;

    ClientServicesImpl(ReliableChannel ch, ClientBinaryMarshaller marsh, ClientClusterGroupImpl grp) {
        this.ch = ch;
        this.marsh = marsh;
        this.grp = grp;
        this.utils = new ClientUtils(marsh);
    }

    @Override
    public ClientClusterGroup clusterGroup() {
        return this.grp;
    }

    @Override
    public <T> T serviceProxy(String name, Class<? super T> svcItf) {
        return this.serviceProxy(name, svcItf, 0L);
    }

    @Override
    public <T> T serviceProxy(String name, Class<? super T> svcItf, long timeout) {
        A.notNullOrEmpty(name, "name");
        A.notNull(svcItf, "svcItf");
        return (T)Proxy.newProxyInstance(svcItf.getClassLoader(), new Class[]{svcItf}, new ServiceInvocationHandler(name, timeout, this.grp));
    }

    ClientServices withClusterGroup(ClientClusterGroupImpl grp) {
        A.notNull(grp, "grp");
        return new ClientServicesImpl(this.ch, this.marsh, grp);
    }

    private class ServiceInvocationHandler<T>
    implements InvocationHandler {
        private static final byte FLAG_PARAMETER_TYPES_MASK = 2;
        private final String name;
        private final long timeout;
        private final ClientClusterGroupImpl grp;

        private ServiceInvocationHandler(String name, long timeout, ClientClusterGroupImpl grp) {
            this.name = name;
            this.timeout = timeout;
            this.grp = grp;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                Collection<UUID> nodeIds = this.grp.nodeIds();
                if (nodeIds != null && nodeIds.isEmpty()) {
                    throw new ClientException("Cluster group is empty.");
                }
                return ClientServicesImpl.this.ch.service(ClientOperation.SERVICE_INVOKE, req -> this.writeServiceInvokeRequest((PayloadOutputChannel)req, nodeIds, method, args), res -> ClientServicesImpl.this.utils.readObject(res.in(), false));
            }
            catch (ClientError e) {
                throw new ClientException(e);
            }
        }

        private void writeServiceInvokeRequest(PayloadOutputChannel ch, Collection<UUID> nodeIds, Method method, Object[] args) {
            ch.clientChannel().protocolCtx().checkFeatureSupported(ProtocolBitmaskFeature.SERVICE_INVOKE);
            try (BinaryRawWriterEx writer = ClientServicesImpl.this.utils.createBinaryWriter(ch.out());){
                writer.writeString(this.name);
                writer.writeByte((byte)2);
                writer.writeLong(this.timeout);
                if (nodeIds == null) {
                    writer.writeInt(0);
                } else {
                    writer.writeInt(nodeIds.size());
                    for (UUID nodeId : nodeIds) {
                        writer.writeLong(nodeId.getMostSignificantBits());
                        writer.writeLong(nodeId.getLeastSignificantBits());
                    }
                }
                PlatformServiceMethod ann = method.getDeclaredAnnotation(PlatformServiceMethod.class);
                writer.writeString(ann != null ? ann.value() : method.getName());
                Class<?>[] paramTypes = method.getParameterTypes();
                if (F.isEmpty(args)) {
                    writer.writeInt(0);
                } else {
                    writer.writeInt(args.length);
                    assert (args.length == paramTypes.length) : "args=" + args.length + ", types=" + paramTypes.length;
                    for (int i = 0; i < args.length; ++i) {
                        writer.writeInt(ClientServicesImpl.this.marsh.context().typeId(paramTypes[i].getName()));
                        writer.writeObject(args[i]);
                    }
                }
            }
        }
    }
}

