/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.jmx;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.ignite.IgniteException;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.spi.metric.jmx.ReadOnlyDynamicMBean;
import org.apache.ignite.spi.systemview.view.SystemView;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;

public class SystemViewMBean<R>
extends ReadOnlyDynamicMBean {
    public static final String VIEWS = "views";
    public static final String ID = "systemViewRowId";
    private final SystemView<R> sysView;
    private final MBeanInfo info;
    private final CompositeType rowType;
    private final TabularType sysViewType;

    public SystemViewMBean(SystemView<R> sysView) {
        this.sysView = sysView;
        int cnt = sysView.walker().count();
        final String[] fields = new String[cnt + 1];
        final OpenType[] types = new OpenType[cnt + 1];
        sysView.walker().visitAll(new SystemViewRowAttributeWalker.AttributeVisitor(){

            @Override
            public <T> void accept(int idx, String name, Class<T> clazz) {
                fields[idx] = name;
                types[idx] = clazz.isAssignableFrom(String.class) || clazz.isEnum() || clazz.isAssignableFrom(IgniteUuid.class) || clazz.isAssignableFrom(UUID.class) || clazz.isAssignableFrom(Class.class) || clazz.isAssignableFrom(InetSocketAddress.class) ? SimpleType.STRING : (clazz.isAssignableFrom(BigDecimal.class) ? SimpleType.BIGDECIMAL : (clazz.isAssignableFrom(BigInteger.class) ? SimpleType.BIGINTEGER : (clazz.isAssignableFrom(Date.class) ? SimpleType.DATE : (clazz.isAssignableFrom(ObjectName.class) ? SimpleType.OBJECTNAME : (clazz == Boolean.TYPE || clazz.isAssignableFrom(Boolean.class) ? SimpleType.BOOLEAN : (clazz == Byte.TYPE || clazz.isAssignableFrom(Byte.class) ? SimpleType.BYTE : (clazz == Character.TYPE || clazz.isAssignableFrom(Character.class) ? SimpleType.CHARACTER : (clazz == Short.TYPE || clazz.isAssignableFrom(Short.class) ? SimpleType.SHORT : (clazz == Integer.TYPE || clazz.isAssignableFrom(Integer.class) ? SimpleType.INTEGER : (clazz == Long.TYPE || clazz.isAssignableFrom(Long.class) ? SimpleType.LONG : (clazz == Float.TYPE || clazz.isAssignableFrom(Float.class) ? SimpleType.FLOAT : (clazz == Double.TYPE || clazz.isAssignableFrom(Double.class) ? SimpleType.DOUBLE : SimpleType.STRING))))))))))));
            }
        });
        fields[cnt] = ID;
        types[cnt] = SimpleType.INTEGER;
        try {
            this.rowType = new CompositeType(sysView.rowClass().getName(), sysView.description(), fields, fields, types);
            this.info = new OpenMBeanInfoSupport(sysView.rowClass().getName(), sysView.description(), new OpenMBeanAttributeInfo[]{new OpenMBeanAttributeInfoSupport(VIEWS, VIEWS, this.rowType, true, false, false)}, null, null, null);
            this.sysViewType = new TabularType(sysView.rowClass().getName(), sysView.description(), this.rowType, new String[]{ID});
        }
        catch (OpenDataException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public Object getAttribute(String attribute) {
        if ("MBeanInfo".equals(attribute)) {
            return this.getMBeanInfo();
        }
        if (attribute.equals(VIEWS)) {
            TabularDataSupport rows = new TabularDataSupport(this.sysViewType);
            AttributeToMapVisitor visitor = new AttributeToMapVisitor();
            try {
                int idx = 0;
                for (Object row : this.sysView) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    visitor.data(data);
                    this.sysView.walker().visitAll(row, visitor);
                    data.put(ID, idx++);
                    rows.put(new CompositeDataSupport(this.rowType, data));
                }
            }
            catch (OpenDataException e) {
                throw new IgniteException(e);
            }
            return rows;
        }
        throw new IllegalArgumentException("Unknown attribute " + attribute);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.info;
    }

    private static class AttributeToMapVisitor
    implements SystemViewRowAttributeWalker.AttributeWithValueVisitor {
        private Map<String, Object> data;

        private AttributeToMapVisitor() {
        }

        public void data(Map<String, Object> data) {
            this.data = data;
        }

        @Override
        public <T> void accept(int idx, String name, Class<T> clazz, T val) {
            if (clazz.isEnum()) {
                this.data.put(name, ((Enum)val).name());
            } else if (clazz.isAssignableFrom(Class.class)) {
                this.data.put(name, ((Class)val).getName());
            } else if (clazz.isAssignableFrom(IgniteUuid.class) || clazz.isAssignableFrom(UUID.class) || clazz.isAssignableFrom(InetSocketAddress.class)) {
                this.data.put(name, String.valueOf(val));
            } else {
                this.data.put(name, val);
            }
        }

        @Override
        public void acceptBoolean(int idx, String name, boolean val) {
            this.data.put(name, val);
        }

        @Override
        public void acceptChar(int idx, String name, char val) {
            this.data.put(name, Character.valueOf(val));
        }

        @Override
        public void acceptByte(int idx, String name, byte val) {
            this.data.put(name, val);
        }

        @Override
        public void acceptShort(int idx, String name, short val) {
            this.data.put(name, val);
        }

        @Override
        public void acceptInt(int idx, String name, int val) {
            this.data.put(name, val);
        }

        @Override
        public void acceptLong(int idx, String name, long val) {
            this.data.put(name, val);
        }

        @Override
        public void acceptFloat(int idx, String name, float val) {
            this.data.put(name, Float.valueOf(val));
        }

        @Override
        public void acceptDouble(int idx, String name, double val) {
            this.data.put(name, val);
        }
    }
}

