/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedLockRequest;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridNearLockRequest
extends GridDistributedLockRequest {
    private static final long serialVersionUID = 0L;
    private static final int NEED_RETURN_VALUE_FLAG_MASK = 1;
    private static final int FIRST_CLIENT_REQ_FLAG_MASK = 2;
    private static final int SYNC_COMMIT_FLAG_MASK = 4;
    private static final int NEAR_CACHE_FLAG_MASK = 8;
    private AffinityTopologyVersion topVer;
    private int miniId;
    private CacheEntryPredicate[] filter;
    @GridToStringInclude
    private GridCacheVersion[] dhtVers;
    private UUID subjId;
    private int taskNameHash;
    private long createTtl;
    private long accessTtl;
    private byte flags;
    private String txLbl;

    public GridNearLockRequest() {
    }

    public GridNearLockRequest(int cacheId, @NotNull AffinityTopologyVersion topVer, UUID nodeId, long threadId, IgniteUuid futId, GridCacheVersion lockVer, boolean isInTx, boolean isRead, boolean retVal, TransactionIsolation isolation, boolean isInvalidate, long timeout, int keyCnt, int txSize, boolean syncCommit, @Nullable UUID subjId, int taskNameHash, long createTtl, long accessTtl, boolean skipStore, boolean keepBinary, boolean firstClientReq, boolean nearCache, boolean addDepInfo, @Nullable String txLbl) {
        super(cacheId, nodeId, lockVer, threadId, futId, lockVer, isInTx, isRead, isolation, isInvalidate, timeout, keyCnt, txSize, skipStore, keepBinary, addDepInfo);
        assert (topVer.compareTo(AffinityTopologyVersion.ZERO) > 0);
        this.topVer = topVer;
        this.subjId = subjId;
        this.taskNameHash = taskNameHash;
        this.createTtl = createTtl;
        this.accessTtl = accessTtl;
        this.txLbl = txLbl;
        this.dhtVers = new GridCacheVersion[keyCnt];
        this.setFlag(syncCommit, 4);
        this.setFlag(firstClientReq, 2);
        this.setFlag(retVal, 1);
        this.setFlag(nearCache, 8);
    }

    public boolean nearCache() {
        return this.isFlag(8);
    }

    private void setFlag(boolean flag, int mask) {
        this.flags = flag ? (byte)(this.flags | mask) : (byte)(this.flags & ~mask);
    }

    private boolean isFlag(int mask) {
        return (this.flags & mask) != 0;
    }

    public boolean firstClientRequest() {
        return this.isFlag(2);
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public void topologyVersion(AffinityTopologyVersion topVer) {
        this.topVer = topVer;
    }

    public UUID subjectId() {
        return this.subjId;
    }

    public int taskNameHash() {
        return this.taskNameHash;
    }

    public boolean syncCommit() {
        return this.isFlag(4);
    }

    public CacheEntryPredicate[] filter() {
        return this.filter;
    }

    public void filter(CacheEntryPredicate[] filter, GridCacheContext ctx) throws IgniteCheckedException {
        this.filter = filter;
    }

    public int miniId() {
        return this.miniId;
    }

    public void miniId(int miniId) {
        this.miniId = miniId;
    }

    public boolean needReturnValue() {
        return this.isFlag(1);
    }

    public void addKeyBytes(KeyCacheObject key, boolean retVal, @Nullable GridCacheVersion dhtVer, GridCacheContext ctx) throws IgniteCheckedException {
        this.dhtVers[this.idx] = dhtVer;
        this.addKeyBytes(key, retVal, ctx);
    }

    public GridCacheVersion dhtVersion(int idx) {
        return this.dhtVers[idx];
    }

    public long createTtl() {
        return this.createTtl;
    }

    public long accessTtl() {
        return this.accessTtl;
    }

    @Nullable
    public String txLabel() {
        return this.txLbl;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        if (this.filter != null) {
            GridCacheContext cctx = ctx.cacheContext(this.cacheId);
            for (CacheEntryPredicate p : this.filter) {
                if (p == null) continue;
                p.prepareMarshal(cctx);
            }
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        if (this.filter != null) {
            GridCacheContext cctx = ctx.cacheContext(this.cacheId);
            for (CacheEntryPredicate p : this.filter) {
                if (p == null) continue;
                p.finishUnmarshal(cctx, ldr);
            }
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 21: {
                if (!writer.writeLong("accessTtl", this.accessTtl)) {
                    return false;
                }
                writer.incrementState();
            }
            case 22: {
                if (!writer.writeLong("createTtl", this.createTtl)) {
                    return false;
                }
                writer.incrementState();
            }
            case 23: {
                if (!writer.writeObjectArray("dhtVers", this.dhtVers, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 24: {
                if (!writer.writeObjectArray("filter", this.filter, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 25: {
                if (!writer.writeByte("flags", this.flags)) {
                    return false;
                }
                writer.incrementState();
            }
            case 26: {
                if (!writer.writeInt("miniId", this.miniId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 27: {
                if (!writer.writeUuid("subjId", this.subjId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 28: {
                if (!writer.writeInt("taskNameHash", this.taskNameHash)) {
                    return false;
                }
                writer.incrementState();
            }
            case 29: {
                if (!writer.writeAffinityTopologyVersion("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 30: {
                if (!writer.writeString("txLbl", this.txLbl)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 21: {
                this.accessTtl = reader.readLong("accessTtl");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 22: {
                this.createTtl = reader.readLong("createTtl");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 23: {
                this.dhtVers = reader.readObjectArray("dhtVers", MessageCollectionItemType.MSG, GridCacheVersion.class);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 24: {
                this.filter = reader.readObjectArray("filter", MessageCollectionItemType.MSG, CacheEntryPredicate.class);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 25: {
                this.flags = reader.readByte("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 26: {
                this.miniId = reader.readInt("miniId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 27: {
                this.subjId = reader.readUuid("subjId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 28: {
                this.taskNameHash = reader.readInt("taskNameHash");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 29: {
                this.topVer = reader.readAffinityTopologyVersion("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 30: {
                this.txLbl = reader.readString("txLbl");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridNearLockRequest.class);
    }

    @Override
    public short directType() {
        return 51;
    }

    @Override
    public byte fieldsCount() {
        return 31;
    }

    @Override
    public String toString() {
        return S.toString(GridNearLockRequest.class, this, "filter", Arrays.toString(this.filter), "super", super.toString());
    }
}

