/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheDeployable;
import org.apache.ignite.internal.processors.cache.GridCacheIdMessage;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.NearCacheUpdates;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.UpdateErrors;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class GridNearAtomicUpdateResponse
extends GridCacheIdMessage
implements GridCacheDeployable {
    private static final long serialVersionUID = 0L;
    public static final int CACHE_MSG_IDX = GridNearAtomicUpdateResponse.nextIndexId();
    @GridDirectTransient
    private UUID nodeId;
    private long futId;
    private UpdateErrors errs;
    @GridToStringInclude
    private GridCacheReturn ret;
    private AffinityTopologyVersion remapTopVer;
    private NearCacheUpdates nearUpdates;
    private int partId = -1;
    @GridDirectCollection(value=UUID.class)
    @GridToStringInclude
    private List<UUID> mapping;
    @GridDirectTransient
    private boolean nodeLeft;

    public GridNearAtomicUpdateResponse() {
    }

    public GridNearAtomicUpdateResponse(int cacheId, UUID nodeId, long futId, int partId, boolean nodeLeft, boolean addDepInfo) {
        this.cacheId = cacheId;
        this.nodeId = nodeId;
        this.futId = futId;
        this.partId = partId;
        this.nodeLeft = nodeLeft;
        this.addDepInfo = addDepInfo;
    }

    public boolean nodeLeftResponse() {
        return this.nodeLeft;
    }

    @Override
    public int lookupIndex() {
        return CACHE_MSG_IDX;
    }

    public void mapping(List<UUID> mapping) {
        this.mapping = mapping;
    }

    @Nullable
    public List<UUID> mapping() {
        return this.mapping;
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public void nodeId(UUID nodeId) {
        this.nodeId = nodeId;
    }

    public long futureId() {
        return this.futId;
    }

    public void error(IgniteCheckedException err) {
        if (this.errs == null) {
            this.errs = new UpdateErrors();
        }
        this.errs.onError(err);
    }

    @Override
    public IgniteCheckedException error() {
        return this.errs != null ? this.errs.error() : null;
    }

    public Collection<KeyCacheObject> failedKeys() {
        return this.errs != null ? this.errs.failedKeys() : null;
    }

    public GridCacheReturn returnValue() {
        return this.ret;
    }

    public void returnValue(GridCacheReturn ret) {
        this.ret = ret;
    }

    void remapTopologyVersion(AffinityTopologyVersion remapTopVer) {
        this.remapTopVer = remapTopVer;
    }

    @Nullable
    AffinityTopologyVersion remapTopologyVersion() {
        return this.remapTopVer;
    }

    private void initNearUpdates() {
        if (this.nearUpdates == null) {
            this.nearUpdates = new NearCacheUpdates();
        }
    }

    void addNearValue(int keyIdx, @Nullable CacheObject val, long ttl, long expireTime) {
        this.initNearUpdates();
        this.nearUpdates.addNearValue(keyIdx, val, ttl, expireTime);
    }

    void addNearTtl(int keyIdx, long ttl, long expireTime) {
        this.initNearUpdates();
        this.nearUpdates.addNearTtl(keyIdx, ttl, expireTime);
    }

    public long nearExpireTime(int idx) {
        return this.nearUpdates != null ? this.nearUpdates.nearExpireTime(idx) : -1L;
    }

    public long nearTtl(int idx) {
        return this.nearUpdates != null ? this.nearUpdates.nearTtl(idx) : -1L;
    }

    void nearVersion(GridCacheVersion nearVer) {
        this.initNearUpdates();
        this.nearUpdates.nearVersion(nearVer);
    }

    public GridCacheVersion nearVersion() {
        return this.nearUpdates != null ? this.nearUpdates.nearVersion() : null;
    }

    void addSkippedIndex(int keyIdx) {
        this.initNearUpdates();
        this.nearUpdates.addSkippedIndex(keyIdx);
    }

    @Nullable
    public List<Integer> skippedIndexes() {
        return this.nearUpdates != null ? this.nearUpdates.skippedIndexes() : null;
    }

    @Nullable
    public List<Integer> nearValuesIndexes() {
        return this.nearUpdates != null ? this.nearUpdates.nearValuesIndexes() : null;
    }

    @Nullable
    public CacheObject nearValue(int idx) {
        return this.nearUpdates != null ? this.nearUpdates.nearValue(idx) : null;
    }

    public synchronized void addFailedKey(KeyCacheObject key, Throwable e) {
        assert (key != null);
        assert (e != null);
        if (this.errs == null) {
            this.errs = new UpdateErrors();
        }
        this.errs.addFailedKey(key, e);
    }

    synchronized void addFailedKeys(Collection<KeyCacheObject> keys, Throwable e) {
        if (this.errs == null) {
            this.errs = new UpdateErrors();
        }
        this.errs.addFailedKeys(keys, e);
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        if (this.errs != null) {
            this.errs.prepareMarshal(this, cctx);
        }
        if (this.nearUpdates != null) {
            this.prepareMarshalCacheObjects(this.nearUpdates.nearValues(), cctx);
        }
        if (this.ret != null) {
            this.ret.prepareMarshal(cctx);
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        if (this.errs != null) {
            this.errs.finishUnmarshal(this, cctx, ldr);
        }
        if (this.nearUpdates != null) {
            this.finishUnmarshalCacheObjects(this.nearUpdates.nearValues(), cctx, ldr);
        }
        if (this.ret != null) {
            this.ret.finishUnmarshal(cctx, ldr);
        }
    }

    @Override
    public int partition() {
        return this.partId;
    }

    @Override
    public boolean addDeploymentInfo() {
        return this.addDepInfo;
    }

    @Override
    public IgniteLogger messageLogger(GridCacheSharedContext ctx) {
        return ctx.atomicMessageLogger();
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 4: {
                if (!writer.writeMessage("errs", this.errs)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeLong("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeCollection("mapping", this.mapping, MessageCollectionItemType.UUID)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeMessage("nearUpdates", this.nearUpdates)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeInt("partId", this.partId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeAffinityTopologyVersion("remapTopVer", this.remapTopVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeMessage("ret", this.ret)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 4: {
                this.errs = (UpdateErrors)reader.readMessage("errs");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.futId = reader.readLong("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.mapping = (List)reader.readCollection("mapping", MessageCollectionItemType.UUID);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.nearUpdates = (NearCacheUpdates)reader.readMessage("nearUpdates");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.partId = reader.readInt("partId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.remapTopVer = reader.readAffinityTopologyVersion("remapTopVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.ret = (GridCacheReturn)reader.readMessage("ret");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridNearAtomicUpdateResponse.class);
    }

    @Override
    public short directType() {
        return 41;
    }

    @Override
    public byte fieldsCount() {
        return 11;
    }

    @Override
    public String toString() {
        return S.toString(GridNearAtomicUpdateResponse.class, this, super.toString());
    }
}

