/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.DuplicateTypeIdException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.MappingStoreTask;
import org.apache.ignite.internal.MarshallerMappingFileStore;
import org.apache.ignite.internal.UnregisteredBinaryTypeException;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionFullMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap;
import org.apache.ignite.internal.processors.closure.GridClosureProcessor;
import org.apache.ignite.internal.processors.marshaller.MappedName;
import org.apache.ignite.internal.processors.marshaller.MappingExchangeResult;
import org.apache.ignite.internal.processors.marshaller.MarshallerMappingItem;
import org.apache.ignite.internal.processors.marshaller.MarshallerMappingTransport;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.marshaller.MarshallerContext;
import org.apache.ignite.marshaller.MarshallerUtils;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.plugin.PluginProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarshallerContextImpl
implements MarshallerContext {
    private final Map<Integer, MappedName> sysTypesMap = new HashMap<Integer, MappedName>();
    private final Collection<String> sysTypesSet = new HashSet<String>();
    private final List<ConcurrentMap<Integer, MappedName>> allCaches = new CopyOnWriteArrayList<ConcurrentMap<Integer, MappedName>>();
    private MarshallerMappingFileStore fileStore;
    private GridClosureProcessor closProc;
    private MarshallerMappingTransport transport;
    private boolean clientNode;
    private final IgnitePredicate<String> clsFilter;
    private final JdkMarshaller jdkMarsh;
    @Nullable
    private File marshallerMappingFileStoreDir;

    public MarshallerContextImpl(@Nullable Collection<PluginProvider> plugins, IgnitePredicate<String> clsFilter) {
        this.clsFilter = clsFilter;
        this.jdkMarsh = new JdkMarshaller(clsFilter);
        this.initializeCaches();
        try {
            ClassLoader ldr = U.gridClassLoader();
            MarshallerUtils.processSystemClasses(ldr, plugins, clsName -> {
                int typeId = clsName.hashCode();
                MappedName oldClsName = this.sysTypesMap.put(typeId, new MappedName((String)clsName, true));
                if (oldClsName != null && !oldClsName.className().equals(clsName)) {
                    throw new IgniteException("Duplicate type ID [id=" + typeId + ", oldClsName=" + oldClsName + ", clsName=" + clsName + ']');
                }
                this.sysTypesSet.add((String)clsName);
            });
            this.checkHasClassName(GridDhtPartitionFullMap.class.getName(), ldr, "META-INF/classnames.properties");
            this.checkHasClassName(GridDhtPartitionMap.class.getName(), ldr, "META-INF/classnames.properties");
            this.checkHasClassName(HashMap.class.getName(), ldr, "META-INF/classnames-jdk.properties");
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to initialize marshaller context.", e);
        }
    }

    private void initializeCaches() {
        this.allCaches.add(new CombinedMap(new ConcurrentHashMap<Integer, MappedName>(), this.sysTypesMap));
    }

    public ArrayList<Map<Integer, MappedName>> getCachedMappings() {
        int size = this.allCaches.size();
        ArrayList<Map<Integer, MappedName>> result = new ArrayList<Map<Integer, MappedName>>(size);
        for (int i = 0; i < size; ++i) {
            Map res = i == 0 ? ((CombinedMap)this.allCaches.get(0)).userMap : (Map)this.allCaches.get(i);
            if (res != null && !res.isEmpty()) {
                result.add(res);
                continue;
            }
            result.add(Collections.emptyMap());
        }
        return result;
    }

    public void onMappingDataReceived(byte platformId, Map<Integer, MappedName> marshallerMappings) throws IgniteCheckedException {
        ConcurrentMap<Integer, MappedName> platformCache = this.getCacheFor(platformId);
        for (Map.Entry<Integer, MappedName> e : marshallerMappings.entrySet()) {
            int typeId = e.getKey();
            String clsName = e.getValue().className();
            MappedName mappedName = (MappedName)platformCache.get(typeId);
            if (mappedName != null && !F.isEmpty(clsName) && clsName.equals(mappedName.className())) continue;
            platformCache.put(typeId, new MappedName(clsName, true));
            this.fileStore.mergeAndWriteMapping(platformId, typeId, clsName);
        }
    }

    public void checkHasClassName(String clsName, ClassLoader ldr, String fileName) {
        ConcurrentMap<Integer, MappedName> cache = this.getCacheFor((byte)0);
        if (!cache.containsKey(clsName.hashCode())) {
            throw new IgniteException("Failed to read class name from class names properties file. Make sure class names properties file packaged with ignite binaries is not corrupted [clsName=" + clsName + ", fileName=" + fileName + ", ldr=" + ldr + ']');
        }
    }

    @Override
    public boolean registerClassName(byte platformId, int typeId, String clsName, boolean failIfUnregistered) throws IgniteCheckedException {
        ConcurrentMap<Integer, MappedName> cache = this.getCacheFor(platformId);
        MappedName mappedName = (MappedName)cache.get(typeId);
        if (mappedName != null) {
            if (!mappedName.className().equals(clsName)) {
                throw new DuplicateTypeIdException(platformId, typeId, mappedName.className(), clsName);
            }
            if (mappedName.accepted()) {
                return true;
            }
            if (this.transport.stopping()) {
                return false;
            }
            MarshallerMappingItem item = new MarshallerMappingItem(platformId, typeId, clsName);
            GridFutureAdapter<MappingExchangeResult> fut = this.transport.awaitMappingAcceptance(item, cache);
            if (failIfUnregistered && !fut.isDone()) {
                throw new UnregisteredBinaryTypeException(typeId, fut);
            }
            MappingExchangeResult res = fut.get();
            return this.convertXchRes(res);
        }
        if (this.transport.stopping()) {
            return false;
        }
        MarshallerMappingItem item = new MarshallerMappingItem(platformId, typeId, clsName);
        GridFutureAdapter<MappingExchangeResult> fut = this.transport.proposeMapping(item, cache);
        if (failIfUnregistered && !fut.isDone()) {
            throw new UnregisteredBinaryTypeException(typeId, fut);
        }
        MappingExchangeResult res = fut.get();
        return this.convertXchRes(res);
    }

    @Override
    public boolean registerClassName(byte platformId, int typeId, String clsName) throws IgniteCheckedException {
        return this.registerClassName(platformId, typeId, clsName, false);
    }

    @Override
    public boolean registerClassNameLocally(byte platformId, int typeId, String clsName) throws IgniteCheckedException {
        ConcurrentMap<Integer, MappedName> cache = this.getCacheFor(platformId);
        this.fileStore.mergeAndWriteMapping(platformId, typeId, clsName);
        cache.put(typeId, new MappedName(clsName, true));
        return true;
    }

    private boolean convertXchRes(MappingExchangeResult res) throws IgniteCheckedException {
        if (res.successful()) {
            return true;
        }
        if (res.exchangeDisabled()) {
            return false;
        }
        assert (res.error() != null);
        throw res.error();
    }

    public MappedName onMappingProposed(MarshallerMappingItem item) {
        ConcurrentMap<Integer, MappedName> cache = this.getCacheFor(item.platformId());
        MappedName newName = new MappedName(item.className(), false);
        return cache.putIfAbsent(item.typeId(), newName);
    }

    public void onMappingAccepted(MarshallerMappingItem item) {
        ConcurrentMap<Integer, MappedName> cache = this.getCacheFor(item.platformId());
        cache.replace(item.typeId(), new MappedName(item.className(), true));
        this.closProc.runLocalSafe(new MappingStoreTask(this.fileStore, item.platformId(), item.typeId(), item.className()));
    }

    @Override
    public Class getClass(int typeId, ClassLoader ldr) throws ClassNotFoundException, IgniteCheckedException {
        String clsName = this.getClassName((byte)0, typeId);
        if (clsName == null) {
            throw new ClassNotFoundException("Unknown type ID: " + typeId);
        }
        return U.forName(clsName, ldr, this.clsFilter);
    }

    @Override
    public String getClassName(byte platformId, int typeId) throws ClassNotFoundException, IgniteCheckedException {
        String clsName;
        ConcurrentMap<Integer, MappedName> cache = this.getCacheFor(platformId);
        MappedName mappedName = (MappedName)cache.get(typeId);
        if (mappedName != null) {
            clsName = mappedName.className();
        } else {
            clsName = this.fileStore.readMapping(platformId, typeId);
            if (clsName != null) {
                cache.putIfAbsent(typeId, new MappedName(clsName, true));
            } else {
                if (this.clientNode) {
                    mappedName = (MappedName)cache.get(typeId);
                    if (mappedName == null) {
                        GridFutureAdapter<MappingExchangeResult> fut = this.transport.requestMapping(new MarshallerMappingItem(platformId, typeId, null), cache);
                        clsName = fut.get().className();
                    } else {
                        clsName = mappedName.className();
                    }
                    if (clsName == null) {
                        throw new ClassNotFoundException("Requesting mapping from grid failed for [platformId=" + platformId + ", typeId=" + typeId + "]");
                    }
                    return clsName;
                }
                throw new ClassNotFoundException("Unknown pair [platformId=" + platformId + ", typeId=" + typeId + "]");
            }
        }
        return clsName;
    }

    @Override
    public IgnitePredicate<String> classNameFilter() {
        return this.clsFilter;
    }

    @Override
    public JdkMarshaller jdkMarshaller() {
        return this.jdkMarsh;
    }

    public String resolveMissedMapping(byte platformId, int typeId) {
        ConcurrentMap<Integer, MappedName> cache = this.getCacheFor(platformId);
        MappedName mappedName = (MappedName)cache.get(typeId);
        if (mappedName != null) {
            assert (mappedName.accepted()) : mappedName;
            return mappedName.className();
        }
        return null;
    }

    public void onMissedMappingResolved(MarshallerMappingItem item, String resolvedClsName) {
        int typeId;
        ConcurrentMap<Integer, MappedName> cache = this.getCacheFor(item.platformId());
        MappedName mappedName = (MappedName)cache.get(typeId = item.typeId());
        if (mappedName != null) {
            assert (resolvedClsName.equals(mappedName.className())) : "Class name resolved from cluster: " + resolvedClsName + ", class name from local cache: " + mappedName.className();
        } else {
            mappedName = new MappedName(resolvedClsName, true);
            cache.putIfAbsent(typeId, mappedName);
            this.closProc.runLocalSafe(new MappingStoreTask(this.fileStore, item.platformId(), item.typeId(), resolvedClsName));
        }
    }

    @Override
    public boolean isSystemType(String typeName) {
        return this.sysTypesSet.contains(typeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentMap<Integer, MappedName> getCacheFor(byte platformId) {
        ConcurrentMap<Integer, MappedName> map;
        if (platformId < this.allCaches.size() && (map = this.allCaches.get(platformId)) != null) {
            return map;
        }
        MarshallerContextImpl marshallerContextImpl = this;
        synchronized (marshallerContextImpl) {
            int size = this.allCaches.size();
            if (platformId < size) {
                map = this.allCaches.get(platformId);
                if (map == null) {
                    map = new ConcurrentHashMap<Integer, MappedName>();
                    this.allCaches.set(platformId, map);
                }
            } else {
                map = new ConcurrentHashMap<Integer, MappedName>();
                MarshallerContextImpl.putAtIndex(map, this.allCaches, platformId, size);
            }
        }
        return map;
    }

    private static void putAtIndex(ConcurrentMap<Integer, MappedName> map, Collection<ConcurrentMap<Integer, MappedName>> allCaches, byte targetIdx, int size) {
        int lastIdx = size - 1;
        int nullElemsToAdd = targetIdx - lastIdx - 1;
        for (int i = 0; i < nullElemsToAdd; ++i) {
            allCaches.add(null);
        }
        allCaches.add(map);
    }

    public void onMarshallerProcessorStarted(GridKernalContext ctx, MarshallerMappingTransport transport) throws IgniteCheckedException {
        assert (ctx != null);
        IgniteConfiguration cfg = ctx.config();
        String workDir = U.workDirectory(cfg.getWorkDirectory(), cfg.getIgniteHome());
        IgniteLogger fileStoreLog = ctx.log(MarshallerMappingFileStore.class);
        this.fileStore = this.marshallerMappingFileStoreDir == null ? new MarshallerMappingFileStore(workDir, fileStoreLog) : new MarshallerMappingFileStore(fileStoreLog, this.marshallerMappingFileStoreDir);
        this.transport = transport;
        this.closProc = ctx.closure();
        this.clientNode = ctx.clientNode();
        if (CU.isPersistenceEnabled(ctx.config())) {
            this.fileStore.restoreMappings(this);
        }
    }

    public void onMarshallerProcessorStop() {
        this.transport.markStopping();
    }

    public Iterator<Map.Entry<Byte, Map<Integer, String>>> currentMappings() {
        byte by = this.allCaches.size();
        HashMap res = IgniteUtils.newHashMap(by);
        for (byte i = 0; i < by; i = (byte)((byte)(i + 1))) {
            Map platformMappings = this.allCaches.get(i);
            if (platformMappings == null) continue;
            if (i == 0) {
                platformMappings = ((CombinedMap)platformMappings).userMap;
            }
            HashMap nameMappings = IgniteUtils.newHashMap(platformMappings.size());
            for (Map.Entry e : platformMappings.entrySet()) {
                nameMappings.put(e.getKey(), ((MappedName)e.getValue()).className());
            }
            res.put(i, nameMappings);
        }
        return res.entrySet().iterator();
    }

    public boolean initialized() {
        return this.fileStore != null;
    }

    public void setMarshallerMappingFileStoreDir(@Nullable File marshallerMappingFileStoreDir) {
        this.marshallerMappingFileStoreDir = marshallerMappingFileStoreDir;
    }

    static final class CombinedMap
    extends AbstractMap<Integer, MappedName>
    implements ConcurrentMap<Integer, MappedName> {
        private final ConcurrentMap<Integer, MappedName> userMap;
        private final Map<Integer, MappedName> sysMap;

        CombinedMap(ConcurrentMap<Integer, MappedName> userMap, Map<Integer, MappedName> sysMap) {
            this.userMap = userMap;
            this.sysMap = sysMap;
        }

        @Override
        public Set<Map.Entry<Integer, MappedName>> entrySet() {
            return Collections.emptySet();
        }

        @Override
        public MappedName putIfAbsent(@NotNull Integer key, MappedName val) {
            return this.userMap.putIfAbsent(key, val);
        }

        @Override
        public boolean remove(@NotNull Object key, Object val) {
            return false;
        }

        @Override
        public boolean replace(@NotNull Integer key, @NotNull MappedName oldVal, @NotNull MappedName newVal) {
            return false;
        }

        @Override
        public MappedName replace(@NotNull Integer key, @NotNull MappedName val) {
            return this.userMap.replace(key, val);
        }

        @Override
        public MappedName get(Object key) {
            MappedName res = this.sysMap.get(key);
            if (res != null) {
                return res;
            }
            return (MappedName)this.userMap.get(key);
        }

        @Override
        public MappedName put(Integer key, MappedName val) {
            return this.userMap.put(key, val);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.userMap.containsKey(key) || this.sysMap.containsKey(key);
        }
    }
}

