/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql;

import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.util.typedef.internal.S;

public class SqlParseException
extends IgniteException {
    private static final long serialVersionUID = 0L;
    private final String sql;
    private final int pos;
    private final int code;

    public SqlParseException(String sql, int pos, int code, String msg) {
        super(SqlParseException.prepareMessage(sql, pos, msg));
        this.sql = sql;
        this.pos = pos;
        this.code = code;
    }

    protected SqlParseException(SqlParseException e) {
        super(e.getMessage());
        this.sql = e.sql;
        this.pos = e.pos;
        this.code = e.code;
    }

    private static String prepareMessage(String sql, int pos, String msg) {
        String sql0 = pos == sql.length() ? sql + "[*]" : sql.substring(0, pos) + "[*]" + sql.substring(pos);
        return "Failed to parse SQL statement \"" + sql0 + "\": " + msg;
    }

    public String sql() {
        return this.sql;
    }

    public int position() {
        return this.pos;
    }

    public int code() {
        return this.code;
    }

    @Override
    public String toString() {
        return S.toString(SqlParseException.class, this, "msg", this.getMessage());
    }
}

