/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.hadoop;

import org.apache.ignite.internal.processors.hadoop.HadoopJobInfo;
import org.jetbrains.annotations.Nullable;

public enum HadoopJobProperty {
    COMBINER_HASHMAP_SIZE("ignite.combiner.hashmap.size"),
    PARTITION_HASHMAP_SIZE("ignite.partition.hashmap.size"),
    EXTERNAL_CONCURRENT_MAPPERS("ignite.external.concurrent.mappers"),
    EXTERNAL_CONCURRENT_REDUCERS("ignite.external.concurrent.reducers"),
    JOB_STATUS_POLL_DELAY("ignite.job.status.poll.delay"),
    JOB_SHARED_CLASSLOADER("ignite.job.shared.classloader"),
    JOB_PARTIALLY_RAW_COMPARATOR("ignite.job.partially.raw.comparator"),
    SHUFFLE_OFFHEAP_PAGE_SIZE("ignite.shuffle.offheap.page.size"),
    SHUFFLE_COMBINER_NO_SORTING("ignite.shuffle.combiner.no.sorting"),
    SHUFFLE_REDUCER_NO_SORTING("ignite.shuffle.reducer.no.sorting"),
    SHUFFLE_MSG_SIZE("ignite.shuffle.message.size"),
    SHUFFLE_MSG_GZIP("ignite.shuffle.message.gzip"),
    SHUFFLE_MAPPER_STRIPED_OUTPUT("ignite.shuffle.mapper.striped.output"),
    SHUFFLE_JOB_THROTTLE("ignite.shuffle.job.throttle");

    private final String propName;

    private HadoopJobProperty(String propName) {
        this.propName = propName;
    }

    public String propertyName() {
        return this.propName;
    }

    public static String get(HadoopJobInfo jobInfo, HadoopJobProperty pty, @Nullable String dflt) {
        String res = jobInfo.property(pty.propertyName());
        return res == null ? dflt : res;
    }

    public static int get(HadoopJobInfo jobInfo, HadoopJobProperty pty, int dflt) {
        String res = jobInfo.property(pty.propertyName());
        return res == null ? dflt : Integer.parseInt(res);
    }

    public static boolean get(HadoopJobInfo jobInfo, HadoopJobProperty pty, boolean dflt) {
        String res = jobInfo.property(pty.propertyName());
        return res == null ? dflt : Boolean.parseBoolean(res);
    }
}

