/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near.consistency;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.CacheConsistencyViolationEvent;
import org.apache.ignite.internal.managers.eventstorage.GridEventStorageManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridPartitionedGetFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.consistency.GridNearReadRepairAbstractFuture;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;

public class GridNearReadRepairFuture
extends GridNearReadRepairAbstractFuture {
    public GridNearReadRepairFuture(AffinityTopologyVersion topVer, GridCacheContext ctx, Collection<KeyCacheObject> keys, boolean readThrough, String taskName, boolean deserializeBinary, boolean recovery, IgniteCacheExpiryPolicy expiryPlc, IgniteInternalTx tx) {
        super(topVer, ctx, keys, readThrough, taskName, deserializeBinary, recovery, expiryPlc, tx);
    }

    @Override
    protected void reduce() {
        HashMap<KeyCacheObject, EntryGetResult> newestMap = new HashMap<KeyCacheObject, EntryGetResult>();
        HashMap<KeyCacheObject, EntryGetResult> fixedMap = new HashMap<KeyCacheObject, EntryGetResult>();
        for (GridPartitionedGetFuture fut : this.futs.values()) {
            for (Map.Entry entry : ((Map)fut.result()).entrySet()) {
                KeyCacheObject key = (KeyCacheObject)entry.getKey();
                EntryGetResult candidate = (EntryGetResult)entry.getValue();
                newestMap.putIfAbsent(key, candidate);
                EntryGetResult newest = (EntryGetResult)newestMap.get(key);
                if (newest.version().compareTo(candidate.version()) < 0) {
                    newestMap.put(key, candidate);
                    fixedMap.put(key, candidate);
                }
                if (newest.version().compareTo(candidate.version()) <= 0) continue;
                fixedMap.put(key, newest);
            }
        }
        this.recordConsistencyViolation(fixedMap);
        this.onDone(fixedMap);
    }

    private void recordConsistencyViolation(Map<KeyCacheObject, EntryGetResult> fixedRaw) {
        GridEventStorageManager evtMgr = this.ctx.gridEvents();
        if (!evtMgr.isRecordable(135)) {
            return;
        }
        if (fixedRaw.isEmpty()) {
            return;
        }
        HashMap fixedMap = new HashMap();
        for (Map.Entry<KeyCacheObject, EntryGetResult> entry : fixedRaw.entrySet()) {
            KeyCacheObject key = entry.getKey();
            CacheObject val = (CacheObject)entry.getValue().value();
            this.ctx.addResult(fixedMap, key, val, false, false, this.deserializeBinary, false, null, 0L, 0L);
        }
        HashMap<UUID, Map<UUID, Map>> originalMap = new HashMap<UUID, Map<UUID, Map>>();
        for (Map.Entry pair : this.futs.entrySet()) {
            ClusterNode node = (ClusterNode)pair.getKey();
            GridPartitionedGetFuture fut = (GridPartitionedGetFuture)pair.getValue();
            for (Map.Entry entry : ((Map)fut.result()).entrySet()) {
                KeyCacheObject key = (KeyCacheObject)entry.getKey();
                if (!fixedRaw.containsKey(key)) continue;
                CacheObject val = (CacheObject)((EntryGetResult)entry.getValue()).value();
                originalMap.computeIfAbsent(node.id(), id -> new HashMap());
                Map map = (Map)originalMap.get(node.id());
                this.ctx.addResult(map, key, val, false, false, this.deserializeBinary, false, null, 0L, 0L);
            }
        }
        evtMgr.record(new CacheConsistencyViolationEvent(this.ctx.discovery().localNode(), "Consistency violation fixed.", originalMap, fixedMap));
    }
}

