/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.GridCacheDeployable;
import org.apache.ignite.internal.processors.cache.GridCacheIdMessage;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionable;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public abstract class GridDistributedBaseMessage
extends GridCacheIdMessage
implements GridCacheDeployable,
GridCacheVersionable {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    protected GridCacheVersion ver;
    @GridToStringExclude
    private byte[] candsByIdxBytes;
    @GridToStringInclude
    @GridDirectCollection(value=GridCacheVersion.class)
    private Collection<GridCacheVersion> committedVers;
    @GridToStringInclude
    @GridDirectCollection(value=GridCacheVersion.class)
    private Collection<GridCacheVersion> rolledbackVers;
    @GridToStringInclude
    @GridDirectTransient
    private int cnt;

    protected GridDistributedBaseMessage() {
    }

    protected GridDistributedBaseMessage(int cnt, boolean addDepInfo) {
        assert (cnt >= 0);
        this.cnt = cnt;
        this.addDepInfo = addDepInfo;
    }

    protected GridDistributedBaseMessage(GridCacheVersion ver, int cnt, boolean addDepInfo) {
        this(cnt, addDepInfo);
        assert (ver != null);
        this.ver = ver;
    }

    @Override
    public boolean addDeploymentInfo() {
        return this.addDepInfo;
    }

    @Override
    public GridCacheVersion version() {
        return this.ver;
    }

    public void version(GridCacheVersion ver) {
        this.ver = ver;
    }

    public void completedVersions(Collection<GridCacheVersion> committedVers, Collection<GridCacheVersion> rolledbackVers) {
        this.committedVers = committedVers;
        this.rolledbackVers = rolledbackVers;
    }

    public Collection<GridCacheVersion> committedVersions() {
        return this.committedVers == null ? Collections.emptyList() : this.committedVers;
    }

    public Collection<GridCacheVersion> rolledbackVersions() {
        return this.rolledbackVers == null ? Collections.emptyList() : this.rolledbackVers;
    }

    int keysCount() {
        return this.cnt;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 4: {
                if (!writer.writeByteArray("candsByIdxBytes", this.candsByIdxBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeCollection("committedVers", this.committedVers, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeCollection("rolledbackVers", this.rolledbackVers, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeMessage("ver", this.ver)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 4: {
                this.candsByIdxBytes = reader.readByteArray("candsByIdxBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.committedVers = reader.readCollection("committedVers", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.rolledbackVers = reader.readCollection("rolledbackVers", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.ver = (GridCacheVersion)reader.readMessage("ver");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDistributedBaseMessage.class);
    }

    @Override
    public String toString() {
        return S.toString(GridDistributedBaseMessage.class, this, "super", super.toString());
    }
}

