/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import javax.management.InstanceNotFoundException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockTrackerMXBean;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockTrackerManager;
import org.apache.ignite.internal.util.typedef.internal.U;

public class CacheDiagnosticManager
extends GridCacheSharedManagerAdapter {
    public static final String MBEAN_GROUP = "Diagnostic";
    private PageLockTrackerManager pageLockTrackerManager;

    @Override
    protected void start0() throws IgniteCheckedException {
        super.start0();
        String name = this.cctx.kernalContext().pdsFolderResolver().resolveFolders().consistentId().toString();
        this.pageLockTrackerManager = new PageLockTrackerManager(this.log, name);
        this.pageLockTrackerManager.start();
        this.registerMetricsMBean(this.cctx.gridConfig(), MBEAN_GROUP, "PageLockTracker", this.pageLockTrackerManager.mxBean(), PageLockTrackerMXBean.class);
    }

    @Override
    protected void stop0(boolean cancel) {
        super.stop0(cancel);
        this.unregisterMetricsMBean(this.cctx.gridConfig(), MBEAN_GROUP, "PageLockTracker");
        this.pageLockTrackerManager.stop();
    }

    public PageLockTrackerManager pageLockTracker() {
        return this.pageLockTrackerManager;
    }

    protected <T> void registerMetricsMBean(IgniteConfiguration cfg, String groupName, String mbeanName, T impl2, Class<T> clazz) {
        if (U.IGNITE_MBEANS_DISABLED) {
            return;
        }
        try {
            U.registerMBean(cfg.getMBeanServer(), cfg.getIgniteInstanceName(), groupName, mbeanName, impl2, clazz);
        }
        catch (Throwable e) {
            U.error(this.log, "Failed to register MBean with name: " + mbeanName, e);
        }
    }

    protected void unregisterMetricsMBean(IgniteConfiguration cfg, String groupName, String name) {
        if (U.IGNITE_MBEANS_DISABLED) {
            return;
        }
        assert (cfg != null);
        try {
            cfg.getMBeanServer().unregisterMBean(U.makeMBeanName(cfg.getIgniteInstanceName(), groupName, name));
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (Throwable e) {
            U.error(this.log, "Failed to unregister MBean for memory metrics: " + name, e);
        }
    }
}

