/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import org.apache.ignite.IgniteIllegalStateException;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryContextHolder;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryReaderHandles;
import org.apache.ignite.internal.binary.BinaryThreadLocalContext;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.streams.BinaryHeapInputStream;
import org.apache.ignite.internal.binary.streams.BinaryInputStream;
import org.apache.ignite.internal.binary.streams.BinaryOutputStream;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.jetbrains.annotations.Nullable;

public class GridBinaryMarshaller {
    public static final ThreadLocal<Boolean> KEEP_BINARIES = ThreadLocal.withInitial(() -> true);
    private static final ThreadLocal<BinaryContextHolder> BINARY_CTX = ThreadLocal.withInitial(BinaryContextHolder::new);
    public static final byte OPTM_MARSH = -2;
    public static final byte BYTE = 1;
    public static final byte SHORT = 2;
    public static final byte INT = 3;
    public static final byte LONG = 4;
    public static final byte FLOAT = 5;
    public static final byte DOUBLE = 6;
    public static final byte CHAR = 7;
    public static final byte BOOLEAN = 8;
    public static final byte DECIMAL = 30;
    public static final byte STRING = 9;
    public static final byte UUID = 10;
    public static final byte DATE = 11;
    public static final byte BYTE_ARR = 12;
    public static final byte SHORT_ARR = 13;
    public static final byte INT_ARR = 14;
    public static final byte LONG_ARR = 15;
    public static final byte FLOAT_ARR = 16;
    public static final byte DOUBLE_ARR = 17;
    public static final byte CHAR_ARR = 18;
    public static final byte BOOLEAN_ARR = 19;
    public static final byte DECIMAL_ARR = 31;
    public static final byte STRING_ARR = 20;
    public static final byte UUID_ARR = 21;
    public static final byte DATE_ARR = 22;
    public static final byte OBJ_ARR = 23;
    public static final byte COL = 24;
    public static final byte MAP = 25;
    public static final byte BINARY_OBJ = 27;
    public static final byte ENUM = 28;
    public static final byte ENUM_ARR = 29;
    public static final byte CLASS = 32;
    public static final byte TIMESTAMP = 33;
    public static final byte TIMESTAMP_ARR = 34;
    public static final byte PROXY = 35;
    public static final byte TIME = 36;
    public static final byte TIME_ARR = 37;
    public static final byte BINARY_ENUM = 38;
    public static final byte NULL = 101;
    public static final byte HANDLE = 102;
    public static final byte OBJ = 103;
    public static final byte USER_SET = -1;
    public static final byte USER_COL = 0;
    public static final byte ARR_LIST = 1;
    public static final byte LINKED_LIST = 2;
    public static final byte HASH_SET = 3;
    public static final byte LINKED_HASH_SET = 4;
    public static final byte SINGLETON_LIST = 5;
    public static final byte HASH_MAP = 1;
    public static final byte LINKED_HASH_MAP = 2;
    public static final byte PLATFORM_JAVA_OBJECT_FACTORY_PROXY = 99;
    public static final int OBJECT = -1;
    public static final int UNREGISTERED_TYPE_ID = 0;
    public static final byte PROTO_VER = 1;
    public static final int PROTO_VER_POS = 1;
    public static final int FLAGS_POS = 2;
    public static final int TYPE_ID_POS = 4;
    public static final int HASH_CODE_POS = 8;
    public static final int TOTAL_LEN_POS = 12;
    public static final int SCHEMA_ID_POS = 16;
    public static final int SCHEMA_OR_RAW_OFF_POS = 20;
    public static final byte DFLT_HDR_LEN = 24;
    private final BinaryContext ctx;

    public GridBinaryMarshaller(BinaryContext ctx) {
        this.ctx = ctx;
    }

    public byte[] marshal(@Nullable Object obj, boolean failIfUnregistered) throws BinaryObjectException {
        if (obj == null) {
            return new byte[]{101};
        }
        try (BinaryWriterExImpl writer = new BinaryWriterExImpl(this.ctx);){
            writer.failIfUnregistered(failIfUnregistered);
            writer.marshal(obj);
            byte[] byArray = writer.array();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T unmarshal(byte[] bytes, @Nullable ClassLoader clsLdr) throws BinaryObjectException {
        assert (bytes != null);
        BinaryContext oldCtx = GridBinaryMarshaller.pushContext(this.ctx);
        try {
            Object object = BinaryUtils.unmarshal(BinaryHeapInputStream.create(bytes, 0), this.ctx, clsLdr);
            return (T)object;
        }
        finally {
            GridBinaryMarshaller.popContext(oldCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T unmarshal(BinaryInputStream in) throws BinaryObjectException {
        BinaryContext oldCtx = GridBinaryMarshaller.pushContext(this.ctx);
        try {
            Object object = BinaryUtils.unmarshal(in, this.ctx, null);
            return (T)object;
        }
        finally {
            GridBinaryMarshaller.popContext(oldCtx);
        }
    }

    @Nullable
    public <T> T deserialize(byte[] arr, @Nullable ClassLoader ldr) throws BinaryObjectException {
        assert (arr != null);
        assert (arr.length > 0);
        if (arr[0] == 101) {
            return null;
        }
        return this.deserialize(BinaryHeapInputStream.create(arr, 0), ldr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T deserialize(BinaryInputStream in, @Nullable ClassLoader ldr, @Nullable BinaryReaderHandles hnds) throws BinaryObjectException {
        BinaryContext oldCtx = GridBinaryMarshaller.pushContext(this.ctx);
        try {
            Object object = new BinaryReaderExImpl(this.ctx, in, ldr, hnds, true).deserialize();
            return (T)object;
        }
        finally {
            GridBinaryMarshaller.popContext(oldCtx);
        }
    }

    public BinaryContext pushContext() {
        return GridBinaryMarshaller.pushContext(this.ctx);
    }

    @Nullable
    private static BinaryContext pushContext(BinaryContext ctx) {
        return BINARY_CTX.get().set(ctx);
    }

    public static void popContext(@Nullable BinaryContext oldCtx) {
        BINARY_CTX.get().set(oldCtx);
    }

    public BinaryReaderExImpl reader(BinaryInputStream stream) {
        assert (stream != null);
        return new BinaryReaderExImpl(this.ctx, stream, null, true);
    }

    public boolean mustDeserialize(Object obj) {
        return obj != null && this.ctx.mustDeserialize(obj.getClass());
    }

    public BinaryWriterExImpl writer(BinaryOutputStream out) {
        return new BinaryWriterExImpl(this.ctx, out, BinaryThreadLocalContext.get().schemaHolder(), null);
    }

    public BinaryContext context() {
        return this.ctx;
    }

    public static BinaryContext threadLocalContext() {
        BinaryContext ctx = BINARY_CTX.get().get();
        if (ctx == null) {
            IgniteKernal ignite = IgnitionEx.localIgnite();
            IgniteCacheObjectProcessor proc = ignite.context().cacheObjects();
            if (proc instanceof CacheObjectBinaryProcessorImpl) {
                return ((CacheObjectBinaryProcessorImpl)proc).binaryContext();
            }
            throw new IgniteIllegalStateException("Ignite instance must be started with " + BinaryMarshaller.class.getName() + " [name=" + ignite.name() + ']');
        }
        return ctx;
    }
}

