/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.command;

import java.util.UUID;
import org.apache.ignite.internal.sql.SqlLexer;
import org.apache.ignite.internal.sql.SqlLexerTokenType;
import org.apache.ignite.internal.sql.SqlParserUtils;
import org.apache.ignite.internal.sql.command.SqlCommand;

public class SqlKillQueryCommand
implements SqlCommand {
    private static final String ASYNC = "ASYNC";
    private static final String EXPECTED_GLOBAL_QRY_ID_FORMAT = "Global query id should have format '{node_id}_{query_id}', e.g. '6fa749ee-7cf8-4635-be10-36a1c75267a7_54321'";
    private long nodeQryId;
    private UUID nodeId;
    private boolean async;

    @Override
    public SqlCommand parse(SqlLexer lex) {
        this.async = SqlParserUtils.skipIfMatchesOptionalKeyword(lex, ASYNC);
        this.parseGlobalQueryId(lex);
        return this;
    }

    private void parseGlobalQueryId(SqlLexer lex) {
        String tok;
        String[] ids;
        if (lex.shift() && lex.tokenType() == SqlLexerTokenType.STRING && (ids = (tok = lex.token()).split("_")).length == 2) {
            try {
                this.nodeId = UUID.fromString(ids[0]);
                this.nodeQryId = Long.parseLong(ids[1]);
                return;
            }
            catch (Exception exception) {
                throw SqlParserUtils.error(lex, EXPECTED_GLOBAL_QRY_ID_FORMAT);
            }
        }
        if (this.async) {
            throw SqlParserUtils.error(lex, "Expected global query id. Global query id should have format '{node_id}_{query_id}', e.g. '6fa749ee-7cf8-4635-be10-36a1c75267a7_54321'");
        }
        throw SqlParserUtils.error(lex, "Expected ASYNC token or global query id. Global query id should have format '{node_id}_{query_id}', e.g. '6fa749ee-7cf8-4635-be10-36a1c75267a7_54321'");
    }

    @Override
    public String schemaName() {
        return null;
    }

    @Override
    public void schemaName(String schemaName) {
    }

    public long nodeQueryId() {
        return this.nodeQryId;
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public boolean async() {
        return this.async;
    }
}

