/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.cache.CacheCommands;
import org.apache.ignite.internal.commandline.cache.CacheSubcommands;
import org.apache.ignite.internal.commandline.cache.argument.FindAndDeleteGarbageArg;
import org.apache.ignite.internal.visor.cache.VisorFindAndDeleteGarbageInPersistenceJobResult;
import org.apache.ignite.internal.visor.cache.VisorFindAndDeleteGarbageInPersistenceTask;
import org.apache.ignite.internal.visor.cache.VisorFindAndDeleteGarbageInPersistenceTaskArg;
import org.apache.ignite.internal.visor.cache.VisorFindAndDeleteGarbageInPersistenceTaskResult;

public class FindAndDeleteGarbage
implements Command<Arguments> {
    private Arguments args;

    @Override
    public void printUsage(Logger logger) {
        String GROUPS = "groupName1,...,groupNameN";
        String description = "Find and optionally delete garbage from shared cache groups which could be left after cache destroy.";
        CacheCommands.usageCache(logger, CacheSubcommands.FIND_AND_DELETE_GARBAGE, description, null, CommandLogger.optional(GROUPS), CacheCommands.OP_NODE_ID, CommandLogger.optional(FindAndDeleteGarbageArg.DELETE));
    }

    @Override
    public Arguments arg() {
        return this.args;
    }

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger logger) throws Exception {
        VisorFindAndDeleteGarbageInPersistenceTaskArg taskArg = new VisorFindAndDeleteGarbageInPersistenceTaskArg(this.args.groups(), this.args.delete(), this.args.nodeId() != null ? Collections.singleton(this.args.nodeId()) : null);
        try (GridClient client = Command.startClient(clientCfg);){
            VisorFindAndDeleteGarbageInPersistenceTaskResult taskRes = (VisorFindAndDeleteGarbageInPersistenceTaskResult)TaskExecutor.executeTask(client, VisorFindAndDeleteGarbageInPersistenceTask.class, taskArg, clientCfg);
            CommandLogger.printErrors(taskRes.exceptions(), "Scanning for garbage failed on nodes:", logger);
            for (Map.Entry<UUID, VisorFindAndDeleteGarbageInPersistenceJobResult> nodeEntry : taskRes.result().entrySet()) {
                if (!nodeEntry.getValue().hasGarbage()) {
                    logger.info("Node " + nodeEntry.getKey() + " - garbage not found.");
                    continue;
                }
                logger.info("Garbage found on node " + nodeEntry.getKey() + ":");
                VisorFindAndDeleteGarbageInPersistenceJobResult value = nodeEntry.getValue();
                Map<Integer, Map<Integer, Long>> grpPartErrorsCount = value.checkResult();
                if (!grpPartErrorsCount.isEmpty()) {
                    for (Map.Entry<Integer, Map<Integer, Long>> entry : grpPartErrorsCount.entrySet()) {
                        for (Map.Entry<Integer, Long> e : entry.getValue().entrySet()) {
                            logger.info("  Group=" + entry.getKey() + ", partition=" + e.getKey() + ", count of keys=" + e.getValue());
                        }
                    }
                }
                logger.info("");
            }
            VisorFindAndDeleteGarbageInPersistenceTaskResult visorFindAndDeleteGarbageInPersistenceTaskResult = taskRes;
            return visorFindAndDeleteGarbageInPersistenceTaskResult;
        }
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        boolean delete = false;
        UUID nodeId = null;
        Set<String> groups = null;
        int argsCnt = 0;
        while (argIter.hasNextSubArg() && argsCnt++ < 3) {
            String nextArg = argIter.nextArg("");
            FindAndDeleteGarbageArg arg = CommandArgUtils.of(nextArg, FindAndDeleteGarbageArg.class);
            if (arg == FindAndDeleteGarbageArg.DELETE) {
                delete = true;
                continue;
            }
            try {
                nodeId = UUID.fromString(nextArg);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                groups = argIter.parseStringSet(nextArg);
            }
        }
        this.args = new Arguments(groups, nodeId, delete);
    }

    @Override
    public String name() {
        return CacheSubcommands.FIND_AND_DELETE_GARBAGE.text().toUpperCase();
    }

    public static class Arguments {
        private Set<String> groups;
        private UUID nodeId;
        private boolean delete;

        public Arguments(Set<String> groups, UUID nodeId, boolean delete) {
            this.groups = groups;
            this.nodeId = nodeId;
            this.delete = delete;
        }

        public UUID nodeId() {
            return this.nodeId;
        }

        public Set<String> groups() {
            return this.groups;
        }

        public boolean delete() {
            return this.delete;
        }
    }
}

