/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientClusterState;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandList;

public class ActivateCommand
implements Command<Void> {
    @Override
    public void printUsage(Logger logger) {
        Command.usage(logger, "Activate cluster:", CommandList.ACTIVATE, new String[0]);
    }

    @Override
    public Object execute(GridClientConfiguration cfg, Logger logger) throws Exception {
        try (GridClient client = Command.startClient(cfg);){
            GridClientClusterState state = client.state();
            state.active(true);
            logger.info("Cluster activated");
        }
        catch (Throwable e) {
            logger.severe("Failed to activate cluster.");
            throw e;
        }
        return null;
    }

    @Override
    public Void arg() {
        return null;
    }

    @Override
    public String name() {
        return CommandList.ACTIVATE.toCommandName();
    }
}

