/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.optimizer.affinity;

import java.util.Collection;
import java.util.Collections;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionClientContext;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionNode;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionTable;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.jetbrains.annotations.Nullable;

public abstract class PartitionSingleNode
implements PartitionNode {
    @GridToStringExclude
    protected final PartitionTable tbl;

    protected PartitionSingleNode(PartitionTable tbl) {
        this.tbl = tbl;
    }

    @Override
    public Collection<Integer> apply(PartitionClientContext cliCtx, Object ... args) throws IgniteCheckedException {
        Integer part = this.applySingle(cliCtx, args);
        return part != null ? Collections.singletonList(part) : null;
    }

    public abstract Integer applySingle(@Nullable PartitionClientContext var1, Object ... var2) throws IgniteCheckedException;

    public abstract boolean constant();

    @Override
    public int joinGroup() {
        return this.tbl.joinGroup();
    }

    @Override
    public String cacheName() {
        assert (this.tbl != null);
        return this.tbl.cacheName();
    }

    public abstract int value();

    public PartitionTable table() {
        return this.tbl;
    }

    public int hashCode() {
        int hash = this.constant() ? 1 : 0;
        hash = 31 * hash + this.value();
        if (this.tbl != null) {
            hash = 31 * hash + this.tbl.alias().hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        PartitionSingleNode other = (PartitionSingleNode)obj;
        return F.eq(this.constant(), other.constant()) && F.eq(this.value(), other.value()) && F.eq(this.tbl.alias(), other.tbl.alias());
    }
}

