/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.streams.BinaryHeapInputStream;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequestNoId;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBatchExecuteRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBulkLoadBatchRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcCachePartitionsRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcConnectionContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaColumnsRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaIndexesRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaParamsRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaPrimaryKeysRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaSchemasRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaTablesRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcOrderedBatchExecuteRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryCancelRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryCloseRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryExecuteRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryFetchRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryMetadataRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRawBinarylizable;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcRequest
extends ClientListenerRequestNoId
implements JdbcRawBinarylizable {
    static final byte QRY_EXEC = 2;
    static final byte QRY_FETCH = 3;
    static final byte QRY_CLOSE = 4;
    static final byte QRY_META = 5;
    public static final byte BATCH_EXEC = 6;
    static final byte META_TABLES = 7;
    static final byte META_COLUMNS = 8;
    static final byte META_INDEXES = 9;
    static final byte META_PARAMS = 10;
    static final byte META_PRIMARY_KEYS = 11;
    static final byte META_SCHEMAS = 12;
    static final byte BULK_LOAD_BATCH = 13;
    static final byte BATCH_EXEC_ORDERED = 14;
    static final byte QRY_CANCEL = 15;
    static final byte CACHE_PARTITIONS = 16;
    private static final AtomicLong REQ_ID_GENERATOR = new AtomicLong();
    private byte type;
    private long reqId;

    public JdbcRequest(byte type) {
        this.type = type;
        this.reqId = REQ_ID_GENERATOR.incrementAndGet();
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        writer.writeByte(this.type);
        if (ver.compareTo(JdbcConnectionContext.VER_2_8_0) >= 0) {
            writer.writeLong(this.reqId);
        }
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        if (ver.compareTo(JdbcConnectionContext.VER_2_8_0) >= 0) {
            this.reqId = reader.readLong();
        }
    }

    @Override
    public long requestId() {
        return this.reqId;
    }

    public byte type() {
        return this.type;
    }

    public static JdbcRequest readRequest(BinaryReaderExImpl reader, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        JdbcRequest req;
        byte reqType = reader.readByte();
        switch (reqType) {
            case 2: {
                req = new JdbcQueryExecuteRequest();
                break;
            }
            case 3: {
                req = new JdbcQueryFetchRequest();
                break;
            }
            case 5: {
                req = new JdbcQueryMetadataRequest();
                break;
            }
            case 4: {
                req = new JdbcQueryCloseRequest();
                break;
            }
            case 6: {
                req = new JdbcBatchExecuteRequest();
                break;
            }
            case 7: {
                req = new JdbcMetaTablesRequest();
                break;
            }
            case 8: {
                req = new JdbcMetaColumnsRequest();
                break;
            }
            case 9: {
                req = new JdbcMetaIndexesRequest();
                break;
            }
            case 10: {
                req = new JdbcMetaParamsRequest();
                break;
            }
            case 11: {
                req = new JdbcMetaPrimaryKeysRequest();
                break;
            }
            case 12: {
                req = new JdbcMetaSchemasRequest();
                break;
            }
            case 13: {
                req = new JdbcBulkLoadBatchRequest();
                break;
            }
            case 14: {
                req = new JdbcOrderedBatchExecuteRequest();
                break;
            }
            case 15: {
                req = new JdbcQueryCancelRequest();
                break;
            }
            case 16: {
                req = new JdbcCachePartitionsRequest();
                break;
            }
            default: {
                throw new IgniteException("Unknown SQL listener request ID: [request ID=" + reqType + ']');
            }
        }
        req.readBinary(reader, ver);
        return req;
    }

    public static byte readType(byte[] msg) {
        return msg[0];
    }

    public static long readRequestId(byte[] msg) {
        BinaryHeapInputStream stream = new BinaryHeapInputStream(msg);
        stream.position(1);
        return stream.readLong();
    }

    public String toString() {
        return S.toString(JdbcRequest.class, this);
    }
}

