/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Map;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.igfs.IgfsFile;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.internal.processors.igfs.IgfsEntryInfo;
import org.apache.ignite.internal.processors.igfs.IgfsUtils;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public final class IgfsFileImpl
implements IgfsFile,
Externalizable,
Binarylizable {
    private static final long serialVersionUID = 0L;
    private IgfsPath path;
    private IgniteUuid fileId;
    private int blockSize;
    private long grpBlockSize;
    private long len;
    private long accessTime;
    private long modificationTime;
    private byte flags;
    private Map<String, String> props;

    public IgfsFileImpl() {
    }

    public IgfsFileImpl(IgfsFile igfsFile, long grpBlockSize) {
        A.notNull(igfsFile, "igfsFile");
        this.path = igfsFile.path();
        this.fileId = igfsFile instanceof IgfsFileImpl ? ((IgfsFileImpl)igfsFile).fileId : IgniteUuid.randomUuid();
        this.blockSize = igfsFile.blockSize();
        this.len = igfsFile.length();
        this.grpBlockSize = igfsFile.isFile() ? grpBlockSize : 0L;
        this.props = igfsFile.properties();
        this.accessTime = igfsFile.accessTime();
        this.modificationTime = igfsFile.modificationTime();
        this.flags = IgfsUtils.flags(igfsFile.isDirectory(), igfsFile.isFile());
    }

    public IgfsFileImpl(IgfsPath path, IgfsEntryInfo info, long globalGrpBlockSize) {
        A.notNull(path, "path");
        A.notNull(info, "info");
        this.path = path;
        this.fileId = info.id();
        this.flags = IgfsUtils.flags(info.isDirectory(), info.isFile());
        if (info.isFile()) {
            this.blockSize = info.blockSize();
            this.len = info.length();
            this.grpBlockSize = info.affinityKey() == null ? globalGrpBlockSize : (info.length() == 0L ? globalGrpBlockSize : info.length());
        }
        this.props = info.properties();
        if (this.props == null) {
            this.props = Collections.emptyMap();
        }
        this.accessTime = info.accessTime();
        this.modificationTime = info.modificationTime();
    }

    @Override
    public IgfsPath path() {
        return this.path;
    }

    public IgniteUuid fileId() {
        return this.fileId;
    }

    @Override
    public boolean isFile() {
        return IgfsUtils.isFile(this.flags);
    }

    @Override
    public boolean isDirectory() {
        return IgfsUtils.isDirectory(this.flags);
    }

    @Override
    public long length() {
        return this.len;
    }

    @Override
    public int blockSize() {
        return this.blockSize;
    }

    @Override
    public long groupBlockSize() {
        return this.grpBlockSize;
    }

    @Override
    public long accessTime() {
        return this.accessTime;
    }

    @Override
    public long modificationTime() {
        return this.modificationTime;
    }

    @Override
    public String property(String name) throws IllegalArgumentException {
        String val = this.props.get(name);
        if (val == null) {
            throw new IllegalArgumentException("File property not found [path=" + this.path + ", name=" + name + ']');
        }
        return val;
    }

    @Override
    public String property(String name, @Nullable String dfltVal) {
        String val = this.props.get(name);
        return val == null ? dfltVal : val;
    }

    @Override
    public Map<String, String> properties() {
        return this.props;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.path.writeExternal(out);
        out.writeInt(this.blockSize);
        out.writeLong(this.grpBlockSize);
        out.writeLong(this.len);
        IgfsUtils.writeStringMap(out, this.props);
        out.writeLong(this.accessTime);
        out.writeLong(this.modificationTime);
        out.writeByte(this.flags);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.path = IgfsUtils.readPath(in);
        this.blockSize = in.readInt();
        this.grpBlockSize = in.readLong();
        this.len = in.readLong();
        this.props = IgfsUtils.readStringMap(in);
        this.accessTime = in.readLong();
        this.modificationTime = in.readLong();
        this.flags = in.readByte();
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter rawWriter = writer.rawWriter();
        IgfsUtils.writePath(rawWriter, this.path);
        rawWriter.writeInt(this.blockSize);
        rawWriter.writeLong(this.grpBlockSize);
        rawWriter.writeLong(this.len);
        IgfsUtils.writeProperties(rawWriter, this.props);
        rawWriter.writeLong(this.accessTime);
        rawWriter.writeLong(this.modificationTime);
        rawWriter.writeByte(this.flags);
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader rawReader = reader.rawReader();
        this.path = IgfsUtils.readPath(rawReader);
        this.blockSize = rawReader.readInt();
        this.grpBlockSize = rawReader.readLong();
        this.len = rawReader.readLong();
        this.props = IgfsUtils.readProperties(rawReader);
        this.accessTime = rawReader.readLong();
        this.modificationTime = rawReader.readLong();
        this.flags = rawReader.readByte();
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IgfsFileImpl that = (IgfsFileImpl)o;
        return this.path.equals(that.path);
    }

    public String toString() {
        return S.toString(IgfsFileImpl.class, this);
    }
}

