/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.partstorage;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.IncompleteObject;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.DataRegionMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.Storable;
import org.apache.ignite.internal.processors.cache.persistence.freelist.AbstractFreeList;
import org.apache.ignite.internal.processors.cache.persistence.partstorage.PartitionMetaStorage;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.AbstractDataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.DataPagePayload;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageLockListener;

public class PartitionMetaStorageImpl<T extends Storable>
extends AbstractFreeList<T>
implements PartitionMetaStorage<T> {
    public PartitionMetaStorageImpl(int cacheId, String name, DataRegionMetricsImpl memMetrics, DataRegion memPlc, ReuseList reuseList, IgniteWriteAheadLogManager wal, long metaPageId, boolean initNew, PageLockListener lsnr, GridKernalContext ctx, AtomicLong pageListCacheLimit) throws IgniteCheckedException {
        super(cacheId, name, memMetrics, memPlc, reuseList, wal, metaPageId, initNew, lsnr, ctx, pageListCacheLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final byte[] readRow(long link) throws IgniteCheckedException {
        assert (link != 0L) : "link";
        long nextLink = link;
        IncompleteObject incomplete = null;
        int size = 0;
        boolean first = true;
        do {
            long pageId = PageIdUtils.pageId(nextLink);
            long page = this.pageMem.acquirePage(this.grpId, pageId);
            try {
                long pageAddr = this.pageMem.readLock(this.grpId, pageId, page);
                assert (pageAddr != 0L) : nextLink;
                try {
                    AbstractDataPageIO io = (AbstractDataPageIO)PageIO.getPageIO(pageAddr);
                    DataPagePayload data = io.readPayload(pageAddr, PageIdUtils.itemId(nextLink), this.pageMem.pageSize());
                    nextLink = data.nextLink();
                    if (first) {
                        if (nextLink == 0L) {
                            long payloadAddr = pageAddr + (long)data.offset();
                            byte[] byArray = PageUtils.getBytes(payloadAddr, 4, PageUtils.getInt(payloadAddr, 0));
                            return byArray;
                        }
                        first = false;
                    }
                    ByteBuffer buf = this.pageMem.pageBuffer(pageAddr);
                    buf.position(data.offset());
                    buf.limit(data.offset() + data.payloadSize());
                    if (size == 0) {
                        if (buf.remaining() >= 4 && incomplete == null) {
                            size = buf.getInt();
                            incomplete = new IncompleteObject(new byte[size]);
                        } else {
                            if (incomplete == null) {
                                incomplete = new IncompleteObject(new byte[4]);
                            }
                            incomplete.readData(buf);
                            if (incomplete.isReady()) {
                                size = ByteBuffer.wrap(incomplete.data()).order(buf.order()).getInt();
                                incomplete = new IncompleteObject(new byte[size]);
                            }
                        }
                    }
                    if (size != 0 && buf.remaining() > 0) {
                        incomplete.readData(buf);
                    }
                }
                finally {
                    this.pageMem.readUnlock(this.grpId, pageId, page);
                }
            }
            finally {
                this.pageMem.releasePage(this.grpId, pageId, page);
            }
        } while (nextLink != 0L);
        assert (incomplete.isReady());
        return incomplete.data();
    }
}

