/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.metastorage;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageBPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageDataRow;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageRow;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageRowStore;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageLockListener;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.jetbrains.annotations.Nullable;

public class MetastorageTree
extends BPlusTree<MetastorageRow, MetastorageDataRow> {
    public static final int MAX_KEY_LEN = 64;
    private MetastorageRowStore rowStore;
    private final int partId;

    public MetastorageTree(int cacheId, String name, PageMemory pageMem, IgniteWriteAheadLogManager wal, AtomicLong globalRmvId, ReuseList reuseList, MetastorageRowStore rowStore, long metaPageId, boolean initNew, @Nullable FailureProcessor failureProcessor, int partId, @Nullable PageLockListener lockLsnr) throws IgniteCheckedException {
        super(name, cacheId, null, pageMem, wal, globalRmvId, metaPageId, reuseList, MetastorageBPlusIO.INNER_IO_VERSIONS, MetastorageBPlusIO.LEAF_IO_VERSIONS, failureProcessor, lockLsnr);
        this.rowStore = rowStore;
        this.partId = partId;
        this.initTree(initNew);
    }

    @Override
    protected int compare(BPlusIO<MetastorageRow> io, long pageAddr, int idx, MetastorageRow row) throws IgniteCheckedException {
        String key = ((MetastorageBPlusIO)((Object)io)).getKey(pageAddr, idx, this.rowStore);
        return key.compareTo(row.key());
    }

    @Override
    public MetastorageDataRow getRow(BPlusIO<MetastorageRow> io, long pageAddr, int idx, Object x) throws IgniteCheckedException {
        return ((MetastorageBPlusIO)((Object)io)).getDataRow(pageAddr, idx, this.rowStore);
    }

    public MetastorageRowStore rowStore() {
        return this.rowStore;
    }

    @Override
    protected long allocatePageNoReuse() throws IgniteCheckedException {
        return this.pageMem.allocatePage(this.grpId, this.partId, (byte)1);
    }
}

