/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.DumpSupported;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.LockTrackerFactory;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockDump;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockListenerIndexAdapter;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockTracker;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockTrackerManager;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.ThreadPageLocksDumpLock;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageLockListener;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lifecycle.LifecycleAware;

public class SharedPageLockTracker
implements LifecycleAware,
PageLockListener,
DumpSupported<ThreadPageLocksDumpLock> {
    private static final long OVERHEAD_SIZE = 92L;
    private final PageLockTrackerManager.MemoryCalculator memCalc;
    public final int threadLimits;
    public final int timeOutWorkerInterval;
    private final Map<Long, PageLockTracker<? extends PageLockDump>> threadStacks = new HashMap<Long, PageLockTracker<? extends PageLockDump>>();
    private final Map<Long, Thread> threadIdToThreadRef = new HashMap<Long, Thread>();
    private final Map<String, Integer> structureNameToId = new HashMap<String, Integer>();
    private final TimeOutWorker timeOutWorker = new TimeOutWorker();
    private Map<Long, State> prevThreadsState = new HashMap<Long, State>();
    private int idGen;
    private final Consumer<Set<State>> hangThreadsCallBack;
    private final ThreadLocal<PageLockTracker> lockTracker = ThreadLocal.withInitial(this::createTracker);

    public SharedPageLockTracker() {
        this(ids -> {}, new PageLockTrackerManager.MemoryCalculator());
    }

    public SharedPageLockTracker(Consumer<Set<State>> hangThreadsCallBack, PageLockTrackerManager.MemoryCalculator memCalc) {
        this(1000, IgniteSystemProperties.getInteger("IGNITE_PAGE_LOCK_TRACKER_CHECK_INTERVAL", 60000), hangThreadsCallBack, memCalc);
    }

    public SharedPageLockTracker(int threadLimits, int timeOutWorkerInterval, Consumer<Set<State>> hangThreadsCallBack, PageLockTrackerManager.MemoryCalculator memCalc) {
        this.threadLimits = threadLimits;
        this.timeOutWorkerInterval = timeOutWorkerInterval;
        this.hangThreadsCallBack = hangThreadsCallBack;
        this.memCalc = memCalc;
        this.memCalc.onHeapAllocated(92L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PageLockTracker createTracker() {
        Thread thread = Thread.currentThread();
        String name = "name=" + thread.getName();
        long threadId = thread.getId();
        PageLockTracker<? extends PageLockDump> tracker = LockTrackerFactory.create(LockTrackerFactory.DEFAULT_TYPE, LockTrackerFactory.DEFAULT_CAPACITY, name, this.memCalc);
        SharedPageLockTracker sharedPageLockTracker = this;
        synchronized (sharedPageLockTracker) {
            this.threadStacks.put(threadId, tracker);
            this.threadIdToThreadRef.put(threadId, thread);
            this.memCalc.onHeapAllocated(80L);
            if (this.threadIdToThreadRef.size() > this.threadLimits) {
                this.cleanTerminatedThreads();
            }
        }
        return tracker;
    }

    public synchronized PageLockListener registrateStructure(String structureName) {
        Integer id = this.structureNameToId.get(structureName);
        if (id == null) {
            id = ++this.idGen;
            this.structureNameToId.put(structureName, id);
            this.memCalc.onHeapAllocated(structureName.getBytes().length + 16 + 28);
        }
        this.memCalc.onHeapAllocated(28L);
        return new PageLockListenerIndexAdapter(id, this);
    }

    @Override
    public void onBeforeWriteLock(int structureId, long pageId, long page) {
        this.lockTracker.get().onBeforeWriteLock(structureId, pageId, page);
    }

    @Override
    public void onWriteLock(int structureId, long pageId, long page, long pageAddr) {
        this.lockTracker.get().onWriteLock(structureId, pageId, page, pageAddr);
    }

    @Override
    public void onWriteUnlock(int structureId, long pageId, long page, long pageAddr) {
        this.lockTracker.get().onWriteUnlock(structureId, pageId, page, pageAddr);
    }

    @Override
    public void onBeforeReadLock(int structureId, long pageId, long page) {
        this.lockTracker.get().onBeforeReadLock(structureId, pageId, page);
    }

    @Override
    public void onReadLock(int structureId, long pageId, long page, long pageAddr) {
        this.lockTracker.get().onReadLock(structureId, pageId, page, pageAddr);
    }

    @Override
    public void onReadUnlock(int structureId, long pageId, long page, long pageAddr) {
        this.lockTracker.get().onReadUnlock(structureId, pageId, page, pageAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ThreadPageLocksDumpLock dump() {
        Collection<PageLockTracker<? extends PageLockDump>> trackers = this.threadStacks.values();
        ArrayList<ThreadPageLocksDumpLock.ThreadState> threadStates = new ArrayList<ThreadPageLocksDumpLock.ThreadState>(this.threadStacks.size());
        for (PageLockTracker<? extends PageLockDump> pageLockTracker : trackers) {
            boolean acquired = pageLockTracker.acquireSafePoint();
            assert (acquired);
        }
        for (Map.Entry entry : this.threadStacks.entrySet()) {
            Long threadId = (Long)entry.getKey();
            Thread thread = this.threadIdToThreadRef.get(threadId);
            PageLockTracker tracker = (PageLockTracker)entry.getValue();
            try {
                Object pageLockDump = tracker.dump();
                threadStates.add(new ThreadPageLocksDumpLock.ThreadState(threadId, thread.getName(), thread.getState(), (PageLockDump)pageLockDump, tracker.isInvalid() ? tracker.invalidContext() : null));
            }
            finally {
                tracker.releaseSafePoint();
            }
        }
        Map<Integer, String> idToStructureName0 = Collections.unmodifiableMap(this.structureNameToId.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey)));
        List<ThreadPageLocksDumpLock.ThreadState> list = Collections.unmodifiableList(threadStates);
        long time = !threadStates.isEmpty() ? ((ThreadPageLocksDumpLock.ThreadState)threadStates.get((int)0)).pageLockDump.time() : System.currentTimeMillis();
        return new ThreadPageLocksDumpLock(time, idToStructureName0, list);
    }

    private synchronized void cleanTerminatedThreads() {
        Iterator<Map.Entry<Long, Thread>> it = this.threadIdToThreadRef.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, Thread> entry = it.next();
            long threadId = entry.getKey();
            Thread thread = entry.getValue();
            if (thread.getState() != Thread.State.TERMINATED) continue;
            PageLockTracker<? extends PageLockDump> tracker = this.threadStacks.remove(threadId);
            if (tracker != null) {
                this.memCalc.onHeapFree(40L);
                tracker.free();
            }
            it.remove();
            this.memCalc.onHeapFree(40L);
        }
    }

    private synchronized Map<Long, State> getThreadOperationState() {
        return this.threadStacks.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            PageLockTracker lt = (PageLockTracker)e.getValue();
            return new State(lt.operationsCounter(), lt.heldLocksNumber(), this.threadIdToThreadRef.get(e.getKey()));
        }));
    }

    private synchronized Set<State> hangThreads() {
        HashSet<State> hangsThreads = new HashSet<State>();
        Map<Long, State> currentThreadsOperationState = this.getThreadOperationState();
        this.prevThreadsState.forEach((threadId, prevState) -> {
            boolean threadHoldedLocks;
            State state = (State)currentThreadsOperationState.get(threadId);
            if (state == null) {
                return;
            }
            boolean bl = threadHoldedLocks = state.heldLockCnt != 0L;
            if (prevState.equals(state) && threadHoldedLocks) {
                hangsThreads.add(state);
            }
        });
        this.prevThreadsState = currentThreadsOperationState;
        return hangsThreads;
    }

    @Override
    public void start() throws IgniteException {
        this.timeOutWorker.setDaemon(true);
        this.timeOutWorker.start();
    }

    @Override
    public void stop() throws IgniteException {
        this.timeOutWorker.interrupt();
        try {
            this.timeOutWorker.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInterruptedException(e);
        }
    }

    @Override
    public IgniteFuture<ThreadPageLocksDumpLock> dumpSync() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean acquireSafePoint() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean releaseSafePoint() {
        throw new UnsupportedOperationException();
    }

    public static class State {
        final long threadOpCnt;
        final long heldLockCnt;
        final Thread thread;

        private State(long threadOpCnt, long heldLockCnt, Thread thread) {
            this.threadOpCnt = threadOpCnt;
            this.heldLockCnt = heldLockCnt;
            this.thread = thread;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            return this.threadOpCnt == state.threadOpCnt && this.heldLockCnt == state.heldLockCnt && Objects.equals(this.thread, state.thread);
        }

        public int hashCode() {
            return Objects.hash(this.threadOpCnt, this.heldLockCnt, this.thread);
        }
    }

    private class TimeOutWorker
    extends Thread {
        private TimeOutWorker() {
        }

        @Override
        public void run() {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    Set threadIds;
                    TimeOutWorker.sleep(SharedPageLockTracker.this.timeOutWorkerInterval);
                    SharedPageLockTracker.this.cleanTerminatedThreads();
                    if (SharedPageLockTracker.this.hangThreadsCallBack == null || F.isEmpty(threadIds = SharedPageLockTracker.this.hangThreads())) continue;
                    SharedPageLockTracker.this.hangThreadsCallBack.accept(threadIds);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

