/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near.consistency;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridPartitionedGetFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.consistency.GridNearReadRepairAbstractFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.consistency.IgniteConsistencyViolationException;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;

public class GridNearReadRepairCheckOnlyFuture
extends GridNearReadRepairAbstractFuture {
    private final boolean skipVals;
    private final boolean needVer;
    private boolean keepCacheObjects;

    public GridNearReadRepairCheckOnlyFuture(GridCacheContext ctx, Collection<KeyCacheObject> keys, boolean readThrough, String taskName, boolean deserializeBinary, boolean recovery, IgniteCacheExpiryPolicy expiryPlc, boolean skipVals, boolean needVer, boolean keepCacheObjects, IgniteInternalTx tx) {
        super(null, ctx, keys, readThrough, taskName, deserializeBinary, recovery, expiryPlc, tx);
        this.skipVals = skipVals;
        this.needVer = needVer;
        this.keepCacheObjects = keepCacheObjects;
    }

    @Override
    protected void reduce() {
        HashMap<KeyCacheObject, EntryGetResult> map = new HashMap<KeyCacheObject, EntryGetResult>();
        for (GridPartitionedGetFuture fut : this.futs.values()) {
            for (Map.Entry entry : ((Map)fut.result()).entrySet()) {
                KeyCacheObject key = (KeyCacheObject)entry.getKey();
                EntryGetResult candidate = (EntryGetResult)entry.getValue();
                EntryGetResult old = (EntryGetResult)map.get(key);
                if (old != null && old.version().compareTo(candidate.version()) != 0) {
                    if (REMAP_CNT_UPD.incrementAndGet(this) > MAX_REMAP_CNT) {
                        this.onDone(new IgniteConsistencyViolationException("Distributed cache consistency violation detected."));
                    } else {
                        this.map(this.ctx.affinity().affinityTopologyVersion());
                    }
                    return;
                }
                map.put(key, candidate);
            }
        }
        this.onDone(map);
    }

    public <K, V> IgniteInternalFuture<V> single() {
        return this.chain(fut -> {
            try {
                IgniteBiTuple map = new IgniteBiTuple();
                for (Map.Entry entry : ((Map)fut.get()).entrySet()) {
                    EntryGetResult getRes = (EntryGetResult)entry.getValue();
                    this.ctx.addResult(map, (KeyCacheObject)entry.getKey(), (CacheObject)getRes.value(), this.skipVals, this.keepCacheObjects, this.deserializeBinary, false, getRes, getRes.version(), 0L, 0L, this.needVer);
                }
                if (this.skipVals) {
                    Boolean val = map.isEmpty() ? false : (Boolean)F.firstValue(map);
                    return val;
                }
                return F.firstValue(map);
            }
            catch (IgniteCheckedException e) {
                throw new GridClosureException(e);
            }
        });
    }

    public <K, V> IgniteInternalFuture<Map<K, V>> multi() {
        return this.chain(fut -> {
            try {
                HashMap map = U.newHashMap(this.keys.size());
                for (Map.Entry entry : ((Map)fut.get()).entrySet()) {
                    EntryGetResult getRes = (EntryGetResult)entry.getValue();
                    this.ctx.addResult(map, (KeyCacheObject)entry.getKey(), (CacheObject)getRes.value(), this.skipVals, this.keepCacheObjects, this.deserializeBinary, false, getRes, getRes.version(), 0L, 0L, this.needVer);
                }
                return map;
            }
            catch (Exception e) {
                throw new GridClosureException(e);
            }
        });
    }
}

