/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorEither;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.query.VisorQueryCursor;
import org.apache.ignite.internal.visor.query.VisorQueryResult;
import org.apache.ignite.internal.visor.query.VisorQueryScanRegexFilter;
import org.apache.ignite.internal.visor.query.VisorQueryUtils;
import org.apache.ignite.internal.visor.query.VisorScanQueryTaskArg;
import org.apache.ignite.internal.visor.util.VisorExceptionWrapper;
import org.apache.ignite.lang.IgniteBiPredicate;

@GridInternal
public class VisorScanQueryTask
extends VisorOneNodeTask<VisorScanQueryTaskArg, VisorEither<VisorQueryResult>> {
    private static final long serialVersionUID = 0L;

    protected VisorScanQueryJob job(VisorScanQueryTaskArg arg) {
        return new VisorScanQueryJob(arg, this.debug);
    }

    private static class VisorScanQueryJob
    extends VisorJob<VisorScanQueryTaskArg, VisorEither<VisorQueryResult>> {
        private static final long serialVersionUID = 0L;

        private VisorScanQueryJob(VisorScanQueryTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        private QueryCursor<Cache.Entry<Object, Object>> scan(IgniteCache<Object, Object> c, VisorScanQueryTaskArg arg, IgniteBiPredicate<Object, Object> filter) {
            ScanQuery<Object, Object> qry = new ScanQuery<Object, Object>(filter);
            qry.setPageSize(arg.getPageSize());
            qry.setLocal(arg.isLocal());
            return c.withKeepBinary().query(qry);
        }

        private QueryCursor<Cache.Entry<Object, Object>> near(IgniteCache<Object, Object> c) {
            return new VisorNearCacheCursor<Cache.Entry<Object, Object>>(c.localEntries(CachePeekMode.NEAR).iterator());
        }

        @Override
        protected VisorEither<VisorQueryResult> run(VisorScanQueryTaskArg arg) {
            try {
                IgniteCache<Object, Object> c = this.ignite.cache(arg.getCacheName());
                UUID nid = this.ignite.localNode().id();
                String filterText = arg.getFilter();
                long start = U.currentTimeMillis();
                VisorQueryScanRegexFilter filter = null;
                if (!F.isEmpty(filterText)) {
                    filter = new VisorQueryScanRegexFilter(arg.isCaseSensitive(), arg.isRegEx(), filterText);
                }
                VisorQueryCursor<Cache.Entry<Object, Object>> cur = new VisorQueryCursor<Cache.Entry<Object, Object>>(arg.isNear() ? this.near(c) : this.scan(c, arg, filter));
                List<Object[]> rows = VisorQueryUtils.fetchScanQueryRows(cur, arg.getPageSize());
                long duration = U.currentTimeMillis() - start;
                boolean hasNext = cur.hasNext();
                String qryId = "VISOR_SCAN_QUERY-" + UUID.randomUUID();
                if (hasNext) {
                    this.ignite.cluster().nodeLocalMap().put(qryId, cur);
                    VisorQueryUtils.scheduleResultSetHolderRemoval(qryId, this.ignite);
                } else {
                    cur.close();
                }
                return new VisorEither<VisorQueryResult>(new VisorQueryResult(nid, qryId, VisorQueryUtils.SCAN_COL_NAMES, rows, hasNext, duration));
            }
            catch (Throwable e) {
                return new VisorEither<VisorExceptionWrapper>(new VisorExceptionWrapper(e));
            }
        }

        public String toString() {
            return S.toString(VisorScanQueryJob.class, this);
        }

        private static class VisorNearCacheCursor<T>
        implements QueryCursor<T> {
            private final Iterator<T> it;

            private VisorNearCacheCursor(Iterator<T> it) {
                this.it = it;
            }

            @Override
            public List<T> getAll() {
                ArrayList<T> all = new ArrayList<T>();
                while (this.it.hasNext()) {
                    all.add(this.it.next());
                }
                return all;
            }

            @Override
            public void close() {
            }

            @Override
            public Iterator<T> iterator() {
                return this.it;
            }
        }
    }
}

