/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.compute;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeTaskNoResultCache;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.compute.PlatformAbstractTask;
import org.apache.ignite.internal.processors.platform.compute.PlatformJob;
import org.apache.ignite.internal.util.typedef.F;
import org.jetbrains.annotations.Nullable;

@ComputeTaskNoResultCache
public class PlatformBroadcastingMultiClosureTask
extends PlatformAbstractTask {
    private static final long serialVersionUID = 0L;
    private Collection<PlatformJob> jobs;

    public PlatformBroadcastingMultiClosureTask(PlatformContext ctx, long taskPtr) {
        super(ctx, taskPtr);
    }

    @Override
    @Nullable
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Object arg) {
        assert (!F.isEmpty(this.jobs)) : "Jobs emptiness must be checked in native platform.";
        if (!F.isEmpty(subgrid)) {
            HashMap<PlatformJob, ClusterNode> map = new HashMap<PlatformJob, ClusterNode>(this.jobs.size() * subgrid.size(), 1.0f);
            for (PlatformJob job : this.jobs) {
                boolean first = true;
                for (ClusterNode node : subgrid) {
                    if (first) {
                        map.put(job, node);
                        first = false;
                        continue;
                    }
                    map.put(this.ctx.createClosureJob(this, job.pointer(), job.job()), node);
                }
            }
            return map;
        }
        return Collections.emptyMap();
    }

    public void jobs(Collection<PlatformJob> jobs) {
        this.jobs = jobs;
    }
}

