/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.verify;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.internal.processors.cache.verify.IdleVerifyResultV2;
import org.apache.ignite.internal.processors.cache.verify.PartitionHashRecordV2;
import org.apache.ignite.internal.processors.cache.verify.PartitionKeyV2;
import org.apache.ignite.internal.processors.cache.verify.VerifyBackupPartitionsTaskV2;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyDumpTaskArg;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyTaskArg;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VerifyBackupPartitionsDumpTask
extends ComputeTaskAdapter<VisorIdleVerifyTaskArg, String> {
    private static final long serialVersionUID = 0L;
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH-mm-ss_SSS");
    public static final String IDLE_DUMP_FILE_PREMIX = "idle-dump-";
    private final VerifyBackupPartitionsTaskV2 delegate = new VerifyBackupPartitionsTaskV2();
    private VisorIdleVerifyDumpTaskArg taskArg;
    @IgniteInstanceResource
    private Ignite ignite;

    @Override
    @Nullable
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, VisorIdleVerifyTaskArg arg) throws IgniteException {
        if (arg instanceof VisorIdleVerifyDumpTaskArg) {
            this.taskArg = (VisorIdleVerifyDumpTaskArg)arg;
        }
        return this.delegate.map(subgrid, arg);
    }

    @Override
    @Nullable
    public String reduce(List<ComputeJobResult> results) throws IgniteException {
        TreeMap<PartitionKeyV2, List> clusterHashes = new TreeMap<PartitionKeyV2, List>(this.buildPartitionKeyComparator());
        for (ComputeJobResult res : results) {
            Map nodeHashes = (Map)res.getData();
            for (Map.Entry e : nodeHashes.entrySet()) {
                clusterHashes.computeIfAbsent((PartitionKeyV2)e.getKey(), k -> new ArrayList()).add(e.getValue());
            }
        }
        Comparator<PartitionHashRecordV2> recordComp = this.buildRecordComparator().reversed();
        LinkedHashMap<PartitionKeyV2, List<PartitionHashRecordV2>> partitions = new LinkedHashMap<PartitionKeyV2, List<PartitionHashRecordV2>>();
        int skippedRecords = 0;
        for (Map.Entry entry : clusterHashes.entrySet()) {
            if (this.needToAdd((List)entry.getValue())) {
                ((List)entry.getValue()).sort(recordComp);
                partitions.put((PartitionKeyV2)entry.getKey(), (List<PartitionHashRecordV2>)entry.getValue());
                continue;
            }
            ++skippedRecords;
        }
        return this.writeHashes(partitions, (IdleVerifyResultV2)this.delegate.reduce((List)results), skippedRecords);
    }

    private boolean needToAdd(List<PartitionHashRecordV2> records) {
        if (records.isEmpty() || this.taskArg != null && !this.taskArg.isSkipZeros()) {
            return true;
        }
        PartitionHashRecordV2 record = records.get(0);
        if (record.updateCounter() != 0L || record.size() != 0L) {
            return true;
        }
        int firstHash = record.partitionHash();
        for (int i = 1; i < records.size(); ++i) {
            record = records.get(i);
            if (record.partitionHash() == firstHash && record.updateCounter() == 0L && record.size() == 0L) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeHashes(Map<PartitionKeyV2, List<PartitionHashRecordV2>> partitions, IdleVerifyResultV2 conflictRes, int skippedRecords) throws IgniteException {
        File workDir = this.ignite.configuration().getWorkDirectory() == null ? new File("/tmp") : new File(this.ignite.configuration().getWorkDirectory());
        File out = new File(workDir, IDLE_DUMP_FILE_PREMIX + LocalDateTime.now().format(TIME_FORMATTER) + ".txt");
        this.ignite.log().info("IdleVerifyDumpTask will write output to " + out.getAbsolutePath());
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(out));){
            try {
                writer.write("idle_verify check has finished, found " + partitions.size() + " partitions\n");
                if (skippedRecords > 0) {
                    writer.write(skippedRecords + " partitions was skipped\n");
                }
                if (!F.isEmpty(partitions)) {
                    writer.write("Cluster partitions:\n");
                    for (Map.Entry<PartitionKeyV2, List<PartitionHashRecordV2>> entry : partitions.entrySet()) {
                        writer.write("Partition: " + entry.getKey() + "\n");
                        writer.write("Partition instances: " + entry.getValue() + "\n");
                    }
                    writer.write("\n\n-----------------------------------\n\n");
                    conflictRes.print(str -> {
                        try {
                            writer.write((String)str);
                        }
                        catch (IOException e) {
                            throw new IgniteException("Failed to write partitions conflict.", e);
                        }
                    });
                }
            }
            finally {
                writer.flush();
            }
            this.ignite.log().info("IdleVerifyDumpTask successfully written dump to '" + out.getAbsolutePath() + "'");
        }
        catch (IOException | IgniteException e) {
            this.ignite.log().error("Failed to write dump file: " + out.getAbsolutePath(), e);
            throw new IgniteException(e);
        }
        return out.getAbsolutePath();
    }

    @NotNull
    private Comparator<PartitionHashRecordV2> buildRecordComparator() {
        return (o1, o2) -> {
            int compare = Boolean.compare(o1.isPrimary(), o2.isPrimary());
            if (compare != 0) {
                return compare;
            }
            return o1.consistentId().toString().compareTo(o2.consistentId().toString());
        };
    }

    @NotNull
    private Comparator<PartitionKeyV2> buildPartitionKeyComparator() {
        return (o1, o2) -> {
            int compare = Integer.compare(o1.groupId(), o2.groupId());
            if (compare != 0) {
                return compare;
            }
            return Integer.compare(o1.partitionId(), o2.partitionId());
        };
    }
}

