/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import java.io.Serializable;
import java.util.UUID;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class MvccCoordinator
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final UUID nodeId;
    private final long crdVer;
    @GridToStringInclude
    private final AffinityTopologyVersion topVer;

    public MvccCoordinator(UUID nodeId, long crdVer, AffinityTopologyVersion topVer) {
        assert (nodeId != null);
        assert (crdVer > 0L) : crdVer;
        assert (topVer != null);
        this.nodeId = nodeId;
        this.crdVer = crdVer;
        this.topVer = topVer;
    }

    public long coordinatorVersion() {
        return this.crdVer;
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MvccCoordinator that = (MvccCoordinator)o;
        return this.crdVer == that.crdVer;
    }

    public int hashCode() {
        return (int)(this.crdVer ^ this.crdVer >>> 32);
    }

    public String toString() {
        return S.toString(MvccCoordinator.class, this);
    }
}

