/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.cache.Cache;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.wal.record.delta.DataPageMvccMarkUpdatedRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.DataPageMvccUpdateNewTxStateHintRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.DataPageMvccUpdateTxStateHintRecord;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryImplEx;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheInvokeEntry;
import org.apache.ignite.internal.processors.cache.CacheInvokeResult;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.IgniteRebalanceIterator;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.PartitionUpdateCounter;
import org.apache.ignite.internal.processors.cache.distributed.dht.colocated.GridDhtDetachedCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionPartialCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteDhtDemandedPartitionsMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteHistoricalIterator;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteRebalanceIteratorImpl;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshotWithoutTxs;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersion;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.persistence.CacheSearchRow;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.persistence.RootPage;
import org.apache.ignite.internal.processors.cache.persistence.RowStore;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.DataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageHandler;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryManager;
import org.apache.ignite.internal.processors.cache.tree.CacheDataRowStore;
import org.apache.ignite.internal.processors.cache.tree.CacheDataTree;
import org.apache.ignite.internal.processors.cache.tree.DataRow;
import org.apache.ignite.internal.processors.cache.tree.PendingEntriesTree;
import org.apache.ignite.internal.processors.cache.tree.PendingRow;
import org.apache.ignite.internal.processors.cache.tree.RowLinkIO;
import org.apache.ignite.internal.processors.cache.tree.SearchRow;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccDataRow;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccUpdateDataRow;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccUpdateDataRowNative;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccUpdateResult;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.ResultType;
import org.apache.ignite.internal.processors.cache.tree.mvcc.search.MvccFirstRowTreeClosure;
import org.apache.ignite.internal.processors.cache.tree.mvcc.search.MvccLinkAwareSearchRow;
import org.apache.ignite.internal.processors.cache.tree.mvcc.search.MvccMaxSearchRow;
import org.apache.ignite.internal.processors.cache.tree.mvcc.search.MvccMinSearchRow;
import org.apache.ignite.internal.processors.cache.tree.mvcc.search.MvccSnapshotSearchRow;
import org.apache.ignite.internal.processors.cache.tree.mvcc.search.MvccTreeClosure;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.query.GridQueryRowCacheCleaner;
import org.apache.ignite.internal.util.GridAtomicLong;
import org.apache.ignite.internal.util.GridCloseableIteratorAdapter;
import org.apache.ignite.internal.util.GridEmptyCloseableIterator;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.GridStripedLock;
import org.apache.ignite.internal.util.IgniteTree;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.internal.util.lang.IgniteInClosure2X;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgniteCacheOffheapManagerImpl
implements IgniteCacheOffheapManager {
    public static final long UNWIND_THROTTLING_TIMEOUT = Long.getLong("IGNITE_UNWIND_THROTTLING_TIMEOUT", 500L);
    protected GridCacheSharedContext ctx;
    protected CacheGroupContext grp;
    protected IgniteLogger log;
    private IgniteCacheOffheapManager.CacheDataStore locCacheDataStore;
    protected final ConcurrentMap<Integer, IgniteCacheOffheapManager.CacheDataStore> partDataStores = new ConcurrentHashMap<Integer, IgniteCacheOffheapManager.CacheDataStore>();
    private PendingEntriesTree pendingEntries;
    protected volatile boolean hasPendingEntries;
    protected volatile long nextCleanTime;
    private final GridAtomicLong globalRmvId = new GridAtomicLong(U.currentTimeMillis() * 1000000L);
    protected final GridSpinBusyLock busyLock = new GridSpinBusyLock();
    private int updateValSizeThreshold;
    protected GridStripedLock partStoreLock = new GridStripedLock(Runtime.getRuntime().availableProcessors());

    @Override
    public GridAtomicLong globalRemoveId() {
        return this.globalRmvId;
    }

    @Override
    public void start(GridCacheSharedContext ctx, CacheGroupContext grp) throws IgniteCheckedException {
        this.ctx = ctx;
        this.grp = grp;
        this.log = ctx.logger(this.getClass());
        this.updateValSizeThreshold = ctx.database().pageSize() / 2;
        if (grp.affinityNode()) {
            ctx.database().checkpointReadLock();
            try {
                this.initDataStructures();
                if (grp.isLocal()) {
                    this.locCacheDataStore = this.createCacheDataStore(0);
                }
            }
            finally {
                ctx.database().checkpointReadUnlock();
            }
        }
    }

    @Override
    public void onCacheStarted(GridCacheContext cctx) throws IgniteCheckedException {
        this.initPendingTree(cctx);
    }

    protected void initPendingTree(GridCacheContext cctx) throws IgniteCheckedException {
        assert (!cctx.group().persistenceEnabled());
        if (cctx.affinityNode() && cctx.ttl().eagerTtlEnabled() && this.pendingEntries == null) {
            String name = "PendingEntries";
            long rootPage = this.allocateForTree();
            this.pendingEntries = new PendingEntriesTree(this.grp, name, this.grp.dataRegion().pageMemory(), rootPage, this.grp.reuseList(), true);
        }
    }

    protected void initDataStructures() throws IgniteCheckedException {
    }

    @Override
    public void stopCache(int cacheId, boolean destroy) {
        if (destroy && this.grp.affinityNode()) {
            this.removeCacheData(cacheId);
        }
    }

    @Override
    public void stop() {
        try {
            for (IgniteCacheOffheapManager.CacheDataStore store : this.cacheDataStores()) {
                this.destroyCacheDataStore(store);
            }
            if (this.pendingEntries != null) {
                this.pendingEntries.destroy();
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e.getMessage(), e);
        }
    }

    @Override
    public void onKernalStop() {
        this.busyLock.block();
    }

    private void removeCacheData(int cacheId) {
        assert (this.grp.affinityNode());
        try {
            if (this.grp.sharedGroup()) {
                assert (cacheId != 0);
                for (IgniteCacheOffheapManager.CacheDataStore store : this.cacheDataStores()) {
                    store.clear(cacheId);
                }
                if (this.pendingEntries != null) {
                    PendingRow row = new PendingRow(cacheId);
                    GridCursor cursor = this.pendingEntries.find(row, row, PendingEntriesTree.WITHOUT_KEY);
                    while (cursor.next()) {
                        boolean res = this.pendingEntries.removex(cursor.get());
                        assert (res);
                    }
                }
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e.getMessage(), e);
        }
    }

    @Override
    public IgniteCacheOffheapManager.CacheDataStore dataStore(GridDhtLocalPartition part) {
        if (this.grp.isLocal()) {
            return this.locCacheDataStore;
        }
        assert (part != null);
        return part.dataStore();
    }

    public IgniteCacheOffheapManager.CacheDataStore dataStore(int part) {
        return this.grp.isLocal() ? this.locCacheDataStore : (IgniteCacheOffheapManager.CacheDataStore)this.partDataStores.get(part);
    }

    @Override
    public long cacheEntriesCount(int cacheId) {
        long size = 0L;
        for (IgniteCacheOffheapManager.CacheDataStore store : this.cacheDataStores()) {
            size += store.cacheSize(cacheId);
        }
        return size;
    }

    @Override
    public long totalPartitionEntriesCount(int p) {
        if (this.grp.isLocal()) {
            return this.locCacheDataStore.fullSize();
        }
        GridDhtLocalPartition part = this.grp.topology().localPartition(p, AffinityTopologyVersion.NONE, false, true);
        return part != null ? part.dataStore().fullSize() : 0L;
    }

    @Nullable
    private IgniteCacheOffheapManager.CacheDataStore partitionData(int p) {
        if (this.grp.isLocal()) {
            return this.locCacheDataStore;
        }
        GridDhtLocalPartition part = this.grp.topology().localPartition(p, AffinityTopologyVersion.NONE, false, true);
        return part != null ? part.dataStore() : null;
    }

    @Override
    public long cacheEntriesCount(int cacheId, boolean primary, boolean backup, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        if (this.grp.isLocal()) {
            return this.cacheEntriesCount(cacheId, 0);
        }
        long cnt = 0L;
        Iterator<IgniteCacheOffheapManager.CacheDataStore> it = this.cacheData(primary, backup, topVer);
        while (it.hasNext()) {
            cnt += it.next().cacheSize(cacheId);
        }
        return cnt;
    }

    @Override
    public long cacheEntriesCount(int cacheId, int part) {
        IgniteCacheOffheapManager.CacheDataStore store = this.partitionData(part);
        return store == null ? 0L : store.cacheSize(cacheId);
    }

    private Iterator<IgniteCacheOffheapManager.CacheDataStore> cacheData(boolean primary, boolean backup, AffinityTopologyVersion topVer) {
        assert (primary || backup);
        if (this.grp.isLocal()) {
            return this.singletonIterator(this.locCacheDataStore);
        }
        Iterator<GridDhtLocalPartition> it = this.grp.topology().currentLocalPartitions().iterator();
        if (primary && backup) {
            return F.iterator(it, new IgniteClosure<GridDhtLocalPartition, IgniteCacheOffheapManager.CacheDataStore>(){

                @Override
                public IgniteCacheOffheapManager.CacheDataStore apply(GridDhtLocalPartition part) {
                    return part.dataStore();
                }
            }, true, new IgnitePredicate[0]);
        }
        final Set<Integer> parts = primary ? this.grp.affinity().primaryPartitions(this.ctx.localNodeId(), topVer) : this.grp.affinity().backupPartitions(this.ctx.localNodeId(), topVer);
        return F.iterator(it, new IgniteClosure<GridDhtLocalPartition, IgniteCacheOffheapManager.CacheDataStore>(){

            @Override
            public IgniteCacheOffheapManager.CacheDataStore apply(GridDhtLocalPartition part) {
                return part.dataStore();
            }
        }, true, new IgnitePredicate<GridDhtLocalPartition>(){

            @Override
            public boolean apply(GridDhtLocalPartition part) {
                return parts.contains(part.id());
            }
        });
    }

    @Override
    public void invoke(GridCacheContext cctx, KeyCacheObject key, GridDhtLocalPartition part, IgniteCacheOffheapManager.OffheapInvokeClosure c) throws IgniteCheckedException {
        this.dataStore(part).invoke(cctx, key, c);
    }

    @Override
    public void update(GridCacheContext cctx, KeyCacheObject key, CacheObject val, GridCacheVersion ver, long expireTime, GridDhtLocalPartition part, @Nullable CacheDataRow oldRow) throws IgniteCheckedException {
        assert (expireTime >= 0L);
        this.dataStore(part).update(cctx, key, val, ver, expireTime, oldRow);
    }

    @Override
    public boolean mvccInitialValue(GridCacheMapEntry entry, CacheObject val, GridCacheVersion ver, long expireTime, MvccVersion mvccVer, MvccVersion newMvccVer) throws IgniteCheckedException {
        return this.dataStore(entry.localPartition()).mvccInitialValue(entry.context(), entry.key(), val, ver, expireTime, mvccVer, newMvccVer);
    }

    @Override
    public boolean mvccInitialValueIfAbsent(GridCacheMapEntry entry, CacheObject val, GridCacheVersion ver, long expireTime, MvccVersion mvccVer, MvccVersion newMvccVer, byte txState, byte newTxState) throws IgniteCheckedException {
        return this.dataStore(entry.localPartition()).mvccInitialValueIfAbsent(entry.context(), entry.key(), val, ver, expireTime, mvccVer, newMvccVer, txState, newTxState);
    }

    @Override
    public boolean mvccUpdateRowWithPreloadInfo(GridCacheMapEntry entry, @Nullable CacheObject val, GridCacheVersion ver, long expireTime, MvccVersion mvccVer, MvccVersion newMvccVer, byte mvccTxState, byte newMvccTxState) throws IgniteCheckedException {
        assert (entry.lockedByCurrentThread());
        return this.dataStore(entry.localPartition()).mvccUpdateRowWithPreloadInfo(entry.context(), entry.key(), val, ver, expireTime, mvccVer, newMvccVer, mvccTxState, newMvccTxState);
    }

    @Override
    public MvccUpdateResult mvccUpdate(GridCacheMapEntry entry, CacheObject val, GridCacheVersion ver, long expireTime, MvccSnapshot mvccSnapshot, boolean primary, boolean needHistory, boolean noCreate, boolean needOldVal, @Nullable CacheEntryPredicate filter, boolean retVal, EntryProcessor entryProc, Object[] invokeArgs) throws IgniteCheckedException {
        if (entry.detached() || entry.isNear()) {
            return null;
        }
        assert (entry.lockedByCurrentThread());
        return this.dataStore(entry.localPartition()).mvccUpdate(entry.context(), entry.key(), val, ver, expireTime, mvccSnapshot, filter, entryProc, invokeArgs, primary, needHistory, noCreate, needOldVal, retVal);
    }

    @Override
    public MvccUpdateResult mvccRemove(GridCacheMapEntry entry, MvccSnapshot mvccSnapshot, boolean primary, boolean needHistory, boolean needOldVal, @Nullable CacheEntryPredicate filter, boolean retVal) throws IgniteCheckedException {
        if (entry.detached() || entry.isNear()) {
            return null;
        }
        assert (entry.lockedByCurrentThread());
        return this.dataStore(entry.localPartition()).mvccRemove(entry.context(), entry.key(), mvccSnapshot, filter, primary, needHistory, needOldVal, retVal);
    }

    @Override
    public GridLongList mvccUpdateNative(boolean primary, GridCacheMapEntry entry, CacheObject val, GridCacheVersion ver, long expireTime, MvccSnapshot mvccSnapshot) throws IgniteCheckedException {
        if (entry.detached() || entry.isNear()) {
            return null;
        }
        return this.dataStore(entry.localPartition()).mvccUpdateNative(entry.context(), primary, entry.key(), val, ver, expireTime, mvccSnapshot);
    }

    @Override
    public GridLongList mvccRemoveNative(boolean primary, GridCacheMapEntry entry, MvccSnapshot mvccSnapshot) throws IgniteCheckedException {
        if (entry.detached() || entry.isNear()) {
            return null;
        }
        return this.dataStore(entry.localPartition()).mvccRemoveNative(entry.context(), primary, entry.key(), mvccSnapshot);
    }

    @Override
    public void mvccRemoveAll(GridCacheMapEntry entry) throws IgniteCheckedException {
        if (entry.detached() || entry.isNear()) {
            return;
        }
        this.dataStore(entry.localPartition()).mvccRemoveAll(entry.context(), entry.key());
    }

    @Override
    @Nullable
    public MvccUpdateResult mvccLock(GridCacheMapEntry entry, MvccSnapshot mvccSnapshot) throws IgniteCheckedException {
        if (entry.detached() || entry.isNear()) {
            return null;
        }
        assert (entry.lockedByCurrentThread());
        return this.dataStore(entry.localPartition()).mvccLock(entry.context(), entry.key(), mvccSnapshot);
    }

    @Override
    public void mvccApplyUpdate(GridCacheContext cctx, KeyCacheObject key, CacheObject val, GridCacheVersion ver, long expireTime, GridDhtLocalPartition part, MvccVersion mvccVer) throws IgniteCheckedException {
        this.dataStore(part).mvccApplyUpdate(cctx, key, val, ver, expireTime, mvccVer);
    }

    @Override
    public void remove(GridCacheContext cctx, KeyCacheObject key, int partId, GridDhtLocalPartition part) throws IgniteCheckedException {
        this.dataStore(part).remove(cctx, key, partId);
    }

    @Override
    @Nullable
    public CacheDataRow read(GridCacheMapEntry entry) throws IgniteCheckedException {
        KeyCacheObject key = entry.key();
        assert (this.grp.isLocal() || entry.localPartition() != null) : entry;
        return this.dataStore(entry.localPartition()).find(entry.context(), key);
    }

    @Override
    @Nullable
    public CacheDataRow read(GridCacheContext cctx, KeyCacheObject key) throws IgniteCheckedException {
        CacheDataRow row;
        IgniteCacheOffheapManager.CacheDataStore dataStore = this.dataStore(cctx, key);
        CacheDataRow cacheDataRow = row = dataStore != null ? dataStore.find(cctx, key) : null;
        assert (row == null || row.value() != null) : row;
        return row;
    }

    @Override
    @Nullable
    public CacheDataRow mvccRead(GridCacheContext cctx, KeyCacheObject key, MvccSnapshot ver) throws IgniteCheckedException {
        CacheDataRow row;
        assert (ver != null);
        IgniteCacheOffheapManager.CacheDataStore dataStore = this.dataStore(cctx, key);
        CacheDataRow cacheDataRow = row = dataStore != null ? dataStore.mvccFind(cctx, key, ver) : null;
        assert (row == null || row.value() != null) : row;
        return row;
    }

    @Override
    public List<IgniteBiTuple<Object, MvccVersion>> mvccAllVersions(GridCacheContext cctx, KeyCacheObject key) throws IgniteCheckedException {
        IgniteCacheOffheapManager.CacheDataStore dataStore = this.dataStore(cctx, key);
        return dataStore != null ? dataStore.mvccFindAllVersions(cctx, key) : Collections.emptyList();
    }

    @Override
    public GridCursor<CacheDataRow> mvccAllVersionsCursor(GridCacheContext cctx, KeyCacheObject key, Object x) throws IgniteCheckedException {
        IgniteCacheOffheapManager.CacheDataStore dataStore = this.dataStore(cctx, key);
        return dataStore != null ? dataStore.mvccAllVersionsCursor(cctx, key, x) : GridCacheOffheapManager.EMPTY_CURSOR;
    }

    @Nullable
    private IgniteCacheOffheapManager.CacheDataStore dataStore(GridCacheContext cctx, KeyCacheObject key) {
        if (this.grp.isLocal()) {
            return this.locCacheDataStore;
        }
        GridDhtLocalPartition part = this.grp.topology().localPartition(cctx.affinity().partition(key), null, false);
        return part != null ? this.dataStore(part) : null;
    }

    @Override
    public boolean containsKey(GridCacheMapEntry entry) {
        try {
            return this.read(entry) != null;
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to read value", e);
            return false;
        }
    }

    @Override
    public void onPartitionCounterUpdated(int part, long cntr) {
    }

    @Override
    public void onPartitionInitialCounterUpdated(int part, long cntr) {
    }

    @Override
    public long lastUpdatedPartitionCounter(int part) {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache(GridCacheContext cctx, boolean readers) {
        GridCacheVersion obsoleteVer = null;
        try (GridCloseableIterator<CacheDataRow> it = this.grp.isLocal() ? this.iterator(cctx.cacheId(), this.cacheDataStores().iterator(), null) : this.evictionSafeIterator(cctx.cacheId(), this.cacheDataStores().iterator());){
            while (it.hasNext()) {
                cctx.shared().database().checkpointReadLock();
                try {
                    KeyCacheObject key = ((CacheDataRow)it.next()).key();
                    try {
                        if (obsoleteVer == null) {
                            obsoleteVer = this.ctx.versions().next();
                        }
                        GridCacheEntryEx entry = cctx.cache().entryEx(key);
                        entry.clear(obsoleteVer, readers);
                    }
                    catch (GridDhtInvalidPartitionException entry) {
                    }
                    catch (IgniteCheckedException e) {
                        U.error(this.log, "Failed to clear cache entry: " + key, e);
                    }
                }
                finally {
                    cctx.shared().database().checkpointReadUnlock();
                }
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to close iterator", e);
        }
    }

    @Override
    public int onUndeploy(ClassLoader ldr) {
        return 0;
    }

    @Override
    public long offHeapAllocatedSize() {
        return 0L;
    }

    @Override
    public <K, V> GridCloseableIterator<Cache.Entry<K, V>> cacheEntriesIterator(final GridCacheContext cctx, boolean primary, boolean backup, AffinityTopologyVersion topVer, final boolean keepBinary) throws IgniteCheckedException {
        final GridIterator<CacheDataRow> it = this.cacheIterator(cctx.cacheId(), primary, backup, topVer, null);
        return new GridCloseableIteratorAdapter<Cache.Entry<K, V>>(){
            private CacheEntryImplEx next;

            @Override
            protected Cache.Entry<K, V> onNext() {
                CacheEntryImplEx ret = this.next;
                this.next = null;
                return ret;
            }

            @Override
            protected boolean onHasNext() {
                if (this.next != null) {
                    return true;
                }
                CacheSearchRow nextRow = null;
                if (it.hasNext()) {
                    nextRow = (CacheDataRow)it.next();
                }
                if (nextRow != null) {
                    KeyCacheObject key = nextRow.key();
                    CacheObject val = nextRow.value();
                    Object key0 = cctx.unwrapBinaryIfNeeded(key, keepBinary, false);
                    Object val0 = cctx.unwrapBinaryIfNeeded(val, keepBinary, false);
                    this.next = new CacheEntryImplEx<Object, Object>(key0, val0, nextRow.version());
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public GridCloseableIterator<KeyCacheObject> cacheKeysIterator(int cacheId, int part) throws IgniteCheckedException {
        IgniteCacheOffheapManager.CacheDataStore data = this.partitionData(part);
        if (data == null) {
            return new GridEmptyCloseableIterator<KeyCacheObject>();
        }
        final GridCursor<? extends CacheDataRow> cur = data.cursor(cacheId, null, null, (Object)CacheDataRowAdapter.RowData.KEY_ONLY);
        return new GridCloseableIteratorAdapter<KeyCacheObject>(){
            private KeyCacheObject next;

            @Override
            protected KeyCacheObject onNext() {
                KeyCacheObject res = this.next;
                this.next = null;
                return res;
            }

            @Override
            protected boolean onHasNext() throws IgniteCheckedException {
                if (this.next != null) {
                    return true;
                }
                if (cur.next()) {
                    CacheDataRow row = (CacheDataRow)cur.get();
                    this.next = row.key();
                }
                return this.next != null;
            }
        };
    }

    @Override
    public GridIterator<CacheDataRow> cacheIterator(int cacheId, boolean primary, boolean backups, AffinityTopologyVersion topVer, @Nullable MvccSnapshot mvccSnapshot) throws IgniteCheckedException {
        return this.iterator(cacheId, this.cacheData(primary, backups, topVer), mvccSnapshot);
    }

    @Override
    public GridIterator<CacheDataRow> cachePartitionIterator(int cacheId, int part, @Nullable MvccSnapshot mvccSnapshot) throws IgniteCheckedException {
        IgniteCacheOffheapManager.CacheDataStore data = this.partitionData(part);
        if (data == null) {
            return new GridEmptyCloseableIterator<CacheDataRow>();
        }
        return this.iterator(cacheId, this.singletonIterator(data), mvccSnapshot);
    }

    @Override
    public GridIterator<CacheDataRow> partitionIterator(int part) throws IgniteCheckedException {
        IgniteCacheOffheapManager.CacheDataStore data = this.partitionData(part);
        if (data == null) {
            return new GridEmptyCloseableIterator<CacheDataRow>();
        }
        return this.iterator(0, this.singletonIterator(data), null);
    }

    private GridCloseableIterator<CacheDataRow> iterator(final int cacheId, final Iterator<IgniteCacheOffheapManager.CacheDataStore> dataIt, final MvccSnapshot mvccSnapshot) {
        return new GridCloseableIteratorAdapter<CacheDataRow>(){
            private GridCursor<? extends CacheDataRow> cur;
            private int curPart;
            private CacheDataRow next;

            @Override
            protected CacheDataRow onNext() {
                CacheDataRow res = this.next;
                this.next = null;
                return res;
            }

            @Override
            protected boolean onHasNext() throws IgniteCheckedException {
                if (this.next != null) {
                    return true;
                }
                while (true) {
                    if (this.cur == null) {
                        if (!dataIt.hasNext()) break;
                        IgniteCacheOffheapManager.CacheDataStore ds = (IgniteCacheOffheapManager.CacheDataStore)dataIt.next();
                        this.curPart = ds.partId();
                        if (mvccSnapshot == null) {
                            this.cur = cacheId == 0 ? ds.cursor() : ds.cursor(cacheId);
                        } else {
                            GridCursor<? extends CacheDataRow> gridCursor = this.cur = cacheId == 0 ? ds.cursor(mvccSnapshot) : ds.cursor(cacheId, mvccSnapshot);
                        }
                    }
                    if (this.cur.next()) {
                        this.next = this.cur.get();
                        this.next.key().partition(this.curPart);
                        break;
                    }
                    this.cur = null;
                }
                return this.next != null;
            }
        };
    }

    private GridCloseableIterator<CacheDataRow> evictionSafeIterator(final int cacheId, final Iterator<IgniteCacheOffheapManager.CacheDataStore> dataIt) {
        return new GridCloseableIteratorAdapter<CacheDataRow>(){
            private GridCursor<? extends CacheDataRow> cur;
            private GridDhtLocalPartition curPart;
            private CacheDataRow next;

            @Override
            protected CacheDataRow onNext() {
                CacheDataRow res = this.next;
                this.next = null;
                return res;
            }

            @Override
            protected boolean onHasNext() throws IgniteCheckedException {
                if (this.next != null) {
                    return true;
                }
                while (true) {
                    if (this.cur == null) {
                        if (!dataIt.hasNext()) break;
                        IgniteCacheOffheapManager.CacheDataStore ds = (IgniteCacheOffheapManager.CacheDataStore)dataIt.next();
                        if (!this.reservePartition(ds.partId())) continue;
                        GridCursor<? extends CacheDataRow> gridCursor = this.cur = cacheId == 0 ? ds.cursor() : ds.cursor(cacheId);
                    }
                    if (this.cur.next()) {
                        this.next = this.cur.get();
                        this.next.key().partition(this.curPart.id());
                        break;
                    }
                    this.cur = null;
                    this.releaseCurrentPartition();
                }
                return this.next != null;
            }

            private void releaseCurrentPartition() {
                GridDhtLocalPartition p = this.curPart;
                assert (p != null);
                this.curPart = null;
                p.release();
            }

            private boolean reservePartition(int partId) {
                GridDhtLocalPartition p = IgniteCacheOffheapManagerImpl.this.grp.topology().localPartition(partId);
                if (p != null && p.reserve()) {
                    this.curPart = p;
                    return true;
                }
                return false;
            }

            @Override
            protected void onClose() throws IgniteCheckedException {
                if (this.curPart != null) {
                    this.releaseCurrentPartition();
                }
            }
        };
    }

    private <T> Iterator<T> singletonIterator(final T item) {
        return new Iterator<T>(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public T next() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return item;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private long allocateForTree() throws IgniteCheckedException {
        long pageId;
        ReuseList reuseList = this.grp.reuseList();
        if (reuseList == null || (pageId = reuseList.takeRecycledPage()) == 0L) {
            pageId = this.grp.dataRegion().pageMemory().allocatePage(this.grp.groupId(), 65535, (byte)2);
        }
        return pageId;
    }

    @Override
    public RootPage rootPageForIndex(int cacheId, String idxName) throws IgniteCheckedException {
        long pageId = this.allocateForTree();
        return new RootPage(new FullPageId(pageId, this.grp.groupId()), true);
    }

    @Override
    public void dropRootPageForIndex(int cacheId, String idxName) throws IgniteCheckedException {
    }

    @Override
    public ReuseList reuseListForIndex(String idxName) {
        return this.grp.reuseList();
    }

    @Override
    public GridCloseableIterator<CacheDataRow> reservedIterator(int part, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        final GridDhtLocalPartition loc = this.grp.topology().localPartition(part, topVer, false);
        if (loc == null || !loc.reserve()) {
            return null;
        }
        if (loc.state() != GridDhtPartitionState.OWNING) {
            loc.release();
            return null;
        }
        IgniteCacheOffheapManager.CacheDataStore data = this.partitionData(part);
        final GridCursor<? extends CacheDataRow> cur = data.cursor();
        return new GridCloseableIteratorAdapter<CacheDataRow>(){
            private CacheDataRow next;

            @Override
            protected CacheDataRow onNext() {
                CacheDataRow res = this.next;
                this.next = null;
                return res;
            }

            @Override
            protected boolean onHasNext() throws IgniteCheckedException {
                if (this.next != null) {
                    return true;
                }
                if (cur.next()) {
                    this.next = (CacheDataRow)cur.get();
                }
                return this.next != null;
            }

            @Override
            protected void onClose() throws IgniteCheckedException {
                assert (loc != null && loc.state() == GridDhtPartitionState.OWNING && loc.reservations() > 0) : "Partition should be in OWNING state and has at least 1 reservation: " + loc;
                loc.release();
            }
        };
    }

    @Override
    public IgniteRebalanceIterator rebalanceIterator(IgniteDhtDemandedPartitionsMap parts, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        TreeMap<Integer, GridCloseableIterator<CacheDataRow>> iterators = new TreeMap<Integer, GridCloseableIterator<CacheDataRow>>();
        HashSet<Integer> missing = new HashSet<Integer>();
        for (Integer p : parts.fullSet()) {
            GridCloseableIterator<CacheDataRow> partIter = this.reservedIterator(p, topVer);
            if (partIter == null) {
                missing.add(p);
                continue;
            }
            iterators.put(p, partIter);
        }
        IgniteHistoricalIterator historicalIterator = this.historicalIterator(parts.historicalMap(), missing);
        IgniteRebalanceIteratorImpl iter = new IgniteRebalanceIteratorImpl(iterators, historicalIterator);
        for (Integer p : missing) {
            iter.setPartitionMissing(p);
        }
        return iter;
    }

    @Nullable
    protected IgniteHistoricalIterator historicalIterator(CachePartitionPartialCountersMap partCntrs, Set<Integer> missing) throws IgniteCheckedException {
        return null;
    }

    @Override
    public final IgniteCacheOffheapManager.CacheDataStore createCacheDataStore(int p) throws IgniteCheckedException {
        IgniteCacheOffheapManager.CacheDataStore dataStore;
        this.partStoreLock.lock(p);
        try {
            assert (!this.partDataStores.containsKey(p));
            dataStore = this.createCacheDataStore0(p);
            this.partDataStores.put(p, dataStore);
        }
        finally {
            this.partStoreLock.unlock(p);
        }
        return dataStore;
    }

    protected IgniteCacheOffheapManager.CacheDataStore createCacheDataStore0(int p) throws IgniteCheckedException {
        long rootPage = this.allocateForTree();
        CacheDataRowStore rowStore = new CacheDataRowStore(this.grp, this.grp.freeList(), p);
        String idxName = this.treeName(p);
        CacheDataTree dataTree = new CacheDataTree(this.grp, idxName, this.grp.reuseList(), rowStore, rootPage, true);
        return new CacheDataStoreImpl(p, idxName, rowStore, dataTree);
    }

    @Override
    public Iterable<IgniteCacheOffheapManager.CacheDataStore> cacheDataStores() {
        if (this.grp.isLocal()) {
            return Collections.singleton(this.locCacheDataStore);
        }
        return new Iterable<IgniteCacheOffheapManager.CacheDataStore>(){

            @Override
            public Iterator<IgniteCacheOffheapManager.CacheDataStore> iterator() {
                return IgniteCacheOffheapManagerImpl.this.partDataStores.values().iterator();
            }
        };
    }

    @Override
    public final void destroyCacheDataStore(IgniteCacheOffheapManager.CacheDataStore store) throws IgniteCheckedException {
        int p = store.partId();
        this.partStoreLock.lock(p);
        try {
            boolean removed = this.partDataStores.remove(p, store);
            assert (removed);
            this.destroyCacheDataStore0(store);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
        finally {
            this.partStoreLock.unlock(p);
        }
    }

    protected void destroyCacheDataStore0(IgniteCacheOffheapManager.CacheDataStore store) throws IgniteCheckedException {
        store.destroy();
    }

    protected final String treeName(int p) {
        return BPlusTree.treeName("p-" + p, "CacheData");
    }

    @Override
    public boolean expire(GridCacheContext cctx, IgniteInClosure2X<GridCacheEntryEx, GridCacheVersion> c, int amount) throws IgniteCheckedException {
        assert (!cctx.isNear()) : cctx.name();
        if (!this.hasPendingEntries || this.nextCleanTime > U.currentTimeMillis()) {
            return false;
        }
        assert (this.pendingEntries != null);
        int cleared = this.expireInternal(cctx, c, amount);
        if (cleared < amount) {
            this.nextCleanTime = U.currentTimeMillis() + UNWIND_THROTTLING_TIMEOUT;
        }
        return amount != -1 && cleared >= amount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int expireInternal(GridCacheContext cctx, IgniteInClosure2X<GridCacheEntryEx, GridCacheVersion> c, int amount) throws IgniteCheckedException {
        long now = U.currentTimeMillis();
        GridCacheVersion obsoleteVer = null;
        GridCursor cur = this.grp.sharedGroup() ? this.pendingEntries.find(new PendingRow(cctx.cacheId()), new PendingRow(cctx.cacheId(), now, 0L)) : this.pendingEntries.find(null, new PendingRow(0, now, 0L));
        if (!cur.next()) {
            return 0;
        }
        if (!this.busyLock.enterBusy()) {
            return 0;
        }
        try {
            int cleared = 0;
            do {
                if (amount != -1 && cleared > amount) {
                    int n = cleared;
                    return n;
                }
                PendingRow row = (PendingRow)cur.get();
                if (row.key.partition() == -1) {
                    row.key.partition(cctx.affinity().partition(row.key));
                }
                assert (row.key != null && row.link != 0L && row.expireTime != 0L) : row;
                if (this.pendingEntries.removex(row)) {
                    GridCacheEntryEx entry;
                    if (obsoleteVer == null) {
                        obsoleteVer = this.ctx.versions().next();
                    }
                    if ((entry = cctx.cache().entryEx(row.key)) != null) {
                        c.apply(entry, obsoleteVer);
                    }
                }
                ++cleared;
            } while (cur.next());
            int n = cleared;
            return n;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public long expiredSize() throws IgniteCheckedException {
        return this.pendingEntries != null ? this.pendingEntries.size() : 0L;
    }

    private final class MvccApplyChangesHandler
    extends PageHandler<MvccDataRow, Boolean> {
        private MvccApplyChangesHandler() {
        }

        @Override
        public Boolean run(int cacheId, long pageId, long page, long pageAddr, PageIO io, Boolean walPlc, MvccDataRow newRow, int itemId) throws IgniteCheckedException {
            assert (IgniteCacheOffheapManagerImpl.this.grp.mvccEnabled());
            DataPageIO iox = (DataPageIO)io;
            int offset = iox.getPayloadOffset(pageAddr, itemId, IgniteCacheOffheapManagerImpl.this.grp.dataRegion().pageMemory().realPageSize(IgniteCacheOffheapManagerImpl.this.grp.groupId()), 40);
            long crd = iox.mvccCoordinator(pageAddr, offset);
            long cntr = iox.mvccCounter(pageAddr, offset);
            int opCntrAndHint = iox.mvccOperationCounter(pageAddr, offset);
            int opCntr = opCntrAndHint & 0x1FFFFFFF;
            byte txState = (byte)(opCntrAndHint >>> 30);
            long newCrd = iox.newMvccCoordinator(pageAddr, offset);
            long newCntr = iox.newMvccCounter(pageAddr, offset);
            int newOpCntrAndHint = iox.newMvccOperationCounter(pageAddr, offset);
            int newOpCntr = newOpCntrAndHint & 0x1FFFFFFF;
            byte newTxState = (byte)(newOpCntrAndHint >>> 30);
            assert (crd == newRow.mvccCoordinatorVersion());
            assert (cntr == newRow.mvccCounter());
            assert (opCntr == newRow.mvccOperationCounter());
            if (txState != newRow.mvccTxState() && newRow.mvccTxState() != 0) {
                assert (txState == 0);
                iox.mvccOperationCounter(pageAddr, offset, opCntr | newRow.mvccTxState() << 30);
                if (MvccApplyChangesHandler.isWalDeltaRecordNeeded(IgniteCacheOffheapManagerImpl.this.grp.dataRegion().pageMemory(), cacheId, pageId, page, IgniteCacheOffheapManagerImpl.this.ctx.wal(), walPlc)) {
                    IgniteCacheOffheapManagerImpl.this.ctx.wal().log(new DataPageMvccUpdateTxStateHintRecord(cacheId, pageId, itemId, newRow.mvccTxState()));
                }
            }
            if (MvccUtils.compare(newCrd, newCntr, newOpCntr, newRow.newMvccCoordinatorVersion(), newRow.newMvccCounter(), newRow.newMvccOperationCounter()) != 0) {
                iox.updateNewVersion(pageAddr, offset, newRow.newMvccVersion(), newRow.newMvccTxState());
                if (MvccApplyChangesHandler.isWalDeltaRecordNeeded(IgniteCacheOffheapManagerImpl.this.grp.dataRegion().pageMemory(), cacheId, pageId, page, IgniteCacheOffheapManagerImpl.this.ctx.wal(), walPlc)) {
                    IgniteCacheOffheapManagerImpl.this.ctx.wal().log(new DataPageMvccMarkUpdatedRecord(cacheId, pageId, itemId, newRow.newMvccCoordinatorVersion(), newRow.newMvccCounter(), newRow.newMvccOperationCounter()));
                }
            } else if (newTxState != newRow.newMvccTxState() && newRow.newMvccTxState() != 0) {
                assert (newTxState == 0);
                iox.newMvccOperationCounter(pageAddr, offset, newOpCntr | newRow.newMvccTxState() << 30);
                if (MvccApplyChangesHandler.isWalDeltaRecordNeeded(IgniteCacheOffheapManagerImpl.this.grp.dataRegion().pageMemory(), cacheId, pageId, page, IgniteCacheOffheapManagerImpl.this.ctx.wal(), walPlc)) {
                    IgniteCacheOffheapManagerImpl.this.ctx.wal().log(new DataPageMvccUpdateNewTxStateHintRecord(cacheId, pageId, itemId, newRow.newMvccTxState()));
                }
            }
            return Boolean.TRUE;
        }
    }

    private final class MvccUpdateTxStateHintHandler
    extends PageHandler<Void, Boolean> {
        private MvccUpdateTxStateHintHandler() {
        }

        @Override
        public Boolean run(int cacheId, long pageId, long page, long pageAddr, PageIO io, Boolean walPlc, Void ignore, int itemId) throws IgniteCheckedException {
            byte state;
            DataPageIO iox = (DataPageIO)io;
            int offset = iox.getPayloadOffset(pageAddr, itemId, IgniteCacheOffheapManagerImpl.this.grp.dataRegion().pageMemory().realPageSize(IgniteCacheOffheapManagerImpl.this.grp.groupId()), 40);
            long crd = iox.mvccCoordinator(pageAddr, offset);
            long cntr = iox.mvccCounter(pageAddr, offset);
            int opCntr = iox.mvccOperationCounter(pageAddr, offset);
            byte txState = (byte)(opCntr >>> 30);
            if (txState == 0) {
                byte state2 = MvccUtils.state(IgniteCacheOffheapManagerImpl.this.grp, crd, cntr, opCntr);
                if (state2 == 3 || state2 == 2) {
                    iox.mvccOperationCounter(pageAddr, offset, opCntr | state2 << 30);
                    if (MvccUpdateTxStateHintHandler.isWalDeltaRecordNeeded(IgniteCacheOffheapManagerImpl.this.grp.dataRegion().pageMemory(), cacheId, pageId, page, IgniteCacheOffheapManagerImpl.this.ctx.wal(), walPlc)) {
                        IgniteCacheOffheapManagerImpl.this.ctx.wal().log(new DataPageMvccUpdateTxStateHintRecord(cacheId, pageId, itemId, state2));
                    }
                } else {
                    throw MvccUtils.unexpectedStateException(IgniteCacheOffheapManagerImpl.this.grp, state2, crd, cntr, opCntr);
                }
            }
            long newCrd = iox.newMvccCoordinator(pageAddr, offset);
            long newCntr = iox.newMvccCounter(pageAddr, offset);
            int newOpCntr = iox.newMvccOperationCounter(pageAddr, offset);
            byte newTxState = (byte)(newOpCntr >>> 30);
            if (newCrd != 0L && newTxState == 0 && ((state = MvccUtils.state(IgniteCacheOffheapManagerImpl.this.grp, newCrd, newCntr, newOpCntr)) == 3 || state == 2)) {
                iox.newMvccOperationCounter(pageAddr, offset, newOpCntr | state << 30);
                if (MvccUpdateTxStateHintHandler.isWalDeltaRecordNeeded(IgniteCacheOffheapManagerImpl.this.grp.dataRegion().pageMemory(), cacheId, pageId, page, IgniteCacheOffheapManagerImpl.this.ctx.wal(), walPlc)) {
                    IgniteCacheOffheapManagerImpl.this.ctx.wal().log(new DataPageMvccUpdateNewTxStateHintRecord(cacheId, pageId, itemId, state));
                }
            }
            return Boolean.TRUE;
        }
    }

    private final class MvccMarkUpdatedHandler
    extends PageHandler<MvccVersion, Boolean> {
        private MvccMarkUpdatedHandler() {
        }

        @Override
        public Boolean run(int cacheId, long pageId, long page, long pageAddr, PageIO io, Boolean walPlc, MvccVersion newVer, int itemId) throws IgniteCheckedException {
            assert (IgniteCacheOffheapManagerImpl.this.grp.mvccEnabled());
            DataPageIO iox = (DataPageIO)io;
            int offset = iox.getPayloadOffset(pageAddr, itemId, IgniteCacheOffheapManagerImpl.this.grp.dataRegion().pageMemory().realPageSize(IgniteCacheOffheapManagerImpl.this.grp.groupId()), 40);
            long newCrd = iox.newMvccCoordinator(pageAddr, offset);
            long newCntr = iox.newMvccCounter(pageAddr, offset);
            int newOpCntr = iox.newMvccOperationCounter(pageAddr, offset);
            assert (newCrd == 0L || MvccUtils.state(IgniteCacheOffheapManagerImpl.this.grp, newCrd, newCntr, newOpCntr) == 2);
            iox.updateNewVersion(pageAddr, offset, newVer, (byte)0);
            if (MvccMarkUpdatedHandler.isWalDeltaRecordNeeded(IgniteCacheOffheapManagerImpl.this.grp.dataRegion().pageMemory(), cacheId, pageId, page, IgniteCacheOffheapManagerImpl.this.ctx.wal(), walPlc)) {
                IgniteCacheOffheapManagerImpl.this.ctx.wal().log(new DataPageMvccMarkUpdatedRecord(cacheId, pageId, itemId, newVer.coordinatorVersion(), newVer.counter(), newVer.operationCounter()));
            }
            return Boolean.TRUE;
        }
    }

    protected class CacheDataStoreImpl
    implements IgniteCacheOffheapManager.CacheDataStore {
        private final int partId;
        private String name;
        private final CacheDataRowStore rowStore;
        private final CacheDataTree dataTree;
        protected final PartitionUpdateCounter pCntr;
        private final AtomicLong storageSize;
        private final ConcurrentMap<Integer, AtomicLong> cacheSizes;
        private final PageHandler<MvccVersion, Boolean> mvccUpdateMarker;
        private final PageHandler<Void, Boolean> mvccUpdateTxStateHint;
        private final PageHandler<MvccDataRow, Boolean> mvccApplyChanges;

        public CacheDataStoreImpl(int partId, String name, CacheDataRowStore rowStore, CacheDataTree dataTree) {
            this.pCntr = new PartitionUpdateCounter(IgniteCacheOffheapManagerImpl.this.log);
            this.storageSize = new AtomicLong();
            this.cacheSizes = new ConcurrentHashMap<Integer, AtomicLong>();
            this.mvccUpdateMarker = new MvccMarkUpdatedHandler();
            this.mvccUpdateTxStateHint = new MvccUpdateTxStateHintHandler();
            this.mvccApplyChanges = new MvccApplyChangesHandler();
            this.partId = partId;
            this.name = name;
            this.rowStore = rowStore;
            this.dataTree = dataTree;
        }

        void incrementSize(int cacheId) {
            this.updateSize(cacheId, 1L);
        }

        void decrementSize(int cacheId) {
            this.updateSize(cacheId, -1L);
        }

        @Override
        public int partId() {
            return this.partId;
        }

        @Override
        public long cacheSize(int cacheId) {
            if (IgniteCacheOffheapManagerImpl.this.grp.sharedGroup()) {
                AtomicLong size = (AtomicLong)this.cacheSizes.get(cacheId);
                return size != null ? (long)((int)size.get()) : 0L;
            }
            return this.storageSize.get();
        }

        @Override
        public Map<Integer, Long> cacheSizes() {
            if (!IgniteCacheOffheapManagerImpl.this.grp.sharedGroup()) {
                return null;
            }
            HashMap<Integer, Long> res = new HashMap<Integer, Long>();
            for (Map.Entry e : this.cacheSizes.entrySet()) {
                res.put((Integer)e.getKey(), ((AtomicLong)e.getValue()).longValue());
            }
            return res;
        }

        @Override
        public long fullSize() {
            return this.storageSize.get();
        }

        @Override
        public void updateSize(int cacheId, long delta) {
            this.storageSize.addAndGet(delta);
            if (IgniteCacheOffheapManagerImpl.this.grp.sharedGroup()) {
                AtomicLong size = (AtomicLong)this.cacheSizes.get(cacheId);
                if (size == null) {
                    size = new AtomicLong();
                    AtomicLong old = this.cacheSizes.putIfAbsent(cacheId, size);
                    if (old != null) {
                        size = old;
                    }
                }
                size.addAndGet(delta);
            }
        }

        @Override
        public long nextUpdateCounter() {
            return this.pCntr.next();
        }

        @Override
        public long initialUpdateCounter() {
            return this.pCntr.initial();
        }

        @Override
        public void updateInitialCounter(long cntr) {
            this.pCntr.updateInitial(cntr);
        }

        @Override
        public long getAndIncrementUpdateCounter(long delta) {
            return this.pCntr.getAndAdd(delta);
        }

        @Override
        public long updateCounter() {
            return this.pCntr.get();
        }

        @Override
        public void updateCounter(long val) {
            this.pCntr.update(val);
        }

        @Override
        public void updateCounter(long start, long delta) {
            this.pCntr.update(start, delta);
        }

        @Override
        public void finalizeUpdateCountres() {
            this.pCntr.finalizeUpdateCountres();
        }

        @Override
        public String name() {
            return this.name;
        }

        private boolean canUpdateOldRow(GridCacheContext cctx, @Nullable CacheDataRow oldRow, DataRow dataRow) throws IgniteCheckedException {
            if (oldRow == null || cctx.queries().enabled() || IgniteCacheOffheapManagerImpl.this.grp.mvccEnabled()) {
                return false;
            }
            if (oldRow.expireTime() != dataRow.expireTime()) {
                return false;
            }
            boolean sizeWithCacheId = IgniteCacheOffheapManagerImpl.this.grp.sharedGroup();
            int oldLen = oldRow.size();
            if (!IgniteCacheOffheapManagerImpl.this.grp.storeCacheIdInDataPage() && IgniteCacheOffheapManagerImpl.this.grp.sharedGroup() && oldRow.cacheId() != 0) {
                oldLen -= 4;
            }
            if (oldLen > IgniteCacheOffheapManagerImpl.this.updateValSizeThreshold) {
                return false;
            }
            int newLen = dataRow.size();
            return oldLen == newLen;
        }

        @Override
        public void invoke(GridCacheContext cctx, KeyCacheObject key, IgniteCacheOffheapManager.OffheapInvokeClosure c) throws IgniteCheckedException {
            int cacheId = IgniteCacheOffheapManagerImpl.this.grp.sharedGroup() ? cctx.cacheId() : 0;
            this.invoke0(cctx, new SearchRow(cacheId, key), c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void invoke0(GridCacheContext cctx, CacheSearchRow row, IgniteCacheOffheapManager.OffheapInvokeClosure c) throws IgniteCheckedException {
            if (!IgniteCacheOffheapManagerImpl.this.busyLock.enterBusy()) {
                throw new NodeStoppingException("Operation has been cancelled (node is stopping).");
            }
            try {
                assert (cctx.shared().database().checkpointLockIsHeldByThread());
                this.dataTree.invoke(row, (Object)CacheDataRowAdapter.RowData.NO_KEY, c);
                switch (c.operationType()) {
                    case PUT: {
                        assert (c.newRow() != null) : c;
                        CacheDataRow oldRow = c.oldRow();
                        this.finishUpdate(cctx, (CacheDataRow)c.newRow(), oldRow);
                        return;
                    }
                    case REMOVE: {
                        CacheDataRow oldRow = c.oldRow();
                        this.finishRemove(cctx, row.key(), oldRow);
                        return;
                    }
                    case NOOP: {
                        return;
                    }
                    default: {
                        assert (false) : c.operationType();
                        return;
                    }
                }
            }
            finally {
                IgniteCacheOffheapManagerImpl.this.busyLock.leaveBusy();
            }
        }

        @Override
        public CacheDataRow createRow(GridCacheContext cctx, KeyCacheObject key, CacheObject val, GridCacheVersion ver, long expireTime, @Nullable CacheDataRow oldRow) throws IgniteCheckedException {
            int cacheId = IgniteCacheOffheapManagerImpl.this.grp.storeCacheIdInDataPage() ? cctx.cacheId() : 0;
            DataRow dataRow = this.makeDataRow(key, val, ver, expireTime, cacheId);
            if (this.canUpdateOldRow(cctx, oldRow, dataRow) && this.rowStore.updateRow(oldRow.link(), dataRow)) {
                dataRow.link(oldRow.link());
            } else {
                CacheObjectContext coCtx = cctx.cacheObjectContext();
                key.valueBytes(coCtx);
                val.valueBytes(coCtx);
                this.rowStore.addRow(dataRow);
            }
            assert (dataRow.link() != 0L) : dataRow;
            if (IgniteCacheOffheapManagerImpl.this.grp.sharedGroup() && dataRow.cacheId() == 0) {
                dataRow.cacheId(cctx.cacheId());
            }
            return dataRow;
        }

        @NotNull
        private DataRow makeDataRow(KeyCacheObject key, CacheObject val, GridCacheVersion ver, long expireTime, int cacheId) {
            if (key.partition() == -1) {
                key.partition(this.partId);
            }
            return new DataRow(key, val, ver, this.partId, expireTime, cacheId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean mvccInitialValue(GridCacheContext cctx, KeyCacheObject key, @Nullable CacheObject val, GridCacheVersion ver, long expireTime, MvccVersion mvccVer, MvccVersion newMvccVer) throws IgniteCheckedException {
            assert (mvccVer != null || newMvccVer == null) : newMvccVer;
            if (!IgniteCacheOffheapManagerImpl.this.busyLock.enterBusy()) {
                throw new NodeStoppingException("Operation has been cancelled (node is stopping).");
            }
            try {
                CacheObjectContext coCtx = cctx.cacheObjectContext();
                key.valueBytes(coCtx);
                if (mvccVer == null) {
                    mvccVer = MvccUtils.INITIAL_VERSION;
                    this.mvccRemoveAll(cctx, key);
                }
                if (val != null) {
                    val.valueBytes(coCtx);
                    MvccDataRow updateRow = new MvccDataRow(key, val, ver, this.partId, expireTime, cctx.cacheId(), mvccVer, newMvccVer);
                    assert (cctx.shared().database().checkpointLockIsHeldByThread());
                    if (!IgniteCacheOffheapManagerImpl.this.grp.storeCacheIdInDataPage() && updateRow.cacheId() != 0) {
                        updateRow.cacheId(0);
                        this.rowStore.addRow(updateRow);
                        updateRow.cacheId(cctx.cacheId());
                    } else {
                        this.rowStore.addRow(updateRow);
                    }
                    this.dataTree.putx(updateRow);
                    this.incrementSize(cctx.cacheId());
                    if (cctx.queries().enabled()) {
                        cctx.queries().store(updateRow, null, true);
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                IgniteCacheOffheapManagerImpl.this.busyLock.leaveBusy();
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean mvccInitialValueIfAbsent(GridCacheContext cctx, KeyCacheObject key, @Nullable CacheObject val, GridCacheVersion ver, long expireTime, MvccVersion mvccVer, MvccVersion newMvccVer, byte txState, byte newTxState) throws IgniteCheckedException {
            assert (mvccVer != null);
            if (!IgniteCacheOffheapManagerImpl.this.busyLock.enterBusy()) {
                throw new NodeStoppingException("Operation has been cancelled (node is stopping).");
            }
            try {
                CacheObjectContext coCtx = cctx.cacheObjectContext();
                key.valueBytes(coCtx);
                if (val != null) {
                    val.valueBytes(coCtx);
                }
                assert (cctx.shared().database().checkpointLockIsHeldByThread());
                MvccPutIfAbsentClosure clo = new MvccPutIfAbsentClosure(key, val, ver, this.partId, expireTime, cctx.cacheId(), mvccVer, newMvccVer, txState, newTxState);
                this.dataTree.invoke(clo, (Object)CacheDataRowAdapter.RowData.LINK_ONLY, clo);
                if (clo.operationType() == IgniteTree.OperationType.PUT) {
                    this.finishUpdate(cctx, clo, null);
                }
                boolean bl = clo.operationType() == IgniteTree.OperationType.PUT;
                return bl;
            }
            finally {
                IgniteCacheOffheapManagerImpl.this.busyLock.leaveBusy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean mvccUpdateRowWithPreloadInfo(GridCacheContext cctx, KeyCacheObject key, @Nullable CacheObject val, GridCacheVersion ver, long expireTime, MvccVersion mvccVer, MvccVersion newMvccVer, byte mvccTxState, byte newMvccTxState) throws IgniteCheckedException {
            if (!IgniteCacheOffheapManagerImpl.this.busyLock.enterBusy()) {
                throw new NodeStoppingException("Operation has been cancelled (node is stopping).");
            }
            try {
                CacheObjectContext coCtx = cctx.cacheObjectContext();
                key.valueBytes(coCtx);
                if (val != null) {
                    val.valueBytes(coCtx);
                }
                assert (cctx.shared().database().checkpointLockIsHeldByThread());
                MvccUpdateRowWithPreloadInfoClosure clo = new MvccUpdateRowWithPreloadInfoClosure(cctx, key, val, ver, expireTime, mvccVer, newMvccVer, mvccTxState, newMvccTxState);
                this.invoke0(cctx, clo, clo);
            }
            finally {
                IgniteCacheOffheapManagerImpl.this.busyLock.leaveBusy();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MvccUpdateResult mvccUpdate(GridCacheContext cctx, KeyCacheObject key, CacheObject val, GridCacheVersion ver, long expireTime, MvccSnapshot mvccSnapshot, @Nullable CacheEntryPredicate filter, EntryProcessor entryProc, Object[] invokeArgs, boolean primary, boolean needHistory, boolean noCreate, boolean needOldVal, boolean retVal) throws IgniteCheckedException {
            assert (mvccSnapshot != null);
            assert (primary || !needHistory);
            if (!IgniteCacheOffheapManagerImpl.this.busyLock.enterBusy()) {
                throw new NodeStoppingException("Operation has been cancelled (node is stopping).");
            }
            try {
                int cacheId = IgniteCacheOffheapManagerImpl.this.grp.sharedGroup() ? cctx.cacheId() : 0;
                CacheObjectContext coCtx = cctx.cacheObjectContext();
                key.valueBytes(coCtx);
                if (val != null) {
                    val.valueBytes(coCtx);
                }
                MvccUpdateDataRow updateRow = new MvccUpdateDataRow(cctx, key, val, ver, this.partId, expireTime, mvccSnapshot, null, filter, primary, false, needHistory, noCreate, needOldVal, retVal || entryProc != null);
                assert (cctx.shared().database().checkpointLockIsHeldByThread());
                this.dataTree.visit(new MvccMaxSearchRow(cacheId, key), new MvccMinSearchRow(cacheId, key), updateRow);
                ResultType res = updateRow.resultType();
                if (res == ResultType.LOCKED || res == ResultType.VERSION_MISMATCH) {
                    MvccUpdateDataRow mvccUpdateDataRow = updateRow;
                    return mvccUpdateDataRow;
                }
                if (res == ResultType.VERSION_FOUND || res == ResultType.FILTERED || res == ResultType.PREV_NULL && noCreate) {
                    this.cleanup(cctx, updateRow.cleanupRows());
                    MvccUpdateDataRow mvccUpdateDataRow = updateRow;
                    return mvccUpdateDataRow;
                }
                CacheDataRow oldRow = null;
                if (res == ResultType.PREV_NOT_NULL) {
                    oldRow = updateRow.oldRow();
                    assert (oldRow != null && oldRow.link() != 0L) : oldRow;
                    oldRow.key(key);
                } else assert (res == ResultType.PREV_NULL);
                if (entryProc != null) {
                    CacheInvokeEntry.Operation op = this.applyEntryProcessor(cctx, key, ver, entryProc, invokeArgs, updateRow, oldRow);
                    if (op == CacheInvokeEntry.Operation.NONE) {
                        if (res == ResultType.PREV_NOT_NULL) {
                            updateRow.value(oldRow.value());
                        }
                        updateRow.resultType(ResultType.FILTERED);
                        this.cleanup(cctx, updateRow.cleanupRows());
                        MvccUpdateDataRow mvccUpdateDataRow = updateRow;
                        return mvccUpdateDataRow;
                    }
                    if (res == ResultType.PREV_NOT_NULL) {
                        this.rowStore.updateDataRow(oldRow.link(), this.mvccUpdateMarker, mvccSnapshot);
                        if (op == CacheInvokeEntry.Operation.REMOVE) {
                            updateRow.resultType(ResultType.REMOVED_NOT_NULL);
                            this.cleanup(cctx, updateRow.cleanupRows());
                            this.clearPendingEntries(cctx, oldRow);
                            MvccUpdateDataRow mvccUpdateDataRow = updateRow;
                            return mvccUpdateDataRow;
                        }
                    } else assert (op != CacheInvokeEntry.Operation.REMOVE);
                } else if (oldRow != null) {
                    this.rowStore.updateDataRow(oldRow.link(), this.mvccUpdateMarker, mvccSnapshot);
                }
                if (!IgniteCacheOffheapManagerImpl.this.grp.storeCacheIdInDataPage() && updateRow.cacheId() != 0) {
                    updateRow.cacheId(0);
                    this.rowStore.addRow(updateRow);
                    updateRow.cacheId(cctx.cacheId());
                } else {
                    this.rowStore.addRow(updateRow);
                }
                if (needHistory) {
                    assert (updateRow.link() != 0L);
                    updateRow.history().add(new MvccLinkAwareSearchRow(cacheId, key, updateRow.mvccCoordinatorVersion(), updateRow.mvccCounter(), updateRow.mvccOperationCounter(), updateRow.link()));
                }
                boolean old = this.dataTree.putx(updateRow);
                assert (!old);
                GridCacheQueryManager qryMgr = cctx.queries();
                if (qryMgr.enabled()) {
                    qryMgr.store(updateRow, null, true);
                }
                this.updatePendingEntries(cctx, updateRow, oldRow);
                this.cleanup(cctx, updateRow.cleanupRows());
                MvccUpdateDataRow mvccUpdateDataRow = updateRow;
                return mvccUpdateDataRow;
            }
            finally {
                IgniteCacheOffheapManagerImpl.this.busyLock.leaveBusy();
            }
        }

        private CacheInvokeEntry.Operation applyEntryProcessor(GridCacheContext cctx, KeyCacheObject key, GridCacheVersion ver, EntryProcessor entryProc, Object[] invokeArgs, MvccUpdateDataRow updateRow, CacheDataRow oldRow) {
            Object procRes = null;
            Exception err = null;
            CacheObject oldVal = oldRow == null ? null : oldRow.value();
            CacheInvokeEntry invokeEntry = new CacheInvokeEntry(key, oldVal, ver, cctx.keepBinary(), new GridDhtDetachedCacheEntry(cctx, key));
            try {
                procRes = entryProc.process(invokeEntry, invokeArgs);
                if (invokeEntry.modified() && invokeEntry.op() != CacheInvokeEntry.Operation.REMOVE) {
                    Object val = invokeEntry.getValue(true);
                    CacheObject val0 = cctx.toCacheObject(val);
                    val0.prepareForCache(cctx.cacheObjectContext());
                    updateRow.value(val0);
                }
            }
            catch (Exception e) {
                IgniteCacheOffheapManagerImpl.this.log.error("Exception was thrown during entry processing.", e);
                err = e;
            }
            CacheInvokeResult<Object> invokeRes = err == null ? CacheInvokeResult.fromResult(procRes) : CacheInvokeResult.fromError(err);
            updateRow.invokeResult(invokeRes);
            return invokeEntry.op();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MvccUpdateResult mvccRemove(GridCacheContext cctx, KeyCacheObject key, MvccSnapshot mvccSnapshot, @Nullable CacheEntryPredicate filter, boolean primary, boolean needHistory, boolean needOldVal, boolean retVal) throws IgniteCheckedException {
            assert (mvccSnapshot != null);
            assert (primary || mvccSnapshot.activeTransactions().size() == 0) : mvccSnapshot;
            assert (primary || !needHistory);
            if (!IgniteCacheOffheapManagerImpl.this.busyLock.enterBusy()) {
                throw new NodeStoppingException("Operation has been cancelled (node is stopping).");
            }
            try {
                int cacheId = IgniteCacheOffheapManagerImpl.this.grp.sharedGroup() ? cctx.cacheId() : 0;
                CacheObjectContext coCtx = cctx.cacheObjectContext();
                key.valueBytes(coCtx);
                MvccUpdateDataRow updateRow = new MvccUpdateDataRow(cctx, key, null, null, this.partId, 0L, mvccSnapshot, null, filter, primary, false, needHistory, true, needOldVal, retVal);
                assert (cctx.shared().database().checkpointLockIsHeldByThread());
                this.dataTree.visit(new MvccMaxSearchRow(cacheId, key), new MvccMinSearchRow(cacheId, key), updateRow);
                ResultType res = updateRow.resultType();
                if (res == ResultType.LOCKED || res == ResultType.VERSION_MISMATCH) {
                    MvccUpdateDataRow mvccUpdateDataRow = updateRow;
                    return mvccUpdateDataRow;
                }
                if (res == ResultType.VERSION_FOUND || res == ResultType.FILTERED) {
                    this.cleanup(cctx, updateRow.cleanupRows());
                    MvccUpdateDataRow mvccUpdateDataRow = updateRow;
                    return mvccUpdateDataRow;
                }
                if (res == ResultType.PREV_NOT_NULL) {
                    CacheDataRow oldRow = updateRow.oldRow();
                    assert (oldRow != null && oldRow.link() != 0L) : oldRow;
                    this.rowStore.updateDataRow(oldRow.link(), this.mvccUpdateMarker, mvccSnapshot);
                    this.clearPendingEntries(cctx, oldRow);
                }
                this.cleanup(cctx, updateRow.cleanupRows());
                MvccUpdateDataRow mvccUpdateDataRow = updateRow;
                return mvccUpdateDataRow;
            }
            finally {
                IgniteCacheOffheapManagerImpl.this.busyLock.leaveBusy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MvccUpdateResult mvccLock(GridCacheContext cctx, KeyCacheObject key, MvccSnapshot mvccSnapshot) throws IgniteCheckedException {
            assert (mvccSnapshot != null);
            if (!IgniteCacheOffheapManagerImpl.this.busyLock.enterBusy()) {
                throw new NodeStoppingException("Operation has been cancelled (node is stopping).");
            }
            try {
                int cacheId = IgniteCacheOffheapManagerImpl.this.grp.sharedGroup() ? cctx.cacheId() : 0;
                CacheObjectContext coCtx = cctx.cacheObjectContext();
                key.valueBytes(coCtx);
                MvccUpdateDataRow updateRow = new MvccUpdateDataRow(cctx, key, null, null, this.partId, 0L, mvccSnapshot, null, null, true, true, false, false, false, false);
                assert (cctx.shared().database().checkpointLockIsHeldByThread());
                this.dataTree.visit(new MvccMaxSearchRow(cacheId, key), new MvccMinSearchRow(cacheId, key), updateRow);
                ResultType res = updateRow.resultType();
                if (res == ResultType.LOCKED || res == ResultType.VERSION_MISMATCH) {
                    MvccUpdateDataRow mvccUpdateDataRow = updateRow;
                    return mvccUpdateDataRow;
                }
                this.cleanup(cctx, updateRow.cleanupRows());
                MvccUpdateDataRow mvccUpdateDataRow = updateRow;
                return mvccUpdateDataRow;
            }
            finally {
                IgniteCacheOffheapManagerImpl.this.busyLock.leaveBusy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GridLongList mvccUpdateNative(GridCacheContext cctx, boolean primary, KeyCacheObject key, CacheObject val, GridCacheVersion ver, long expireTime, MvccSnapshot mvccSnapshot) throws IgniteCheckedException {
            assert (mvccSnapshot != null);
            assert (primary || mvccSnapshot.activeTransactions().size() == 0) : mvccSnapshot;
            if (!IgniteCacheOffheapManagerImpl.this.busyLock.enterBusy()) {
                throw new NodeStoppingException("Operation has been cancelled (node is stopping).");
            }
            try {
                int cacheId = IgniteCacheOffheapManagerImpl.this.grp.sharedGroup() ? cctx.cacheId() : 0;
                CacheObjectContext coCtx = cctx.cacheObjectContext();
                key.valueBytes(coCtx);
                val.valueBytes(coCtx);
                MvccUpdateDataRowNative updateRow = new MvccUpdateDataRowNative(key, val, ver, expireTime, mvccSnapshot, null, this.partId, cctx);
                assert (cctx.shared().database().checkpointLockIsHeldByThread());
                this.dataTree.iterate(new MvccMaxSearchRow(cacheId, key), new MvccMinSearchRow(cacheId, key), updateRow);
                ResultType res = updateRow.resultType();
                if (res == ResultType.VERSION_FOUND) {
                    this.cleanup(cctx, updateRow.cleanupRows());
                    GridLongList gridLongList = null;
                    return gridLongList;
                }
                CacheDataRow oldRow = null;
                if (res == ResultType.PREV_NOT_NULL) {
                    oldRow = updateRow.oldRow();
                    assert (oldRow != null && oldRow.link() != 0L) : oldRow;
                    oldRow.key(key);
                    this.rowStore.updateDataRow(oldRow.link(), this.mvccUpdateMarker, mvccSnapshot);
                } else assert (res == ResultType.PREV_NULL);
                if (!IgniteCacheOffheapManagerImpl.this.grp.storeCacheIdInDataPage() && updateRow.cacheId() != 0) {
                    updateRow.cacheId(0);
                    this.rowStore.addRow(updateRow);
                    updateRow.cacheId(cctx.cacheId());
                } else {
                    this.rowStore.addRow(updateRow);
                }
                boolean old = this.dataTree.putx(updateRow);
                assert (!old);
                this.incrementSize(cctx.cacheId());
                GridCacheQueryManager qryMgr = cctx.queries();
                if (qryMgr.enabled()) {
                    qryMgr.store(updateRow, null, true);
                }
                this.updatePendingEntries(cctx, updateRow, oldRow);
                this.cleanup(cctx, updateRow.cleanupRows());
                GridLongList gridLongList = updateRow.activeTransactions();
                return gridLongList;
            }
            finally {
                IgniteCacheOffheapManagerImpl.this.busyLock.leaveBusy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GridLongList mvccRemoveNative(GridCacheContext cctx, boolean primary, KeyCacheObject key, MvccSnapshot mvccSnapshot) throws IgniteCheckedException {
            assert (mvccSnapshot != null);
            assert (primary || mvccSnapshot.activeTransactions().size() == 0) : mvccSnapshot;
            if (!IgniteCacheOffheapManagerImpl.this.busyLock.enterBusy()) {
                throw new NodeStoppingException("Operation has been cancelled (node is stopping).");
            }
            try {
                int cacheId = IgniteCacheOffheapManagerImpl.this.grp.sharedGroup() ? cctx.cacheId() : 0;
                CacheObjectContext coCtx = cctx.cacheObjectContext();
                key.valueBytes(coCtx);
                MvccUpdateDataRowNative updateRow = new MvccUpdateDataRowNative(key, null, null, 0L, mvccSnapshot, null, this.partId, cctx);
                assert (cctx.shared().database().checkpointLockIsHeldByThread());
                this.dataTree.iterate(new MvccMaxSearchRow(cacheId, key), new MvccMinSearchRow(cacheId, key), updateRow);
                ResultType res = updateRow.resultType();
                if (res == ResultType.VERSION_FOUND) {
                    assert (!primary) : updateRow;
                    this.cleanup(cctx, updateRow.cleanupRows());
                    GridLongList gridLongList = null;
                    return gridLongList;
                }
                if (res == ResultType.PREV_NOT_NULL) {
                    CacheDataRow oldRow = updateRow.oldRow();
                    assert (oldRow != null && oldRow.link() != 0L) : oldRow;
                    this.rowStore.updateDataRow(oldRow.link(), this.mvccUpdateMarker, mvccSnapshot);
                    this.clearPendingEntries(cctx, oldRow);
                }
                this.cleanup(cctx, updateRow.cleanupRows());
                GridLongList gridLongList = updateRow.activeTransactions();
                return gridLongList;
            }
            finally {
                IgniteCacheOffheapManagerImpl.this.busyLock.leaveBusy();
            }
        }

        @Override
        public void mvccRemoveAll(GridCacheContext cctx, KeyCacheObject key) throws IgniteCheckedException {
            boolean cleanup;
            key.valueBytes(cctx.cacheObjectContext());
            int cacheId = IgniteCacheOffheapManagerImpl.this.grp.sharedGroup() ? cctx.cacheId() : 0;
            boolean bl = cleanup = cctx.queries().enabled() || IgniteCacheOffheapManagerImpl.this.hasPendingEntries;
            assert (cctx.shared().database().checkpointLockIsHeldByThread());
            GridCursor cur = this.dataTree.find(new MvccMaxSearchRow(cacheId, key), new MvccMinSearchRow(cacheId, key), (Object)(cleanup ? CacheDataRowAdapter.RowData.NO_KEY : CacheDataRowAdapter.RowData.LINK_ONLY));
            boolean first = true;
            while (cur.next()) {
                CacheDataRow row = (CacheDataRow)cur.get();
                row.key(key);
                assert (row.link() != 0L) : row;
                boolean rmvd = this.dataTree.removex(row);
                assert (rmvd) : row;
                if (cleanup) {
                    if (cctx.queries().enabled()) {
                        cctx.queries().remove(key, row);
                    }
                    if (first) {
                        this.clearPendingEntries(cctx, row);
                    }
                }
                this.rowStore.removeRow(row.link());
                if (!first) continue;
                first = false;
            }
            if (!first) {
                this.decrementSize(cctx.cacheId());
            }
        }

        @Override
        public int cleanup(GridCacheContext cctx, @Nullable List<MvccLinkAwareSearchRow> cleanupRows) throws IgniteCheckedException {
            int res = 0;
            if (cleanupRows != null) {
                GridCacheQueryManager qryMgr = cctx.queries();
                for (int i = 0; i < cleanupRows.size(); ++i) {
                    MvccLinkAwareSearchRow cleanupRow = cleanupRows.get(i);
                    assert (cleanupRow.link() != 0L) : cleanupRow;
                    assert (cctx.shared().database().checkpointLockIsHeldByThread());
                    CacheDataRow oldRow = (CacheDataRow)this.dataTree.remove(cleanupRow);
                    if (oldRow == null) continue;
                    assert (oldRow.mvccCounter() == cleanupRow.mvccCounter());
                    if (qryMgr.enabled()) {
                        qryMgr.remove(oldRow.key(), oldRow);
                    }
                    this.clearPendingEntries(cctx, oldRow);
                    this.rowStore.removeRow(cleanupRow.link());
                    ++res;
                }
            }
            return res;
        }

        @Override
        public void updateTxState(GridCacheContext cctx, CacheSearchRow row) throws IgniteCheckedException {
            assert (IgniteCacheOffheapManagerImpl.this.grp.mvccEnabled());
            assert (MvccUtils.mvccVersionIsValid(row.mvccCoordinatorVersion(), row.mvccCounter(), row.mvccOperationCounter())) : row;
            CacheDataRow row0 = (CacheDataRow)this.dataTree.findOne(row, (Object)CacheDataRowAdapter.RowData.LINK_ONLY);
            if (row0 != null) {
                this.rowStore.updateDataRow(row0.link(), this.mvccUpdateTxStateHint, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(GridCacheContext cctx, KeyCacheObject key, CacheObject val, GridCacheVersion ver, long expireTime, @Nullable CacheDataRow oldRow) throws IgniteCheckedException {
            assert (oldRow == null || oldRow.link() != 0L) : oldRow;
            if (!IgniteCacheOffheapManagerImpl.this.busyLock.enterBusy()) {
                throw new NodeStoppingException("Operation has been cancelled (node is stopping).");
            }
            try {
                CacheDataRow old;
                int cacheId;
                int n = cacheId = IgniteCacheOffheapManagerImpl.this.grp.storeCacheIdInDataPage() ? cctx.cacheId() : 0;
                assert (oldRow == null || oldRow.cacheId() == cacheId) : oldRow;
                DataRow dataRow = this.makeDataRow(key, val, ver, expireTime, cacheId);
                CacheObjectContext coCtx = cctx.cacheObjectContext();
                key.valueBytes(coCtx);
                val.valueBytes(coCtx);
                assert (cctx.shared().database().checkpointLockIsHeldByThread());
                if (this.canUpdateOldRow(cctx, oldRow, dataRow) && this.rowStore.updateRow(oldRow.link(), dataRow)) {
                    old = oldRow;
                    dataRow.link(oldRow.link());
                } else {
                    this.rowStore.addRow(dataRow);
                    assert (dataRow.link() != 0L) : dataRow;
                    if (IgniteCacheOffheapManagerImpl.this.grp.sharedGroup() && dataRow.cacheId() == 0) {
                        dataRow.cacheId(cctx.cacheId());
                    }
                    if (oldRow != null) {
                        old = oldRow;
                        this.dataTree.putx(dataRow);
                    } else {
                        old = this.dataTree.put(dataRow);
                    }
                }
                this.finishUpdate(cctx, dataRow, old);
            }
            finally {
                IgniteCacheOffheapManagerImpl.this.busyLock.leaveBusy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mvccApplyUpdate(GridCacheContext cctx, KeyCacheObject key, CacheObject val, GridCacheVersion ver, long expireTime, MvccVersion mvccVer) throws IgniteCheckedException {
            if (!IgniteCacheOffheapManagerImpl.this.busyLock.enterBusy()) {
                throw new NodeStoppingException("Operation has been cancelled (node is stopping).");
            }
            try {
                int cacheId = IgniteCacheOffheapManagerImpl.this.grp.sharedGroup() ? cctx.cacheId() : 0;
                CacheObjectContext coCtx = cctx.cacheObjectContext();
                key.valueBytes(coCtx);
                if (val != null) {
                    val.valueBytes(coCtx);
                }
                MvccSnapshotWithoutTxs mvccSnapshot = new MvccSnapshotWithoutTxs(mvccVer.coordinatorVersion(), mvccVer.counter(), mvccVer.operationCounter(), 0L);
                MvccUpdateDataRow updateRow = new MvccUpdateDataRow(cctx, key, val, ver, this.partId, 0L, mvccSnapshot, null, null, false, false, false, false, false, false);
                assert (cctx.shared().database().checkpointLockIsHeldByThread());
                this.dataTree.visit(new MvccMaxSearchRow(cacheId, key), new MvccMinSearchRow(cacheId, key), updateRow);
                ResultType res = updateRow.resultType();
                assert (res == ResultType.PREV_NULL || res == ResultType.PREV_NOT_NULL) : res;
                if (res == ResultType.PREV_NOT_NULL) {
                    CacheDataRow oldRow = updateRow.oldRow();
                    assert (oldRow != null && oldRow.link() != 0L) : oldRow;
                    this.rowStore.updateDataRow(oldRow.link(), this.mvccUpdateMarker, mvccSnapshot);
                }
                if (val != null) {
                    if (!IgniteCacheOffheapManagerImpl.this.grp.storeCacheIdInDataPage() && updateRow.cacheId() != 0) {
                        updateRow.cacheId(0);
                        this.rowStore.addRow(updateRow);
                        updateRow.cacheId(cctx.cacheId());
                    } else {
                        this.rowStore.addRow(updateRow);
                    }
                    boolean old = this.dataTree.putx(updateRow);
                    assert (!old);
                    GridCacheQueryManager qryMgr = cctx.queries();
                    if (qryMgr.enabled()) {
                        qryMgr.store(updateRow, null, true);
                    }
                    this.cleanup(cctx, updateRow.cleanupRows());
                }
            }
            finally {
                IgniteCacheOffheapManagerImpl.this.busyLock.leaveBusy();
            }
        }

        private void finishUpdate(GridCacheContext cctx, CacheDataRow newRow, @Nullable CacheDataRow oldRow) throws IgniteCheckedException {
            if (oldRow == null) {
                this.incrementSize(cctx.cacheId());
            }
            KeyCacheObject key = newRow.key();
            GridCacheQueryManager qryMgr = cctx.queries();
            if (qryMgr.enabled()) {
                qryMgr.store(newRow, oldRow, true);
            }
            this.updatePendingEntries(cctx, newRow, oldRow);
            if (oldRow != null) {
                assert (oldRow.link() != 0L) : oldRow;
                if (newRow.link() != oldRow.link()) {
                    this.rowStore.removeRow(oldRow.link());
                }
            }
            this.updateIgfsMetrics(cctx, key, oldRow != null ? oldRow.value() : null, newRow.value());
        }

        private void updatePendingEntries(GridCacheContext cctx, CacheDataRow newRow, @Nullable CacheDataRow oldRow) throws IgniteCheckedException {
            int cacheId;
            long expireTime = newRow.expireTime();
            int n = cacheId = IgniteCacheOffheapManagerImpl.this.grp.sharedGroup() ? cctx.cacheId() : 0;
            if (oldRow != null) {
                assert (oldRow.link() != 0L) : oldRow;
                if (this.pendingTree() != null && oldRow.expireTime() != 0L) {
                    this.pendingTree().removex(new PendingRow(cacheId, oldRow.expireTime(), oldRow.link()));
                }
            }
            if (this.pendingTree() != null && expireTime != 0L) {
                this.pendingTree().putx(new PendingRow(cacheId, expireTime, newRow.link()));
                IgniteCacheOffheapManagerImpl.this.hasPendingEntries = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(GridCacheContext cctx, KeyCacheObject key, int partId) throws IgniteCheckedException {
            if (!IgniteCacheOffheapManagerImpl.this.busyLock.enterBusy()) {
                throw new NodeStoppingException("Operation has been cancelled (node is stopping).");
            }
            try {
                int cacheId;
                int n = cacheId = IgniteCacheOffheapManagerImpl.this.grp.sharedGroup() ? cctx.cacheId() : 0;
                assert (cctx.shared().database().checkpointLockIsHeldByThread());
                CacheDataRow oldRow = (CacheDataRow)this.dataTree.remove(new SearchRow(cacheId, key));
                this.finishRemove(cctx, key, oldRow);
            }
            finally {
                IgniteCacheOffheapManagerImpl.this.busyLock.leaveBusy();
            }
        }

        private void finishRemove(GridCacheContext cctx, KeyCacheObject key, @Nullable CacheDataRow oldRow) throws IgniteCheckedException {
            GridCacheQueryManager qryMgr;
            if (oldRow != null) {
                this.clearPendingEntries(cctx, oldRow);
                this.decrementSize(cctx.cacheId());
            }
            if ((qryMgr = cctx.queries()).enabled()) {
                qryMgr.remove(key, oldRow);
            }
            if (oldRow != null) {
                this.rowStore.removeRow(oldRow.link());
            }
            this.updateIgfsMetrics(cctx, key, oldRow != null ? oldRow.value() : null, null);
        }

        private void clearPendingEntries(GridCacheContext cctx, CacheDataRow oldRow) throws IgniteCheckedException {
            int cacheId;
            int n = cacheId = IgniteCacheOffheapManagerImpl.this.grp.sharedGroup() ? cctx.cacheId() : 0;
            assert (oldRow.link() != 0L) : oldRow;
            assert (cacheId == 0 || oldRow.cacheId() == cacheId) : "Incorrect cache ID [expected=" + cacheId + ", actual=" + oldRow.cacheId() + "].";
            if (this.pendingTree() != null && oldRow.expireTime() != 0L) {
                this.pendingTree().removex(new PendingRow(cacheId, oldRow.expireTime(), oldRow.link()));
            }
        }

        @Override
        public CacheDataRow find(GridCacheContext cctx, KeyCacheObject key) throws IgniteCheckedException {
            CacheDataRow row;
            int cacheId;
            key.valueBytes(cctx.cacheObjectContext());
            int n = cacheId = IgniteCacheOffheapManagerImpl.this.grp.sharedGroup() ? cctx.cacheId() : 0;
            if (IgniteCacheOffheapManagerImpl.this.grp.mvccEnabled()) {
                MvccFirstRowTreeClosure clo = new MvccFirstRowTreeClosure(cctx);
                this.dataTree.iterate(new MvccMaxSearchRow(cacheId, key), new MvccMinSearchRow(cacheId, key), clo);
                row = clo.row();
            } else {
                row = (CacheDataRow)this.dataTree.findOne(new SearchRow(cacheId, key), (Object)CacheDataRowAdapter.RowData.NO_KEY);
            }
            this.afterRowFound(row, key);
            return row;
        }

        @Override
        public List<IgniteBiTuple<Object, MvccVersion>> mvccFindAllVersions(GridCacheContext cctx, KeyCacheObject key) throws IgniteCheckedException {
            assert (IgniteCacheOffheapManagerImpl.this.grp.mvccEnabled());
            key.valueBytes(cctx.cacheObjectContext());
            int cacheId = IgniteCacheOffheapManagerImpl.this.grp.sharedGroup() ? cctx.cacheId() : 0;
            GridCursor cur = this.dataTree.find(new MvccMaxSearchRow(cacheId, key), new MvccMinSearchRow(cacheId, key));
            ArrayList<IgniteBiTuple<Object, MvccVersion>> res = new ArrayList<IgniteBiTuple<Object, MvccVersion>>();
            long crd = 0L;
            long cntr = 0L;
            int opCntr = 0;
            while (cur.next()) {
                CacheDataRow row = (CacheDataRow)cur.get();
                if (MvccUtils.compareNewVersion(row, crd, cntr, opCntr) != 0) {
                    res.add(F.t(null, row.newMvccVersion()));
                }
                res.add(F.t(row.value(), row.mvccVersion()));
                crd = row.mvccCoordinatorVersion();
                cntr = row.mvccCounter();
                opCntr = row.mvccOperationCounter();
            }
            return res;
        }

        @Override
        public GridCursor<CacheDataRow> mvccAllVersionsCursor(GridCacheContext cctx, KeyCacheObject key, Object x) throws IgniteCheckedException {
            int cacheId = cctx.cacheId();
            return this.dataTree.find(new MvccMaxSearchRow(cacheId, key), new MvccMinSearchRow(cacheId, key), x);
        }

        @Override
        public CacheDataRow mvccFind(GridCacheContext cctx, KeyCacheObject key, MvccSnapshot snapshot) throws IgniteCheckedException {
            key.valueBytes(cctx.cacheObjectContext());
            int cacheId = IgniteCacheOffheapManagerImpl.this.grp.sharedGroup() ? cctx.cacheId() : 0;
            MvccSnapshotSearchRow clo = new MvccSnapshotSearchRow(cctx, key, snapshot);
            this.dataTree.iterate(clo, new MvccMinSearchRow(cacheId, key), clo);
            CacheDataRow row = clo.row();
            this.afterRowFound(row, key);
            return row;
        }

        private void afterRowFound(@Nullable CacheDataRow row, KeyCacheObject key) throws IgniteCheckedException {
            if (row != null) {
                row.key(key);
                IgniteCacheOffheapManagerImpl.this.grp.dataRegion().evictionTracker().touchPage(row.link());
            }
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor() throws IgniteCheckedException {
            return this.dataTree.find(null, null);
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor(Object x) throws IgniteCheckedException {
            return this.dataTree.find(null, null, x);
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor(MvccSnapshot mvccSnapshot) throws IgniteCheckedException {
            if (mvccSnapshot != null) {
                assert (IgniteCacheOffheapManagerImpl.this.grp.mvccEnabled());
                return this.dataTree.find(null, null, new MvccFirstVisibleRowTreeClosure(IgniteCacheOffheapManagerImpl.this.grp.singleCacheContext(), mvccSnapshot), null);
            }
            return this.dataTree.find(null, null);
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor(int cacheId) throws IgniteCheckedException {
            return this.cursor(cacheId, null, null);
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor(int cacheId, MvccSnapshot mvccSnapshot) throws IgniteCheckedException {
            return this.cursor(cacheId, null, null, null, mvccSnapshot);
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor(int cacheId, KeyCacheObject lower, KeyCacheObject upper) throws IgniteCheckedException {
            return this.cursor(cacheId, lower, upper, null);
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor(int cacheId, KeyCacheObject lower, KeyCacheObject upper, Object x) throws IgniteCheckedException {
            return this.cursor(cacheId, lower, upper, null, null);
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor(int cacheId, KeyCacheObject lower, KeyCacheObject upper, Object x, MvccSnapshot snapshot) throws IgniteCheckedException {
            SearchRow upperRow;
            SearchRow lowerRow;
            if (IgniteCacheOffheapManagerImpl.this.grp.sharedGroup()) {
                assert (cacheId != 0);
                lowerRow = lower != null ? new SearchRow(cacheId, lower) : new SearchRow(cacheId);
                upperRow = upper != null ? new SearchRow(cacheId, upper) : new SearchRow(cacheId);
            } else {
                lowerRow = lower != null ? new SearchRow(0, lower) : null;
                SearchRow searchRow = upperRow = upper != null ? new SearchRow(0, upper) : null;
            }
            if (snapshot != null) {
                assert (IgniteCacheOffheapManagerImpl.this.grp.mvccEnabled());
                GridCacheContext cctx = IgniteCacheOffheapManagerImpl.this.grp.sharedGroup() ? IgniteCacheOffheapManagerImpl.this.grp.shared().cacheContext(cacheId) : IgniteCacheOffheapManagerImpl.this.grp.singleCacheContext();
                return this.dataTree.find(lowerRow, upperRow, new MvccFirstVisibleRowTreeClosure(cctx, snapshot), x);
            }
            return this.dataTree.find(lowerRow, upperRow, x);
        }

        @Override
        public void destroy() throws IgniteCheckedException {
            final AtomicReference exception = new AtomicReference();
            this.dataTree.destroy(new IgniteInClosure<CacheSearchRow>(){

                @Override
                public void apply(CacheSearchRow row) {
                    try {
                        CacheDataStoreImpl.this.rowStore.removeRow(row.link());
                    }
                    catch (IgniteCheckedException e) {
                        U.error(IgniteCacheOffheapManagerImpl.this.log, "Failed to remove row [link=" + row.link() + "]");
                        IgniteCheckedException ex = (IgniteCheckedException)exception.get();
                        if (ex == null) {
                            exception.set(e);
                        }
                        ex.addSuppressed(e);
                    }
                }
            });
            if (exception.get() != null) {
                throw new IgniteCheckedException("Failed to destroy store", (Throwable)exception.get());
            }
        }

        @Override
        public void clear(int cacheId) throws IgniteCheckedException {
            assert (cacheId != 0);
            if (this.cacheSize(cacheId) == 0L) {
                return;
            }
            IgniteCheckedException ex = null;
            GridCursor<? extends CacheDataRow> cur = this.cursor(cacheId, null, null, (Object)CacheDataRowAdapter.RowData.KEY_ONLY);
            while (cur.next()) {
                CacheDataRow row = cur.get();
                assert (row.link() != 0L) : row;
                try {
                    boolean res = this.dataTree.removex(row);
                    assert (res) : row;
                    this.rowStore.removeRow(row.link());
                    this.decrementSize(cacheId);
                }
                catch (IgniteCheckedException e) {
                    U.error(IgniteCacheOffheapManagerImpl.this.log, "Fail remove row [link=" + row.link() + "]");
                    if (ex == null) {
                        ex = e;
                        continue;
                    }
                    ex.addSuppressed(e);
                }
            }
            if (ex != null) {
                throw new IgniteCheckedException("Fail destroy store", ex);
            }
        }

        @Override
        public RowStore rowStore() {
            return this.rowStore;
        }

        @Override
        public void setRowCacheCleaner(GridQueryRowCacheCleaner rowCacheCleaner) {
            this.rowStore().setRowCacheCleaner(rowCacheCleaner);
        }

        @Override
        public void init(long size, long updCntr, @Nullable Map<Integer, Long> cacheSizes) {
            this.pCntr.init(updCntr);
            this.storageSize.set(size);
            if (cacheSizes != null) {
                for (Map.Entry<Integer, Long> e : cacheSizes.entrySet()) {
                    this.cacheSizes.put(e.getKey(), new AtomicLong(e.getValue()));
                }
            }
        }

        @Override
        public PendingEntriesTree pendingTree() {
            return IgniteCacheOffheapManagerImpl.this.pendingEntries;
        }

        private void updateIgfsMetrics(GridCacheContext cctx, KeyCacheObject key, CacheObject oldVal, CacheObject newVal) {
            GridCacheAdapter cache = cctx.cache();
            if (cache == null) {
                return;
            }
            if (cache.isIgfsDataCache() && !cctx.isNear() && IgniteCacheOffheapManagerImpl.this.ctx.kernalContext().igfsHelper().isIgfsBlockKey(key.value(cctx.cacheObjectContext(), false))) {
                int oldSize = this.valueLength(cctx, oldVal);
                int newSize = this.valueLength(cctx, newVal);
                int delta = newSize - oldSize;
                if (delta != 0) {
                    cache.onIgfsDataSizeChanged(delta);
                }
            }
        }

        private int valueLength(GridCacheContext cctx, @Nullable CacheObject val) {
            if (val == null) {
                return 0;
            }
            byte[] bytes = (byte[])val.value(cctx.cacheObjectContext(), false);
            if (bytes != null) {
                return bytes.length;
            }
            return 0;
        }

        private class MvccUpdateRowWithPreloadInfoClosure
        extends MvccDataRow
        implements IgniteCacheOffheapManager.OffheapInvokeClosure {
            private CacheDataRow oldRow;
            private IgniteTree.OperationType op;

            MvccUpdateRowWithPreloadInfoClosure(GridCacheContext cctx, @Nullable KeyCacheObject key, CacheObject val, GridCacheVersion ver, long expireTime, MvccVersion mvccVer, MvccVersion newMvccVer, byte mvccTxState, byte newMvccTxState) {
                super(key, val, ver, CacheDataStoreImpl.this.partId(), expireTime, cctx.cacheId(), mvccVer, newMvccVer);
                this.mvccTxState(mvccTxState);
                this.newMvccTxState(newMvccTxState);
            }

            @Override
            @Nullable
            public CacheDataRow oldRow() {
                return this.oldRow;
            }

            @Override
            public void call(@Nullable CacheDataRow oldRow) throws IgniteCheckedException {
                this.oldRow = oldRow;
                if (oldRow == null) {
                    this.op = IgniteTree.OperationType.PUT;
                    int cacheId = this.cacheId();
                    if (!IgniteCacheOffheapManagerImpl.this.grp.storeCacheIdInDataPage() && cacheId != 0) {
                        this.cacheId(0);
                    }
                    CacheDataStoreImpl.this.rowStore().addRow(this);
                    this.cacheId(cacheId);
                } else {
                    this.op = IgniteTree.OperationType.NOOP;
                    if (oldRow.mvccTxState() != this.mvccTxState() || oldRow.newMvccCoordinatorVersion() != this.newMvccCoordinatorVersion() || oldRow.newMvccCounter() != this.newMvccCounter() || oldRow.newMvccOperationCounter() != this.newMvccOperationCounter() || oldRow.newMvccTxState() != this.newMvccTxState()) {
                        CacheDataStoreImpl.this.rowStore().updateDataRow(oldRow.link(), CacheDataStoreImpl.this.mvccApplyChanges, this);
                    }
                }
            }

            @Override
            public CacheDataRow newRow() {
                return this.op == IgniteTree.OperationType.PUT ? this : null;
            }

            @Override
            public IgniteTree.OperationType operationType() {
                return this.op == null ? IgniteTree.OperationType.NOOP : this.op;
            }
        }

        private class MvccPutIfAbsentClosure
        extends MvccDataRow
        implements IgniteTree.InvokeClosure<CacheDataRow> {
            private IgniteTree.OperationType op;

            MvccPutIfAbsentClosure(KeyCacheObject key, CacheObject val, GridCacheVersion ver, int part, long expireTime, int cacheId, MvccVersion mvccVer, MvccVersion newMvccVer, byte txState, byte newTxState) {
                super(key, val, ver, part, expireTime, cacheId, mvccVer, newMvccVer);
                this.mvccTxState(txState);
                this.newMvccTxState(newTxState);
            }

            @Override
            public void call(@Nullable CacheDataRow old) throws IgniteCheckedException {
                if (old == null) {
                    this.op = IgniteTree.OperationType.PUT;
                    int cacheId = this.cacheId();
                    if (!IgniteCacheOffheapManagerImpl.this.grp.storeCacheIdInDataPage() && cacheId != 0) {
                        this.cacheId(0);
                    }
                    CacheDataStoreImpl.this.rowStore().addRow(this);
                    this.cacheId(cacheId);
                } else {
                    this.op = IgniteTree.OperationType.NOOP;
                }
            }

            @Override
            public MvccDataRow newRow() {
                return this;
            }

            @Override
            public IgniteTree.OperationType operationType() {
                return this.op;
            }
        }

        private final class MvccFirstVisibleRowTreeClosure
        implements MvccTreeClosure {
            private final GridCacheContext cctx;
            private final MvccSnapshot snapshot;

            MvccFirstVisibleRowTreeClosure(GridCacheContext cctx, MvccSnapshot snapshot) {
                this.cctx = cctx;
                this.snapshot = snapshot;
            }

            @Override
            public boolean apply(BPlusTree<CacheSearchRow, CacheDataRow> tree, BPlusIO<CacheSearchRow> io, long pageAddr, int idx) throws IgniteCheckedException {
                RowLinkIO rowIo = (RowLinkIO)((Object)io);
                long rowCrdVer = rowIo.getMvccCoordinatorVersion(pageAddr, idx);
                long rowCntr = rowIo.getMvccCounter(pageAddr, idx);
                int rowOpCntr = rowIo.getMvccOperationCounter(pageAddr, idx);
                assert (MvccUtils.mvccVersionIsValid(rowCrdVer, rowCntr, rowOpCntr));
                return MvccUtils.isVisible(this.cctx, this.snapshot, rowCrdVer, rowCntr, rowOpCntr, rowIo.getLink(pageAddr, idx));
            }
        }
    }
}

