/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import javax.cache.processor.MutableEntry;
import org.apache.ignite.cache.CacheEntry;
import org.apache.ignite.internal.processors.cache.CacheEntryImplEx;
import org.apache.ignite.internal.processors.cache.CacheLazyEntry;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class CacheInvokeEntry<K, V>
extends CacheLazyEntry<K, V>
implements MutableEntry<K, V> {
    private final boolean hadVal;
    private Operation op = Operation.NONE;
    private V oldVal;
    private GridCacheVersion ver;
    private GridCacheEntryEx entry;

    public CacheInvokeEntry(KeyCacheObject keyObj, @Nullable CacheObject valObj, GridCacheVersion ver, boolean keepBinary, GridCacheEntryEx entry) {
        super(entry.context(), keyObj, valObj, keepBinary);
        this.hadVal = valObj != null;
        this.ver = ver;
        this.entry = entry;
    }

    public CacheInvokeEntry(KeyCacheObject keyObj, @Nullable K key, @Nullable CacheObject valObj, @Nullable V val, GridCacheVersion ver, boolean keepBinary, GridCacheEntryEx entry) {
        super(entry.context(), keyObj, key, valObj, val, keepBinary);
        this.hadVal = valObj != null || val != null;
        this.ver = ver;
        this.entry = entry;
    }

    public boolean exists() {
        return this.val != null || this.valObj != null;
    }

    public void remove() {
        if (!this.entry.isMvcc()) {
            this.op = this.op == Operation.CREATE ? Operation.NONE : Operation.REMOVE;
        } else {
            if (this.op == Operation.CREATE) {
                assert (!this.hadVal);
                this.op = Operation.NONE;
            } else if (this.exists()) {
                assert (this.hadVal);
                this.op = Operation.REMOVE;
            }
            if (this.hadVal && this.oldVal == null) {
                this.oldVal = this.val;
            }
        }
        this.val = null;
        this.valObj = null;
    }

    public void setValue(V val) {
        if (val == null) {
            throw new NullPointerException();
        }
        if (!this.entry.isMvcc()) {
            this.oldVal = this.val;
        } else if (this.hadVal && this.oldVal == null) {
            this.oldVal = this.val;
        }
        this.val = val;
        this.op = this.hadVal ? Operation.UPDATE : Operation.CREATE;
    }

    public Operation op() {
        return this.op;
    }

    public V oldVal() {
        return (V)(this.oldVal == null ? this.val : this.oldVal);
    }

    public boolean modified() {
        return this.op != Operation.NONE;
    }

    public GridCacheEntryEx entry() {
        return this.entry;
    }

    @Override
    public <T> T unwrap(Class<T> cls) {
        if (cls.isAssignableFrom(CacheEntry.class) && this.ver != null) {
            return (T)new CacheEntryImplEx(this.getKey(), this.getValue(), this.ver);
        }
        T res = this.cctx.plugin().unwrapCacheEntry(this, cls);
        if (res != null) {
            return res;
        }
        return super.unwrap(cls);
    }

    @Override
    public String toString() {
        return S.toString(CacheInvokeEntry.class, this);
    }

    public static enum Operation {
        NONE,
        CREATE,
        UPDATE,
        REMOVE;

    }
}

