/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.WalStateProposeMessage;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class CacheGroupDescriptor {
    private final int grpId;
    private final String grpName;
    private final AffinityTopologyVersion startTopVer;
    private final UUID rcvdFrom;
    private final IgniteUuid deploymentId;
    @GridToStringExclude
    private final CacheConfiguration<?, ?> cacheCfg;
    @GridToStringInclude
    private Map<String, Integer> caches;
    private AffinityTopologyVersion rcvdFromVer;
    private final boolean persistenceEnabled;
    private volatile boolean walEnabled;
    private final LinkedList<WalStateProposeMessage> walChangeReqs;

    CacheGroupDescriptor(CacheConfiguration cacheCfg, @Nullable String grpName, int grpId, UUID rcvdFrom, @Nullable AffinityTopologyVersion startTopVer, IgniteUuid deploymentId, Map<String, Integer> caches, boolean persistenceEnabled, boolean walEnabled, @Nullable Collection<WalStateProposeMessage> walChangeReqs) {
        assert (cacheCfg != null);
        assert (grpId != 0);
        this.grpName = grpName;
        this.grpId = grpId;
        this.rcvdFrom = rcvdFrom;
        this.startTopVer = startTopVer;
        this.deploymentId = deploymentId;
        this.cacheCfg = new CacheConfiguration(cacheCfg);
        this.caches = caches;
        this.persistenceEnabled = persistenceEnabled;
        this.walEnabled = walEnabled;
        this.walChangeReqs = walChangeReqs == null ? new LinkedList() : new LinkedList<WalStateProposeMessage>(walChangeReqs);
    }

    public UUID receivedFrom() {
        return this.rcvdFrom;
    }

    public IgniteUuid deploymentId() {
        return this.deploymentId;
    }

    public boolean walEnabled() {
        return this.walEnabled;
    }

    public void walEnabled(boolean walEnabled) {
        this.walEnabled = walEnabled;
    }

    public List<WalStateProposeMessage> walChangeRequests() {
        return new ArrayList<WalStateProposeMessage>(this.walChangeReqs);
    }

    public boolean hasWalChangeRequests() {
        return !this.walChangeReqs.isEmpty();
    }

    @Nullable
    public WalStateProposeMessage nextWalChangeRequest() {
        return this.walChangeReqs.isEmpty() ? null : this.walChangeReqs.getFirst();
    }

    public boolean addWalChangeRequest(WalStateProposeMessage msg) {
        boolean first = !this.hasWalChangeRequests();
        this.walChangeReqs.addLast(msg);
        return first;
    }

    public void removeWalChangeRequest() {
        this.walChangeReqs.removeFirst();
    }

    void onCacheAdded(String cacheName, int cacheId) {
        assert (cacheName != null);
        assert (cacheId != 0) : cacheName;
        HashMap<String, Integer> caches = new HashMap<String, Integer>(this.caches);
        caches.put(cacheName, cacheId);
        this.caches = caches;
    }

    void onCacheStopped(String cacheName, int cacheId) {
        assert (cacheName != null);
        assert (cacheId != 0);
        HashMap<String, Integer> caches = new HashMap<String, Integer>(this.caches);
        Integer rmvd = (Integer)caches.remove(cacheName);
        assert (rmvd != null && rmvd == cacheId) : cacheName;
        this.caches = caches;
    }

    boolean hasCaches() {
        return this.caches != null && !this.caches.isEmpty();
    }

    public boolean sharedGroup() {
        return this.grpName != null;
    }

    public String cacheOrGroupName() {
        return this.grpName != null ? this.grpName : this.cacheCfg.getName();
    }

    @Nullable
    public String groupName() {
        return this.grpName;
    }

    public int groupId() {
        return this.grpId;
    }

    public CacheConfiguration<?, ?> config() {
        return this.cacheCfg;
    }

    public Map<String, Integer> caches() {
        return this.caches;
    }

    @Nullable
    AffinityTopologyVersion receivedFromStartVersion() {
        return this.rcvdFromVer;
    }

    void receivedFromStartVersion(AffinityTopologyVersion rcvdFromVer) {
        this.rcvdFromVer = rcvdFromVer;
    }

    void mergeWith(CacheGroupDescriptor otherDesc) {
        assert (otherDesc != null && otherDesc.config() != null) : otherDesc;
        CacheConfiguration<?, ?> otherCfg = otherDesc.config();
        this.cacheCfg.setRebalanceDelay(otherCfg.getRebalanceDelay());
        this.cacheCfg.setRebalanceBatchesPrefetchCount(otherCfg.getRebalanceBatchesPrefetchCount());
        this.cacheCfg.setRebalanceBatchSize(otherCfg.getRebalanceBatchSize());
        this.cacheCfg.setRebalanceOrder(otherCfg.getRebalanceOrder());
        this.cacheCfg.setRebalanceThrottle(otherCfg.getRebalanceThrottle());
        this.cacheCfg.setRebalanceTimeout(otherCfg.getRebalanceTimeout());
    }

    @Nullable
    public AffinityTopologyVersion startTopologyVersion() {
        return this.startTopVer;
    }

    public boolean persistenceEnabled() {
        return this.persistenceEnabled;
    }

    public String toString() {
        return S.toString(CacheGroupDescriptor.class, this, "cacheName", this.cacheCfg.getName());
    }
}

