/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataPageEvictionMode;
import org.apache.ignite.configuration.TopologyValidator;
import org.apache.ignite.events.CacheRebalancingEvent;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.affinity.GridAffinityAssignmentCache;
import org.apache.ignite.internal.processors.cache.CacheGroupMetricsMXBeanImpl;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCachePreloader;
import org.apache.ignite.internal.processors.cache.GridCachePreloaderAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManagerImpl;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtAffinityAssignmentRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtAffinityAssignmentResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPreloader;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopologyImpl;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.persistence.freelist.FreeList;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cache.query.continuous.CounterSkipContext;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.mxbean.CacheGroupMetricsMXBean;
import org.jetbrains.annotations.Nullable;

public class CacheGroupContext {
    private final int grpId;
    private final UUID rcvdFrom;
    private boolean needsRecovery;
    private final AffinityTopologyVersion locStartVer;
    private final CacheConfiguration<?, ?> ccfg;
    private final GridCacheSharedContext ctx;
    private final boolean affNode;
    private final CacheType cacheType;
    private final byte ioPlc;
    private final boolean depEnabled;
    private final boolean storeCacheId;
    private volatile List<GridCacheContext> caches;
    private volatile List<GridCacheContext> contQryCaches;
    private final IgniteLogger log;
    private GridAffinityAssignmentCache aff;
    private GridDhtPartitionTopologyImpl top;
    private IgniteCacheOffheapManager offheapMgr;
    private GridCachePreloader preldr;
    private final DataRegion dataRegion;
    private final boolean persistenceEnabled;
    private final CacheObjectContext cacheObjCtx;
    private final FreeList freeList;
    private final ReuseList reuseList;
    private boolean drEnabled;
    private boolean qryEnabled;
    private boolean mvccEnabled;
    private CacheGroupMetricsMXBean mxBean;
    private volatile boolean localWalEnabled;
    private volatile boolean globalWalEnabled;

    CacheGroupContext(GridCacheSharedContext ctx, int grpId, UUID rcvdFrom, CacheType cacheType, CacheConfiguration ccfg, boolean affNode, DataRegion dataRegion, CacheObjectContext cacheObjCtx, FreeList freeList, ReuseList reuseList, AffinityTopologyVersion locStartVer, boolean persistenceEnabled, boolean walEnabled) {
        assert (ccfg != null);
        assert (dataRegion != null || !affNode);
        assert (grpId != 0) : "Invalid group ID [cache=" + ccfg.getName() + ", grpName=" + ccfg.getGroupName() + ']';
        this.grpId = grpId;
        this.rcvdFrom = rcvdFrom;
        this.ctx = ctx;
        this.ccfg = ccfg;
        this.affNode = affNode;
        this.dataRegion = dataRegion;
        this.cacheObjCtx = cacheObjCtx;
        this.freeList = freeList;
        this.reuseList = reuseList;
        this.locStartVer = locStartVer;
        this.cacheType = cacheType;
        this.globalWalEnabled = walEnabled;
        this.persistenceEnabled = persistenceEnabled;
        this.localWalEnabled = true;
        this.persistGlobalWalState(walEnabled);
        this.ioPlc = cacheType.ioPolicy();
        this.depEnabled = ctx.kernalContext().deploy().enabled() && !ctx.kernalContext().cacheObjects().isBinaryEnabled(ccfg);
        this.storeCacheId = affNode && dataRegion.config().getPageEvictionMode() != DataPageEvictionMode.DISABLED;
        this.mvccEnabled = ccfg.getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT;
        this.log = ctx.kernalContext().log(this.getClass());
        this.caches = new ArrayList<GridCacheContext>();
        this.mxBean = new CacheGroupMetricsMXBeanImpl(this);
    }

    public boolean mvccEnabled() {
        return this.mvccEnabled;
    }

    public boolean systemCache() {
        return !this.sharedGroup() && CU.isSystemCache(this.ccfg.getName());
    }

    public UUID receivedFrom() {
        return this.rcvdFrom;
    }

    public boolean storeCacheIdInDataPage() {
        return this.storeCacheId;
    }

    public boolean deploymentEnabled() {
        return this.depEnabled;
    }

    public GridCachePreloader preloader() {
        return this.preldr;
    }

    public byte ioPolicy() {
        return this.ioPlc;
    }

    void onCacheStarted(GridCacheContext cctx) throws IgniteCheckedException {
        this.addCacheContext(cctx);
        this.offheapMgr.onCacheStarted(cctx);
    }

    public boolean hasCache(String cacheName) {
        List<GridCacheContext> caches = this.caches;
        for (int i = 0; i < caches.size(); ++i) {
            if (!caches.get(i).name().equals(cacheName)) continue;
            return true;
        }
        return false;
    }

    private void addCacheContext(GridCacheContext cctx) {
        assert (this.cacheType.userCache() == cctx.userCache()) : cctx.name();
        assert (this.grpId == cctx.groupId()) : cctx.name();
        ArrayList<GridCacheContext> caches = new ArrayList<GridCacheContext>(this.caches);
        assert (this.sharedGroup() || caches.isEmpty());
        boolean add = caches.add(cctx);
        assert (add) : cctx.name();
        if (!this.qryEnabled && QueryUtils.isEnabled(cctx.config())) {
            this.qryEnabled = true;
        }
        if (!this.drEnabled && cctx.isDrEnabled()) {
            this.drEnabled = true;
        }
        this.caches = caches;
    }

    private void removeCacheContext(GridCacheContext cctx) {
        ArrayList<GridCacheContext> caches = new ArrayList<GridCacheContext>(this.caches);
        Iterator<GridCacheContext> it = caches.iterator();
        while (it.hasNext()) {
            GridCacheContext next = it.next();
            if (next != cctx) continue;
            assert (this.sharedGroup() || caches.size() == 1) : caches.size();
            it.remove();
            break;
        }
        if (QueryUtils.isEnabled(cctx.config())) {
            boolean qryEnabled = false;
            for (int i = 0; i < caches.size(); ++i) {
                if (!QueryUtils.isEnabled(caches.get(i).config())) continue;
                qryEnabled = true;
                break;
            }
            this.qryEnabled = qryEnabled;
        }
        if (cctx.isDrEnabled()) {
            boolean drEnabled = false;
            for (int i = 0; i < caches.size(); ++i) {
                if (!caches.get(i).isDrEnabled()) continue;
                drEnabled = true;
                break;
            }
            this.drEnabled = drEnabled;
        }
        this.caches = caches;
    }

    public GridCacheContext singleCacheContext() {
        List<GridCacheContext> caches = this.caches;
        assert (!this.sharedGroup() && caches.size() == 1) : "stopping=" + this.ctx.kernalContext().isStopping() + ", groupName=" + this.ccfg.getGroupName() + ", caches=" + caches;
        return caches.get(0);
    }

    public void unwindUndeploys() {
        List<GridCacheContext> caches = this.caches;
        for (int i = 0; i < caches.size(); ++i) {
            GridCacheContext cctx = caches.get(i);
            cctx.deploy().unwind(cctx);
        }
    }

    public boolean eventRecordable(int type) {
        return this.cacheType.userCache() && this.ctx.gridEvents().isRecordable(type);
    }

    public boolean userCache() {
        return this.cacheType.userCache();
    }

    public void addRebalanceEvent(int part, int type, ClusterNode discoNode, int discoType, long discoTs) {
        assert (discoNode != null);
        assert (type > 0);
        assert (discoType > 0);
        assert (discoTs > 0L);
        if (!this.eventRecordable(type)) {
            LT.warn(this.log, "Added event without checking if event is recordable: " + U.gridEventName(type));
        }
        List<GridCacheContext> caches = this.caches;
        for (int i = 0; i < caches.size(); ++i) {
            GridCacheContext cctx = caches.get(i);
            if (cctx.config().isEventsDisabled().booleanValue() || !cctx.recordEvent(type)) continue;
            cctx.gridEvents().record(new CacheRebalancingEvent(cctx.name(), cctx.localNode(), "Cache rebalancing event.", type, part, discoNode, discoType, discoTs));
        }
    }

    public void addUnloadEvent(int part) {
        if (!this.eventRecordable(83)) {
            LT.warn(this.log, "Added event without checking if event is recordable: " + U.gridEventName(83));
        }
        List<GridCacheContext> caches = this.caches;
        for (int i = 0; i < caches.size(); ++i) {
            GridCacheContext cctx = caches.get(i);
            if (cctx.config().isEventsDisabled().booleanValue()) continue;
            cctx.gridEvents().record(new CacheRebalancingEvent(cctx.name(), cctx.localNode(), "Cache unloading event.", 83, part, null, 0, 0L));
        }
    }

    public void addCacheEvent(int part, KeyCacheObject key, UUID evtNodeId, int type, @Nullable CacheObject newVal, boolean hasNewVal, @Nullable CacheObject oldVal, boolean hasOldVal, boolean keepBinary) {
        List<GridCacheContext> caches = this.caches;
        for (int i = 0; i < caches.size(); ++i) {
            GridCacheContext cctx = caches.get(i);
            if (cctx.config().isEventsDisabled().booleanValue()) continue;
            cctx.events().addEvent(part, key, evtNodeId, (IgniteUuid)null, null, type, newVal, hasNewVal, oldVal, hasOldVal, null, null, null, keepBinary);
        }
    }

    public boolean queriesEnabled() {
        return this.qryEnabled;
    }

    public boolean isDrEnabled() {
        return this.drEnabled;
    }

    public FreeList freeList() {
        return this.freeList;
    }

    public ReuseList reuseList() {
        return this.reuseList;
    }

    public CacheObjectContext cacheObjectContext() {
        return this.cacheObjCtx;
    }

    public GridCacheSharedContext shared() {
        return this.ctx;
    }

    public DataRegion dataRegion() {
        return this.dataRegion;
    }

    public boolean affinityNode() {
        return this.affNode;
    }

    public GridDhtPartitionTopology topology() {
        if (this.top == null) {
            throw new IllegalStateException("Topology is not initialized: " + this.cacheOrGroupName());
        }
        return this.top;
    }

    public boolean isTopologyLocked() {
        if (this.top == null) {
            return false;
        }
        return this.top.holdsLock();
    }

    public IgniteCacheOffheapManager offheap() {
        return this.offheapMgr;
    }

    public boolean needsRecovery() {
        return this.needsRecovery;
    }

    public void needsRecovery(boolean needsRecovery) {
        this.needsRecovery = needsRecovery;
    }

    public AffinityTopologyVersion localStartVersion() {
        return this.locStartVer;
    }

    public boolean isLocal() {
        return this.ccfg.getCacheMode() == CacheMode.LOCAL;
    }

    public boolean isReplicated() {
        return this.ccfg.getCacheMode() == CacheMode.REPLICATED;
    }

    public CacheConfiguration config() {
        return this.ccfg;
    }

    public IgnitePredicate<ClusterNode> nodeFilter() {
        return this.ccfg.getNodeFilter();
    }

    Collection<?> configuredUserObjects() {
        return Arrays.asList(this.ccfg.getAffinity(), this.ccfg.getNodeFilter(), this.ccfg.getTopologyValidator());
    }

    @Nullable
    public TopologyValidator topologyValidator() {
        return this.ccfg.getTopologyValidator();
    }

    public AffinityFunction affinityFunction() {
        return this.ccfg.getAffinity();
    }

    public GridAffinityAssignmentCache affinity() {
        return this.aff;
    }

    @Nullable
    public String name() {
        return this.ccfg.getGroupName();
    }

    public String cacheOrGroupName() {
        return this.ccfg.getGroupName() != null ? this.ccfg.getGroupName() : this.ccfg.getName();
    }

    public int groupId() {
        return this.grpId;
    }

    public boolean sharedGroup() {
        return this.ccfg.getGroupName() != null;
    }

    public void onKernalStop() {
        this.aff.cancelFutures(new IgniteCheckedException("Failed to wait for topology update, node is stopping."));
        this.preldr.onKernalStop();
        this.offheapMgr.onKernalStop();
    }

    void stopCache(GridCacheContext cctx, boolean destroy) {
        if (this.top != null) {
            this.top.onCacheStopped(cctx.cacheId());
        }
        this.offheapMgr.stopCache(cctx.cacheId(), destroy);
        this.removeCacheContext(cctx);
    }

    void stopGroup() {
        IgniteCheckedException err = new IgniteCheckedException("Failed to wait for topology update, cache (or node) is stopping.");
        this.ctx.evict().onCacheGroupStopped(this);
        this.aff.cancelFutures(err);
        this.preldr.onKernalStop();
        this.offheapMgr.stop();
        this.ctx.io().removeCacheGroupHandlers(this.grpId);
    }

    public Set<Integer> cacheIds() {
        List<GridCacheContext> caches = this.caches;
        HashSet<Integer> ids = U.newHashSet(caches.size());
        for (int i = 0; i < caches.size(); ++i) {
            ids.add(caches.get(i).cacheId());
        }
        return ids;
    }

    public List<GridCacheContext> caches() {
        return this.caches;
    }

    boolean hasCaches() {
        List<GridCacheContext> caches = this.caches;
        return !caches.isEmpty();
    }

    public void onPartitionEvicted(int part) {
        List<GridCacheContext> caches = this.caches;
        for (int i = 0; i < caches.size(); ++i) {
            GridCacheContext cctx = caches.get(i);
            if (cctx.isDrEnabled()) {
                cctx.dr().partitionEvicted(part);
            }
            cctx.continuousQueries().onPartitionEvicted(part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCacheWithContinuousQuery(GridCacheContext cctx) {
        assert (this.sharedGroup()) : this.cacheOrGroupName();
        assert (cctx.group() == this) : cctx.name();
        assert (!cctx.isLocal()) : cctx.name();
        CacheGroupContext cacheGroupContext = this;
        synchronized (cacheGroupContext) {
            List<GridCacheContext> contQryCaches = this.contQryCaches;
            if (contQryCaches == null) {
                contQryCaches = new ArrayList<GridCacheContext>();
            }
            contQryCaches.add(cctx);
            this.contQryCaches = contQryCaches;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCacheWithContinuousQuery(GridCacheContext cctx) {
        assert (this.sharedGroup()) : this.cacheOrGroupName();
        assert (cctx.group() == this) : cctx.name();
        assert (!cctx.isLocal()) : cctx.name();
        CacheGroupContext cacheGroupContext = this;
        synchronized (cacheGroupContext) {
            List<GridCacheContext> contQryCaches = this.contQryCaches;
            if (contQryCaches == null) {
                return;
            }
            contQryCaches.remove(cctx);
            if (contQryCaches.isEmpty()) {
                contQryCaches = null;
            }
            this.contQryCaches = contQryCaches;
        }
    }

    public void onPartitionCounterUpdate(int cacheId, int part, long cntr, AffinityTopologyVersion topVer, boolean primary) {
        List<Runnable> procC;
        assert (this.sharedGroup());
        if (this.isLocal()) {
            return;
        }
        List<GridCacheContext> contQryCaches = this.contQryCaches;
        if (contQryCaches == null) {
            return;
        }
        CounterSkipContext skipCtx = null;
        for (int i = 0; i < contQryCaches.size(); ++i) {
            GridCacheContext cctx = contQryCaches.get(i);
            if (cacheId == cctx.cacheId()) continue;
            skipCtx = cctx.continuousQueries().skipUpdateCounter(skipCtx, part, cntr, topVer, primary);
        }
        List<Runnable> list = procC = skipCtx != null ? skipCtx.processClosures() : null;
        if (procC != null) {
            this.ctx.kernalContext().closure().runLocalSafe(new Runnable(){

                @Override
                public void run() {
                    for (Runnable c : procC) {
                        c.run();
                    }
                }
            });
        }
    }

    public boolean hasContinuousQueryCaches() {
        return !F.isEmpty(this.contQryCaches);
    }

    public void start() throws IgniteCheckedException {
        this.aff = new GridAffinityAssignmentCache(this.ctx.kernalContext(), this.cacheOrGroupName(), this.grpId, this.ccfg.getAffinity(), this.ccfg.getNodeFilter(), this.ccfg.getBackups(), this.ccfg.getCacheMode() == CacheMode.LOCAL, this.persistenceEnabled());
        if (this.ccfg.getCacheMode() != CacheMode.LOCAL) {
            this.top = new GridDhtPartitionTopologyImpl(this.ctx, this);
            if (!this.ctx.kernalContext().clientNode()) {
                this.ctx.io().addCacheGroupHandler(this.groupId(), GridDhtAffinityAssignmentRequest.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new IgniteBiInClosure<UUID, GridDhtAffinityAssignmentRequest>(){

                    @Override
                    public void apply(UUID nodeId, GridDhtAffinityAssignmentRequest msg) {
                        CacheGroupContext.this.processAffinityAssignmentRequest(nodeId, msg);
                    }
                });
            }
            this.preldr = new GridDhtPreloader(this);
            this.preldr.start();
        } else {
            this.preldr = new GridCachePreloaderAdapter(this);
        }
        if (this.persistenceEnabled()) {
            try {
                this.offheapMgr = new GridCacheOffheapManager();
            }
            catch (Exception e) {
                throw new IgniteCheckedException("Failed to initialize offheap manager", e);
            }
        } else {
            this.offheapMgr = new IgniteCacheOffheapManagerImpl();
        }
        this.offheapMgr.start(this.ctx, this);
        this.ctx.affinity().onCacheGroupCreated(this);
    }

    public boolean persistenceEnabled() {
        return this.persistenceEnabled;
    }

    private void processAffinityAssignmentRequest(final UUID nodeId, final GridDhtAffinityAssignmentRequest req) {
        IgniteInternalFuture<AffinityTopologyVersion> fut;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Processing affinity assignment request [node=" + nodeId + ", req=" + req + ']');
        }
        if ((fut = this.aff.readyFuture(req.topologyVersion())) != null) {
            fut.listen((IgniteInClosure<IgniteInternalFuture<AffinityTopologyVersion>>)new CI1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                @Override
                public void apply(IgniteInternalFuture<AffinityTopologyVersion> fut) {
                    CacheGroupContext.this.processAffinityAssignmentRequest0(nodeId, req);
                }
            });
        } else {
            this.processAffinityAssignmentRequest0(nodeId, req);
        }
    }

    private void processAffinityAssignmentRequest0(UUID nodeId, GridDhtAffinityAssignmentRequest req) {
        AffinityTopologyVersion topVer = req.topologyVersion();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Affinity is ready for topology version, will send response [topVer=" + topVer + ", node=" + nodeId + ']');
        }
        AffinityAssignment assignment = this.aff.cachedAffinity(topVer);
        GridDhtAffinityAssignmentResponse res = new GridDhtAffinityAssignmentResponse(req.futureId(), this.grpId, topVer, assignment.assignment());
        if (this.aff.centralizedAffinityFunction()) {
            assert (assignment.idealAssignment() != null);
            res.idealAffinityAssignment(assignment.idealAssignment());
        }
        if (req.sendPartitionsState()) {
            res.partitionMap(this.top.partitionMap(true));
        }
        try {
            this.ctx.io().send(nodeId, (GridCacheMessage)res, (byte)4);
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to send affinity assignment response to remote node [node=" + nodeId + ']', e);
        }
    }

    public void onDisconnected(IgniteFuture reconnectFut) {
        IgniteClientDisconnectedCheckedException err = new IgniteClientDisconnectedCheckedException(reconnectFut, "Failed to wait for topology update, client disconnected.");
        if (this.aff != null) {
            this.aff.cancelFutures(err);
        }
    }

    public boolean rebalanceEnabled() {
        return this.ccfg.getRebalanceMode() != CacheRebalanceMode.NONE;
    }

    public void onReconnected() {
        this.aff.onReconnected();
        if (this.top != null) {
            this.top.onReconnected();
        }
        this.preldr.onReconnected();
    }

    public CacheGroupMetricsMXBean mxBean() {
        return this.mxBean;
    }

    public String toString() {
        return "CacheGroupContext [grp=" + this.cacheOrGroupName() + ']';
    }

    public boolean walEnabled() {
        return this.localWalEnabled && this.globalWalEnabled;
    }

    public boolean localWalEnabled() {
        return this.localWalEnabled;
    }

    public boolean globalWalEnabled() {
        return this.globalWalEnabled;
    }

    public void globalWalEnabled(boolean enabled) {
        if (this.globalWalEnabled != enabled) {
            this.log.info("Global WAL state for group=" + this.cacheOrGroupName() + " changed from " + this.globalWalEnabled + " to " + enabled);
            this.persistGlobalWalState(enabled);
            this.globalWalEnabled = enabled;
        }
    }

    public void localWalEnabled(boolean enabled) {
        if (this.localWalEnabled != enabled) {
            this.log.info("Local WAL state for group=" + this.cacheOrGroupName() + " changed from " + this.localWalEnabled + " to " + enabled);
            this.persistLocalWalState(enabled);
            this.localWalEnabled = enabled;
        }
    }

    private void persistGlobalWalState(boolean enabled) {
        this.shared().database().walEnabled(this.grpId, enabled, false);
    }

    private void persistLocalWalState(boolean enabled) {
        this.shared().database().walEnabled(this.grpId, enabled, true);
    }
}

