/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.util.Collection;
import java.util.function.Consumer;
import org.apache.ignite.client.ClientConnectionException;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.internal.binary.streams.BinaryInputStream;
import org.apache.ignite.internal.binary.streams.BinaryOutputStream;
import org.apache.ignite.internal.client.thin.ClientOperation;
import org.apache.ignite.internal.client.thin.ClientProtocolError;
import org.apache.ignite.internal.client.thin.ClientServerError;
import org.apache.ignite.internal.client.thin.QueryPager;
import org.apache.ignite.internal.client.thin.ReliableChannel;

abstract class GenericQueryPager<T>
implements QueryPager<T> {
    private final ClientOperation qryOp;
    private final ClientOperation pageQryOp;
    private final Consumer<BinaryOutputStream> qryWriter;
    private final ReliableChannel ch;
    private boolean hasNext = true;
    private boolean hasFirstPage = false;
    private Long cursorId = null;

    GenericQueryPager(ReliableChannel ch, ClientOperation qryOp, ClientOperation pageQryOp, Consumer<BinaryOutputStream> qryWriter) {
        this.ch = ch;
        this.qryOp = qryOp;
        this.pageQryOp = pageQryOp;
        this.qryWriter = qryWriter;
    }

    @Override
    public Collection<T> next() throws ClientException {
        if (!this.hasNext) {
            throw new IllegalStateException("No more query results");
        }
        return this.hasFirstPage ? this.queryPage() : this.ch.service(this.qryOp, this.qryWriter, this::readResult);
    }

    @Override
    public void close() throws Exception {
        if (this.cursorId != null && this.hasNext) {
            this.ch.request(ClientOperation.RESOURCE_CLOSE, req -> req.writeLong(this.cursorId));
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public boolean hasFirstPage() {
        return this.hasFirstPage;
    }

    abstract Collection<T> readEntries(BinaryInputStream var1);

    private Collection<T> readResult(BinaryInputStream in) {
        if (!this.hasFirstPage) {
            long resCursorId = in.readLong();
            if (this.cursorId != null) {
                if (this.cursorId != resCursorId) {
                    throw new ClientProtocolError(String.format("Expected cursor [%s] but received cursor [%s]", this.cursorId, resCursorId));
                }
            } else {
                this.cursorId = resCursorId;
            }
        }
        Collection<T> res = this.readEntries(in);
        this.hasNext = in.readBoolean();
        this.hasFirstPage = true;
        return res;
    }

    private Collection<T> queryPage() throws ClientException {
        try {
            return this.ch.service(this.pageQryOp, req -> req.writeLong(this.cursorId), this::readResult);
        }
        catch (ClientServerError ex) {
            if (ex.getCode() != 1011) {
                throw ex;
            }
        }
        catch (ClientConnectionException clientConnectionException) {
            // empty catch block
        }
        this.hasFirstPage = false;
        return this.ch.service(this.qryOp, this.qryWriter, this::readResult);
    }
}

