/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.eviction.sorted;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.apache.ignite.cache.eviction.AbstractEvictionPolicy;
import org.apache.ignite.cache.eviction.EvictableEntry;
import org.apache.ignite.cache.eviction.sorted.SortedEvictionPolicyMBean;
import org.apache.ignite.internal.util.GridConcurrentSkipListSet;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.mxbean.IgniteMBeanAware;
import org.jetbrains.annotations.Nullable;

public class SortedEvictionPolicy<K, V>
extends AbstractEvictionPolicy<K, V>
implements IgniteMBeanAware {
    private static final long serialVersionUID = 0L;
    private Comparator<Holder<K, V>> comp;
    private final AtomicLong orderCnt = new AtomicLong();
    private final GridConcurrentSkipListSetEx<K, V> set;

    public SortedEvictionPolicy() {
        this(100000, null);
    }

    public SortedEvictionPolicy(int max) {
        this(max, null);
    }

    public SortedEvictionPolicy(int max, @Nullable Comparator<EvictableEntry<K, V>> comp) {
        this(max, 1, comp);
    }

    public SortedEvictionPolicy(int max, int batchSize, @Nullable Comparator<EvictableEntry<K, V>> comp) {
        this.setMaxSize(max);
        this.setBatchSize(batchSize);
        this.comp = comp == null ? new DefaultHolderComparator() : new HolderComparator<K, V>(comp);
        this.set = new GridConcurrentSkipListSetEx<K, V>(this.comp);
    }

    public SortedEvictionPolicy(@Nullable Comparator<EvictableEntry<K, V>> comp) {
        this.comp = comp == null ? new DefaultHolderComparator() : new HolderComparator<K, V>(comp);
        this.set = new GridConcurrentSkipListSetEx<K, V>(this.comp);
    }

    @Override
    public SortedEvictionPolicy<K, V> setMaxMemorySize(long maxMemSize) {
        super.setMaxMemorySize(maxMemSize);
        return this;
    }

    @Override
    public SortedEvictionPolicy<K, V> setMaxSize(int max) {
        super.setMaxSize(max);
        return this;
    }

    @Override
    public SortedEvictionPolicy<K, V> setBatchSize(int batchSize) {
        super.setBatchSize(batchSize);
        return this;
    }

    public Collection<EvictableEntry<K, V>> queue() {
        LinkedHashSet<EvictableEntry> cp = new LinkedHashSet<EvictableEntry>();
        for (Holder holder : this.set) {
            cp.add(holder.entry);
        }
        return Collections.unmodifiableCollection(cp);
    }

    @Override
    protected boolean touch(EvictableEntry<K, V> entry) {
        Holder<K, V> holder = (Holder<K, V>)entry.meta();
        if (holder == null) {
            do {
                if (entry.putMetaIfAbsent(holder = new Holder<K, V>(entry, this.orderCnt.incrementAndGet())) != null) {
                    return false;
                }
                this.set.add(holder);
                if (((Holder)holder).order <= 0L) continue;
                if (!entry.isCached()) {
                    this.removeMeta(holder);
                    return false;
                }
                this.memSize.add(entry.size());
                return true;
            } while (entry.removeMeta(holder));
            return false;
        }
        return false;
    }

    @Override
    public int getCurrentSize() {
        return this.set.sizex();
    }

    @Override
    protected int shrink0() {
        Object h = this.set.pollFirst();
        if (h == null) {
            return -1;
        }
        int size = 0;
        EvictableEntry entry = ((Holder)h).entry;
        assert (entry != null);
        if (((Holder)h).order > 0L && entry.removeMeta(h)) {
            size = entry.size();
            this.memSize.add(-size);
            if (!entry.evict()) {
                this.touch(entry);
            }
        }
        return size;
    }

    @Override
    public Object getMBean() {
        return new SortedEvictionPolicyMBeanImpl();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.comp);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.comp = (Comparator)in.readObject();
    }

    @Override
    protected boolean removeMeta(Object meta) {
        Holder holder = (Holder)meta;
        long order0 = holder.order;
        if (order0 > 0L) {
            holder.order = -order0;
        }
        return this.set.remove(holder);
    }

    private class SortedEvictionPolicyMBeanImpl
    implements SortedEvictionPolicyMBean {
        private SortedEvictionPolicyMBeanImpl() {
        }

        @Override
        public long getCurrentMemorySize() {
            return SortedEvictionPolicy.this.getCurrentMemorySize();
        }

        @Override
        public int getCurrentSize() {
            return SortedEvictionPolicy.this.getCurrentSize();
        }

        @Override
        public int getMaxSize() {
            return SortedEvictionPolicy.this.getMaxSize();
        }

        @Override
        public void setMaxSize(int max) {
            SortedEvictionPolicy.this.setMaxSize(max);
        }

        @Override
        public int getBatchSize() {
            return SortedEvictionPolicy.this.getBatchSize();
        }

        @Override
        public void setBatchSize(int batchSize) {
            SortedEvictionPolicy.this.setBatchSize(batchSize);
        }

        @Override
        public long getMaxMemorySize() {
            return SortedEvictionPolicy.this.getMaxMemorySize();
        }

        @Override
        public void setMaxMemorySize(long maxMemSize) {
            SortedEvictionPolicy.this.setMaxMemorySize(maxMemSize);
        }
    }

    private static class GridConcurrentSkipListSetEx<K, V>
    extends GridConcurrentSkipListSet<Holder<K, V>> {
        private static final long serialVersionUID = 0L;
        private final LongAdder size = new LongAdder();

        public GridConcurrentSkipListSetEx(Comparator<? super Holder<K, V>> comp) {
            super(comp);
        }

        public int sizex() {
            return this.size.intValue();
        }

        @Override
        public boolean add(Holder<K, V> e) {
            boolean res = super.add(e);
            assert (res);
            this.size.increment();
            return res;
        }

        @Override
        public boolean remove(Object o) {
            boolean res = super.remove(o);
            if (res) {
                this.size.decrement();
            }
            return res;
        }

        @Override
        @Nullable
        public Holder<K, V> pollFirst() {
            Holder e = (Holder)super.pollFirst();
            if (e != null) {
                this.size.decrement();
            }
            return e;
        }
    }

    private static class DefaultHolderComparator<K, V>
    implements Comparator<Holder<K, V>>,
    Serializable {
        private static final long serialVersionUID = 0L;

        private DefaultHolderComparator() {
        }

        @Override
        public int compare(Holder<K, V> h1, Holder<K, V> h2) {
            if (h1 == h2) {
                return 0;
            }
            EvictableEntry e1 = ((Holder)h1).entry;
            EvictableEntry e2 = ((Holder)h2).entry;
            int cmp = ((Comparable)e1.getKey()).compareTo(e2.getKey());
            return cmp == 0 ? Long.compare(Math.abs(((Holder)h1).order), Math.abs(((Holder)h2).order)) : cmp;
        }
    }

    private static class HolderComparator<K, V>
    implements Comparator<Holder<K, V>>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final Comparator<EvictableEntry<K, V>> comp;

        public HolderComparator(Comparator<EvictableEntry<K, V>> comp) {
            A.notNull(comp, "comp");
            this.comp = comp;
        }

        @Override
        public int compare(Holder<K, V> h1, Holder<K, V> h2) {
            EvictableEntry e2;
            if (h1 == h2) {
                return 0;
            }
            EvictableEntry e1 = ((Holder)h1).entry;
            int cmp = this.comp.compare(e1, e2 = ((Holder)h2).entry);
            return cmp == 0 ? Long.compare(Math.abs(((Holder)h1).order), Math.abs(((Holder)h2).order)) : cmp;
        }
    }

    private static class Holder<K, V> {
        private final EvictableEntry<K, V> entry;
        private volatile long order;

        public Holder(EvictableEntry<K, V> entry, long order) {
            assert (order > 0L);
            this.entry = entry;
            this.order = order;
        }

        public int hashCode() {
            return this.entry.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Holder h = (Holder)obj;
            return Objects.equals(this.entry, h.entry) && Math.abs(this.order) == Math.abs(h.order);
        }
    }
}

