/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.configuration.DataPageEvictionMode;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class VisorDataRegionConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String name;
    private long initSize;
    private long maxSize;
    private String swapPath;
    private DataPageEvictionMode pageEvictionMode;
    private double evictionThreshold;
    private int emptyPagesPoolSize;
    private boolean metricsEnabled;
    private int metricsSubIntervalCount;
    private long metricsRateTimeInterval;
    private boolean persistenceEnabled;
    private long checkpointPageBufSize;

    public VisorDataRegionConfiguration() {
    }

    public VisorDataRegionConfiguration(DataRegionConfiguration plc) {
        assert (plc != null);
        this.name = plc.getName();
        this.initSize = plc.getInitialSize();
        this.maxSize = plc.getMaxSize();
        this.swapPath = plc.getSwapPath();
        this.pageEvictionMode = plc.getPageEvictionMode();
        this.evictionThreshold = plc.getEvictionThreshold();
        this.emptyPagesPoolSize = plc.getEmptyPagesPoolSize();
        this.metricsEnabled = plc.isMetricsEnabled();
        this.metricsSubIntervalCount = plc.getMetricsSubIntervalCount();
        this.metricsRateTimeInterval = plc.getMetricsRateTimeInterval();
        this.persistenceEnabled = plc.isPersistenceEnabled();
        this.checkpointPageBufSize = plc.getCheckpointPageBufferSize();
    }

    public static List<VisorDataRegionConfiguration> from(DataRegionConfiguration[] regCfgs) {
        ArrayList<VisorDataRegionConfiguration> res = new ArrayList<VisorDataRegionConfiguration>();
        if (regCfgs != null) {
            for (DataRegionConfiguration plc : regCfgs) {
                res.add(new VisorDataRegionConfiguration(plc));
            }
        }
        return res;
    }

    public String getName() {
        return this.name;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public long getInitialSize() {
        return this.initSize;
    }

    public String getSwapPath() {
        return this.swapPath;
    }

    public DataPageEvictionMode getPageEvictionMode() {
        return this.pageEvictionMode;
    }

    public double getEvictionThreshold() {
        return this.evictionThreshold;
    }

    public int getEmptyPagesPoolSize() {
        return this.emptyPagesPoolSize;
    }

    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    public int getMetricsSubIntervalCount() {
        return this.metricsSubIntervalCount;
    }

    public long getMetricsRateTimeInterval() {
        return this.metricsRateTimeInterval;
    }

    public boolean isPersistenceEnabled() {
        return this.persistenceEnabled;
    }

    public long getCheckpointPageBufferSize() {
        return this.checkpointPageBufSize;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.name);
        out.writeLong(this.initSize);
        out.writeLong(this.maxSize);
        U.writeString(out, this.swapPath);
        U.writeEnum(out, this.pageEvictionMode);
        out.writeDouble(this.evictionThreshold);
        out.writeInt(this.emptyPagesPoolSize);
        out.writeBoolean(this.metricsEnabled);
        out.writeInt(this.metricsSubIntervalCount);
        out.writeLong(this.metricsRateTimeInterval);
        out.writeBoolean(this.persistenceEnabled);
        out.writeLong(this.checkpointPageBufSize);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = U.readString(in);
        this.initSize = in.readLong();
        this.maxSize = in.readLong();
        this.swapPath = U.readString(in);
        this.pageEvictionMode = DataPageEvictionMode.fromOrdinal(in.readByte());
        this.evictionThreshold = in.readDouble();
        this.emptyPagesPoolSize = in.readInt();
        this.metricsEnabled = in.readBoolean();
        this.metricsSubIntervalCount = in.readInt();
        this.metricsRateTimeInterval = in.readLong();
        this.persistenceEnabled = in.readBoolean();
        this.checkpointPageBufSize = in.readLong();
    }

    public String toString() {
        return S.toString(VisorDataRegionConfiguration.class, this);
    }
}

