/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridKernalGateway;
import org.apache.ignite.internal.GridLoggerProxy;
import org.apache.ignite.internal.GridPluginComponent;
import org.apache.ignite.internal.IgniteComponentType;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.LongJVMPauseDetector;
import org.apache.ignite.internal.MarshallerContextImpl;
import org.apache.ignite.internal.maintenance.MaintenanceProcessor;
import org.apache.ignite.internal.managers.checkpoint.GridCheckpointManager;
import org.apache.ignite.internal.managers.collision.GridCollisionManager;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.managers.deployment.GridDeploymentManager;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.managers.encryption.GridEncryptionManager;
import org.apache.ignite.internal.managers.eventstorage.GridEventStorageManager;
import org.apache.ignite.internal.managers.failover.GridFailoverManager;
import org.apache.ignite.internal.managers.indexing.GridIndexingManager;
import org.apache.ignite.internal.managers.loadbalancer.GridLoadBalancerManager;
import org.apache.ignite.internal.managers.systemview.GridSystemViewManager;
import org.apache.ignite.internal.managers.tracing.GridTracingManager;
import org.apache.ignite.internal.processors.affinity.GridAffinityProcessor;
import org.apache.ignite.internal.processors.authentication.IgniteAuthenticationProcessor;
import org.apache.ignite.internal.processors.cache.CacheConflictResolutionManager;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cache.mvcc.MvccProcessor;
import org.apache.ignite.internal.processors.cache.persistence.defragmentation.IgniteDefragmentation;
import org.apache.ignite.internal.processors.cache.persistence.defragmentation.IgniteDefragmentationImpl;
import org.apache.ignite.internal.processors.cache.persistence.filename.PdsFoldersResolver;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.apache.ignite.internal.processors.closure.GridClosureProcessor;
import org.apache.ignite.internal.processors.cluster.ClusterProcessor;
import org.apache.ignite.internal.processors.cluster.GridClusterStateProcessor;
import org.apache.ignite.internal.processors.compress.CompressionProcessor;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedConfigurationProcessor;
import org.apache.ignite.internal.processors.continuous.GridContinuousProcessor;
import org.apache.ignite.internal.processors.datastreamer.DataStreamProcessor;
import org.apache.ignite.internal.processors.datastructures.DataStructuresProcessor;
import org.apache.ignite.internal.processors.diagnostic.DiagnosticProcessor;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.apache.ignite.internal.processors.job.GridJobProcessor;
import org.apache.ignite.internal.processors.jobmetrics.GridJobMetricsProcessor;
import org.apache.ignite.internal.processors.localtask.DurableBackgroundTasksProcessor;
import org.apache.ignite.internal.processors.marshaller.GridMarshallerMappingProcessor;
import org.apache.ignite.internal.processors.metastorage.DistributedMetaStorage;
import org.apache.ignite.internal.processors.metric.GridMetricManager;
import org.apache.ignite.internal.processors.nodevalidation.DiscoveryNodeValidationProcessor;
import org.apache.ignite.internal.processors.odbc.ClientListenerProcessor;
import org.apache.ignite.internal.processors.performancestatistics.PerformanceStatisticsProcessor;
import org.apache.ignite.internal.processors.platform.PlatformProcessor;
import org.apache.ignite.internal.processors.platform.plugin.PlatformPluginProcessor;
import org.apache.ignite.internal.processors.plugin.IgnitePluginProcessor;
import org.apache.ignite.internal.processors.pool.PoolProcessor;
import org.apache.ignite.internal.processors.port.GridPortProcessor;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.resource.GridResourceProcessor;
import org.apache.ignite.internal.processors.rest.IgniteRestProcessor;
import org.apache.ignite.internal.processors.schedule.IgniteScheduleProcessorAdapter;
import org.apache.ignite.internal.processors.security.IgniteSecurity;
import org.apache.ignite.internal.processors.segmentation.GridSegmentationProcessor;
import org.apache.ignite.internal.processors.service.ServiceProcessorAdapter;
import org.apache.ignite.internal.processors.session.GridTaskSessionProcessor;
import org.apache.ignite.internal.processors.subscription.GridInternalSubscriptionProcessor;
import org.apache.ignite.internal.processors.task.GridTaskProcessor;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.processors.tracing.Tracing;
import org.apache.ignite.internal.suggestions.GridPerformanceSuggestions;
import org.apache.ignite.internal.util.IgniteExceptionRegistry;
import org.apache.ignite.internal.util.StripedExecutor;
import org.apache.ignite.internal.util.spring.IgniteSpringHelper;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.worker.WorkersRegistry;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.maintenance.MaintenanceRegistry;
import org.apache.ignite.plugin.PluginNotFoundException;
import org.apache.ignite.plugin.PluginProvider;
import org.apache.ignite.thread.IgniteStripedThreadPoolExecutor;
import org.jetbrains.annotations.Nullable;

@GridToStringExclude
public class GridKernalContextImpl
implements GridKernalContext,
Externalizable {
    private static final long serialVersionUID = 0L;
    private static final ThreadLocal<String> stash = new ThreadLocal();
    @GridToStringExclude
    private GridDeploymentManager depMgr;
    @GridToStringExclude
    private GridIoManager ioMgr;
    @GridToStringExclude
    private GridDiscoveryManager discoMgr;
    @GridToStringExclude
    private GridCheckpointManager cpMgr;
    @GridToStringExclude
    private GridEventStorageManager evtMgr;
    @GridToStringExclude
    private GridFailoverManager failoverMgr;
    @GridToStringExclude
    private GridCollisionManager colMgr;
    @GridToStringExclude
    private GridLoadBalancerManager loadMgr;
    @GridToStringExclude
    private IgniteSecurity security;
    @GridToStringExclude
    private GridIndexingManager indexingMgr;
    @GridToStringExclude
    private GridEncryptionManager encryptionMgr;
    @GridToStringExclude
    private IgniteDefragmentation defragMgr;
    @GridToStringExclude
    private GridTracingManager tracingMgr;
    @GridToStringInclude
    private ClientListenerProcessor sqlListenerProc;
    @GridToStringInclude
    private GridQueryProcessor qryProc;
    @GridToStringInclude
    private GridTaskProcessor taskProc;
    @GridToStringInclude
    private GridJobProcessor jobProc;
    @GridToStringInclude
    private GridTimeoutProcessor timeProc;
    @GridToStringInclude
    private GridResourceProcessor rsrcProc;
    @GridToStringInclude
    private GridJobMetricsProcessor jobMetricsProc;
    @GridToStringInclude
    private GridMetricManager metricMgr;
    @GridToStringInclude
    private GridSystemViewManager sysViewMgr;
    @GridToStringInclude
    private GridClosureProcessor closProc;
    @GridToStringInclude
    private ServiceProcessorAdapter srvcProc;
    @GridToStringInclude
    private GridCacheProcessor cacheProc;
    @GridToStringInclude
    private GridClusterStateProcessor stateProc;
    @GridToStringInclude
    private DistributedMetaStorage distributedMetastorage;
    @GridToStringInclude
    private DistributedConfigurationProcessor distributedConfigurationProcessor;
    @GridToStringInclude
    private GridTaskSessionProcessor sesProc;
    @GridToStringInclude
    private GridPortProcessor portProc;
    @GridToStringInclude
    private IgniteScheduleProcessorAdapter scheduleProc;
    @GridToStringInclude
    private IgniteRestProcessor restProc;
    @GridToStringInclude
    private DataStreamProcessor dataLdrProc;
    @GridToStringInclude
    private GridSegmentationProcessor segProc;
    @GridToStringInclude
    private GridAffinityProcessor affProc;
    @GridToStringExclude
    private GridContinuousProcessor contProc;
    @GridToStringExclude
    private PoolProcessor poolProc;
    @GridToStringExclude
    private GridMarshallerMappingProcessor mappingProc;
    @GridToStringExclude
    private IgnitePluginProcessor pluginProc;
    @GridToStringExclude
    private IgniteCacheObjectProcessor cacheObjProc;
    @GridToStringExclude
    private PlatformProcessor platformProc;
    @GridToStringExclude
    private IgniteSpringHelper spring;
    @GridToStringExclude
    private ClusterProcessor cluster;
    @GridToStringExclude
    private CompressionProcessor compressProc;
    @GridToStringExclude
    private DataStructuresProcessor dataStructuresProc;
    @GridToStringExclude
    private MvccProcessor coordProc;
    @GridToStringExclude
    private IgniteAuthenticationProcessor authProc;
    @GridToStringInclude
    private DiagnosticProcessor diagnosticProcessor;
    @GridToStringExclude
    private MaintenanceProcessor maintenanceProc;
    @GridToStringExclude
    private List<GridComponent> comps;
    @GridToStringExclude
    protected ExecutorService execSvc;
    @GridToStringExclude
    protected ExecutorService svcExecSvc;
    @GridToStringExclude
    protected ExecutorService sysExecSvc;
    @GridToStringExclude
    protected StripedExecutor stripedExecSvc;
    @GridToStringExclude
    private ExecutorService p2pExecSvc;
    @GridToStringExclude
    private ExecutorService mgmtExecSvc;
    @GridToStringExclude
    private StripedExecutor dataStreamExecSvc;
    @GridToStringExclude
    protected ExecutorService restExecSvc;
    @GridToStringExclude
    protected ExecutorService affExecSvc;
    @GridToStringExclude
    protected ExecutorService idxExecSvc;
    @GridToStringExclude
    private ExecutorService buildIdxExecSvc;
    @GridToStringExclude
    protected IgniteStripedThreadPoolExecutor callbackExecSvc;
    @GridToStringExclude
    protected ExecutorService qryExecSvc;
    @GridToStringExclude
    protected ExecutorService schemaExecSvc;
    @GridToStringExclude
    protected ExecutorService rebalanceExecSvc;
    @GridToStringExclude
    protected IgniteStripedThreadPoolExecutor rebalanceStripedExecSvc;
    @GridToStringExclude
    private Map<String, ? extends ExecutorService> customExecSvcs;
    @GridToStringExclude
    private Map<String, Object> attrs;
    @GridToStringExclude
    private WorkersRegistry workersRegistry;
    @GridToStringExclude
    private LongJVMPauseDetector pauseDetector;
    @GridToStringExclude
    private DurableBackgroundTasksProcessor durableBackgroundTasksProcessor;
    @GridToStringExclude
    private PerformanceStatisticsProcessor perfStatProc;
    private Thread.UncaughtExceptionHandler hnd;
    private IgniteEx grid;
    private ExecutorService utilityCachePool;
    private IgniteConfiguration cfg;
    private GridKernalGateway gw;
    private volatile boolean segFlag;
    private final GridPerformanceSuggestions perf;
    private MarshallerContextImpl marshCtx;
    private ClusterNode locNode;
    private volatile boolean disconnected;
    private PdsFoldersResolver pdsFolderRslvr;
    private GridInternalSubscriptionProcessor internalSubscriptionProc;
    private FailureProcessor failureProc;
    private boolean recoveryMode;
    private final boolean igniteDaemon;

    public GridKernalContextImpl() {
        this.comps = new LinkedList<GridComponent>();
        this.attrs = new HashMap<String, Object>();
        this.perf = new GridPerformanceSuggestions();
        this.recoveryMode = true;
        this.igniteDaemon = IgniteSystemProperties.getBoolean("IGNITE_DAEMON");
    }

    protected GridKernalContextImpl(GridLoggerProxy log, IgniteEx grid, IgniteConfiguration cfg, GridKernalGateway gw, ExecutorService utilityCachePool, ExecutorService execSvc, ExecutorService svcExecSvc, ExecutorService sysExecSvc, StripedExecutor stripedExecSvc, ExecutorService p2pExecSvc, ExecutorService mgmtExecSvc, StripedExecutor dataStreamExecSvc, ExecutorService restExecSvc, ExecutorService affExecSvc, @Nullable ExecutorService idxExecSvc, @Nullable ExecutorService buildIdxExecSvc, IgniteStripedThreadPoolExecutor callbackExecSvc, ExecutorService qryExecSvc, ExecutorService schemaExecSvc, ExecutorService rebalanceExecSvc, IgniteStripedThreadPoolExecutor rebalanceStripedExecSvc, @Nullable Map<String, ? extends ExecutorService> customExecSvcs, List<PluginProvider> plugins, IgnitePredicate<String> clsFilter, WorkersRegistry workerRegistry, Thread.UncaughtExceptionHandler hnd, LongJVMPauseDetector pauseDetector) {
        block5: {
            this.comps = new LinkedList<GridComponent>();
            this.attrs = new HashMap<String, Object>();
            this.perf = new GridPerformanceSuggestions();
            this.recoveryMode = true;
            this.igniteDaemon = IgniteSystemProperties.getBoolean("IGNITE_DAEMON");
            assert (grid != null);
            assert (cfg != null);
            assert (gw != null);
            this.grid = grid;
            this.cfg = cfg;
            this.gw = gw;
            this.utilityCachePool = utilityCachePool;
            this.execSvc = execSvc;
            this.svcExecSvc = svcExecSvc;
            this.sysExecSvc = sysExecSvc;
            this.stripedExecSvc = stripedExecSvc;
            this.p2pExecSvc = p2pExecSvc;
            this.mgmtExecSvc = mgmtExecSvc;
            this.dataStreamExecSvc = dataStreamExecSvc;
            this.restExecSvc = restExecSvc;
            this.affExecSvc = affExecSvc;
            this.idxExecSvc = idxExecSvc;
            this.buildIdxExecSvc = buildIdxExecSvc;
            this.callbackExecSvc = callbackExecSvc;
            this.qryExecSvc = qryExecSvc;
            this.schemaExecSvc = schemaExecSvc;
            this.rebalanceExecSvc = rebalanceExecSvc;
            this.rebalanceStripedExecSvc = rebalanceStripedExecSvc;
            this.customExecSvcs = customExecSvcs;
            this.workersRegistry = workerRegistry;
            this.hnd = hnd;
            this.pauseDetector = pauseDetector;
            this.marshCtx = new MarshallerContextImpl(plugins, clsFilter);
            this.defragMgr = new IgniteDefragmentationImpl(this);
            try {
                this.spring = (IgniteSpringHelper)IgniteComponentType.SPRING.create(false);
            }
            catch (IgniteCheckedException ignored) {
                if (log == null || !log.isDebugEnabled()) break block5;
                log.debug("Failed to load spring component, will not be able to extract userVersion from META-INF/ignite.xml.");
            }
        }
    }

    @Override
    public Iterator<GridComponent> iterator() {
        return this.comps.iterator();
    }

    @Override
    public List<GridComponent> components() {
        return Collections.unmodifiableList(this.comps);
    }

    public void add(GridComponent comp) {
        this.add(comp, true);
    }

    public void add(GridComponent comp, boolean addToList) {
        assert (comp != null);
        if (comp instanceof GridDeploymentManager) {
            this.depMgr = (GridDeploymentManager)comp;
        } else if (comp instanceof GridIoManager) {
            this.ioMgr = (GridIoManager)comp;
        } else if (comp instanceof GridDiscoveryManager) {
            this.discoMgr = (GridDiscoveryManager)comp;
        } else if (comp instanceof GridCheckpointManager) {
            this.cpMgr = (GridCheckpointManager)comp;
        } else if (comp instanceof GridEventStorageManager) {
            this.evtMgr = (GridEventStorageManager)comp;
        } else if (comp instanceof GridFailoverManager) {
            this.failoverMgr = (GridFailoverManager)comp;
        } else if (comp instanceof GridCollisionManager) {
            this.colMgr = (GridCollisionManager)comp;
        } else if (comp instanceof GridLoadBalancerManager) {
            this.loadMgr = (GridLoadBalancerManager)comp;
        } else if (comp instanceof GridIndexingManager) {
            this.indexingMgr = (GridIndexingManager)comp;
        } else if (comp instanceof GridEncryptionManager) {
            this.encryptionMgr = (GridEncryptionManager)comp;
        } else if (comp instanceof GridTracingManager) {
            this.tracingMgr = (GridTracingManager)comp;
        } else if (comp instanceof FailureProcessor) {
            this.failureProc = (FailureProcessor)comp;
        } else if (comp instanceof GridTaskProcessor) {
            this.taskProc = (GridTaskProcessor)comp;
        } else if (comp instanceof GridJobProcessor) {
            this.jobProc = (GridJobProcessor)comp;
        } else if (comp instanceof GridTimeoutProcessor) {
            this.timeProc = (GridTimeoutProcessor)comp;
        } else if (comp instanceof GridResourceProcessor) {
            this.rsrcProc = (GridResourceProcessor)comp;
        } else if (comp instanceof GridJobMetricsProcessor) {
            this.jobMetricsProc = (GridJobMetricsProcessor)comp;
        } else if (comp instanceof GridMetricManager) {
            this.metricMgr = (GridMetricManager)comp;
        } else if (comp instanceof GridSystemViewManager) {
            this.sysViewMgr = (GridSystemViewManager)comp;
        } else if (comp instanceof GridCacheProcessor) {
            this.cacheProc = (GridCacheProcessor)comp;
        } else if (comp instanceof GridClusterStateProcessor) {
            this.stateProc = (GridClusterStateProcessor)comp;
        } else if (comp instanceof DistributedMetaStorage) {
            this.distributedMetastorage = (DistributedMetaStorage)((Object)comp);
        } else if (comp instanceof DistributedConfigurationProcessor) {
            this.distributedConfigurationProcessor = (DistributedConfigurationProcessor)comp;
        } else if (comp instanceof GridTaskSessionProcessor) {
            this.sesProc = (GridTaskSessionProcessor)comp;
        } else if (comp instanceof GridPortProcessor) {
            this.portProc = (GridPortProcessor)comp;
        } else if (comp instanceof GridClosureProcessor) {
            this.closProc = (GridClosureProcessor)comp;
        } else if (comp instanceof ServiceProcessorAdapter) {
            this.srvcProc = (ServiceProcessorAdapter)comp;
        } else if (comp instanceof IgniteScheduleProcessorAdapter) {
            this.scheduleProc = (IgniteScheduleProcessorAdapter)comp;
        } else if (comp instanceof GridSegmentationProcessor) {
            this.segProc = (GridSegmentationProcessor)comp;
        } else if (comp instanceof GridAffinityProcessor) {
            this.affProc = (GridAffinityProcessor)comp;
        } else if (comp instanceof IgniteRestProcessor) {
            this.restProc = (IgniteRestProcessor)comp;
        } else if (comp instanceof DataStreamProcessor) {
            this.dataLdrProc = (DataStreamProcessor)comp;
        } else if (comp instanceof GridContinuousProcessor) {
            this.contProc = (GridContinuousProcessor)comp;
        } else if (comp instanceof IgniteCacheObjectProcessor) {
            this.cacheObjProc = (IgniteCacheObjectProcessor)comp;
        } else if (comp instanceof IgnitePluginProcessor) {
            this.pluginProc = (IgnitePluginProcessor)comp;
        } else if (comp instanceof GridQueryProcessor) {
            this.qryProc = (GridQueryProcessor)comp;
        } else if (comp instanceof ClientListenerProcessor) {
            this.sqlListenerProc = (ClientListenerProcessor)comp;
        } else if (comp instanceof DataStructuresProcessor) {
            this.dataStructuresProc = (DataStructuresProcessor)comp;
        } else if (comp instanceof ClusterProcessor) {
            this.cluster = (ClusterProcessor)comp;
        } else if (comp instanceof PlatformProcessor) {
            this.platformProc = (PlatformProcessor)comp;
        } else if (comp instanceof PoolProcessor) {
            this.poolProc = (PoolProcessor)comp;
        } else if (comp instanceof GridMarshallerMappingProcessor) {
            this.mappingProc = (GridMarshallerMappingProcessor)comp;
        } else if (comp instanceof MvccProcessor) {
            this.coordProc = (MvccProcessor)comp;
        } else if (comp instanceof PdsFoldersResolver) {
            this.pdsFolderRslvr = (PdsFoldersResolver)((Object)comp);
        } else if (comp instanceof GridInternalSubscriptionProcessor) {
            this.internalSubscriptionProc = (GridInternalSubscriptionProcessor)comp;
        } else if (comp instanceof IgniteAuthenticationProcessor) {
            this.authProc = (IgniteAuthenticationProcessor)comp;
        } else if (comp instanceof IgniteSecurity) {
            this.security = (IgniteSecurity)((Object)comp);
        } else if (comp instanceof CompressionProcessor) {
            this.compressProc = (CompressionProcessor)comp;
        } else if (comp instanceof DiagnosticProcessor) {
            this.diagnosticProcessor = (DiagnosticProcessor)comp;
        } else if (comp instanceof DurableBackgroundTasksProcessor) {
            this.durableBackgroundTasksProcessor = (DurableBackgroundTasksProcessor)comp;
        } else if (comp instanceof MaintenanceProcessor) {
            this.maintenanceProc = (MaintenanceProcessor)comp;
        } else if (comp instanceof PerformanceStatisticsProcessor) {
            this.perfStatProc = (PerformanceStatisticsProcessor)comp;
        } else if (!(comp instanceof DiscoveryNodeValidationProcessor) && !(comp instanceof PlatformPluginProcessor)) assert (comp instanceof GridPluginComponent) : "Unknown manager class: " + comp.getClass();
        if (addToList) {
            this.comps.add(comp);
        }
    }

    public void addHelper(Object helper) {
        assert (helper != null);
        assert (false) : "Unknown helper class: " + helper.getClass();
    }

    @Override
    public boolean isStopping() {
        return ((IgniteKernal)this.grid).isStopping();
    }

    @Nullable
    private ClusterNode localNode() {
        if (this.locNode == null && this.discoMgr != null) {
            this.locNode = this.discoMgr.localNode();
        }
        return this.locNode;
    }

    @Override
    public UUID localNodeId() {
        ClusterNode locNode0 = this.localNode();
        return locNode0 != null ? locNode0.id() : this.config().getNodeId();
    }

    @Override
    public String igniteInstanceName() {
        return this.cfg.getIgniteInstanceName();
    }

    @Override
    public GridKernalGateway gateway() {
        return this.gw;
    }

    @Override
    public IgniteEx grid() {
        return this.grid;
    }

    @Override
    public IgniteConfiguration config() {
        return this.cfg;
    }

    @Override
    public GridTaskProcessor task() {
        return this.taskProc;
    }

    @Override
    public GridJobProcessor job() {
        return this.jobProc;
    }

    @Override
    public GridTimeoutProcessor timeout() {
        return this.timeProc;
    }

    @Override
    public GridResourceProcessor resource() {
        return this.rsrcProc;
    }

    @Override
    public GridJobMetricsProcessor jobMetric() {
        return this.jobMetricsProc;
    }

    @Override
    public GridMetricManager metric() {
        return this.metricMgr;
    }

    @Override
    public GridSystemViewManager systemView() {
        return this.sysViewMgr;
    }

    @Override
    public MaintenanceRegistry maintenanceRegistry() {
        return this.maintenanceProc;
    }

    @Override
    public GridCacheProcessor cache() {
        return this.cacheProc;
    }

    @Override
    public GridClusterStateProcessor state() {
        return this.stateProc;
    }

    @Override
    public DistributedMetaStorage distributedMetastorage() {
        return this.distributedMetastorage;
    }

    @Override
    public DistributedConfigurationProcessor distributedConfiguration() {
        return this.distributedConfigurationProcessor;
    }

    @Override
    public Tracing tracing() {
        return this.tracingMgr;
    }

    @Override
    public GridTaskSessionProcessor session() {
        return this.sesProc;
    }

    @Override
    public GridClosureProcessor closure() {
        return this.closProc;
    }

    @Override
    public ServiceProcessorAdapter service() {
        return this.srvcProc;
    }

    @Override
    public GridPortProcessor ports() {
        return this.portProc;
    }

    @Override
    public IgniteScheduleProcessorAdapter schedule() {
        return this.scheduleProc;
    }

    @Override
    public GridDeploymentManager deploy() {
        return this.depMgr;
    }

    @Override
    public GridIoManager io() {
        return this.ioMgr;
    }

    @Override
    public GridDiscoveryManager discovery() {
        return this.discoMgr;
    }

    @Override
    public GridCheckpointManager checkpoint() {
        return this.cpMgr;
    }

    @Override
    public GridEventStorageManager event() {
        return this.evtMgr;
    }

    @Override
    public GridFailoverManager failover() {
        return this.failoverMgr;
    }

    @Override
    public GridCollisionManager collision() {
        return this.colMgr;
    }

    @Override
    public IgniteSecurity security() {
        return this.security;
    }

    @Override
    public GridLoadBalancerManager loadBalancing() {
        return this.loadMgr;
    }

    @Override
    public GridIndexingManager indexing() {
        return this.indexingMgr;
    }

    @Override
    public GridEncryptionManager encryption() {
        return this.encryptionMgr;
    }

    @Override
    public IgniteDefragmentation defragmentation() {
        return this.defragMgr;
    }

    @Override
    public WorkersRegistry workersRegistry() {
        return this.workersRegistry;
    }

    @Override
    public GridAffinityProcessor affinity() {
        return this.affProc;
    }

    @Override
    public IgniteRestProcessor rest() {
        return this.restProc;
    }

    @Override
    public GridSegmentationProcessor segmentation() {
        return this.segProc;
    }

    @Override
    public <K, V> DataStreamProcessor<K, V> dataStream() {
        return this.dataLdrProc;
    }

    @Override
    public GridContinuousProcessor continuous() {
        return this.contProc;
    }

    @Override
    public PoolProcessor pools() {
        return this.poolProc;
    }

    @Override
    public GridMarshallerMappingProcessor mapping() {
        return this.mappingProc;
    }

    @Override
    public ExecutorService utilityCachePool() {
        return this.utilityCachePool;
    }

    @Override
    public IgniteStripedThreadPoolExecutor asyncCallbackPool() {
        return this.callbackExecSvc;
    }

    @Override
    public IgniteCacheObjectProcessor cacheObjects() {
        return this.cacheObjProc;
    }

    @Override
    public GridQueryProcessor query() {
        return this.qryProc;
    }

    @Override
    public ClientListenerProcessor sqlListener() {
        return this.sqlListenerProc;
    }

    @Override
    public DataStructuresProcessor dataStructures() {
        return this.dataStructuresProc;
    }

    @Override
    public MvccProcessor coordinators() {
        return this.coordProc;
    }

    @Override
    public IgniteAuthenticationProcessor authentication() {
        return this.authProc;
    }

    @Override
    public IgniteLogger log(String ctgr) {
        return this.config().getGridLogger().getLogger(ctgr);
    }

    @Override
    public IgniteLogger log(Class<?> cls) {
        return this.log(cls.getName());
    }

    @Override
    public GridPerformanceSuggestions performance() {
        return this.perf;
    }

    @Override
    public LongJVMPauseDetector longJvmPauseDetector() {
        return this.pauseDetector;
    }

    @Override
    public DiagnosticProcessor diagnostic() {
        return this.diagnosticProcessor;
    }

    @Override
    public void printMemoryStats() {
        X.println(">>> ", new Object[0]);
        X.println(">>> Grid memory stats [igniteInstanceName=" + this.igniteInstanceName() + ']', new Object[0]);
        for (GridComponent comp : this.comps) {
            comp.printMemoryStats();
        }
    }

    @Override
    public boolean isDaemon() {
        ClusterNode locNode0 = this.localNode();
        return locNode0 != null ? locNode0.isDaemon() : this.config().isDaemon() || this.igniteDaemon;
    }

    @Override
    public String userVersion(ClassLoader ldr) {
        return this.spring != null ? this.spring.userVersion(ldr, this.log(this.spring.getClass())) : "0";
    }

    @Override
    public PluginProvider pluginProvider(String name) throws PluginNotFoundException {
        Object plugin = this.pluginProc.pluginProvider(name);
        if (plugin == null) {
            throw new PluginNotFoundException(name);
        }
        return plugin;
    }

    @Override
    @Nullable
    public <T> T createComponent(Class<T> cls) {
        T res = this.pluginProc.createComponent(cls);
        if (res != null) {
            return res;
        }
        if (cls.equals(IgniteCacheObjectProcessor.class)) {
            return (T)new CacheObjectBinaryProcessorImpl(this);
        }
        if (cls.equals(CacheConflictResolutionManager.class)) {
            return null;
        }
        throw new IgniteException("Unsupported component type: " + cls);
    }

    @Override
    public IgnitePluginProcessor plugins() {
        return this.pluginProc;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString(out, this.grid.name());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        U.readString(in);
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            GridKernalContext gridKernalContext = IgnitionEx.localIgnite().context();
            return gridKernalContext;
        }
        catch (IllegalStateException e) {
            throw U.withCause(new InvalidObjectException(e.getMessage()), e);
        }
        finally {
            stash.remove();
        }
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.execSvc;
    }

    @Override
    public ExecutorService getServiceExecutorService() {
        return this.svcExecSvc;
    }

    @Override
    public ExecutorService getSystemExecutorService() {
        return this.sysExecSvc;
    }

    @Override
    public StripedExecutor getStripedExecutorService() {
        return this.stripedExecSvc;
    }

    @Override
    public ExecutorService getManagementExecutorService() {
        return this.mgmtExecSvc;
    }

    @Override
    public ExecutorService getPeerClassLoadingExecutorService() {
        return this.p2pExecSvc;
    }

    @Override
    public StripedExecutor getDataStreamerExecutorService() {
        return this.dataStreamExecSvc;
    }

    @Override
    public ExecutorService getRestExecutorService() {
        return this.restExecSvc;
    }

    @Override
    public ExecutorService getAffinityExecutorService() {
        return this.affExecSvc;
    }

    @Override
    @Nullable
    public ExecutorService getIndexingExecutorService() {
        return this.idxExecSvc;
    }

    @Override
    public ExecutorService getQueryExecutorService() {
        return this.qryExecSvc;
    }

    @Override
    public ExecutorService getSchemaExecutorService() {
        return this.schemaExecSvc;
    }

    @Override
    public ExecutorService getRebalanceExecutorService() {
        return this.rebalanceExecSvc;
    }

    @Override
    public IgniteStripedThreadPoolExecutor getStripedRebalanceExecutorService() {
        return this.rebalanceStripedExecSvc;
    }

    @Override
    public Map<String, ? extends ExecutorService> customExecutors() {
        return this.customExecSvcs;
    }

    @Override
    public IgniteExceptionRegistry exceptionRegistry() {
        return IgniteExceptionRegistry.get();
    }

    @Override
    public Object nodeAttribute(String key) {
        return this.attrs.get(key);
    }

    @Override
    public boolean hasNodeAttribute(String key) {
        return this.attrs.containsKey(key);
    }

    @Override
    public Object addNodeAttribute(String key, Object val) {
        return this.attrs.put(key, val);
    }

    @Override
    public Map<String, Object> nodeAttributes() {
        return this.attrs;
    }

    @Override
    public ClusterProcessor cluster() {
        return this.cluster;
    }

    @Override
    public MarshallerContextImpl marshallerContext() {
        return this.marshCtx;
    }

    @Override
    public boolean clientNode() {
        return this.cfg.isClientMode() != false || this.cfg.isDaemon();
    }

    @Override
    public boolean clientDisconnected() {
        ClusterNode locNode0 = this.localNode();
        return locNode0 != null ? locNode0.isClient() && this.disconnected : false;
    }

    @Override
    public PlatformProcessor platform() {
        return this.platformProc;
    }

    @Override
    public GridInternalSubscriptionProcessor internalSubscriptionProcessor() {
        return this.internalSubscriptionProc;
    }

    void disconnected(boolean disconnected) {
        this.disconnected = disconnected;
    }

    @Override
    public PdsFoldersResolver pdsFolderResolver() {
        return this.pdsFolderRslvr;
    }

    @Override
    public boolean invalid() {
        FailureProcessor failureProc = this.failure();
        return failureProc != null && failureProc.failureContext() != null && failureProc.failureContext().type() != FailureType.SEGMENTATION;
    }

    @Override
    public boolean segmented() {
        FailureProcessor failureProc = this.failure();
        return failureProc != null && failureProc.failureContext() != null && failureProc.failureContext().type() == FailureType.SEGMENTATION;
    }

    @Override
    public FailureProcessor failure() {
        return this.failureProc;
    }

    @Override
    public Thread.UncaughtExceptionHandler uncaughtExceptionHandler() {
        return this.hnd;
    }

    @Override
    public CompressionProcessor compress() {
        return this.compressProc;
    }

    @Override
    public boolean recoveryMode() {
        return this.recoveryMode;
    }

    public void recoveryMode(boolean recoveryMode) {
        this.recoveryMode = recoveryMode;
    }

    public String toString() {
        return S.toString(GridKernalContextImpl.class, this);
    }

    @Override
    public DurableBackgroundTasksProcessor durableBackgroundTasksProcessor() {
        return this.durableBackgroundTasksProcessor;
    }

    @Override
    public ExecutorService buildIndexExecutorService() {
        return this.buildIdxExecSvc;
    }

    @Override
    public PerformanceStatisticsProcessor performanceStatistics() {
        return this.perfStatProc;
    }
}

