/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.jdbc;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.UUID;
import org.apache.ignite.cache.store.jdbc.JdbcTypesTransformer;

public class JdbcTypesDefaultTransformer
implements JdbcTypesTransformer {
    private static final long serialVersionUID = 0L;
    public static final JdbcTypesDefaultTransformer INSTANCE = new JdbcTypesDefaultTransformer();

    @Override
    public Object getColumnValue(ResultSet rs, int colIdx, Class<?> type) throws SQLException {
        if (type == String.class) {
            return rs.getString(colIdx);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            int res = rs.getInt(colIdx);
            return rs.wasNull() && type == Integer.class ? null : Integer.valueOf(res);
        }
        if (type == Long.TYPE || type == Long.class) {
            long res = rs.getLong(colIdx);
            return rs.wasNull() && type == Long.class ? null : Long.valueOf(res);
        }
        if (type == Double.TYPE || type == Double.class) {
            double res = rs.getDouble(colIdx);
            return rs.wasNull() && type == Double.class ? null : Double.valueOf(res);
        }
        if (type == java.sql.Date.class || type == Date.class) {
            return rs.getDate(colIdx);
        }
        if (type == Timestamp.class) {
            return rs.getTimestamp(colIdx);
        }
        if (type == Time.class) {
            return rs.getTime(colIdx);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            boolean res = rs.getBoolean(colIdx);
            return rs.wasNull() && type == Boolean.class ? null : Boolean.valueOf(res);
        }
        if (type == Byte.TYPE || type == Byte.class) {
            byte res = rs.getByte(colIdx);
            return rs.wasNull() && type == Byte.class ? null : Byte.valueOf(res);
        }
        if (type == Short.TYPE || type == Short.class) {
            short res = rs.getShort(colIdx);
            return rs.wasNull() && type == Short.class ? null : Short.valueOf(res);
        }
        if (type == Float.TYPE || type == Float.class) {
            float res = rs.getFloat(colIdx);
            return rs.wasNull() && type == Float.class ? null : Float.valueOf(res);
        }
        if (type == BigDecimal.class) {
            return rs.getBigDecimal(colIdx);
        }
        if (type == UUID.class) {
            Object res = rs.getObject(colIdx);
            if (res instanceof UUID) {
                return res;
            }
            if (res instanceof byte[]) {
                ByteBuffer bb = ByteBuffer.wrap((byte[])res);
                long most = bb.getLong();
                long least = bb.getLong();
                return new UUID(most, least);
            }
            if (res instanceof String) {
                return UUID.fromString((String)res);
            }
        }
        if (type.isEnum()) {
            if (NUMERIC_TYPES.contains(rs.getMetaData().getColumnType(colIdx))) {
                int ordinal = rs.getInt(colIdx);
                ?[] values = type.getEnumConstants();
                return rs.wasNull() || ordinal >= values.length ? null : values[ordinal];
            }
            String str = rs.getString(colIdx);
            try {
                return rs.wasNull() ? null : Enum.valueOf(type, str.trim());
            }
            catch (IllegalArgumentException ignore) {
                return null;
            }
        }
        return rs.getObject(colIdx);
    }
}

